/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */

#ifndef __CCM_ACTION_H__
#define __CCM_ACTION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define CCM_TYPE_ACTION (ccm_action_get_type ())
#define CCM_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_ACTION, CCMAction))
#define CCM_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_ACTION, CCMActionClass))
#define CCM_IS_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_ACTION))
#define CCM_IS_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_ACTION))
#define CCM_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_ACTION, CCMActionClass))

typedef struct _CCMAction CCMAction;
typedef struct _CCMActionClass CCMActionClass;
typedef struct _CCMActionPrivate CCMActionPrivate;

typedef enum  {
	CCM_ACTION_ERROR_WINDOW_IGNORE,
	CCM_ACTION_ERROR_WINDOW_NOT_FOUND
} CCMActionError;
#define CCM_ACTION_ERROR ccm_action_error_quark ()
struct _CCMAction {
	GObject parent_instance;
	CCMActionPrivate * priv;
};

struct _CCMActionClass {
	GObjectClass parent_class;
	char* (*to_string) (CCMAction* self, const char* format);
};


GQuark ccm_action_error_quark (void);
char* ccm_action_to_string (CCMAction* self, const char* format);
glong ccm_action_get_time (CCMAction* self);
void ccm_action_set_time (CCMAction* self, glong value);
GType ccm_action_get_type (void);
GType ccm_action_register_type (GTypeModule * module);


G_END_DECLS

#endif
