/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */

#include <ccm-automate-dialog.h>
#include <ccm-timeline.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkx.h>
#include <cairo.h>
#include <ccm-cairo-utils.h>
#include <ccm-window.h>
#include <ccm-window-plugin.h>
#include <stdio.h>
#include <ccm-debug.h>
#include <ccm-story-board.h>




struct _CCMAutomateDialogPrivate {
	CCMScreen* screen;
	CCMTimeline* timeline;
	GtkWindow* main;
	GtkWidget* close;
	GtkImage* close_image;
	GtkCheckButton* hint_motion;
	CCMStoryBoard* story_board;
};

#define CCM_AUTOMATE_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CCM_TYPE_AUTOMATE_DIALOG, CCMAutomateDialogPrivate))
enum  {
	CCM_AUTOMATE_DIALOG_DUMMY_PROPERTY
};
#define CCM_AUTOMATE_DIALOG_UI_FILE "/usr/share/cairo-compmgr/ui/ccm-automate.ui"
static void _ccm_automate_dialog_on_new_frame_ccm_timeline_new_frame (CCMTimeline* _sender, gint object, gpointer self);
static void _ccm_automate_dialog_on_completed_ccm_timeline_completed (CCMTimeline* _sender, gpointer self);
static void ccm_automate_dialog_on_new_frame (CCMAutomateDialog* self, CCMTimeline* timeline, gint num_frame);
static void ccm_automate_dialog_on_completed (CCMAutomateDialog* self, CCMTimeline* timeline);
static void ccm_automate_dialog_on_realize (CCMAutomateDialog* self, GtkWidget* widget);
static gboolean ccm_automate_dialog_on_expose_event (CCMAutomateDialog* self, GtkWidget* widget, const GdkEventExpose* event);
static gboolean ccm_automate_dialog_on_close (CCMAutomateDialog* self, GtkWidget* widget, const GdkEventButton* event);
static void ccm_automate_dialog_on_record_clicked (CCMAutomateDialog* self, GtkButton* button);
static void ccm_automate_dialog_on_stop_clicked (CCMAutomateDialog* self, GtkButton* button);
static void _ccm_automate_dialog_on_realize_gtk_widget_realize (GtkWidget* _sender, gpointer self);
static gboolean _ccm_automate_dialog_on_expose_event_gtk_widget_expose_event (GtkWidget* _sender, const GdkEventExpose* event, gpointer self);
static gboolean _ccm_automate_dialog_on_close_gtk_widget_button_press_event (GtkWidget* _sender, const GdkEventButton* event, gpointer self);
static void _ccm_automate_dialog_on_record_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _ccm_automate_dialog_on_stop_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ccm_automate_dialog_construct_ui (CCMAutomateDialog* self);
static gpointer ccm_automate_dialog_parent_class = NULL;
static void ccm_automate_dialog_finalize (GObject* obj);



static void _ccm_automate_dialog_on_new_frame_ccm_timeline_new_frame (CCMTimeline* _sender, gint object, gpointer self) {
	ccm_automate_dialog_on_new_frame (self, _sender, object);
}


static void _ccm_automate_dialog_on_completed_ccm_timeline_completed (CCMTimeline* _sender, gpointer self) {
	ccm_automate_dialog_on_completed (self, _sender);
}


CCMAutomateDialog* ccm_automate_dialog_construct (GType object_type, CCMScreen* screen) {
	CCMAutomateDialog * self;
	CCMTimeline* _tmp0;
	g_return_val_if_fail (screen != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->priv->screen = screen;
	_tmp0 = NULL;
	self->priv->timeline = (_tmp0 = ccm_timeline_new ((guint) 10, (guint) 60), (self->priv->timeline == NULL) ? NULL : (self->priv->timeline = (g_object_unref (self->priv->timeline), NULL)), _tmp0);
	ccm_timeline_set_direction (self->priv->timeline, CCM_TIMELINE_BACKWARD);
	g_signal_connect_object (self->priv->timeline, "new-frame", (GCallback) _ccm_automate_dialog_on_new_frame_ccm_timeline_new_frame, self, 0);
	g_signal_connect_object (self->priv->timeline, "completed", (GCallback) _ccm_automate_dialog_on_completed_ccm_timeline_completed, self, 0);
	ccm_automate_dialog_construct_ui (self);
	return self;
}


CCMAutomateDialog* ccm_automate_dialog_new (CCMScreen* screen) {
	return ccm_automate_dialog_construct (CCM_TYPE_AUTOMATE_DIALOG, screen);
}


static void ccm_automate_dialog_on_new_frame (CCMAutomateDialog* self, CCMTimeline* timeline, gint num_frame) {
	gint width;
	gint height;
	gint x;
	gint y;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	width = 0;
	height = 0;
	x = 0;
	y = 0;
	gdk_window_get_origin (((GtkWidget*) self->priv->main)->window, &x, &y);
	gdk_drawable_get_size ((GdkDrawable*) ((GtkWidget*) self->priv->main)->window, &width, &height);
	height = height - self->priv->close->allocation.height;
	gtk_window_move (self->priv->main, x, -((gint) (((double) height) * ccm_timeline_get_progress (timeline))));
}


static void ccm_automate_dialog_on_completed (CCMAutomateDialog* self, CCMTimeline* timeline) {
	char* stock;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	stock = NULL;
	if (ccm_timeline_get_direction (timeline) == CCM_TIMELINE_FORWARD) {
		char* _tmp0;
		_tmp0 = NULL;
		stock = (_tmp0 = g_strdup (GTK_STOCK_GO_DOWN), stock = (g_free (stock), NULL), _tmp0);
	} else {
		char* _tmp1;
		_tmp1 = NULL;
		stock = (_tmp1 = g_strdup (GTK_STOCK_GO_UP), stock = (g_free (stock), NULL), _tmp1);
	}
	gtk_image_set_from_stock (self->priv->close_image, stock, GTK_ICON_SIZE_BUTTON);
	stock = (g_free (stock), NULL);
}


static void ccm_automate_dialog_on_realize (CCMAutomateDialog* self, GtkWidget* widget) {
	gint width;
	gint height;
	GdkAtom atom_enable;
	guchar* _tmp1;
	gint enable_size;
	gint enable_length1;
	guchar* _tmp0;
	guchar* enable;
	GdkPixmap* pixmap;
	cairo_t* ctx;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	width = 0;
	height = 0;
	atom_enable = gdk_atom_intern_static_string ("_CCM_SHADOW_ENABLED");
	_tmp1 = NULL;
	_tmp0 = NULL;
	enable = (_tmp1 = (_tmp0 = g_new0 (guchar, 1), _tmp0[0] = (guchar) 1, _tmp0), enable_length1 = 1, enable_size = enable_length1, _tmp1);
	gdk_property_change (((GtkWidget*) self->priv->main)->window, atom_enable, gdk_x11_xatom_to_atom (gdk_x11_get_xatom_by_name ("CARDINAL")), 32, GDK_PROP_MODE_REPLACE, enable, enable_length1);
	gdk_drawable_get_size ((GdkDrawable*) ((GtkWidget*) self->priv->main)->window, &width, &height);
	gdk_window_set_override_redirect (((GtkWidget*) self->priv->main)->window, TRUE);
	gtk_window_move (self->priv->main, (ccm_screen_get_xscreen (self->priv->screen)->width / 2) - (width / 2), 0);
	pixmap = gdk_pixmap_new (NULL, width, height, 1);
	ctx = gdk_cairo_create ((GdkDrawable*) pixmap);
	cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
	cairo_set_source_rgba (ctx, (double) 0, (double) 0, (double) 0, (double) 0);
	cairo_paint (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_OVER);
	cairo_translate (ctx, (double) (width / 2), (double) (height / 2));
	cairo_rotate (ctx, -M_PI);
	cairo_translate (ctx, (double) ((-width) / 2), (double) ((-height) / 2));
	cairo_set_source_rgba (ctx, (double) 1, (double) 1, (double) 1, (double) 1);
	cairo_notebook_page_round ((cairo_t*) ctx, (double) 0, (double) 0, (double) width, (double) height, (double) 0, (double) self->priv->close->allocation.width, (double) self->priv->close->allocation.height, 6);
	cairo_fill (ctx);
	cairo_surface_finish (cairo_get_target (ctx));
	gdk_window_shape_combine_mask (widget->window, (GdkBitmap*) NULL, 0, 0);
	gdk_window_input_shape_combine_mask (widget->window, (GdkBitmap*) NULL, 0, 0);
	gdk_window_shape_combine_mask (widget->window, (GdkBitmap*) pixmap, 0, 0);
	gdk_window_input_shape_combine_mask (widget->window, (GdkBitmap*) pixmap, 0, 0);
	enable = (g_free (enable), NULL);
	(pixmap == NULL) ? NULL : (pixmap = (g_object_unref (pixmap), NULL));
	(ctx == NULL) ? NULL : (ctx = (cairo_destroy (ctx), NULL));
}


static gboolean ccm_automate_dialog_on_expose_event (CCMAutomateDialog* self, GtkWidget* widget, const GdkEventExpose* event) {
	cairo_t* ctx;
	gint width;
	gint height;
	GtkWidget* _tmp0;
	GtkWidget* child;
	gboolean _tmp1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	ctx = gdk_cairo_create ((GdkDrawable*) widget->window);
	width = 0;
	height = 0;
	gdk_drawable_get_size ((GdkDrawable*) widget->window, &width, &height);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_OVER);
	cairo_translate (ctx, (double) (width / 2), (double) (height / 2));
	cairo_rotate (ctx, -M_PI);
	cairo_translate (ctx, (double) ((-width) / 2), (double) ((-height) / 2));
	cairo_set_source_rgba (ctx, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_NORMAL].red) / 65535, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_NORMAL].green) / 65535, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_NORMAL].blue) / 65535, 0.85);
	cairo_notebook_page_round ((cairo_t*) ctx, (double) 0, (double) 0, (double) width, (double) height, (double) 0, (double) self->priv->close->allocation.width, (double) self->priv->close->allocation.height, 6);
	cairo_fill (ctx);
	cairo_set_source_rgba (ctx, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_SELECTED].red) / 65535, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_SELECTED].green) / 65535, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_SELECTED].blue) / 65535, (double) 1);
	cairo_notebook_page_round ((cairo_t*) ctx, (double) 0, (double) 0, (double) width, (double) height, (double) 0, (double) self->priv->close->allocation.width, (double) self->priv->close->allocation.height, 6);
	cairo_stroke (ctx);
	_tmp0 = NULL;
	child = (_tmp0 = gtk_bin_get_child ((GtkBin*) GTK_WINDOW (widget)), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	gtk_container_propagate_expose (GTK_CONTAINER (widget), child, &(*event));
	return (_tmp1 = TRUE, (ctx == NULL) ? NULL : (ctx = (cairo_destroy (ctx), NULL)), (child == NULL) ? NULL : (child = (g_object_unref (child), NULL)), _tmp1);
}


static gboolean ccm_automate_dialog_on_close (CCMAutomateDialog* self, GtkWidget* widget, const GdkEventButton* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if (ccm_timeline_get_direction (self->priv->timeline) == CCM_TIMELINE_FORWARD) {
		ccm_timeline_set_direction (self->priv->timeline, CCM_TIMELINE_BACKWARD);
	} else {
		ccm_timeline_set_direction (self->priv->timeline, CCM_TIMELINE_FORWARD);
	}
	ccm_timeline_stop (self->priv->timeline);
	ccm_timeline_start (self->priv->timeline);
	return FALSE;
}


static void ccm_automate_dialog_on_record_clicked (CCMAutomateDialog* self, GtkButton* button) {
	Window xwindow;
	GList* ignore;
	CCMWindow* window;
	CCMStoryBoard* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	xwindow = GDK_WINDOW_XWINDOW (((GtkWidget*) self->priv->main)->window);
	ignore = NULL;
	window = ccm_screen_find_window (self->priv->screen, xwindow);
	ignore = g_list_append (ignore, window);
	_tmp0 = NULL;
	self->priv->story_board = (_tmp0 = ccm_story_board_new (self->priv->screen, "test", ignore), (self->priv->story_board == NULL) ? NULL : (self->priv->story_board = (g_object_unref (self->priv->story_board), NULL)), _tmp0);
	ccm_story_board_set_hint_motion (self->priv->story_board, gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->hint_motion));
	(ignore == NULL) ? NULL : (ignore = (g_list_free (ignore), NULL));
}


static void ccm_automate_dialog_on_stop_clicked (CCMAutomateDialog* self, GtkButton* button) {
	CCMStoryBoard* _tmp1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (self->priv->story_board != NULL) {
		char* _tmp0;
		_tmp0 = NULL;
		fprintf (stdout, "%s", _tmp0 = ccm_story_board_to_string (self->priv->story_board, "%ccmsb"));
		_tmp0 = (g_free (_tmp0), NULL);
	}
	_tmp1 = NULL;
	self->priv->story_board = (_tmp1 = NULL, (self->priv->story_board == NULL) ? NULL : (self->priv->story_board = (g_object_unref (self->priv->story_board), NULL)), _tmp1);
}


static void _ccm_automate_dialog_on_realize_gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	ccm_automate_dialog_on_realize (self, _sender);
}


static gboolean _ccm_automate_dialog_on_expose_event_gtk_widget_expose_event (GtkWidget* _sender, const GdkEventExpose* event, gpointer self) {
	return ccm_automate_dialog_on_expose_event (self, _sender, event);
}


static gboolean _ccm_automate_dialog_on_close_gtk_widget_button_press_event (GtkWidget* _sender, const GdkEventButton* event, gpointer self) {
	return ccm_automate_dialog_on_close (self, _sender, event);
}


static void _ccm_automate_dialog_on_record_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	ccm_automate_dialog_on_record_clicked (self, _sender);
}


static void _ccm_automate_dialog_on_stop_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	ccm_automate_dialog_on_stop_clicked (self, _sender);
}


static void ccm_automate_dialog_construct_ui (CCMAutomateDialog* self) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	{
		GtkBuilder* builder;
		GtkWindow* _tmp2;
		GtkWindow* _tmp1;
		GObject* _tmp0;
		GdkScreen* _tmp3;
		GdkScreen* screen;
		GdkColormap* _tmp4;
		GdkColormap* colormap;
		GtkWidget* _tmp7;
		GtkWidget* _tmp6;
		GObject* _tmp5;
		GtkImage* _tmp10;
		GtkImage* _tmp9;
		GObject* _tmp8;
		GtkButton* _tmp12;
		GObject* _tmp11;
		GtkButton* record;
		GtkButton* _tmp14;
		GObject* _tmp13;
		GtkButton* stop;
		GtkCheckButton* _tmp17;
		GtkCheckButton* _tmp16;
		GObject* _tmp15;
		/* Get builder file*/
		builder = gtk_builder_new ();
		gtk_builder_add_from_file (builder, CCM_AUTOMATE_DIALOG_UI_FILE, &inner_error);
		if (inner_error != NULL) {
			(builder == NULL) ? NULL : (builder = (g_object_unref (builder), NULL));
			goto __catch2_g_error;
			goto __finally2;
		}
		/* Get main dialog*/
		_tmp2 = NULL;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->main = (_tmp2 = (_tmp1 = (_tmp0 = gtk_builder_get_object (builder, "main"), GTK_IS_WINDOW (_tmp0) ? ((GtkWindow*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->main == NULL) ? NULL : (self->priv->main = (g_object_unref (self->priv->main), NULL)), _tmp2);
		gtk_window_set_keep_above (self->priv->main, TRUE);
		/* Set window as rgba*/
		_tmp3 = NULL;
		screen = (_tmp3 = gdk_screen_get_default (), (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3));
		_tmp4 = NULL;
		colormap = (_tmp4 = gdk_screen_get_rgba_colormap (screen), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4));
		gtk_widget_set_colormap ((GtkWidget*) self->priv->main, colormap);
		g_signal_connect_object (GTK_WIDGET (self->priv->main), "realize", (GCallback) _ccm_automate_dialog_on_realize_gtk_widget_realize, self, 0);
		g_signal_connect_object (GTK_WIDGET (self->priv->main), "expose-event", (GCallback) _ccm_automate_dialog_on_expose_event_gtk_widget_expose_event, self, 0);
		/* Get close event area*/
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		self->priv->close = (_tmp7 = (_tmp6 = (_tmp5 = gtk_builder_get_object (builder, "close"), GTK_IS_WIDGET (_tmp5) ? ((GtkWidget*) _tmp5) : NULL), (_tmp6 == NULL) ? NULL : g_object_ref (_tmp6)), (self->priv->close == NULL) ? NULL : (self->priv->close = (g_object_unref (self->priv->close), NULL)), _tmp7);
		g_signal_connect_object (self->priv->close, "button-press-event", (GCallback) _ccm_automate_dialog_on_close_gtk_widget_button_press_event, self, 0);
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		self->priv->close_image = (_tmp10 = (_tmp9 = (_tmp8 = gtk_builder_get_object (builder, "close_image"), GTK_IS_IMAGE (_tmp8) ? ((GtkImage*) _tmp8) : NULL), (_tmp9 == NULL) ? NULL : g_object_ref (_tmp9)), (self->priv->close_image == NULL) ? NULL : (self->priv->close_image = (g_object_unref (self->priv->close_image), NULL)), _tmp10);
		/* Get record button press*/
		_tmp12 = NULL;
		_tmp11 = NULL;
		record = (_tmp12 = (_tmp11 = gtk_builder_get_object (builder, "record"), GTK_IS_BUTTON (_tmp11) ? ((GtkButton*) _tmp11) : NULL), (_tmp12 == NULL) ? NULL : g_object_ref (_tmp12));
		g_signal_connect_object (record, "clicked", (GCallback) _ccm_automate_dialog_on_record_clicked_gtk_button_clicked, self, 0);
		/* Get record button press*/
		_tmp14 = NULL;
		_tmp13 = NULL;
		stop = (_tmp14 = (_tmp13 = gtk_builder_get_object (builder, "stop"), GTK_IS_BUTTON (_tmp13) ? ((GtkButton*) _tmp13) : NULL), (_tmp14 == NULL) ? NULL : g_object_ref (_tmp14));
		g_signal_connect_object (stop, "clicked", (GCallback) _ccm_automate_dialog_on_stop_clicked_gtk_button_clicked, self, 0);
		/* Get record button press*/
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		self->priv->hint_motion = (_tmp17 = (_tmp16 = (_tmp15 = gtk_builder_get_object (builder, "hint_motion"), GTK_IS_CHECK_BUTTON (_tmp15) ? ((GtkCheckButton*) _tmp15) : NULL), (_tmp16 == NULL) ? NULL : g_object_ref (_tmp16)), (self->priv->hint_motion == NULL) ? NULL : (self->priv->hint_motion = (g_object_unref (self->priv->hint_motion), NULL)), _tmp17);
		(builder == NULL) ? NULL : (builder = (g_object_unref (builder), NULL));
		(screen == NULL) ? NULL : (screen = (g_object_unref (screen), NULL));
		(colormap == NULL) ? NULL : (colormap = (g_object_unref (colormap), NULL));
		(record == NULL) ? NULL : (record = (g_object_unref (record), NULL));
		(stop == NULL) ? NULL : (stop = (g_object_unref (stop), NULL));
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * ex;
		ex = inner_error;
		inner_error = NULL;
		{
			ccm_log ("Error on create automate dialog: %s", ex->message, NULL);
			(ex == NULL) ? NULL : (ex = (g_error_free (ex), NULL));
		}
	}
	__finally2:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


void ccm_automate_dialog_show (CCMAutomateDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show ((GtkWidget*) self->priv->main);
}


void ccm_automate_dialog_hide (CCMAutomateDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->main);
}


static void ccm_automate_dialog_class_init (CCMAutomateDialogClass * klass) {
	ccm_automate_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CCMAutomateDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = ccm_automate_dialog_finalize;
}


static void ccm_automate_dialog_instance_init (CCMAutomateDialog * self) {
	self->priv = CCM_AUTOMATE_DIALOG_GET_PRIVATE (self);
}


static void ccm_automate_dialog_finalize (GObject* obj) {
	CCMAutomateDialog * self;
	self = CCM_AUTOMATE_DIALOG (obj);
	{
		gtk_object_destroy ((GtkObject*) self->priv->main);
	}
	(self->priv->timeline == NULL) ? NULL : (self->priv->timeline = (g_object_unref (self->priv->timeline), NULL));
	(self->priv->main == NULL) ? NULL : (self->priv->main = (g_object_unref (self->priv->main), NULL));
	(self->priv->close == NULL) ? NULL : (self->priv->close = (g_object_unref (self->priv->close), NULL));
	(self->priv->close_image == NULL) ? NULL : (self->priv->close_image = (g_object_unref (self->priv->close_image), NULL));
	(self->priv->hint_motion == NULL) ? NULL : (self->priv->hint_motion = (g_object_unref (self->priv->hint_motion), NULL));
	(self->priv->story_board == NULL) ? NULL : (self->priv->story_board = (g_object_unref (self->priv->story_board), NULL));
	G_OBJECT_CLASS (ccm_automate_dialog_parent_class)->finalize (obj);
}


static GType ccm_automate_dialog_type_id = 0;
GType ccm_automate_dialog_get_type (void) {
	return ccm_automate_dialog_type_id;
}


GType ccm_automate_dialog_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMAutomateDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_automate_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMAutomateDialog), 0, (GInstanceInitFunc) ccm_automate_dialog_instance_init, NULL };
	ccm_automate_dialog_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "CCMAutomateDialog", &g_define_type_info, 0);
	return ccm_automate_dialog_type_id;
}




