/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */

#include <ccm-automate.h>
#include <stdlib.h>
#include <string.h>
#include <ccm-keybind.h>
#include <ccm-config.h>
#include <ccm-debug.h>
#include <ccm-automate-dialog.h>


#define CCM_AUTOMATE_TYPE_OPTIONS (ccm_automate_options_get_type ())

typedef enum  {
	CCM_AUTOMATE_OPTIONS_SHOW_SHORTCUT,
	CCM_AUTOMATE_OPTIONS_N
} CCMAutomateOptions;



struct _CCMAutomatePrivate {
	char** options;
	gint options_length1;
	gint options_size;
	CCMScreen* screen;
	gboolean enable;
	CCMAutomateDialog* dialog;
	CCMKeybind* show_keybind;
	CCMConfig** configs;
	gint configs_length1;
	gint configs_size;
};

#define CCM_AUTOMATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CCM_TYPE_AUTOMATE, CCMAutomatePrivate))
enum  {
	CCM_AUTOMATE_DUMMY_PROPERTY
};
GType ccm_automate_options_get_type (void);
static void ccm_automate_on_show_shortcut_pressed (CCMAutomate* self);
static void _ccm_automate_on_show_shortcut_pressed_ccm_keybind_key_press (CCMKeybind* _sender, gpointer self);
static void ccm_automate_get_show_shortcut (CCMAutomate* self);
static void ccm_automate_on_changed (CCMAutomate* self);
static void _ccm_automate_on_changed_ccm_config_changed (CCMConfig* _sender, gpointer self);
static void ccm_automate_real_load_options (CCMScreenPlugin* base, CCMScreen* screen);
static gpointer ccm_automate_parent_class = NULL;
static CCMScreenPluginIface* ccm_automate_ccm_screen_plugin_parent_iface = NULL;
static void ccm_automate_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);




GType ccm_automate_options_get_type (void) {
	static GType ccm_automate_options_type_id = 0;
	if (G_UNLIKELY (ccm_automate_options_type_id == 0)) {
		static const GEnumValue values[] = {{CCM_AUTOMATE_OPTIONS_SHOW_SHORTCUT, "CCM_AUTOMATE_OPTIONS_SHOW_SHORTCUT", "show-shortcut"}, {CCM_AUTOMATE_OPTIONS_N, "CCM_AUTOMATE_OPTIONS_N", "n"}, {0, NULL, NULL}};
		ccm_automate_options_type_id = g_enum_register_static ("CCMAutomateOptions", values);
	}
	return ccm_automate_options_type_id;
}


static void ccm_automate_on_show_shortcut_pressed (CCMAutomate* self) {
	g_return_if_fail (self != NULL);
	self->priv->enable = !self->priv->enable;
	if (self->priv->enable) {
		ccm_automate_dialog_show (self->priv->dialog);
	} else {
		ccm_automate_dialog_hide (self->priv->dialog);
	}
}


static void _ccm_automate_on_show_shortcut_pressed_ccm_keybind_key_press (CCMKeybind* _sender, gpointer self) {
	ccm_automate_on_show_shortcut_pressed (self);
}


static void ccm_automate_get_show_shortcut (CCMAutomate* self) {
	GError * inner_error;
	char* shortcut;
	CCMKeybind* _tmp3;
	const char* _tmp2;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	shortcut = g_strdup ("<Super>a");
	{
		char* _tmp0;
		char* _tmp1;
		_tmp0 = ccm_config_get_string (self->priv->configs[CCM_AUTOMATE_OPTIONS_SHOW_SHORTCUT], &inner_error);
		if (inner_error != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
		_tmp1 = NULL;
		shortcut = (_tmp1 = _tmp0, shortcut = (g_free (shortcut), NULL), _tmp1);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * ex;
		ex = inner_error;
		inner_error = NULL;
		{
			ccm_log ("Error on get show shortcut config get default", NULL);
			(ex == NULL) ? NULL : (ex = (g_error_free (ex), NULL));
		}
	}
	__finally3:
	if (inner_error != NULL) {
		shortcut = (g_free (shortcut), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->show_keybind = (_tmp3 = ccm_keybind_new (self->priv->screen, (_tmp2 = shortcut, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), TRUE), (self->priv->show_keybind == NULL) ? NULL : (self->priv->show_keybind = (g_object_unref (self->priv->show_keybind), NULL)), _tmp3);
	g_signal_connect_object (self->priv->show_keybind, "key-press", (GCallback) _ccm_automate_on_show_shortcut_pressed_ccm_keybind_key_press, self, 0);
	shortcut = (g_free (shortcut), NULL);
}


static void ccm_automate_on_changed (CCMAutomate* self) {
	g_return_if_fail (self != NULL);
	/* Reload show shortcut*/
	ccm_automate_get_show_shortcut (self);
}


static void _ccm_automate_on_changed_ccm_config_changed (CCMConfig* _sender, gpointer self) {
	ccm_automate_on_changed (self);
}


static void ccm_automate_real_load_options (CCMScreenPlugin* base, CCMScreen* screen) {
	CCMAutomate * self;
	CCMAutomateDialog* _tmp0;
	self = (CCMAutomate*) base;
	g_return_if_fail (screen != NULL);
	self->priv->screen = screen;
	_tmp0 = NULL;
	self->priv->dialog = (_tmp0 = ccm_automate_dialog_new (screen), (self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL)), _tmp0);
	{
		gint cpt;
		/* Get config object*/
		cpt = 0;
		for (; cpt < ((gint) CCM_AUTOMATE_OPTIONS_N); cpt = cpt + 1) {
			CCMConfig* _tmp2;
			const char* _tmp1;
			_tmp2 = NULL;
			_tmp1 = NULL;
			self->priv->configs[cpt] = (_tmp2 = ccm_config_new ((gint) ccm_screen_get_number (screen), g_strdup ("automate"), (_tmp1 = self->priv->options[cpt], (_tmp1 == NULL) ? NULL : g_strdup (_tmp1))), (self->priv->configs[cpt] == NULL) ? NULL : (self->priv->configs[cpt] = (g_object_unref (self->priv->configs[cpt]), NULL)), _tmp2);
			if (self->priv->configs[cpt] != NULL) {
				g_signal_connect_object (self->priv->configs[cpt], "changed", (GCallback) _ccm_automate_on_changed_ccm_config_changed, self, 0);
			}
		}
	}
	/* get default shortcut*/
	ccm_automate_get_show_shortcut (self);
	ccm_screen_plugin_load_options (CCM_SCREEN_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), screen);
}


CCMAutomate* ccm_automate_construct (GType object_type) {
	CCMAutomate * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


CCMAutomate* ccm_automate_new (void) {
	return ccm_automate_construct (CCM_TYPE_AUTOMATE);
}


static void ccm_automate_class_init (CCMAutomateClass * klass) {
	ccm_automate_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CCMAutomatePrivate));
	G_OBJECT_CLASS (klass)->finalize = ccm_automate_finalize;
}


static void ccm_automate_ccm_screen_plugin_interface_init (CCMScreenPluginIface * iface) {
	ccm_automate_ccm_screen_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->load_options = ccm_automate_real_load_options;
}


static void ccm_automate_instance_init (CCMAutomate * self) {
	char** _tmp0;
	self->priv = CCM_AUTOMATE_GET_PRIVATE (self);
	self->priv->options = (_tmp0 = g_new0 (char*, 1 + 1), _tmp0[0] = g_strdup ("show"), _tmp0);
	self->priv->options_length1 = 1;
	_tmp0 = NULL;
	self->priv->enable = FALSE;
	self->priv->configs = g_new0 (CCMConfig*, CCM_AUTOMATE_OPTIONS_N + 1);
	self->priv->configs_length1 = CCM_AUTOMATE_OPTIONS_N;
}


static void ccm_automate_finalize (GObject* obj) {
	CCMAutomate * self;
	self = CCM_AUTOMATE (obj);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	(self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL));
	(self->priv->show_keybind == NULL) ? NULL : (self->priv->show_keybind = (g_object_unref (self->priv->show_keybind), NULL));
	self->priv->configs = (_vala_array_free (self->priv->configs, self->priv->configs_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (ccm_automate_parent_class)->finalize (obj);
}


static GType ccm_automate_type_id = 0;
GType ccm_automate_get_type (void) {
	return ccm_automate_type_id;
}


GType ccm_automate_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMAutomateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_automate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMAutomate), 0, (GInstanceInitFunc) ccm_automate_instance_init, NULL };
	static const GInterfaceInfo ccm_screen_plugin_info = { (GInterfaceInitFunc) ccm_automate_ccm_screen_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	ccm_automate_type_id = g_type_module_register_type (module, CCM_TYPE_PLUGIN, "CCMAutomate", &g_define_type_info, 0);
	g_type_add_interface_static (ccm_automate_type_id, CCM_TYPE_SCREEN_PLUGIN, &ccm_screen_plugin_info);
	return ccm_automate_type_id;
}


GType ccm_automate_get_plugin_type (GTypeModule* module) {
	g_return_val_if_fail (module != NULL, 0UL);
	ccm_action_register_type (module);
	ccm_action_pointer_register_type (module);
	ccm_action_pointer_motion_register_type (module);
	ccm_action_pointer_press_register_type (module);
	ccm_action_pointer_release_register_type (module);
	ccm_story_board_register_type (module);
	ccm_automate_dialog_register_type (module);
	ccm_automate_register_type (module);
	return CCM_TYPE_AUTOMATE;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}




