/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */

#include <ccm-story-board.h>
#include <ccm-display.h>
#include <X11/X.h>
#include <float.h>
#include <math.h>
#include <ccm-debug.h>
#include <ccm-action.h>
#include <ccm-action-pointer-motion.h>
#include <ccm-action-pointer-press.h>
#include <ccm-action-pointer-release.h>




struct _CCMStoryBoardPrivate {
	gboolean _hint_motion;
	CCMScreen* screen;
	char* name;
	GList* ignore;
	GList* actions;
	GTimeVal time;
};

#define CCM_STORY_BOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CCM_TYPE_STORY_BOARD, CCMStoryBoardPrivate))
enum  {
	CCM_STORY_BOARD_DUMMY_PROPERTY,
	CCM_STORY_BOARD_HINT_MOTION
};
static void _g_list_free_g_object_unref (GList* self);
static void _ccm_story_board_on_event_ccm_display_event (CCMDisplay* _sender, XEvent* event, gpointer self);
static void ccm_story_board_on_event (CCMStoryBoard* self, CCMDisplay* display, XEvent* event);
static gpointer ccm_story_board_parent_class = NULL;
static void ccm_story_board_finalize (GObject* obj);



static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void _ccm_story_board_on_event_ccm_display_event (CCMDisplay* _sender, XEvent* event, gpointer self) {
	ccm_story_board_on_event (self, _sender, event);
}


CCMStoryBoard* ccm_story_board_construct (GType object_type, CCMScreen* screen, const char* name, GList* ignore) {
	CCMStoryBoard * self;
	CCMScreen* _tmp1;
	CCMScreen* _tmp0;
	char* _tmp3;
	const char* _tmp2;
	GList* _tmp4;
	GTimeVal _tmp5 = {0};
	GList* _tmp6;
	CCMDisplay* _tmp7;
	CCMDisplay* display;
	g_return_val_if_fail (screen != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (ignore != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	ccm_story_board_set_hint_motion (self, FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->screen = (_tmp1 = (_tmp0 = screen, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->screen == NULL) ? NULL : (self->priv->screen = (g_object_unref (self->priv->screen), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->name = (_tmp3 = (_tmp2 = name, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), self->priv->name = (g_free (self->priv->name), NULL), _tmp3);
	_tmp4 = NULL;
	self->priv->actions = (_tmp4 = NULL, (self->priv->actions == NULL) ? NULL : (self->priv->actions = (_g_list_free_g_object_unref (self->priv->actions), NULL)), _tmp4);
	self->priv->time = (g_get_current_time (&_tmp5), _tmp5);
	_tmp6 = NULL;
	self->priv->ignore = (_tmp6 = g_list_copy (ignore), (self->priv->ignore == NULL) ? NULL : (self->priv->ignore = (g_list_free (self->priv->ignore), NULL)), _tmp6);
	_tmp7 = NULL;
	display = (_tmp7 = ccm_screen_get_display (screen), (_tmp7 == NULL) ? NULL : g_object_ref (_tmp7));
	g_signal_connect_object (display, "event", (GCallback) _ccm_story_board_on_event_ccm_display_event, self, 0);
	return self;
}


CCMStoryBoard* ccm_story_board_new (CCMScreen* screen, const char* name, GList* ignore) {
	return ccm_story_board_construct (CCM_TYPE_STORY_BOARD, screen, name, ignore);
}


static void ccm_story_board_on_event (CCMStoryBoard* self, CCMDisplay* display, XEvent* event) {
	GError * inner_error;
	GTimeVal _tmp0 = {0};
	GTimeVal current;
	glong diff;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (event != NULL);
	inner_error = NULL;
	current = (g_get_current_time (&_tmp0), _tmp0);
	diff = ((current.tv_sec * 1000000) + current.tv_usec) - ((self->priv->time.tv_sec * 1000000) + self->priv->time.tv_usec);
	if (event->type == MotionNotify) {
		CCMAction* _tmp1;
		CCMAction* _tmp2;
		CCMAction* action;
		gboolean insert;
		gboolean _tmp3;
		_tmp1 = NULL;
		if (g_list_last (self->priv->actions) != NULL) {
			_tmp1 = (CCMAction*) g_list_last (self->priv->actions)->data;
		} else {
			_tmp1 = NULL;
		}
		_tmp2 = NULL;
		action = (_tmp2 = _tmp1, (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2));
		insert = TRUE;
		_tmp3 = FALSE;
		if (self->priv->_hint_motion) {
			_tmp3 = action != NULL;
		} else {
			_tmp3 = FALSE;
		}
		if (_tmp3) {
			if (CCM_IS_ACTION_POINTER_MOTION (action)) {
				ccm_action_pointer_motion_set_event (CCM_ACTION_POINTER_MOTION (action), (XMotionEvent*) event);
				ccm_action_set_time ((CCMAction*) CCM_ACTION_POINTER_MOTION (action), (glong) ((gint) (((double) diff) / ((double) 1000))));
				insert = FALSE;
			}
		}
		if (insert) {
			CCMAction* _tmp4;
			CCMAction* _tmp5;
			_tmp4 = NULL;
			action = (_tmp4 = (CCMAction*) ccm_action_pointer_motion_new (self->priv->screen, (XMotionEvent*) event, diff), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp4);
			_tmp5 = NULL;
			self->priv->actions = g_list_append (self->priv->actions, (_tmp5 = action, (_tmp5 == NULL) ? NULL : g_object_ref (_tmp5)));
		}
		(action == NULL) ? NULL : (action = (g_object_unref (action), NULL));
	} else {
		if (event->type == ButtonPress) {
			{
				CCMActionPointerPress* action;
				CCMAction* _tmp6;
				action = ccm_action_pointer_press_new (self->priv->screen, (XButtonEvent*) event, diff, self->priv->ignore, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == CCM_ACTION_ERROR) {
						goto __catch0_ccm_action_error;
					}
					goto __finally0;
				}
				_tmp6 = NULL;
				self->priv->actions = g_list_append (self->priv->actions, (_tmp6 = (CCMAction*) action, (_tmp6 == NULL) ? NULL : g_object_ref (_tmp6)));
				(action == NULL) ? NULL : (action = (g_object_unref (action), NULL));
			}
			goto __finally0;
			__catch0_ccm_action_error:
			{
				GError * ex;
				ex = inner_error;
				inner_error = NULL;
				{
					ccm_debug (ex->message, NULL);
					(ex == NULL) ? NULL : (ex = (g_error_free (ex), NULL));
				}
			}
			__finally0:
			if (inner_error != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
				g_clear_error (&inner_error);
				return;
			}
		} else {
			if (event->type == ButtonRelease) {
				{
					CCMActionPointerRelease* action;
					CCMAction* _tmp7;
					action = ccm_action_pointer_release_new (self->priv->screen, (XButtonEvent*) event, diff, self->priv->ignore, &inner_error);
					if (inner_error != NULL) {
						if (inner_error->domain == CCM_ACTION_ERROR) {
							goto __catch1_ccm_action_error;
						}
						goto __finally1;
					}
					_tmp7 = NULL;
					self->priv->actions = g_list_append (self->priv->actions, (_tmp7 = (CCMAction*) action, (_tmp7 == NULL) ? NULL : g_object_ref (_tmp7)));
					(action == NULL) ? NULL : (action = (g_object_unref (action), NULL));
				}
				goto __finally1;
				__catch1_ccm_action_error:
				{
					GError * ex;
					ex = inner_error;
					inner_error = NULL;
					{
						ccm_debug (ex->message, NULL);
						(ex == NULL) ? NULL : (ex = (g_error_free (ex), NULL));
					}
				}
				__finally1:
				if (inner_error != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
					return;
				}
			}
		}
	}
	self->priv->time = current;
}


char* ccm_story_board_to_string (CCMStoryBoard* self, const char* format) {
	char* val;
	char* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	val = g_strdup ("<story-board>\n");
	{
		GList* action_collection;
		GList* action_it;
		action_collection = self->priv->actions;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			CCMAction* _tmp4;
			CCMAction* action;
			_tmp4 = NULL;
			action = (_tmp4 = (CCMAction*) action_it->data, (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4));
			{
				char* _tmp3;
				char* _tmp2;
				char* _tmp1;
				char* _tmp0;
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp1 = NULL;
				_tmp0 = NULL;
				val = (_tmp3 = g_strconcat (val, _tmp2 = g_strconcat (_tmp1 = g_strconcat ("  ", _tmp0 = ccm_action_to_string (action, "%ccma"), NULL), "\n", NULL), NULL), val = (g_free (val), NULL), _tmp3);
				_tmp2 = (g_free (_tmp2), NULL);
				_tmp1 = (g_free (_tmp1), NULL);
				_tmp0 = (g_free (_tmp0), NULL);
				(action == NULL) ? NULL : (action = (g_object_unref (action), NULL));
			}
		}
	}
	_tmp5 = NULL;
	val = (_tmp5 = g_strconcat (val, "</story-board>\n", NULL), val = (g_free (val), NULL), _tmp5);
	return val;
}


gboolean ccm_story_board_get_hint_motion (CCMStoryBoard* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_hint_motion;
}


void ccm_story_board_set_hint_motion (CCMStoryBoard* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_hint_motion = value;
	g_object_notify ((GObject *) self, "hint-motion");
}


static void ccm_story_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CCMStoryBoard * self;
	gpointer boxed;
	self = CCM_STORY_BOARD (object);
	switch (property_id) {
		case CCM_STORY_BOARD_HINT_MOTION:
		g_value_set_boolean (value, ccm_story_board_get_hint_motion (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ccm_story_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CCMStoryBoard * self;
	self = CCM_STORY_BOARD (object);
	switch (property_id) {
		case CCM_STORY_BOARD_HINT_MOTION:
		ccm_story_board_set_hint_motion (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ccm_story_board_class_init (CCMStoryBoardClass * klass) {
	ccm_story_board_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CCMStoryBoardPrivate));
	G_OBJECT_CLASS (klass)->get_property = ccm_story_board_get_property;
	G_OBJECT_CLASS (klass)->set_property = ccm_story_board_set_property;
	G_OBJECT_CLASS (klass)->finalize = ccm_story_board_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CCM_STORY_BOARD_HINT_MOTION, g_param_spec_boolean ("hint-motion", "hint-motion", "hint-motion", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ccm_story_board_instance_init (CCMStoryBoard * self) {
	self->priv = CCM_STORY_BOARD_GET_PRIVATE (self);
}


static void ccm_story_board_finalize (GObject* obj) {
	CCMStoryBoard * self;
	self = CCM_STORY_BOARD (obj);
	(self->priv->screen == NULL) ? NULL : (self->priv->screen = (g_object_unref (self->priv->screen), NULL));
	self->priv->name = (g_free (self->priv->name), NULL);
	(self->priv->ignore == NULL) ? NULL : (self->priv->ignore = (g_list_free (self->priv->ignore), NULL));
	(self->priv->actions == NULL) ? NULL : (self->priv->actions = (_g_list_free_g_object_unref (self->priv->actions), NULL));
	G_OBJECT_CLASS (ccm_story_board_parent_class)->finalize (obj);
}


static GType ccm_story_board_type_id = 0;
GType ccm_story_board_get_type (void) {
	return ccm_story_board_type_id;
}


GType ccm_story_board_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMStoryBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_story_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMStoryBoard), 0, (GInstanceInitFunc) ccm_story_board_instance_init, NULL };
	ccm_story_board_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "CCMStoryBoard", &g_define_type_info, 0);
	return ccm_story_board_type_id;
}




