/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */

#ifndef __CCM_STORY_BOARD_H__
#define __CCM_STORY_BOARD_H__

#include <glib.h>
#include <glib-object.h>
#include <ccm.h>
#include <ccm-screen.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define CCM_TYPE_STORY_BOARD (ccm_story_board_get_type ())
#define CCM_STORY_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_STORY_BOARD, CCMStoryBoard))
#define CCM_STORY_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_STORY_BOARD, CCMStoryBoardClass))
#define CCM_IS_STORY_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_STORY_BOARD))
#define CCM_IS_STORY_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_STORY_BOARD))
#define CCM_STORY_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_STORY_BOARD, CCMStoryBoardClass))

typedef struct _CCMStoryBoard CCMStoryBoard;
typedef struct _CCMStoryBoardClass CCMStoryBoardClass;
typedef struct _CCMStoryBoardPrivate CCMStoryBoardPrivate;

struct _CCMStoryBoard {
	GObject parent_instance;
	CCMStoryBoardPrivate * priv;
};

struct _CCMStoryBoardClass {
	GObjectClass parent_class;
};


CCMStoryBoard* ccm_story_board_construct (GType object_type, CCMScreen* screen, const char* name, GList* ignore);
CCMStoryBoard* ccm_story_board_new (CCMScreen* screen, const char* name, GList* ignore);
char* ccm_story_board_to_string (CCMStoryBoard* self, const char* format);
gboolean ccm_story_board_get_hint_motion (CCMStoryBoard* self);
void ccm_story_board_set_hint_motion (CCMStoryBoard* self, gboolean value);
GType ccm_story_board_get_type (void);
GType ccm_story_board_register_type (GTypeModule * module);


G_END_DECLS

#endif
