/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */

#include <ccm-vala-window-plugin.h>
#include <stdlib.h>
#include <string.h>
#include <ccm-config.h>
#include <ccm-drawable.h>
#include <ccm-screen.h>
#include <float.h>
#include <math.h>


#define CCM_VALA_WINDOW_PLUGIN_TYPE_OPTIONS (ccm_vala_window_plugin_options_get_type ())

typedef enum  {
	CCM_VALA_WINDOW_PLUGIN_OPTIONS_ENABLE,
	CCM_VALA_WINDOW_PLUGIN_OPTIONS_N
} CCMValaWindowPluginOptions;



static CCMRegion* ccm_drawable_get_damaged (CCMDrawable* self);
struct _CCMValaWindowPluginPrivate {
	char** options;
	gint options_length1;
	gint options_size;
	CCMWindow* window;
	gboolean enabled;
	guint counter;
	CCMConfig** configs;
	gint configs_length1;
	gint configs_size;
};

#define CCM_VALA_WINDOW_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CCM_TYPE_VALA_WINDOW_PLUGIN, CCMValaWindowPluginPrivate))
enum  {
	CCM_VALA_WINDOW_PLUGIN_DUMMY_PROPERTY
};
GType ccm_vala_window_plugin_options_get_type (void);
static void ccm_vala_window_plugin_on_changed (CCMValaWindowPlugin* self, CCMConfig* config);
static void _ccm_vala_window_plugin_on_changed_ccm_config_changed (CCMConfig* _sender, gpointer self);
static void ccm_vala_window_plugin_real_load_options (CCMWindowPlugin* base, CCMWindow* window);
static gboolean ccm_vala_window_plugin_real_paint (CCMWindowPlugin* base, CCMWindow* window, cairo_t* ctx, cairo_surface_t* surface, gboolean y_invert);
static gpointer ccm_vala_window_plugin_parent_class = NULL;
static CCMWindowPluginIface* ccm_vala_window_plugin_ccm_window_plugin_parent_iface = NULL;
static void ccm_vala_window_plugin_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static CCMRegion* ccm_drawable_get_damaged (CCMDrawable* self) {
	void* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	return (CCMRegion*) (g_object_get (self, "damaged", &_tmp0, NULL), _tmp0);
}



GType ccm_vala_window_plugin_options_get_type (void) {
	static GType ccm_vala_window_plugin_options_type_id = 0;
	if (G_UNLIKELY (ccm_vala_window_plugin_options_type_id == 0)) {
		static const GEnumValue values[] = {{CCM_VALA_WINDOW_PLUGIN_OPTIONS_ENABLE, "CCM_VALA_WINDOW_PLUGIN_OPTIONS_ENABLE", "enable"}, {CCM_VALA_WINDOW_PLUGIN_OPTIONS_N, "CCM_VALA_WINDOW_PLUGIN_OPTIONS_N", "n"}, {0, NULL, NULL}};
		ccm_vala_window_plugin_options_type_id = g_enum_register_static ("CCMValaWindowPluginOptions", values);
	}
	return ccm_vala_window_plugin_options_type_id;
}


static void ccm_vala_window_plugin_on_changed (CCMValaWindowPlugin* self, CCMConfig* config) {
	GError * inner_error;
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	inner_error = NULL;
	_tmp0 = ccm_config_get_boolean (config, &inner_error);
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	self->priv->enabled = _tmp0;
	if (!self->priv->enabled) {
		ccm_screen_damage (ccm_drawable_get_screen ((CCMDrawable*) self->priv->window));
	}
}


static void _ccm_vala_window_plugin_on_changed_ccm_config_changed (CCMConfig* _sender, gpointer self) {
	ccm_vala_window_plugin_on_changed (self, _sender);
}


/**
 * Implement load_options window plugin interface
 **/
static void ccm_vala_window_plugin_real_load_options (CCMWindowPlugin* base, CCMWindow* window) {
	CCMValaWindowPlugin * self;
	GError * inner_error;
	CCMScreen* _tmp0;
	CCMScreen* screen;
	gboolean _tmp3;
	self = (CCMValaWindowPlugin*) base;
	g_return_if_fail (window != NULL);
	inner_error = NULL;
	self->priv->window = window;
	_tmp0 = NULL;
	screen = (_tmp0 = ccm_drawable_get_screen ((CCMDrawable*) window), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	{
		gint cpt;
		/* create configs */
		cpt = 0;
		for (; cpt < ((gint) CCM_VALA_WINDOW_PLUGIN_OPTIONS_N); cpt = cpt + 1) {
			CCMConfig* _tmp2;
			const char* _tmp1;
			_tmp2 = NULL;
			_tmp1 = NULL;
			self->priv->configs[cpt] = (_tmp2 = ccm_config_new ((gint) ccm_screen_get_number (screen), g_strdup ("vala-window-plugin"), (_tmp1 = self->priv->options[cpt], (_tmp1 == NULL) ? NULL : g_strdup (_tmp1))), (self->priv->configs[cpt] == NULL) ? NULL : (self->priv->configs[cpt] = (g_object_unref (self->priv->configs[cpt]), NULL)), _tmp2);
			if (self->priv->configs[cpt] != NULL) {
				g_signal_connect_object (self->priv->configs[cpt], "changed", (GCallback) _ccm_vala_window_plugin_on_changed_ccm_config_changed, self, 0);
			}
		}
	}
	_tmp3 = ccm_config_get_boolean (self->priv->configs[(gint) CCM_VALA_WINDOW_PLUGIN_OPTIONS_ENABLE], &inner_error);
	if (inner_error != NULL) {
		(screen == NULL) ? NULL : (screen = (g_object_unref (screen), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	self->priv->enabled = _tmp3;
	/* Chain call to next plugin */
	ccm_window_plugin_load_options (CCM_WINDOW_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), window);
	(screen == NULL) ? NULL : (screen = (g_object_unref (screen), NULL));
}


/**
 * Implement paint window plugin interface
 **/
static gboolean ccm_vala_window_plugin_real_paint (CCMWindowPlugin* base, CCMWindow* window, cairo_t* ctx, cairo_surface_t* surface, gboolean y_invert) {
	CCMValaWindowPlugin * self;
	gboolean ret;
	self = (CCMValaWindowPlugin*) base;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	g_return_val_if_fail (surface != NULL, FALSE);
	ret = FALSE;
	/* Chain call to next plugin */
	ret = ccm_window_plugin_paint (CCM_WINDOW_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), window, ctx, surface, y_invert);
	/* Paint damaged area */
	if (self->priv->enabled) {
		CCMRegion* damaged;
		damaged = ccm_region_copy (ccm_drawable_get_damaged ((CCMDrawable*) window));
		if (damaged != NULL) {
			gint rectangles_size;
			gint rectangles_length1;
			cairo_rectangle_t* rectangles;
			rectangles = (rectangles_length1 = 0, NULL);
			ccm_region_get_rectangles (damaged, &rectangles, &rectangles_length1);
			switch (self->priv->counter) {
				case 0:
				{
					cairo_set_source_rgba (ctx, (double) 1, (double) 0, (double) 0, 0.5);
					break;
				}
				case 1:
				{
					cairo_set_source_rgba (ctx, (double) 0, (double) 1, (double) 0, 0.5);
					break;
				}
				case 2:
				{
					cairo_set_source_rgba (ctx, (double) 0, (double) 0, (double) 1, 0.5);
					break;
				}
				default:
				{
					break;
				}
			}
			if ((self->priv->counter = self->priv->counter + 1) > 2) {
				self->priv->counter = (guint) 0;
			}
			{
				cairo_rectangle_t* rectangle_collection;
				int rectangle_collection_length1;
				int rectangle_it;
				rectangle_collection = rectangles;
				rectangle_collection_length1 = rectangles_length1;
				for (rectangle_it = 0; rectangle_it < rectangles_length1; rectangle_it = rectangle_it + 1) {
					cairo_rectangle_t rectangle;
					rectangle = rectangle_collection[rectangle_it];
					{
						cairo_rectangle (ctx, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
					}
				}
			}
			cairo_fill (ctx);
			rectangles = (g_free (rectangles), NULL);
		}
		(damaged == NULL) ? NULL : (damaged = (ccm_region_destroy (damaged), NULL));
	}
	return ret;
}


CCMValaWindowPlugin* ccm_vala_window_plugin_construct (GType object_type) {
	CCMValaWindowPlugin * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


CCMValaWindowPlugin* ccm_vala_window_plugin_new (void) {
	return ccm_vala_window_plugin_construct (CCM_TYPE_VALA_WINDOW_PLUGIN);
}


static void ccm_vala_window_plugin_class_init (CCMValaWindowPluginClass * klass) {
	ccm_vala_window_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CCMValaWindowPluginPrivate));
	G_OBJECT_CLASS (klass)->finalize = ccm_vala_window_plugin_finalize;
}


static void ccm_vala_window_plugin_ccm_window_plugin_interface_init (CCMWindowPluginIface * iface) {
	ccm_vala_window_plugin_ccm_window_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->load_options = ccm_vala_window_plugin_real_load_options;
	iface->paint = ccm_vala_window_plugin_real_paint;
}


static void ccm_vala_window_plugin_instance_init (CCMValaWindowPlugin * self) {
	char** _tmp0;
	self->priv = CCM_VALA_WINDOW_PLUGIN_GET_PRIVATE (self);
	self->priv->options = (_tmp0 = g_new0 (char*, 1 + 1), _tmp0[0] = g_strdup ("enable"), _tmp0);
	self->priv->options_length1 = 1;
	_tmp0 = NULL;
	self->priv->enabled = FALSE;
	self->priv->counter = (guint) 0;
	self->priv->configs = g_new0 (CCMConfig*, CCM_VALA_WINDOW_PLUGIN_OPTIONS_N + 1);
	self->priv->configs_length1 = CCM_VALA_WINDOW_PLUGIN_OPTIONS_N;
}


static void ccm_vala_window_plugin_finalize (GObject* obj) {
	CCMValaWindowPlugin * self;
	self = CCM_VALA_WINDOW_PLUGIN (obj);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->configs = (_vala_array_free (self->priv->configs, self->priv->configs_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (ccm_vala_window_plugin_parent_class)->finalize (obj);
}


static GType ccm_vala_window_plugin_type_id = 0;
GType ccm_vala_window_plugin_get_type (void) {
	return ccm_vala_window_plugin_type_id;
}


GType ccm_vala_window_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMValaWindowPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_vala_window_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMValaWindowPlugin), 0, (GInstanceInitFunc) ccm_vala_window_plugin_instance_init, NULL };
	static const GInterfaceInfo ccm_window_plugin_info = { (GInterfaceInitFunc) ccm_vala_window_plugin_ccm_window_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	ccm_vala_window_plugin_type_id = g_type_module_register_type (module, CCM_TYPE_PLUGIN, "CCMValaWindowPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (ccm_vala_window_plugin_type_id, CCM_TYPE_WINDOW_PLUGIN, &ccm_window_plugin_info);
	return ccm_vala_window_plugin_type_id;
}


/**
 * Init plugin
 **/
GType ccm_vala_window_plugin_get_plugin_type (GTypeModule* module) {
	g_return_val_if_fail (module != NULL, 0UL);
	ccm_vala_window_plugin_register_type (module);
	return CCM_TYPE_VALA_WINDOW_PLUGIN;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}




