// Message box. Taken from the FOX library and slightly modified for translation purpose.
// Also added a SU button

#include "config.h"
#include "i18n.h"

#include <fx.h>
#include <fxkeys.h>
#include <FXPNGIcon.h>

#include "icons.h"
#include "File.h"
#include "MessageBox.h"

#include "XFileExplorer.h"

// Padding for message box buttons
#define HORZ_PAD 30
#define VERT_PAD 2

#define BOX_BUTTON_MASK   (BOX_OK|BOX_OK_CANCEL|BOX_YES_NO|BOX_YES_NO_CANCEL|BOX_QUIT_CANCEL|BOX_QUIT_SAVE_CANCEL|BOX_OK_SU)


// Map
FXDEFMAP(MessageBox) MessageBoxMap[]=
{
	FXMAPFUNC(SEL_COMMAND,MessageBox::ID_CANCEL,MessageBox::onCmdCancel),
	FXMAPFUNCS(SEL_COMMAND,MessageBox::ID_CLICKED_YES,MessageBox::ID_CLICKED_SAVE,MessageBox::onCmdClicked),
	FXMAPFUNC(SEL_COMMAND,MessageBox::ID_CLICKED_SU,MessageBox::onCmdSu),
};



// Object implementation
FXIMPLEMENT(MessageBox,DialogBox,MessageBoxMap,ARRAYNUMBER(MessageBoxMap))


// Construct message box with given caption, icon, and message text
MessageBox::MessageBox(FXWindow* owner,const FXString& caption,const FXString& text,FXIcon* ic,FXuint opts,FXint x,FXint y):
        DialogBox(owner,caption,opts|DECOR_TITLE|DECOR_BORDER,x,y,0,0, 0,0,0,0, 4,4)
{
    initialize(text,ic,opts&BOX_BUTTON_MASK);
}


// Construct free floating message box with given caption, icon, and message text
MessageBox::MessageBox(FXApp* a,const FXString& caption,const FXString& text,FXIcon* ic,FXuint opts,FXint x,FXint y):
        DialogBox(a,caption,opts|DECOR_TITLE|DECOR_BORDER,x,y,0,0, 0,0,0,0, 4,4)
{
    initialize(text,ic,opts&BOX_BUTTON_MASK);
}


// Build contents
void MessageBox::initialize(const FXString& text,FXIcon* ic,FXuint whichbuttons)
{
    FXButton *initial;
    FXVerticalFrame* content=new FXVerticalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y);
    FXHorizontalFrame* info=new FXHorizontalFrame(content,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,10,10,10,10);
    new FXLabel(info,FXString::null,ic,ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(info,text,NULL,JUSTIFY_LEFT|ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXHorizontalSeparator(content,SEPARATOR_GROOVE|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X);
    FXHorizontalFrame* buttons=new FXHorizontalFrame(content,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH,0,0,0,0,10,10,10,10);
    if(whichbuttons==BOX_OK)
    {
        initial=new FXButton(buttons,_("&OK"),NULL,this,ID_CLICKED_OK,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
    else if(whichbuttons==BOX_OK_SU)
    {
        initial=new FXButton(buttons,_("&OK"),NULL,this,ID_CLICKED_OK,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        FXButton *btn=new FXButton(buttons,_(" \tLaunch Xfe as root (Shift-F3)"),minixferooticon,this,ID_CLICKED_SU,BUTTON_DEFAULT|ICON_AFTER_TEXT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
		FXHotKey hotkey=(SHIFTMASK<<16) | KEY_F3;
		btn->addHotKey(hotkey);
		initial->setFocus();
    }
    else if(whichbuttons==BOX_OK_CANCEL)
    {
        initial=new FXButton(buttons,_("&Cancel"),NULL,this,ID_CLICKED_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&OK"),NULL,this,ID_CLICKED_OK,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
    else if(whichbuttons==BOX_YES_NO)
    {
        initial=new FXButton(buttons,_("&No"),NULL,this,ID_CLICKED_NO,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
		new FXButton(buttons,_("&Yes"),NULL,this,ID_CLICKED_YES,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
    else if(whichbuttons==BOX_YES_NO_CANCEL)
    {
        initial=new FXButton(buttons,_("&Cancel"),NULL,this,ID_CLICKED_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&Yes"),NULL,this,ID_CLICKED_YES,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&No"),NULL,this,ID_CLICKED_NO,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
    else if(whichbuttons==BOX_QUIT_CANCEL)
    {
        initial=new FXButton(buttons,_("&Cancel"),NULL,this,ID_CLICKED_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&Quit"),NULL,this,ID_CLICKED_QUIT,BUTTON_INITIAL|BUTTON_DEFAULT|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
    else if(whichbuttons==BOX_QUIT_SAVE_CANCEL)
    {
        initial=new FXButton(buttons,_("&Cancel"),NULL,this,ID_CLICKED_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&Quit"),NULL,this,ID_CLICKED_QUIT,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        new FXButton(buttons,_("&Save"),NULL,this,ID_CLICKED_SAVE,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
        initial->setFocus();
    }
}


// Close dialog
long MessageBox::onCmdClicked(FXObject*,FXSelector sel,void*)
{
    getApp()->stopModal(this,BOX_CLICKED_YES+(FXSELID(sel)-ID_CLICKED_YES));
    hide();
    return 1;
}

// Launch a root Xfe (su mode)
long MessageBox::onCmdSu(FXObject*,FXSelector sel,void*)
{
    getApp()->stopModal(this,BOX_CLICKED_YES+(FXSELID(sel)-ID_CLICKED_YES));
    hide();
    
	// Wait cursor
	getApp()->beginWaitCursor();

	// Obtain preferred root mode
	FXbool use_sudo=getApp()->reg().readUnsignedEntry("OPTIONS","use_sudo",FALSE);

	// Use sudo or su to launch xfe as root
	FXString command = "xterm -title ";
	FXString title, sucmd;
	if (use_sudo)
	{
		title = _("Enter the user password:");
		sucmd = SUDOCMD;
	}
	else
	{
		title = _("Enter the root password:");
		sucmd = SUCMD;
	}
	
	// Use appropriate background and foreground colors for the xterm
	FXchar color[64];
	fxnamefromcolor(color,getApp()->getBackColor());
	FXString bg=" -bg ";
	bg = bg + ::quote(color) + " ";
	fxnamefromcolor(color,getApp()->getForeColor());
	FXString fg=" -fg ";
	fg = fg + ::quote(color) + " ";
	
	// Execute command
	command = command + ::quote(title) +  bg + fg + sucmd + "&";
	FXint ret=system(command.text());
	if (ret!=0)
	{
        error(getApp(),BOX_OK,_("Error"),_("An error has occurred! \nPlease note that the root mode requires a working xterm installed on your system."));
		getApp()->endWaitCursor();
		return 0;
	}
 	// Wait cursor
	getApp()->endWaitCursor();

    return 1;
}

// Close dialog with a cancel
long MessageBox::onCmdCancel(FXObject* sender,FXSelector,void* ptr)
{
    return MessageBox::onCmdClicked(sender,FXSEL(SEL_COMMAND,ID_CLICKED_CANCEL),ptr);
}

// Show a modal error message
FXuint MessageBox::error(FXWindow* owner,FXuint opts,const char* caption,const char* message,...)
{
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(owner,caption,FXStringVFormat(message,arguments),errorbigicon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}


// Show a modal error message, in free floating window
FXuint MessageBox::error(FXApp* app,FXuint opts,const char* caption,const char* message,...)
{
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(app,caption,FXStringVFormat(message,arguments),errorbigicon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}


// Show a modal warning message
FXuint MessageBox::warning(FXWindow* owner,FXuint opts,const char* caption,const char* message,...)
{
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(owner,caption,FXStringVFormat(message,arguments),warningbigicon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}


// Show a modal warning message, in free floating window
FXuint MessageBox::warning(FXApp* app,FXuint opts,const char* caption,const char* message,...)
{
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(app,caption,FXStringVFormat(message,arguments),warningbigicon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}


// Show a modal question dialog
FXuint MessageBox::question(FXWindow* owner,FXuint opts,const char* caption,const char* message,...)
{
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(owner,caption,FXStringVFormat(message,arguments),questionbigicon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}


// Show a modal question dialog, in free floating window
FXuint MessageBox::question(FXApp* app,FXuint opts,const char* caption,const char* message,...)
{
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(app,caption,FXStringVFormat(message,arguments),questionbigicon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}


// Show a modal information dialog
FXuint MessageBox::information(FXWindow* owner,FXuint opts,const char* caption,const char* message,...)
{
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(owner,caption,FXStringVFormat(message,arguments),infobigicon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}


// Show a modal information dialog, in free floating window
FXuint MessageBox::information(FXApp* app,FXuint opts,const char* caption,const char* message,...)
{
    va_list arguments;
    va_start(arguments,message);
    MessageBox box(app,caption,FXStringVFormat(message,arguments),infobigicon,opts|DECOR_TITLE|DECOR_BORDER);
    va_end(arguments);
    return box.execute();
}
