/*
 *
 *  (c) COPYRIGHT INRIA and W3C, 1999-2005
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

#ifndef AMAYA_HELP_H
#define AMAYA_HELP_H

/****************************************
 Help menu definitions

 This file defines the Help menu entries. 
 Add each entry to the Manual string and
 then associate a macro to its index.
***************************************/

static const char *Manual[] = {
"Manual.html",
"Browsing.html",
"Views.html",
"Selecting.html",
"Document.html",
"Creating.html",
"Attributes.html",
"EditChar.html",
"Templates.html",
"Changing.html",
"Links.html",
"Tables.html",
"ImageMaps.html",
"Math.html",
"SVG.html",
"Xml.html",
"StyleSheets.html",
"Searching.html",
"SpellChecking.html",
"Publishing.html",
"Printing.html",
"Numbering.html",
"MakeBook.html",
"Annotations.html",
"Configure.html",
"ShortCuts.html",
"Access.html",
"WebDAV.html"
};

/* index name... which relates to the precedent table */
#define INDEX          0
#define BROWSING       1
#define VIEWS          2
#define SELECTING      3
#define DOCUMENT       4
#define CREATING       5
#define ATTRIBUTES     6
#define EDITCHAR       7
#define TEMPLATING     8
#define CHANGING       9
#define LINKS         10
#define TABLES        11
#define IMAGEMAPS     12
#define MATH          13
#define SVG           14
#define XML           15
#define CSS           16
#define SEARCHING     17
#define SPELLCHECKING 18
#define PUBLISHING    19
#define PRINTING      20
#define NUMBERING     21
#define MAKEBOOK      22
#define ANNOTATE      23
#define CONFIGURE     24
#define SHORTCUTS     25
#define ACCESS        26
#define WEBDAV        27

#endif /* AMAYA_HELP_H */





