/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gelide
 * Copyright (C) 2008 Juan Ángel Moreno Fernández
 *
 * gelide is free software.
 *
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * gelide is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gelide.  If not, see <http://www.gnu.org/licenses/>
 */

#include <fstream>
#include <iostream>
#include <memory>
#include <glibmm.h>
#include <glib/gstdio.h>
#include "config.hpp"
#include "gelide-utils.hpp"

using namespace std;

CConfig::CConfig(void){
	m_user_dir = Glib::get_home_dir() + "/";
	//m_first_run = true;
	//checkDirs();
	Gnome::Conf::init();

	m_conf_client = Gnome::Conf::Client::get_default_client();
	//if(! m_conf_client->dir_exists(GELIDE_GCONF_ROOT))
	//	m_first_run = true;
}

CConfig::~CConfig(void){
	 m_conf_client->suggest_sync();
}

//bool CConfig::isFirstRun(void){
//	return m_first_run;
//}

Glib::ustring CConfig::getSystemsList(void){
	return m_user_dir + USER_SYSTEMS_LIST;
}

Glib::ustring CConfig::getGelideDir(void){
	return m_user_dir + GELIDE_DIR;
}

void CConfig::getAboutDialogPos(int &p_x, int &p_y){
	p_x = getInt(GELIDE_GCONF_DIALOGS, "about_dialog_x");
	p_y = getInt(GELIDE_GCONF_DIALOGS, "about_dialog_y");
}

void CConfig::setAboutDialogPos(const int p_x, const int p_y){
	setInt(GELIDE_GCONF_DIALOGS, "about_dialog_x", p_x);
	setInt(GELIDE_GCONF_DIALOGS, "about_dialog_y", p_y);
}

void CConfig::getChangeLogDialogPos(int &p_x, int &p_y){
	p_x = getInt(GELIDE_GCONF_DIALOGS, "changelog_dialog_x");
	p_y = getInt(GELIDE_GCONF_DIALOGS, "changelog_dialog_y");
}

void CConfig::setChangeLogDialogPos(const int p_x, const int p_y){
	setInt(GELIDE_GCONF_DIALOGS, "changelog_dialog_x", p_x);
	setInt(GELIDE_GCONF_DIALOGS, "changelog_dialog_y", p_y);
}

void CConfig::getColumnsDialogPos(int &p_x, int &p_y){
	p_x = getInt(GELIDE_GCONF_DIALOGS, "columns_dialog_x");
	p_y = getInt(GELIDE_GCONF_DIALOGS, "columns_dialog_y");
}

void CConfig::setColumnsDialogPos(const int p_x, const int p_y){
	setInt(GELIDE_GCONF_DIALOGS, "columns_dialog_x", p_x);
	setInt(GELIDE_GCONF_DIALOGS, "columns_dialog_y", p_y);
}

void CConfig::getEmulatorEditDialogPos(int &p_x, int &p_y){
	p_x = getInt(GELIDE_GCONF_DIALOGS, "emulatoredit_dialog_x");
	p_y = getInt(GELIDE_GCONF_DIALOGS, "emulatoredit_dialog_y");
}

void CConfig::setEmulatorEditDialogPos(const int p_x, const int p_y){
	setInt(GELIDE_GCONF_DIALOGS, "emulatoredit_dialog_x", p_x);
	setInt(GELIDE_GCONF_DIALOGS, "emulatoredit_dialog_y", p_y);
}

void CConfig::getEmulatorLauncherDialogPos(int &p_x, int &p_y){
	p_x = getInt(GELIDE_GCONF_DIALOGS, "emulatorlauncher_dialog_x");
	p_y = getInt(GELIDE_GCONF_DIALOGS, "emulatorlauncher_dialog_y");
}

void CConfig::setEmulatorLauncherDialogPos(const int p_x, const int p_y){
	setInt(GELIDE_GCONF_DIALOGS, "emulatorlauncher_dialog_x", p_x);
	setInt(GELIDE_GCONF_DIALOGS, "emulatorlauncher_dialog_y", p_y);
}

void CConfig::getGameListGeneratorDialogPos(int &p_x, int &p_y){
	p_x = getInt(GELIDE_GCONF_DIALOGS, "gamelistgenerator_dialog_x");
	p_y = getInt(GELIDE_GCONF_DIALOGS, "gamelistgenerator_dialog_y");
}

void CConfig::setGameListGeneratorDialogPos(const int p_x, const int p_y){
	setInt(GELIDE_GCONF_DIALOGS, "gamelistgenerator_dialog_x", p_x);
	setInt(GELIDE_GCONF_DIALOGS, "gamelistgenerator_dialog_y", p_y);
}

void CConfig::getSystemEditDialogPos(int &p_x, int &p_y){
	p_x = getInt(GELIDE_GCONF_DIALOGS, "systemedit_dialog_x");
	p_y = getInt(GELIDE_GCONF_DIALOGS, "systemedit_dialog_y");
}

void CConfig::setSystemEditDialogPos(const int p_x, const int p_y){
	setInt(GELIDE_GCONF_DIALOGS, "systemedit_dialog_x", p_x);
	setInt(GELIDE_GCONF_DIALOGS, "systemedit_dialog_y", p_y);
}

void CConfig::getPreferencesDialogPos(int &p_x, int &p_y){
	p_x = getInt(GELIDE_GCONF_DIALOGS, "preferences_dialog_x");
	p_y = getInt(GELIDE_GCONF_DIALOGS, "preferences_dialog_y");
}

void CConfig::setPreferencesDialogPos(const int p_x, const int p_y){
	setInt(GELIDE_GCONF_DIALOGS, "preferences_dialog_x", p_x);
	setInt(GELIDE_GCONF_DIALOGS, "preferences_dialog_y", p_y);
}


void CConfig::getUISize(int &p_w, int &p_h){
	p_w = getInt(GELIDE_GCONF_UI, "ui_width");
	p_h = getInt(GELIDE_GCONF_UI, "ui_height");
}

void CConfig::setUISize(const int p_w, const int p_h){
	setInt(GELIDE_GCONF_UI, "ui_width", p_w);
	setInt(GELIDE_GCONF_UI, "ui_height", p_h);
}

void CConfig::getUIPos(int &p_x, int &p_y){
	p_x = getInt(GELIDE_GCONF_UI, "ui_x");
	p_y = getInt(GELIDE_GCONF_UI, "ui_y");
}

void CConfig::setUIPos(const int p_x, const int p_y){
	setInt(GELIDE_GCONF_UI, "ui_x", p_x);
	setInt(GELIDE_GCONF_UI, "ui_y", p_y);
}

void CConfig::getUIFullScreen(bool &p_mode){
	if(!keyExist(GELIDE_GCONF_UI, "fullscreen_mode"))
		p_mode = false;
	else
		p_mode = getBool(GELIDE_GCONF_UI, "fullscreen_mode");
}

void CConfig::setUIFullScreen(const bool p_mode){
	setBool(GELIDE_GCONF_UI, "fullscreen_mode", p_mode);
}

void CConfig::getUIToolbarVisible(bool &p_visible){
	if(!keyExist(GELIDE_GCONF_UI, "tool_bar_visible"))
		p_visible = true;
	else
		p_visible = getBool(GELIDE_GCONF_UI, "tool_bar_visible");
}

void CConfig::setUIToolbarVisible(const bool p_visible){
	setBool(GELIDE_GCONF_UI, "tool_bar_visible", p_visible);
}

void CConfig::getUIFiltersVisible(bool &p_visible){
	if(!keyExist(GELIDE_GCONF_UI, "filters_visible"))
		p_visible = true;
	else
		p_visible = getBool(GELIDE_GCONF_UI, "filters_visible");
}

void CConfig::setUIFiltersVisible(const bool p_visible){
	setBool(GELIDE_GCONF_UI, "filters_visible", p_visible);
}

void CConfig::getUIFiltersWidth(int &p_w){
	p_w = getInt(GELIDE_GCONF_UI, "filters_width");
}

void CConfig::setUIFiltersWidth(const int p_w){
	setInt(GELIDE_GCONF_UI, "filters_width", p_w);
}

void CConfig::getUISelectedFilter(Glib::ustring &p_filter){
	p_filter = getString(GELIDE_GCONF_UI, "selected_filter");
}

void CConfig::setUISelectedFilter(const Glib::ustring &p_filter){
	setString(GELIDE_GCONF_UI, "selected_filter", p_filter);
}

void CConfig::getUISearchString(Glib::ustring &p_str){
	p_str = getString(GELIDE_GCONF_UI, "search_string");
}

void CConfig::setUISearchString(const Glib::ustring &p_str){
	setString(GELIDE_GCONF_UI, "search_string", p_str);
}

void CConfig::getUIBrowserTopSize(int &p_w, int &p_h){
	p_w = getInt(GELIDE_GCONF_UI, "browser_top_width");
	p_h = getInt(GELIDE_GCONF_UI, "browser_top_height");
}

void CConfig::setUIBrowserTopSize(const int p_w, const int p_h){
	setInt(GELIDE_GCONF_UI, "browser_top_width", p_w);
	setInt(GELIDE_GCONF_UI, "browser_top_height", p_h);
}

void CConfig::getUIBrowserLeftSize(int &p_w, int &p_h){
	p_w = getInt(GELIDE_GCONF_UI, "browser_left_width");
	p_h = getInt(GELIDE_GCONF_UI, "browser_left_height");
}

void CConfig::setUIBrowserLeftSize(const int p_w, const int p_h){
	setInt(GELIDE_GCONF_UI, "browser_left_width", p_w);
	setInt(GELIDE_GCONF_UI, "browser_left_height", p_h);
}

void CConfig::getUIBrowserVisible(bool &p_visible){
	if(!keyExist(GELIDE_GCONF_UI, "browser_visible"))
		p_visible = true;
	else
		p_visible = getBool(GELIDE_GCONF_UI, "browser_visible");
}

void CConfig::setUIBrowserVisible(const bool p_visible){
	setBool(GELIDE_GCONF_UI, "browser_visible", p_visible);
}

void CConfig::getUIBrowserMode(int &p_mode){
	p_mode = getInt(GELIDE_GCONF_UI, "browser_mode");
}

void CConfig::setUIBrowserMode(const int p_mode){
	setInt(GELIDE_GCONF_UI, "browser_mode", p_mode);
}

void CConfig::getUIInfoPannel(int &p_pannel){
	p_pannel = getInt(GELIDE_GCONF_UI, "info_pannel_selected");
}

void CConfig::setUIInfoPannel(const int p_pannel){
	setInt(GELIDE_GCONF_UI, "info_pannel_selected", p_pannel);
}

void CConfig::getUIInfoPannelVisible(bool &p_visible){
	if(!keyExist(GELIDE_GCONF_UI, "info_pannel_visible"))
		p_visible = true;
	else
		p_visible = getBool(GELIDE_GCONF_UI, "info_pannel_visible");
}

void CConfig::setUIInfoPannelVisible(const bool p_visible){
	setBool(GELIDE_GCONF_UI, "info_pannel_visible", p_visible);
}

void CConfig::getUIInfoPannelWidth(int &p_w){
	p_w = getInt(GELIDE_GCONF_UI, "info_pannel_widht");
}

void CConfig::setUIInfoPannelWidth(const int p_w){
	setInt(GELIDE_GCONF_UI, "info_pannel_widht", p_w);
}

void CConfig::getUIStatusBarVisible(bool &p_visible){
	if(!keyExist(GELIDE_GCONF_UI, "status_bar_visible"))
		p_visible = true;
	else
		p_visible = getBool(GELIDE_GCONF_UI, "status_bar_visible");
}

void CConfig::setUIStatusBarVisible(const bool p_visible){
	setBool(GELIDE_GCONF_UI, "status_bar_visible", p_visible);
}

void CConfig::getUISelectedSystem(int &p_id){
	p_id = getInt(GELIDE_GCONF_UI, "selected_system");
}

void CConfig::setUISelectedSystem(const int p_id){
	setInt(GELIDE_GCONF_UI, "selected_system", p_id);
}

void CConfig::getUIColumns(std::vector<bool> &p_visibility, std::vector<int> &p_widths, std::vector<int> &p_order){
	p_visibility = getBoolList(GELIDE_GCONF_UI, "columns_visibility");
	p_widths = getIntList(GELIDE_GCONF_UI, "columns_widths");
	p_order = getIntList(GELIDE_GCONF_UI, "columns_order");
}

void CConfig::setUIColumns(const std::list<bool> &p_visibility, const std::list<int> &p_widths, const std::list<int> &p_order){
	setBoolList(GELIDE_GCONF_UI, "columns_visibility", p_visibility);
	setIntList(GELIDE_GCONF_UI, "columns_widths", p_widths);
	setIntList(GELIDE_GCONF_UI, "columns_order", p_order);
}

void CConfig::getUISortColumn(int &p_column, int &p_type){
	p_column = getInt(GELIDE_GCONF_UI, "sort_column");
	p_type = getInt(GELIDE_GCONF_UI, "sort_type");
}

void CConfig::setUISortColumn(const int p_column, const int p_type){
	setInt(GELIDE_GCONF_UI, "sort_column", p_column);
	setInt(GELIDE_GCONF_UI, "sort_type", p_type);
}



void CConfig::getPrefsImportSystems(bool &p_value){
	// El valor por defecto es importar los sistemas en el arranque
	if(!keyExist(GELIDE_GCONF_PREFERENCES, "import_default_systems"))
		p_value = true;
	else
		p_value = getBool(GELIDE_GCONF_PREFERENCES, "import_default_systems");
}

void CConfig::setPrefsImportSystems(const bool p_value){
	setBool(GELIDE_GCONF_PREFERENCES, "import_default_systems", p_value);
}

void CConfig::getPrefsExportIcons(bool &p_value){
	// El valor por defecto es exportar los iconos
	if(!keyExist(GELIDE_GCONF_PREFERENCES, "export_icons"))
		p_value = true;
	else
		p_value = getBool(GELIDE_GCONF_PREFERENCES, "export_icons");
}

void CConfig::setPrefsExportIcons(const bool p_value){
	setBool(GELIDE_GCONF_PREFERENCES, "export_icons", p_value);
}

void CConfig::getPrefsExportDats(bool &p_value){
	if(!keyExist(GELIDE_GCONF_PREFERENCES, "export_icons"))
		p_value = false;
	else
		p_value = getBool(GELIDE_GCONF_PREFERENCES, "export_dats");
}

void CConfig::setPrefsExportDats(const bool p_value){
	setBool(GELIDE_GCONF_PREFERENCES, "export_dats", p_value);
}

void CConfig::getPrefsCopyDatFile(bool &p_value){
	if(!keyExist(GELIDE_GCONF_PREFERENCES, "copy_dat_file"))
		p_value = false;
	else
		p_value = getBool(GELIDE_GCONF_PREFERENCES, "copy_dat_file");
}

void CConfig::setPrefsCopyDatFile(const bool p_value){
	setBool(GELIDE_GCONF_PREFERENCES, "copy_dat_file", p_value);
}

void CConfig::getPrefsCopyIconFile(bool &p_value){
	if(!keyExist(GELIDE_GCONF_PREFERENCES, "copy_icon_file"))
		p_value = true;
	else
		p_value = getBool(GELIDE_GCONF_PREFERENCES, "copy_icon_file");
}

void CConfig::setPrefsCopyIconFile(const bool p_value){
	setBool(GELIDE_GCONF_PREFERENCES, "copy_icon_file", p_value);
}

void CConfig::getPrefsCopyBiosFile(bool &p_value){
	if(!keyExist(GELIDE_GCONF_PREFERENCES, "copy_bios_file"))
		p_value = false;
	else
		p_value = getBool(GELIDE_GCONF_PREFERENCES, "copy_bios_file");
}

void CConfig::setPrefsCopyBiosFile(const bool p_value){
	setBool(GELIDE_GCONF_PREFERENCES, "copy_bios_file", p_value);
}

void CConfig::getPrefsShowEmulatorOutput(bool &p_value){
	if(!keyExist(GELIDE_GCONF_PREFERENCES, "show_emulator_output"))
		p_value = false;
	else
		p_value = getBool(GELIDE_GCONF_PREFERENCES, "show_emulator_output");
}

void CConfig::setPrefsShowEmulatorOutput(const bool p_value){
	setBool(GELIDE_GCONF_PREFERENCES, "show_emulator_output", p_value);
}







bool CConfig::keyExist(const Glib::ustring& p_group, const Glib::ustring& p_key){

#ifdef GLIBMM_EXCEPTIONS_ENABLED
	Gnome::Conf::Value l_value;
	try {
		l_value = m_conf_client->get((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key);
		if(l_value.get_type() == Gnome::Conf::VALUE_INVALID)
			return false;
		else
			return true;
	} catch (Glib::Exception &l_exception) {
		return false;
	}
#else
	int l_ret;
	std::auto_ptr< Glib::Error> l_error;

	l_ret = m_conf_client->get_int((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key, l_error);
	if(l_error.get())
		return false;
	else
		return true;
#endif //GLIBMM_EXCEPTIONS_ENABLED
}


Glib::ustring CConfig::getString(const Glib::ustring& p_group, const Glib::ustring& p_key){
	return m_conf_client->get_string((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key);
}

bool CConfig::getBool(const Glib::ustring& p_group, const Glib::ustring& p_key){
	return m_conf_client->get_bool((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key);
}

int CConfig::getInt(const Glib::ustring& p_group, const Glib::ustring& p_key){
// Forzamos a que se devuelva -1 en caso de no estar la clave
#ifdef GLIBMM_EXCEPTIONS_ENABLED
	Gnome::Conf::Value l_value;
	try {
		l_value = m_conf_client->get((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key);
		if(l_value.get_type() == Gnome::Conf::VALUE_INT)
			return l_value.get_int();
		else
			return -1;
	} catch (Glib::Exception &l_exception) {
		return -1;
	}
#else
	int l_ret;
	std::auto_ptr< Glib::Error> l_error;

	l_ret = m_conf_client->get_int((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key, l_error);
	if(l_error.get())
		return -1;
	else
		return l_ret;
#endif //GLIBMM_EXCEPTIONS_ENABLED
}

std::vector<Glib::ustring> CConfig::getStringList(const Glib::ustring& p_group,	const Glib::ustring& p_key)
{
	return m_conf_client->get_string_list((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key);
}

std::vector<bool> CConfig::getBoolList(const Glib::ustring& p_group, const Glib::ustring& p_key)
{
	return m_conf_client->get_bool_list((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key);
}

std::vector<int> CConfig::getIntList(const Glib::ustring& p_group,	const Glib::ustring& p_key)
{
	return m_conf_client->get_int_list((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key);
}

void CConfig::setString(const Glib::ustring& p_group, const Glib::ustring& p_key,	const Glib::ustring& p_value){
	m_conf_client->set((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key, p_value);
}

void CConfig::setBool(const Glib::ustring& p_group, const Glib::ustring& p_key,  const bool p_value){
	m_conf_client->set((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key, p_value);
}

void CConfig::setInt(const Glib::ustring& p_group, const Glib::ustring& p_key, const int p_value){
	m_conf_client->set((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key, p_value);
}

void CConfig::setStringList(const Glib::ustring& p_group, const Glib::ustring& p_key, const std::list<Glib::ustring> &p_value){
	m_conf_client->set_string_list((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key, p_value);
}

void CConfig::setBoolList(const Glib::ustring& p_group, const Glib::ustring& p_key, const std::list<bool> &p_value){
	m_conf_client->set_bool_list((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key, p_value);
}

void CConfig::setIntList(const Glib::ustring& p_group, const Glib::ustring& p_key,  const std::list<int> &p_value){
	m_conf_client->set_int_list((Glib::ustring)GELIDE_GCONF_ROOT + "/" + p_group + "/" + p_key, p_value);
}

/*void CConfig::checkDirs(void){

	//Comprobamos si existe ~/.gelide
	if(!Glib::file_test(m_user_dir + GELIDE_DIR, Glib::FILE_TEST_EXISTS)){
		if(!CUtils::createDir(m_user_dir + GELIDE_DIR))
			exit(-1);
		m_first_run = true;
	}
	else
		m_first_run = false;
}*/


