/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gelide
 * Copyright (C) 2008 Juan Ángel Moreno Fernández
 *
 * gelide is free software.
 *
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * gelide is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gelide.  If not, see <http://www.gnu.org/licenses/>
 */

#ifndef _CONFIG_HPP_
#define _CONFIG_HPP_

#include "gelide.hpp"
#include <gconfmm.h>
#include <glibmm/ustring.h>
#include <gconfmm/client.h>

#include "template_singleton.hpp"

class CConfig: public CSingleton<CConfig>
{
public:
	// Indica si es la primera ejecución del programa
	//bool isFirstRun(void);

	// Archivo con la lista de sistemas del usuario
	Glib::ustring getSystemsList(void);
	// Directorio base del usuario para los sistemas
	Glib::ustring getGelideDir(void);

	// Métodos para guardar y cargar la posición de dialogos
	void getAboutDialogPos(int &p_x, int &p_y);
	void setAboutDialogPos(const int p_x, const int p_y);
	void getChangeLogDialogPos(int &p_x, int &p_y);
	void setChangeLogDialogPos(const int p_x, const int p_y);
	void getColumnsDialogPos(int &p_x, int &p_y);
	void setColumnsDialogPos(const int p_x, const int p_y);
	void getEmulatorEditDialogPos(int &p_x, int &p_y);
	void setEmulatorEditDialogPos(const int p_x, const int p_y);
	void getEmulatorLauncherDialogPos(int &p_x, int &p_y);
	void setEmulatorLauncherDialogPos(const int p_x, const int p_y);
	void getGameListGeneratorDialogPos(int &p_x, int &p_y);
	void setGameListGeneratorDialogPos(const int p_x, const int p_y);
	void getSystemEditDialogPos(int &p_x, int &p_y);
	void setSystemEditDialogPos(const int p_x, const int p_y);
	void getPreferencesDialogPos(int &p_x, int &p_y);
	void setPreferencesDialogPos(const int p_x, const int p_y);

	// Métodos para obtener la configuración del UI
	void getUISize(int &p_w, int &p_h);
	void setUISize(const int p_w, const int p_h);
	void getUIPos(int &p_x, int &p_y);
	void setUIPos(const int p_x, const int p_y);
	void getUIFullScreen(bool &p_mode);
	void setUIFullScreen(const bool p_mode);
	void getUIToolbarVisible(bool &p_visible);
	void setUIToolbarVisible(const bool p_visible);
	void getUIFiltersVisible(bool &p_visible);
	void setUIFiltersVisible(const bool p_visible);
	void getUIFiltersWidth(int &p_w);
	void setUIFiltersWidth(const int p_w);
	void getUISelectedFilter(Glib::ustring &p_filter);
	void setUISelectedFilter(const Glib::ustring &p_filter);
	void getUISearchString(Glib::ustring &p_str);
	void setUISearchString(const Glib::ustring &p_str);
	void getUIBrowserTopSize(int &p_w, int &p_h);
	void setUIBrowserTopSize(const int p_w, const int p_h);
	void getUIBrowserLeftSize(int &p_w, int &p_h);
	void setUIBrowserLeftSize(const int p_w, const int p_h);
	void getUIBrowserVisible(bool &p_visible);
	void setUIBrowserVisible(const bool p_visible);
	void getUIBrowserMode(int &p_mode);
	void setUIBrowserMode(const int p_mode);
	void getUIInfoPannel(int &p_pannel);
	void setUIInfoPannel(const int p_pannel);
	void getUIInfoPannelVisible(bool &p_visible);
	void setUIInfoPannelVisible(const bool p_visible);
	void getUIInfoPannelWidth(int &p_w);
	void setUIInfoPannelWidth(const int p_w);
	void getUIStatusBarVisible(bool &p_visible);
	void setUIStatusBarVisible(const bool p_visible);
	void getUISelectedSystem(int &p_id);
	void setUISelectedSystem(const int p_id);
	void getUIColumns(std::vector<bool> &p_visibility, std::vector<int> &p_widths, std::vector<int> &p_order);
	void setUIColumns(const std::list<bool> &p_visibility, const std::list<int> &p_widths, const std::list<int> &p_order);
	void getUISortColumn(int &p_column, int &p_type);
	void setUISortColumn(const int p_column, const int p_type);

	// Métodos para obtener las preferencias
	void getPrefsImportSystems(bool &p_value);
	void setPrefsImportSystems(const bool p_value);
	void getPrefsShowEmulatorOutput(bool &p_value);
	void setPrefsShowEmulatorOutput(const bool p_value);

	void getPrefsExportIcons(bool &p_value);
	void setPrefsExportIcons(const bool p_value);
	void getPrefsExportDats(bool &p_value);
	void setPrefsExportDats(const bool p_value);

	void getPrefsCopyDatFile(bool &p_value);
	void setPrefsCopyDatFile(const bool p_value);
	void getPrefsCopyIconFile(bool &p_value);
	void setPrefsCopyIconFile(const bool p_value);
	void getPrefsCopyBiosFile(bool &p_value);
	void setPrefsCopyBiosFile(const bool p_value);





	// Comprueba si existe una clave dada
	bool keyExist(const Glib::ustring& p_group, const Glib::ustring& p_key);
	// Lee un valor de configuración en formato cadena
	Glib::ustring getString(const Glib::ustring& p_group,const Glib::ustring& p_key);
	// Lee un valor de configuración en formato booleano
	bool getBool(const Glib::ustring& p_group, const Glib::ustring& p_key);
	// Lee un valor de configuración en formato int
	int getInt(const Glib::ustring& p_group, const Glib::ustring& p_key);
	// Obtiene una lista de cadenas
	std::vector<Glib::ustring> getStringList(const Glib::ustring& p_group,	const Glib::ustring& p_key);
	// Obtiene una lista de booleanos
	std::vector<bool> getBoolList(const Glib::ustring& p_group,	const Glib::ustring& p_key);
	// Obtiene una lista de enteros
	std::vector<int> getIntList(const Glib::ustring& p_group, const Glib::ustring& p_key);

	// Establece un valor de configuración en formato cadena
	void setString(const Glib::ustring& p_group, const Glib::ustring& p_key, const Glib::ustring& p_value);
	// Establece un valor de configuración en formato booleano
	void setBool(const Glib::ustring& p_group, const Glib::ustring& p_key, const bool p_value);
	// Establece un valor de configuración en formato int
	void setInt(const Glib::ustring& p_group, const Glib::ustring& p_key, const int p_value);
	// Establece un valor de configuración en formato lista de cadenas
	void setStringList(const Glib::ustring& p_group, const Glib::ustring& p_key, const std::list< Glib::ustring > &p_value);
	// Establece un valor de configuración en formato lista debooleano
	void setBoolList(const Glib::ustring& p_group, const Glib::ustring& p_key, const std::list<bool> &p_value);
	// Establece un valor de configuración en formato lista de enteros
	void setIntList(const Glib::ustring& p_group, const Glib::ustring& p_key, const std::list<int> &p_value);

protected:
	friend class CSingleton<CConfig>;
	// Obtiene el path del usuario, comprueba la jerarquía de directorios e
	// intenta cargar el archivo de configuración del programa
	CConfig(void);
	// Guarda el archivo de configuración del programa
	virtual ~CConfig(void);

private:
	// Comprueba y crea la jerarquía de directorios del usuario
	//void checkDirs(void);

	//bool m_first_run;
	Glib::RefPtr<Gnome::Conf::Client> m_conf_client;
	Glib::ustring m_user_dir;
};

#endif // _CONFIG_HPP_
