/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gelide
 * Copyright (C) 2008 Juan Ángel Moreno Fernández
 *
 * gelide is free software.
 *
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * gelide is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gelide.  If not, see <http://www.gnu.org/licenses/>
 */

#ifndef _CMPRODATFILE_HPP_
#define _CMPRODATFILE_HPP_

#include <glibmm/ustring.h>
#include <list>
#include <iostream>
#include "datfile.hpp"
#include "../tokenizer.hpp"
using namespace std;

// Tipo enumerado para identificar los tokens
enum
{
	// Tokens para los bloques del dat
	TK_CLRMAMEPRO,
	TK_EMULATOR,
	TK_GAME,
	TK_ROM,
	TK_DISK,
	TK_BIOSSET,
	// Tokens en el bloque clrmamepro y comunes
	TK_NAME,
	TK_DESCRIPTION,
	TK_CATEGORY,
	TK_VERSION,
	TK_AUTHOR,
	// Tokens para el bloque game
	TK_YEAR,
	TK_MANUFACTURER,
	TK_CLONEOF,
	// Tokens para los bloques rom y disk
	TK_SIZE,
	TK_CRC,
	// Tokens para los parentesis
	TK_LPAR,				// Token Parentesis izquierdo
	TK_RPAR,				// Token Parentesis derecho
	// Contador de palabras reservadas
	NUM_TK_WORDS
};

class CCMProDatFile : public CDatFile
{
public:
	CCMProDatFile(void);
	CCMProDatFile(const Glib::ustring& p_file);
	~CCMProDatFile(void);
	bool load(const Glib::ustring& p_file = "");
	bool loadHeader(const Glib::ustring& p_file = "");
private:
	void parseClrmameproBlock(void);
	void parseEmulatorBlock(void);
	CDatGame* parseGameBlock(void);
	CDatRom* parseRomBlock(unsigned int p_type = DATROM_ROM);
	CDatGame* parseResourceBlock(void);
	void skipBlock(void);
};

#endif // _CMPRODATFILE_HPP_
