/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gelide
 * Copyright (C) 2008 Juan Ángel Moreno Fernández
 *
 * gelide is free software.
 *
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * gelide is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gelide.  If not, see <http://www.gnu.org/licenses/>
 */

#include "datfile.hpp"

CDatRom::CDatRom(void){
	m_type = DATROM_ROM;
	m_name = "";
	m_size = 0;
	m_crc = "";
}

CDatRom::CDatRom(const int p_type, const Glib::ustring& p_name,
				 const unsigned int p_size,	const Glib::ustring& p_crc){
	m_type = p_type;
	m_name = p_name;
	m_size = p_size;
	m_crc = p_crc;
}

CDatRom::~CDatRom(void){
}

void CDatRom::setType(const int p_type){
	m_type = p_type;
}

void CDatRom::setName(const Glib::ustring& p_name){
	m_name = p_name;
}

void CDatRom::setSize(const unsigned int p_size){
	m_size = p_size;
}

void CDatRom::setCrc(const Glib::ustring& p_crc){
	m_crc = p_crc;
}

int CDatRom::getType(void){
	return m_type;
}

Glib::ustring CDatRom::getName(void){
	return m_name;
}

unsigned int CDatRom::getSize(void){
	return m_size;
}

Glib::ustring CDatRom::getCrc(void){
	return m_crc;
}

//-----------------------------------------------------------------------------

CDatGame::CDatGame(void){
	m_name = "";
	m_description = "";
	m_year = 0;
	m_manufacturer = "";
	m_cloneof = "";
	m_rom = NULL;
}

CDatGame::~CDatGame(void){
	if(m_rom != NULL){
		delete m_rom;
	}
}

void CDatGame::setName(const Glib::ustring& p_name){
	m_name = p_name;
}

void CDatGame::setDescription(const Glib::ustring& p_description){
	m_description = p_description;
}

void CDatGame::setYear(const unsigned int p_year){
	m_year = p_year;
}

void CDatGame::setManufacturer(const Glib::ustring& p_manufacturer){
	m_manufacturer = p_manufacturer;
}

void CDatGame::setCloneof(const Glib::ustring& p_cloneof){
	m_cloneof = p_cloneof;
}

void CDatGame::setRom(CDatRom* p_rom){
	m_rom = p_rom;
}

Glib::ustring CDatGame::getName(void){
	return m_name;
}

Glib::ustring CDatGame::getDescription(void){
	return m_description;
}

unsigned int CDatGame::getYear(void){
	return m_year;
}

Glib::ustring CDatGame::getManufacturer(void){
	return m_manufacturer;
}

Glib::ustring CDatGame::getCloneof(void){
	return m_cloneof;
}

CDatRom* CDatGame::getRom(void){
	return m_rom;
}

//-----------------------------------------------------------------------------


CDatFile::CDatFile(void){
	m_loaded = false;
	m_has_header = false;
	m_games = 0;
	m_name = "";
	m_description = "";
	m_category = "";
	m_version = "";
	m_author = "";
	m_emulator_name = "";
	m_emulator_version = "";
}

CDatFile::~CDatFile(void){
	this->clear();
}

void CDatFile::clear(void){
	std::list<CDatGame* >::iterator l_iter;

	for(l_iter = m_games_list.begin(); l_iter != m_games_list.end(); l_iter++)
		delete *l_iter;
	m_games_list.clear();
}

bool CDatFile::isLoaded(void){
	return m_loaded;
}

bool CDatFile::hasHeader(void){
	return m_has_header;
}

int CDatFile::hasGames(void){
	return m_games;
}

std::list<CDatGame*>& CDatFile::getList(void){
	return m_games_list;
}

Glib::ustring CDatFile::getName(void){
	return m_name;
}

Glib::ustring CDatFile::getDescription(void){
	return m_description;
}

Glib::ustring CDatFile::getCategory(void){
	return m_category;
}

Glib::ustring CDatFile::getVersion(void){
	return m_version;
}

Glib::ustring CDatFile::getAuthor(void){
	return m_author;
}

unsigned int CDatFile::getGames(void){
	return m_games;
}

Glib::ustring CDatFile::getEmulatorName(void){
	return m_emulator_name;
}

Glib::ustring CDatFile::getEmulatorVersion(void){
	return m_emulator_version;
}
