/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gelide
 * Copyright (C) 2008 Juan Ángel Moreno Fernández
 *
 * gelide is free software.
 *
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * gelide is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gelide.  If not, see <http://www.gnu.org/licenses/>
 */

/*
 * WARNING: Los bloques dat que utilizamos en Gelide no tienen porqué ser completos.
 * Solo utilizaremos aquello que necesitemos, por lo que no se deberían tomar
 * como referencia de los archivos dat. Se puede ver información sobre los
 * dat en los archivos CMProDatFormat.txt y RomCenterDatFormat.txt
 */

#ifndef _DATFILE_HPP_
#define _DATFILE_HPP_

#include <glibmm/ustring.h>
#include <list>
#include <iostream>
#include "../tokenizer.hpp"

using namespace std;
// Tipos de rom
#define DATROM_ROM	0
#define DATROM_DISK	1


/*------------------------------------------------------
	Mantiene la información de una rom dentro del dat.
--------------------------------------------------------*/
class CDatRom
{
public:
	CDatRom(void);

	CDatRom(const int p_type = DATROM_ROM, const Glib::ustring& p_name = "",
			const unsigned int p_size = 0, const Glib::ustring& p_crc = "");

	~CDatRom(void);

	void setType(const int p_type = DATROM_ROM);
	void setName(const Glib::ustring& p_name = "");
	void setSize(const unsigned int p_size = 0);
	void setCrc(const Glib::ustring& p_crc = "");

	int getType(void);
	Glib::ustring getName(void);
	unsigned int getSize(void);
	Glib::ustring getCrc(void);

private:
	int m_type;
	Glib::ustring m_name;
	unsigned int m_size;
	Glib::ustring m_crc;
};

/*------------------------------------------------------
	Mantiene la información de un juego dentro del dat.
--------------------------------------------------------*/
class CDatGame
{
public:
	CDatGame(void);
	~CDatGame(void);

	void setName(const Glib::ustring& p_name = "");
	void setDescription(const Glib::ustring& p_description = "");
	void setYear(const unsigned int p_year = 0);
	void setManufacturer(const Glib::ustring& p_manufacturer = "");
	void setCloneof(const Glib::ustring& p_cloneof = "");
	void setRom(CDatRom* p_rom);

	Glib::ustring getName(void);
	Glib::ustring getDescription(void);
	unsigned int getYear(void);
	Glib::ustring getManufacturer(void);
	Glib::ustring getCloneof(void);
	CDatRom* getRom(void);

private:
	Glib::ustring m_name;
	Glib::ustring m_description;
	unsigned int m_year;
	Glib::ustring m_manufacturer;
	Glib::ustring m_cloneof;
	CDatRom* m_rom;
};

/*------------------------------------------------------
	Clase base para los archivo dat.
--------------------------------------------------------*/
class CDatFile
{
public:
	CDatFile(void);
	virtual ~CDatFile(void);
	virtual bool load(const Glib::ustring& p_file){return false;};
	virtual bool loadHeader(const Glib::ustring& p_file){return false;};
	void clear(void);
	bool isLoaded(void);
	bool hasHeader(void);
	int hasGames(void);

	std::list<CDatGame*>& getList(void);
	Glib::ustring getName(void);
	Glib::ustring getDescription(void);
	Glib::ustring getCategory(void);
	Glib::ustring getVersion(void);
	Glib::ustring getAuthor(void);
	unsigned int getGames(void);
	Glib::ustring getEmulatorName(void);
	Glib::ustring getEmulatorVersion(void);
protected:
	bool m_loaded;
	bool m_has_header;
	std::list<CDatGame*> m_games_list;
	Glib::ustring m_name;
	Glib::ustring m_description;
	Glib::ustring m_category;
	Glib::ustring m_version;
	Glib::ustring m_author;
	unsigned int m_games;
	Glib::ustring m_emulator_name;
	Glib::ustring m_emulator_version;
	CTokenizer m_tokenizer;
	t_ReservedWord* m_words;
	t_ReservedWord* m_delimiters;
};

#endif // _DATFILE_HPP_
