/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gelide
 * Copyright (C) 2008 Juan Ángel Moreno Fernández
 *
 * gelide is free software.
 *
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * gelide is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gelide.  If not, see <http://www.gnu.org/licenses/>
 */

#include "system_manager.hpp"

void CSystemManager::generateDefaultSystems(void){
	CSystem* l_system;
	CEmulator l_emulator;

	/*"id";"name";"description";"icon_file";"dat_file";"bios_file";"home_dir";"rom_dir";
"snap_dir";"tittle_dir";"front_dir";"back_dir";"card_dir";emulator_id;
"datname";"datDescription";"datcategory";datversion";"datauthor";datgames;
*/

	/*
	 *  Amstrad - GX4000
	 */
	l_system = new CSystem();
	l_system->setName(_("Amstrad GX4000"));
	l_system->setDescription(_("Console released by Amstrad in 1990 and was based on the still-popular CPC technology."));
	l_system->setIconFile(GELIDE_PIXMAPS"amstrad-gx4000.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("gx4000 -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Atari - 2600
	 */
	l_system = new CSystem();
	l_system->setName(_("Atari 2600"));
	l_system->setDescription(_("Originally known as the Atari VCS, was released in October 1977"));
	l_system->setIconFile(GELIDE_PIXMAPS"atari-2600.png");
	// Emulador Stella
	l_emulator.setId(0);
	l_emulator.setName(_("Stella"));
	l_emulator.setDescription(_("Free GNU/Linux emulator for Atari 2600 VCS"));
	l_emulator.setVersion("2.7.6");
	l_emulator.setAuthor(_("Bradford W. Mott & the Stella Team."));
	l_emulator.setHomepage("http://stella.sourceforge.net");
	l_emulator.setPath("/usr/bin/stella");
	l_emulator.setParams("-fullscreen 1 -video gl -gl_fsmax 1 -gl_filter nearest -gl_aspect 1.7 -center 1 -sound 1 -channels 2 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"stella.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("a2600 -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("a2600 -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Atari - 5200
	 */
	l_system = new CSystem();
	l_system->setName(_("Atari 5200"));
	l_system->setDescription(_("Atari 5200 SuperSystem was the replacement for the famous Atari 2600"));
	l_system->setIconFile(GELIDE_PIXMAPS"atari-5200.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("a5200 -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("a5200 -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Atari - 7800
	 */
	l_system = new CSystem();
	l_system->setName(_("Atari 7800"));
	l_system->setDescription(_("Video game console released by Atari Corp in June 1986"));
	l_system->setIconFile(GELIDE_PIXMAPS"atari-7800.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("a7800 -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("a7800p -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Atari - Jaguar
	 */
	l_system = new CSystem();
	l_system->setName(_("Atari Jaguar"));
	l_system->setDescription(_("The first 64-Bits gaming system released by Atari Corp. in 1993"));
	l_system->setIconFile(GELIDE_PIXMAPS"atari-jaguar.png");
	// Emulador Virtual Jaguar Gcc/Sdl
	l_emulator.setId(0);
	l_emulator.setName(_("Virtual Jaguar Gcc/Sdl"));
	l_emulator.setDescription(_("Portable emulator based in Virtual Jaguar"));
	l_emulator.setVersion("1.0.7");
	l_emulator.setAuthor(_("Niels Wagenaar, Carwin Jones, James L. Hammons and Adam Gree"));
	l_emulator.setHomepage("http://sdlemu.ngemu.com/");
	l_emulator.setPath("/usr/bin/virtualjaguar");
	l_emulator.setParams("\"$gf\" -fullscreen -gl");
	l_emulator.setIconFile(GELIDE_PIXMAPS"virtualjaguar.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("jaguar -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\" ");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Atari - Lynx
	 */
	l_system = new CSystem();
	l_system->setName(_("Atari Lynx"));
	l_system->setDescription(_("Was a handheld game console released by Atari Corporation in 1989"));
	l_system->setIconFile(GELIDE_PIXMAPS"atari-lynx.png");
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-lynx.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("lynx -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("lynx -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Bandai - Wonderswan
	 */
	l_system = new CSystem();
	l_system->setName(_("Bandai Wonderswan"));
	l_system->setDescription(_("Handheld 16-Bits game console released in Japan by Bandai in 1999"));
	l_system->setIconFile(GELIDE_PIXMAPS"bandai-wonderswan.png");
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-wswan.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("wswan -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("wswan -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Bandai - Wonderswan color
	 */
	l_system = new CSystem();
	l_system->setName(_("Bandai Wonderswan Color"));
	l_system->setDescription(_("Handheld 16-Bits color game console released in Japan by Bandai in 2000"));
	l_system->setIconFile(GELIDE_PIXMAPS"bandai-wonderswancolor.png");
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-wswan.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("wscolor -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("wscolor -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Coleco - ColecoVision
	 */
	l_system = new CSystem();
	l_system->setName(_("Coleco ColecoVision"));
	l_system->setDescription(_("Coleco Industries' second generation video game console released in August 1982"));
	l_system->setIconFile(GELIDE_PIXMAPS"coleco-colecovision.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("coleco -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("coleco -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Emerson - Arcadia 2001
	 */
	l_system = new CSystem();
	l_system->setName(_("Emerson Arcadia 2001"));
	l_system->setDescription(_("A 8-Bits Second generation video game console"));
	l_system->setIconFile(GELIDE_PIXMAPS"emerson-arcadia2001.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("arcadia -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("arcadia -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Entex - Adventure vision
	 */
	l_system = new CSystem();
	l_system->setName(_("Entex Adventure vision"));
	l_system->setDescription(_("Entex's second generation video game console"));
	l_system->setIconFile(GELIDE_PIXMAPS"entex-adventurevision.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("advision -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("advision -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Fairchild - Channel F
	 */
	l_system = new CSystem();
	l_system->setName(_("Fairchild Channel F"));
	l_system->setDescription(_("Game console released by Fairchild in 1976. It was the first programmable ROM cartridge console."));
	l_system->setIconFile(GELIDE_PIXMAPS"fairchild-channelf.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("channelf -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("channelf -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  GCE - Vectrex
	 */
	l_system = new CSystem();
	l_system->setName(_("GCE Vectrex"));
	l_system->setDescription(_("8-Bits console with an integrated vector monitor which displays vector graphics"));
	l_system->setIconFile(GELIDE_PIXMAPS"gce-vectrex.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("vectrex -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("vectrex -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Magnavox - Odyssey2
	 */
	l_system = new CSystem();
	l_system->setName(_("Magnavox Odyssey2"));
	l_system->setDescription(_("Magnavox second generation video game console released in 1978"));
	l_system->setIconFile(GELIDE_PIXMAPS"magnavox-odyssey2.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("odyssey2 -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("odyssey2 -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Mame: Multiple Arcade Machine Emulator
	 */
	l_system = new CSystem();
	l_system->setName(_("Mame"));
	l_system->setDescription(_("Multiple Arcade Machine Emulator"));
	l_system->setIconFile(GELIDE_PIXMAPS"mame.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMame"));
	l_emulator.setDescription(_("Portable Mame version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130u2");
	l_emulator.setAuthor(_("Nicola Salmoria and the Mame Team"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/sdlmame");
	l_emulator.setParams("-antialias -sound -skip_gameinfo -multithreading -video opengl -keepaspect -rompath \"$gp\" \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmame.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmame
	l_emulator.setId(0);
	l_emulator.setName(_("XMame"));
	l_emulator.setDescription(_("Multiple Arcade Machine Emulator for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("Nicola Salmoria and the Mame Team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmame");
	l_emulator.setParams("-vidmod 0 -fullscreen -ef 1 -aa -ka -doublebuf -rp \"$gp\" -skip_gameinfo \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmame.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Mattel - Intellivision
	 */
	l_system = new CSystem();
	l_system->setName(_("Mattel Intellivision"));
	l_system->setDescription(_("Video game console released by Mattel Electronics in 1979"));
	l_system->setIconFile(GELIDE_PIXMAPS"mattel-intellivision.png");
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("intv -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("intv -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador jzIntv
	l_emulator.setId(0);
	l_emulator.setName(_("jzIntv"));
	l_emulator.setDescription(_("Joe Zbiciak's Intellivision Emulator for Linux"));
	l_emulator.setVersion("1.0-beta3");
	l_emulator.setAuthor(_("Joe Zbiciak"));
	l_emulator.setHomepage("http://spatula-city.org/~im14u2c/intv");
	l_emulator.setPath("/usr/bin/jzintv");
	l_emulator.setParams("-e \"$bp/exec.bin\" -g \"$bp/grom.bin\" -z1 -f1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"jzintv.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Nec - Pc Engine
	 */
	l_system = new CSystem();
	l_system->setName(_("Nec Pc Engine"));
	l_system->setDescription(_("8-Bits video game console also known as TurboGrafx "));
	l_system->setIconFile(GELIDE_PIXMAPS"nec-pcengine.png");
	// Emulador Hu-Go
	l_emulator.setId(0);
	l_emulator.setName(_("Hu-Go!"));
	l_emulator.setDescription(_("Multiplatform Pc Engine / TurboGrafx emulator"));
	l_emulator.setVersion("2.12");
	l_emulator.setAuthor(_("Zeograd"));
	l_emulator.setHomepage("http://www.zeograd.com");
	l_emulator.setPath("/usr/bin/hugo");
	l_emulator.setParams("-a -f -s \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"hu-go.png");
	l_system->addEmulator(l_emulator);
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-pce.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("tg16 -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("tg16 -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Nec - Super Grafx
	 */
	l_system = new CSystem();
	l_system->setName(_("Nec Super Grafx"));
	l_system->setDescription(_("8-Bits video game console successor of the Pc Engine"));
	l_system->setIconFile(GELIDE_PIXMAPS"nec-supergrafx.png");
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-pcfx.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("sgx -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Nintendo - Famicom Disk System
	 */
	l_system = new CSystem();
	l_system->setName(_("Nintendo Famicom Disk System"));
	l_system->setDescription(_("Was released in 1986 by Nintendo as a peripheral for the Famicom console"));
	l_system->setIconFile(GELIDE_PIXMAPS"nintendo-famicom.png");
	// Emulador fceux
	l_emulator.setId(0);
	l_emulator.setName(_("Fceux"));
	l_emulator.setDescription(_("Evolution of the original FCE Ultra"));
	l_emulator.setVersion("2.1.0a");
	l_emulator.setAuthor(_("The Fceux team"));
	l_emulator.setHomepage("http://www.fceux.com");
	l_emulator.setPath("/usr/local/bin/fceux");
	l_emulator.setParams("--xres 800 --yres 600 --autoscale 1 --keepratio 1 --opengl 1 --doublebuf 1 --fullscreen 1 --sound 1 --volume 50 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"fceu.png");
	l_system->addEmulator(l_emulator);
	// Emulador fceu
	l_emulator.setId(0);
	l_emulator.setName(_("Fceu"));
	l_emulator.setDescription(_("FCE Ultra - A Nintendo (8-Bit) emulator"));
	l_emulator.setVersion("0.98.12");
	l_emulator.setAuthor(_("Joe Nahmias"));
	l_emulator.setHomepage("http://fceultra.sourceforge.net");
	l_emulator.setPath("/usr/games/fceu");
	l_emulator.setParams("-fs 1 -xres 800 -yres 600 -soundvol 50 -opengl 1 -doublebuf 1 -stretchx 1 -stretchx 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"fceu.png");
	l_system->addEmulator(l_emulator);
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-nes.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 -m famicom \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("famicom -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -flop \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Nintendo - Game boy
	 */
	l_system = new CSystem();
	l_system->setName(_("Nintendo Game Boy"));
	l_system->setDescription(_("Handheld video game console developed by Nintendo released in 1989"));
	l_system->setIconFile(GELIDE_PIXMAPS"nintendo-gameboy.png");
	// Emulador Gambatte
	l_emulator.setId(0);
	l_emulator.setName(_("Gambatte SDL"));
	l_emulator.setDescription(_("Accuracy-focused, cross-platform Game Boy Color emulator"));
	l_emulator.setVersion("0.4.1");
	l_emulator.setAuthor(_("Sindre Aamås"));
	l_emulator.setHomepage("https://sourceforge.net/projects/gambatte/");
	l_emulator.setPath("/usr/games/gambatte");
	l_emulator.setParams("-f \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"gambatte.png");
	l_system->addEmulator(l_emulator);
	// Emulador VisualBoy Advance
	l_emulator.setId(0);
	l_emulator.setName(_("VisualBoy Advance"));
	l_emulator.setDescription(_("VBA is one of the most known emulators for GBA"));
	l_emulator.setVersion("1.8.0");
	l_emulator.setAuthor(_("Jose Carlos Medeiros"));
	l_emulator.setHomepage("http://vba.ngemu.com");
	l_emulator.setPath("/usr/bin/vba");
	l_emulator.setParams("-F -f 7 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"visualboyadvance.png");
	l_system->addEmulator(l_emulator);
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-gb.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("gameboy -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("gameboy -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Nintendo - Game Boy Color
	 */
	l_system = new CSystem();
	l_system->setName(_("Nintendo Game Boy Color"));
	l_system->setDescription(_("Successor of the Game Boy released in October 1998"));
	l_system->setIconFile(GELIDE_PIXMAPS"nintendo-gameboycolor.png");
	// Emulador Gambatte
	l_emulator.setId(0);
	l_emulator.setName(_("Gambatte SDL"));
	l_emulator.setDescription(_("Accuracy-focused, cross-platform Game Boy Color emulator"));
	l_emulator.setVersion("0.4.1");
	l_emulator.setAuthor(_("Sindre Aamås"));
	l_emulator.setHomepage("https://sourceforge.net/projects/gambatte/");
	l_emulator.setPath("/usr/games/gambatte");
	l_emulator.setParams("-f \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"gambatte.png");
	l_system->addEmulator(l_emulator);
	// Emulador VisualBoy Advance
	l_emulator.setId(0);
	l_emulator.setName(_("VisualBoy Advance"));
	l_emulator.setDescription(_("VBA is one of the most known emulators for GBA"));
	l_emulator.setVersion("1.8.0");
	l_emulator.setAuthor(_("Jose Carlos Medeiros"));
	l_emulator.setHomepage("http://vba.ngemu.com");
	l_emulator.setPath("/usr/bin/vba");
	l_emulator.setParams("-F -f 7 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"visualboyadvance.png");
	l_system->addEmulator(l_emulator);
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-gb.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("gbcolor -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("gbcolor -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Nintendo - Game Boy Advance
	 */
	l_system = new CSystem();
	l_system->setName(_("Nintendo Game Boy Advance"));
	l_system->setDescription(_("32-Bit handheld video game console developed by Nintendo released in 2001"));
	l_system->setIconFile(GELIDE_PIXMAPS"nintendo-gameboyadvance.png");
	// Emulador VisualBoy Advance
	l_emulator.setId(0);
	l_emulator.setName(_("VisualBoy Advance"));
	l_emulator.setDescription(_("VBA is one of the most known emulators for GBA"));
	l_emulator.setVersion("1.8.0");
	l_emulator.setAuthor(_("Jose Carlos Medeiros"));
	l_emulator.setHomepage("http://vba.ngemu.com");
	l_emulator.setPath("/usr/bin/vba");
	l_emulator.setParams("-F -f 7 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"visualboyadvance.png");
	l_system->addEmulator(l_emulator);
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-gba.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 -m gbadvance \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Nintendo - Nes
	 */
	l_system = new CSystem();
	l_system->setName(_("Nintendo Nes"));
	l_system->setDescription(_("8-Bit video game console developed by Nintendo and released in 1983"));
	l_system->setIconFile(GELIDE_PIXMAPS"nintendo-nes.png");
	// Emulador fceux
	l_emulator.setId(0);
	l_emulator.setName(_("Fceux"));
	l_emulator.setDescription(_("Evolution of the original FCE Ultra"));
	l_emulator.setVersion("2.1.0a");
	l_emulator.setAuthor(_("The Fceux team"));
	l_emulator.setHomepage("http://fceux.com/web/htdocs/index.php");
	l_emulator.setPath("/usr/local/bin/fceux");
	l_emulator.setParams("--xres 800 --yres 600 --autoscale 1 --keepratio 1 --opengl 1 --doublebuf 1 --fullscreen 1 --sound 1 --volume 50 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"fceu.png");
	l_system->addEmulator(l_emulator);
	// Emulador fceu
	l_emulator.setId(0);
	l_emulator.setName(_("Fceu"));
	l_emulator.setDescription(_("FCE Ultra - A Nintendo (8-Bit) emulator"));
	l_emulator.setVersion("0.98.12");
	l_emulator.setAuthor(_("Joe Nahmias"));
	l_emulator.setHomepage("http://fceultra.sourceforge.net");
	l_emulator.setPath("/usr/games/fceu");
	l_emulator.setParams("-fs 1 -xres 800 -yres 600 -soundvol 50 -opengl 1 -doublebuf 1 -stretchx 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"fceu.png");
	l_system->addEmulator(l_emulator);
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-nes.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 -m famicom \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("nes -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("nes -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Nintendo - SNes
	 */
	l_system = new CSystem();
	l_system->setName(_("Nintendo SNes"));
	l_system->setDescription(_("16-Bits video game console sucessor of the Nes"));
	l_system->setIconFile(GELIDE_PIXMAPS"nintendo-snes.png");
	// Emulador Zsnes
	l_emulator.setId(0);
	l_emulator.setName(_("Zsnes"));
	l_emulator.setDescription(_("Zsnes - A Super Nintendo emulator"));
	l_emulator.setVersion("1.51");
	l_emulator.setAuthor(_("zsKnight & _Demo_"));
	l_emulator.setHomepage("http://www.zsnes.com");
	l_emulator.setPath("/usr/bin/zsnes");
	l_emulator.setParams("-m -s -r 5 -k 75 -v 7 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"zsnes.png");
	l_system->addEmulator(l_emulator);
	// Emulador Snes9x
	l_emulator.setId(0);
	l_emulator.setName(_("SNes9x"));
	l_emulator.setDescription(_("Portable and Free SNes emulator"));
	l_emulator.setVersion("1.5");
	l_emulator.setAuthor(_("Alain Schroeder"));
	l_emulator.setHomepage("http://www.snes9x.com");
	l_emulator.setPath("/usr/bin/snes9x");
	l_emulator.setParams("-st -sq 4 -y2 -fs -sc \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"snes9x.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 -m superfamicom \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("snes -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("snes -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Nintendo - 64
	 */
	l_system = new CSystem();
	l_system->setName(_("Nintendo 64"));
	l_system->setDescription(_("64-Bit console released by Nintendo in 1996 in Japan."));
	l_system->setIconFile(GELIDE_PIXMAPS"nintendo-n64.png");
	// Emulador Mupen64plus
	l_emulator.setId(0);
	l_emulator.setName(_("Mupen64Plus"));
	l_emulator.setDescription(_("An open source Nintendo 64 emulator"));
	l_emulator.setVersion("1.5");
	l_emulator.setAuthor(_("The Mupen64Plus Team"));
	l_emulator.setHomepage("http://code.google.com/p/mupen64plus");
	l_emulator.setPath("/usr/local/bin/mupen64plus");
	l_emulator.setParams("--nogui --noask --noosd --fullscreen \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mupen64plus.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("n64 -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Raine: Rainbow Island Emulator
	 */
	l_system = new CSystem();
	l_system->setName(_("Raine"));
	l_system->setDescription(_("M680x0 Arcade Emulation"));
	l_system->setIconFile(GELIDE_PIXMAPS"raine-system.png");
	// Emulador raine
	l_emulator.setId(0);
	l_emulator.setName(_("Raine"));
	l_emulator.setDescription(_("Multi arcade emulator mainly focused on Taito and Jaleco hardware"));
	l_emulator.setVersion("0.51.0");
	l_emulator.setAuthor(_("Antiriad And Raine Team"));
	l_emulator.setHomepage("http://rainemu.swishparty.co.uk/");
	l_emulator.setPath("/usr/games/raine");
	l_emulator.setParams("-nogui -game $gn");
	l_emulator.setIconFile(GELIDE_PIXMAPS"raine.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMame"));
	l_emulator.setDescription(_("Portable Mame version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130u2");
	l_emulator.setAuthor(_("Nicola Salmoria and the Mame Team"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/sdlmame");
	l_emulator.setParams("-antialias -sound -skip_gameinfo -multithreading -video opengl -keepaspect -rompath \"$gp\" \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmame.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmame
	l_emulator.setId(0);
	l_emulator.setName(_("XMame"));
	l_emulator.setDescription(_("Multiple Arcade Machine Emulator for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("Nicola Salmoria and the Mame Team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmame");
	l_emulator.setParams("-vidmod 0 -fullscreen -ef 1 -aa -ka -doublebuf -rp \"$gp\" -skip_gameinfo \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmame.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  RCA - Studio II
	 */
	l_system = new CSystem();
	l_system->setName(_("RCA Studio II"));
	l_system->setDescription(_("Video game console made by RCA that debuted in January 1977"));
	l_system->setIconFile(GELIDE_PIXMAPS"rca-studio2.png");
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("studio2 -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("studio2 -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Sega - Game Gear
	 */
	l_system = new CSystem();
	l_system->setName(_("Sega Game Gear"));
	l_system->setDescription(_("Handheld game console released by Sega as response Game Boy"));
	l_system->setIconFile(GELIDE_PIXMAPS"sega-gamegear.png");
	// Emulador osmose
	l_emulator.setId(0);
	l_emulator.setName(_("Osmose"));
	l_emulator.setDescription(_("Open source Sega Master System / Gamegear emulator"));
	l_emulator.setVersion("0.8.5b");
	l_emulator.setAuthor(_("Bruno Vedder"));
	l_emulator.setHomepage("http://bcz.emu-france.com/osmose.htm");
	l_emulator.setPath("/usr/games/osmose");
	l_emulator.setParams("-fs -scale2x \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"osmose.png");
	l_system->addEmulator(l_emulator);
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-gg.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("gamegear -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Sega - Master System
	 */
	l_system = new CSystem();
	l_system->setName(_("Sega Master System"));
	l_system->setDescription(_("8-Bits cartridge based video game console released by Sega"));
	l_system->setIconFile(GELIDE_PIXMAPS"sega-mastersystem.png");
	// Emulador osmose
	l_emulator.setId(0);
	l_emulator.setName(_("Osmose"));
	l_emulator.setDescription(_("Open source Sega Master System / Gamegear emulator"));
	l_emulator.setVersion("0.8.5b");
	l_emulator.setAuthor(_("Bruno Vedder"));
	l_emulator.setHomepage("http://bcz.emu-france.com/osmose.htm");
	l_emulator.setPath("/usr/games/osmose");
	l_emulator.setParams("-fs -scale2x \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"osmose.png");
	l_system->addEmulator(l_emulator);
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-sms.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("sms -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("smsm3 -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\" -bp \"$bp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Sega - Mega Drive
	 */
	l_system = new CSystem();
	l_system->setName(_("Sega Mega Drive"));
	l_system->setDescription(_("16-Bits video game console developed by Sega. Also known as Genesis"));
	l_system->setIconFile(GELIDE_PIXMAPS"sega-megadrive.png");
	// Emulador gens/gs
	l_emulator.setId(0);
	l_emulator.setName(_("Gens/GS"));
	l_emulator.setDescription(_("Free Sega Mega Drive / Génesis / Sega CD / 32x emulator"));
	l_emulator.setVersion("2.15.5-gs-m6");
	l_emulator.setAuthor(_("Stephane Dallongeville\nStephane Akhoun\nDavid Korth (GS)"));
	l_emulator.setHomepage("http://info.sonicretro.org/Gens/GS");
	l_emulator.setPath("/usr/bin/gens");
	l_emulator.setParams("--fs --disable-fps --render 10 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"gens.png");
	l_system->addEmulator(l_emulator);
	// Emulador regen
	l_emulator.setId(0);
	l_emulator.setName(_("Regen"));
	l_emulator.setDescription(_("Sega Genesis/MegaDrive emulator written for maximum accuracy"));
	l_emulator.setVersion("0.9 (Linux)");
	l_emulator.setAuthor(_("AamirM"));
	l_emulator.setHomepage("http://aamirm.hacking-cult.org/about/");
	l_emulator.setPath("/usr/games/regen");
	l_emulator.setParams("-f \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"regen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador generator-cbiere
	l_emulator.setId(0);
	l_emulator.setName(_("Generator (Pal)"));
	l_emulator.setDescription(_("Open source Sega Mega Drive / Génesis emulator"));
	l_emulator.setVersion("0.35 (cbiere)");
	l_emulator.setAuthor(_("James Ponder"));
	l_emulator.setHomepage("http://www.squish.net/generator/");
	l_emulator.setPath("/usr/local/bin/generator-sdl");
	l_emulator.setParams("-a -r europe \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"generator.png");
	l_system->addEmulator(l_emulator);
	// Emulador generator-cbiere
	l_emulator.setId(0);
	l_emulator.setName(_("Generator (Ntsc)"));
	l_emulator.setDescription(_("Open source Sega Mega Drive / Génesis emulator"));
	l_emulator.setVersion("0.35 (cbiere)");
	l_emulator.setAuthor(_("James Ponder"));
	l_emulator.setHomepage("http://www.squish.net/generator/");
	l_emulator.setPath("/usr/local/bin/generator-sdl");
	l_emulator.setParams("-a -r usa \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"generator.png");
	l_system->addEmulator(l_emulator);
	// Emulador dgen
	l_emulator.setId(0);
	l_emulator.setName(_("Dgen/Sdl"));
	l_emulator.setDescription(_("Sega Mega Drive / Génesis emulator"));
	l_emulator.setVersion("1.23");
	l_emulator.setAuthor(_("The Dgen Team"));
	l_emulator.setHomepage("");
	l_emulator.setPath("/usr/bin/dgen");
	l_emulator.setParams("-f \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"dgen.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("genesis -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmess
	l_emulator.setId(0);
	l_emulator.setName(_("XMess"));
	l_emulator.setDescription(_("Multiple Emulator Super System for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("The XMame team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmess");
	l_emulator.setParams("gen_eur -fullscreen -ef 1 -ka -skip_warnings -skip_gameinfo -doublebuf -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  Sega - SG1000
	 */
	l_system = new CSystem();
	l_system->setName(_("Sega SG1000"));
	l_system->setDescription(_("Was the first video game console developed by Sega"));
	l_system->setIconFile(GELIDE_PIXMAPS"sega-sg1000.png");
	// Emulador mednafen
	l_emulator.setId(0);
	l_emulator.setName(_("Mednafen"));
	l_emulator.setDescription(_("Multiple-system emulator for various platforms"));
	l_emulator.setVersion("0.8.B");
	l_emulator.setAuthor(_("The Mednafen team"));
	l_emulator.setHomepage("http://mednafen.sourceforge.net");
	l_emulator.setPath("/usr/games/mednafen");
	l_emulator.setParams("-sms.stretch 0 -fs 1 -vdriver 0 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"mednafen.png");
	l_system->addEmulator(l_emulator);
	// Emulador Xe
	l_emulator.setId(0);
	l_emulator.setName(_("Xe Emulator"));
	l_emulator.setDescription(_("Multiple-system emulator for Linux and Windows"));
	l_emulator.setVersion("2.16.2");
	l_emulator.setAuthor(_("James Li"));
	l_emulator.setHomepage("http://www.xe-emulator.com");
	l_emulator.setPath("/usr/local/bin/xe");
	l_emulator.setParams("--lite --fullscreen --render 1 \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xe.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmess
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMess"));
	l_emulator.setDescription(_("Portable Mess version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130");
	l_emulator.setAuthor(_("Olivier Galibert and R. Belmont"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/mess");
	l_emulator.setParams("sg1000 -ka -skip_warnings -skip_gameinfo -sound -multithreading -video opengl -cart \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmess.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  SNK - Neo-Geo
	 */
	l_system = new CSystem();
	l_system->setName(_("SNK Neo Geo"));
	l_system->setDescription(_("Cartridge-based arcade and home video game system released in 1990 by SNK"));
	l_system->setIconFile(GELIDE_PIXMAPS"snk-neogeo.png");
	// Emulador sdlmame
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMame"));
	l_emulator.setDescription(_("Portable Mame version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130u2");
	l_emulator.setAuthor(_("Nicola Salmoria and the Mame Team"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/sdlmame");
	l_emulator.setParams("-antialias -sound -skip_gameinfo -multithreading -video opengl -keepaspect -rompath \"$gp\" \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmame.png");
	l_system->addEmulator(l_emulator);
	// Emulador gngeo
	l_emulator.setId(0);
	l_emulator.setName(_("GnGeo"));
	l_emulator.setDescription(_("A NeoGeo emulator for linux"));
	l_emulator.setVersion("0.7");
	l_emulator.setAuthor(_("Mathieu PEPONAS & others"));
	l_emulator.setHomepage("http://gngeo.berlios.de/");
	l_emulator.setPath("/usr/bin/gngeo");
	l_emulator.setParams("--biospath=\"$bp\" -f --sound \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"gngeo.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmame
	l_emulator.setId(0);
	l_emulator.setName(_("XMame"));
	l_emulator.setDescription(_("Multiple Arcade Machine Emulator for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("Nicola Salmoria and the Mame Team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmame");
	l_emulator.setParams("-vidmod 0 -fullscreen -ef 1 -aa -ka -doublebuf -rp \"$gp\" -skip_gameinfo \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmame.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

	/*
	 *  ZiNc: 3d arcade emulator
	 */
	l_system = new CSystem();
	l_system->setName(_("ZiNc"));
	l_system->setDescription(_("Zinc - 3d arcade emulator"));
	l_system->setIconFile(GELIDE_PIXMAPS"zinc-system.png");
	// Emulador raine
	l_emulator.setId(0);
	l_emulator.setName(_("ZiNc"));
	l_emulator.setDescription(_("Emulator for Sony ZN-1 and ZN-2 and Namco System 11 hardware"));
	l_emulator.setVersion("1.1");
	l_emulator.setAuthor(_("The_Author and DynaChicken"));
	l_emulator.setHomepage("http://www.emuhype.com");
	l_emulator.setPath("/opt/zinc/zinc");
	l_emulator.setParams("`$ef --list-games|awk '/\\\[$gn/ {print $1}'` --roms-directory=\"$gp\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"zinc.png");
	l_system->addEmulator(l_emulator);
	// Emulador sdlmame
	l_emulator.setId(0);
	l_emulator.setName(_("SdlMame"));
	l_emulator.setDescription(_("Portable Mame version for POSIX-y systems with SDL"));
	l_emulator.setVersion("0.130u2");
	l_emulator.setAuthor(_("Nicola Salmoria and the Mame Team"));
	l_emulator.setHomepage("http://rbelmont.mameworld.info/?page_id=163");
	l_emulator.setPath("/usr/games/sdlmame");
	l_emulator.setParams("-antialias -sound -skip_gameinfo -multithreading -video opengl -keepaspect -rompath \"$gp\" \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"sdlmame.png");
	l_system->addEmulator(l_emulator);
	// Emulador xmame
	l_emulator.setId(0);
	l_emulator.setName(_("XMame"));
	l_emulator.setDescription(_("Multiple Arcade Machine Emulator for UNIX/Linux"));
	l_emulator.setVersion("0.106");
	l_emulator.setAuthor(_("Nicola Salmoria and the Mame Team"));
	l_emulator.setHomepage("http://x.mame.net");
	l_emulator.setPath("/usr/games/xmame");
	l_emulator.setParams("-vidmod 0 -fullscreen -ef 1 -aa -ka -doublebuf -rp \"$gp\" -skip_gameinfo \"$gf\"");
	l_emulator.setIconFile(GELIDE_PIXMAPS"xmame.png");
	l_system->addEmulator(l_emulator);
	addSystem(*l_system);

}

