/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gelide
 * Copyright (C) 2008 Juan Ángel Moreno Fernández
 *
 * gelide is free software.
 *
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * gelide is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gelide.  If not, see <http://www.gnu.org/licenses/>
 */

#include "xml_tools.hpp"

CXmlNode::CXmlNode(void) :
	m_node(NULL)
{
}

CXmlNode::CXmlNode(xmlNodePtr p_node) :
	m_node(p_node)
{
}

CXmlNode::~CXmlNode(){
}

Glib::ustring CXmlNode::getName(void){
	if (m_node->name != NULL)
		return( reinterpret_cast<const char*>(m_node->name));
	else
		return "";
}

Glib::ustring CXmlNode::getAttributeValue(const Glib::ustring& p_name){
	xmlChar* l_value;
	Glib::ustring l_ret;

	l_value = xmlGetProp(m_node, BAD_CAST p_name.c_str());
	if (l_value == NULL)
		return "";
	else{
		l_ret = reinterpret_cast<const char*>(l_value);
		xmlFree (l_value);
		return l_ret;
	}
}

Glib::ustring CXmlNode::getString(void){
	xmlChar* l_value;
	Glib::ustring l_ret;

	l_value = xmlNodeListGetString(m_node->doc, m_node->xmlChildrenNode, 1);
	if (l_value == NULL){
		return "";
	}
	else{
		l_ret = reinterpret_cast<const char*>(l_value) ;
		xmlFree (l_value);
		return l_ret;
	}
}

CXmlNode CXmlNode::getNext(){
	return m_node->next;
}

CXmlNode CXmlNode::getChild(){
	return m_node->children;
}




CXmlDocument::CXmlDocument():
	m_doc(0)
{
}

CXmlDocument::~CXmlDocument()
{
	// free the document
	if (m_doc != 0)
		xmlFreeDoc (m_doc);
}

bool CXmlDocument::load(const Glib::ustring& p_file)
{
	m_doc = xmlParseFile(p_file.c_str());

	if (m_doc == 0)
		return false;
	return true;
}

CXmlNode CXmlDocument::getRoot(){
	xmlNodePtr l_root;

	if (m_doc == 0)
		return NULL;

	l_root = xmlDocGetRootElement(m_doc);

	if (l_root == 0)
		return NULL;

	return l_root;
}







CXmlWriter::CXmlWriter():
	m_writer(NULL)
{
}

CXmlWriter::~CXmlWriter(){
	close();
}

bool CXmlWriter::open(const Glib::ustring& p_file){
    // Creamos el writer sin compresión
    m_writer = xmlNewTextWriterFilename(p_file.c_str(), 0);

    if (m_writer == NULL)
        return false;
    // Establecemos la indentación
    xmlTextWriterSetIndent(m_writer, 1);

    return true;
}

void CXmlWriter::close(void){
  if (m_writer != NULL){
	 xmlFreeTextWriter(m_writer);
	 m_writer = NULL;
	}
}

bool CXmlWriter::startDocument(void){
    int l_ret;

    assert(m_writer);

    l_ret = xmlTextWriterStartDocument(m_writer, "1.0", "utf-8", NULL);
    if (l_ret < 0)
      return false;
    return true;
}

bool CXmlWriter::endDocument(void){
    int l_ret;

    assert(m_writer);

    l_ret = xmlTextWriterEndDocument(m_writer);

    if (l_ret < 0)
      return false;
    return true;
}

bool CXmlWriter::startElement(const Glib::ustring& p_name){
    int l_ret;

    assert(m_writer);

    l_ret = xmlTextWriterStartElement(m_writer, BAD_CAST p_name.c_str());

    if (l_ret < 0)
      return false;
    return true;
}

bool CXmlWriter::endElement(void){
    int l_ret;

    assert(m_writer);

    l_ret = xmlTextWriterEndElement(m_writer);

    if (l_ret < 0)
      return false;
    return true;
}

bool CXmlWriter::writeAttribute(const Glib::ustring& p_name, const Glib::ustring& p_value){
    int l_ret;

    assert(m_writer);

    l_ret = xmlTextWriterWriteAttribute (m_writer, BAD_CAST p_name.c_str(),	BAD_CAST p_value.c_str());

    if (l_ret < 0)
      return false;
    return true;
}

bool CXmlWriter::writeComment(const Glib::ustring& p_comment){
    int l_ret;

    assert(m_writer);

    l_ret = xmlTextWriterWriteComment(m_writer, BAD_CAST p_comment.c_str());

    if (l_ret < 0)
      return false;
    return true;
}

bool CXmlWriter::writeString(const Glib::ustring& p_text){
    int l_ret;

    assert(m_writer);

    l_ret = xmlTextWriterWriteString(m_writer, BAD_CAST p_text.c_str());

    if (l_ret < 0)
      return false;
    return true;
}

