/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gelide
 * Copyright (C) 2008 Juan Ángel Moreno Fernández
 *
 * gelide is free software.
 *
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * gelide is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gelide.  If not, see <http://www.gnu.org/licenses/>
 */

#ifndef _XML_TOOLS_HPP_
#define _XML_TOOLS_HPP_

#include "gelide.hpp"
#include <string>
#include <glibmm/ustring.h>
#include <libxml2/libxml/parser.h>
#include <libxml2/libxml/tree.h>
#include <libxml2/libxml/xmlstring.h>
#include <libxml2/libxml/encoding.h>
#include <libxml2/libxml/xmlwriter.h>

class CXmlNode
{
public:
	CXmlNode(void);
	CXmlNode(xmlNodePtr p_node);
	virtual ~CXmlNode();

	Glib::ustring getName(void);
	Glib::ustring getAttributeValue(const Glib::ustring& p_name);
	Glib::ustring getString(void);

	inline bool isElement(void) { return m_node->type == XML_ELEMENT_NODE; };
	inline bool isValid(void) { return m_node != NULL; };

	CXmlNode getNext(void);
	CXmlNode getChild(void);

private:
	xmlNodePtr m_node;
};


class CXmlDocument
{
public:
	CXmlDocument();
	virtual ~CXmlDocument();

	bool load(const Glib::ustring& p_file);
	CXmlNode getRoot();

private:
	xmlDocPtr m_doc;

};


class CXmlWriter
{
public:

	CXmlWriter();
	virtual ~CXmlWriter();

	bool open(const Glib::ustring& p_file);
	void close(void);

	bool startDocument(void);
	bool endDocument(void);

	bool startElement(const Glib::ustring& p_name);
	bool endElement(void);

	bool writeAttribute(const Glib::ustring& p_name, const Glib::ustring& p_value);
	bool writeComment(const Glib::ustring& p_comment);
	bool writeString(const Glib::ustring& p_text);

private:
	xmlTextWriterPtr m_writer;
};

#endif // _XML_TOOLS_HPP_
