//
// C++ Implementation: cbuttoneditor
//
// Description: 
//
//
// Author: Tomas Mecir <kmuddy@kmuddy.com>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "cbuttoneditor.h"

#include <QGridLayout>
#include <QGroupBox>
#include <QLabel>
#include <QHBoxLayout>

#include <kicondialog.h>
#include <klineedit.h>
#include <klocale.h>

struct cButtonEditor::Private {
  KLineEdit *caption, *command, *command2;
  KIconButton *icon;
  QGroupBox *pushdown;
};

cButtonEditor::cButtonEditor (QWidget *parent)
  : cListEditor (parent)
{
  d = new Private;
}

cButtonEditor::~cButtonEditor ()
{
  // the GUI elements will be destroyed automatically
  delete d;
}

void cButtonEditor::createGUI(QWidget *parent)
{
  QGridLayout *layout = new QGridLayout (parent);
  
  // caption
  QLabel *lbl1 = new QLabel (i18n ("&Caption"), parent);
  d->caption = new KLineEdit (parent);
  lbl1->setBuddy (d->caption);
  d->caption->setWhatsThis( i18n ("Caption of this button."));

  //command
  QLabel *lblc1 = new QLabel (i18n ("Co&mmand"), parent);
  d->command = new KLineEdit (parent);
  lblc1->setBuddy (d->command);
  d->command->setWhatsThis( i18n ("Command that will be executed if you click on the button. "
      "Note that you can enter multiple commands here (separated by semi-colons, "
      "or another characted defined in <b>global settings</b>)."));
  
 //icon
  QLabel *il = new QLabel ("&Icon", parent);
  d->icon = new KIconButton (parent);
  d->icon->setIconSize (32);
  il->setBuddy (d->icon);
  d->icon->setWhatsThis (i18n ("Icon displayed on the button toolbar."));

  // pushdown
  d->pushdown = new QGroupBox ("&Push-down button", parent);
  d->pushdown->setCheckable (true);
  QHBoxLayout *pushdownlayout = new QHBoxLayout (d->pushdown);

  //command2
  QLabel *lblc2 = new QLabel (i18n ("&Un-press command"), d->pushdown);
  d->command2 = new KLineEdit (d->pushdown);
  lblc2->setBuddy (d->command2);
  d->command2->setWhatsThis (i18n ("Command that will be executed if you click on the push-down "
        "button while it's pushed down."));
  pushdownlayout->addWidget (lblc2);
  pushdownlayout->addWidget (d->command2);
 
  QWidget *commonEditor = createCommonAttribEditor (parent);

  //place'em there!
  layout->setSpacing (5);
  layout->addWidget (lbl1, 0, 0);
  layout->addWidget (d->caption, 0, 1);
  layout->addWidget (lblc1, 1, 0);
  layout->addWidget (d->command, 1, 1);
  layout->addWidget (il, 2, 0);
  layout->addWidget (d->icon, 2, 1);
  layout->addWidget (d->pushdown, 3, 0, 1, 2);
  layout->addWidget (commonEditor, 4, 0, 1, 2);
}

void cButtonEditor::fillGUI (const cListObjectData &data)
{
  // Common attributes
  fillCommonAttribEditor (data);

  d->command->setText (data.strValue ("command"));
  d->command2->setText (data.strValue ("command-released"));
  d->caption->setText (data.strValue ("caption"));
  d->icon->setIcon (data.strValue ("icon"));
  d->pushdown->setChecked (data.boolValue ("pushdown"));
}

void cButtonEditor::getDataFromGUI (cListObjectData *data)
{
  // Comon attributes
  getDataFromCommonAttribEditor (data);

  data->strValues["command"] = d->command->text();
  data->strValues["command-released"] = d->command2->text();
  data->strValues["caption"] = d->caption->text();
  data->strValues["icon"] = d->icon->icon();
  data->boolValues["pushdown"] = d->pushdown->isChecked();
}

#include "cbuttoneditor.moc"
