//
// C++ Implementation: ctimereditor
//
// Description: 
//
//
// Author: Tomas Mecir <kmuddy@kmuddy.com>, (C) 2002-2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "ctimereditor.h"

#include "cactionmanager.h"

#include <QCheckBox>
#include <QGridLayout>
#include <QGroupBox>
#include <QLabel>

#include <klineedit.h>
#include <klocale.h>
#include <knuminput.h>

struct cTimerEditor::Private {
  KLineEdit *cmd, *advcmd;
  KIntNumInput *interval, *advinterval;
  QCheckBox *chksingleshot, *chkadvance;
};

cTimerEditor::cTimerEditor (QWidget *parent)
  : cListEditor (parent)
{
  d = new Private;
}

cTimerEditor::~cTimerEditor ()
{
  // the GUI elements will be destroyed automatically
  delete d;
}

void cTimerEditor::createGUI(QWidget *parent)
{
  QGridLayout *layout = new QGridLayout (parent);
  
  //command
  QLabel *lbl1 = new QLabel (i18n ("&Command"), parent);
  d->cmd = new KLineEdit (parent);
  lbl1->setBuddy (d->cmd);
  d->cmd->setWhatsThis( i18n ("Command that will be executed on each tick.\n"
      "Command can include aliases, script calls and similar stuff."));

  //interval
  QLabel *lbl2 = new QLabel (i18n ("&Interval"), parent);
  d->interval = new KIntNumInput (parent);
  d->interval->setMinimum (1);
  d->interval->setMaximum (3600);  //max = 1 hod.
  d->interval->setSuffix (i18n (" secs"));
  lbl2->setBuddy (d->interval);

  //single-shot
  d->chksingleshot = new QCheckBox (i18n ("&Single-shot"), parent);
  d->chksingleshot->setWhatsThis( i18n ("When enabled, the timer will only be executed once and then disabled."));
  
  d->chkadvance = new QCheckBox (i18n ("&Run a command in advance"), parent);
  d->chkadvance->setWhatsThis( i18n ("Run a command a given number of seconds before each timer tick."));

  QGroupBox *grpadvance = new QGroupBox (i18n ("Advance command"), parent);
  QGridLayout *advancelayout = new QGridLayout (grpadvance);

  QLabel *lbl3 = new QLabel (i18n ("&Seconds before tick"), grpadvance);
  d->advinterval = new KIntNumInput (grpadvance);
  d->advinterval->setMinimum (1);
  d->advinterval->setMaximum (180);
  d->advinterval->setSuffix (i18n (" secs"));
  lbl3->setBuddy (d->interval);

  QLabel *lbl4 = new QLabel (i18n ("C&ommand"), parent);
  d->advcmd = new KLineEdit (parent);
  lbl4->setBuddy (d->advcmd);
  d->cmd->setWhatsThis( i18n ("Command that will be executed the specified time before each tick.\n"
      "Command can include aliases, script calls and similar stuff."));

  advancelayout->addWidget (lbl3, 0, 0);
  advancelayout->addWidget (d->advinterval, 0, 1);
  advancelayout->addWidget (lbl4, 1, 0);
  advancelayout->addWidget (d->advcmd, 1, 1);

  QWidget *commonEditor = createCommonAttribEditor (parent);

  //place'em there!
  layout->setSpacing (5);
  layout->addWidget (lbl1, 0, 0);
  layout->addWidget (d->cmd, 0, 1);
  layout->addWidget (lbl2, 1, 0);
  layout->addWidget (d->interval, 1, 1);
  layout->addWidget (d->chksingleshot, 2, 0, 1, 2);
  layout->addWidget (d->chkadvance, 3, 0, 1, 2);
  layout->addWidget (grpadvance, 4, 0, 1, 2);
  layout->addWidget (commonEditor, 5, 0, 1, 2);

  connect (d->chkadvance, SIGNAL (toggled(bool)), grpadvance, SLOT (setEnabled (bool)));
  // initial state
  d->chkadvance->setChecked (false);
  grpadvance->setEnabled (false);
}

void cTimerEditor::fillGUI (const cListObjectData &data)
{
  // Common attributes
  fillCommonAttribEditor (data);

  d->cmd->setText (data.strValue ("command"));
  d->interval->setValue (data.intValue ("interval"));
  d->chksingleshot->setChecked (data.boolValue ("single-shot"));
  d->chkadvance->setChecked (data.boolValue ("advance"));
  d->advcmd->setText (data.strValue ("command-advance"));
  d->advinterval->setValue (data.intValue ("advance-seconds"));
}

void cTimerEditor::getDataFromGUI (cListObjectData *data)
{
  // Comon attributes
  getDataFromCommonAttribEditor (data);

  data->strValues["command"] = d->cmd->text();
  data->intValues["interval"] = d->interval->value();
  data->boolValues["single-shot"] = d->chksingleshot->isChecked();
  data->boolValues["advance"] = d->chkadvance->isChecked();
  data->strValues["command-advance"] = d->advcmd->text();
  data->intValues["advance-seconds"] = d->advinterval->value();
}

#include "ctimereditor.moc"
