/***************************************************************************
 *            tttfhgui.cpp
 *
 *  ven apr 23 19:48:20 CEST 2010
 *  Copyright  2010  Simone Tobia
 *  Email simone.tobia@gmail.com
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "tttfhgui.h"
#include "ui_tttfhgui.h"

TTTFHGui::TTTFHGui(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::TTTFHGui)
{
    ui->setupUi(this);

    sessionDialog = new SessionDialog;
    connect(this->ui->actionNew, SIGNAL(activated()), this, SLOT(newSession()));
    connect(this->ui->actionRestart, SIGNAL(activated()), this, SLOT(restart()));
    connect(this->ui->actionAbout, SIGNAL(activated()), this, SLOT(about()));
    connect(this->ui->actionQuick_Rules, SIGNAL(activated()), this, SLOT(quick()));

    statusLabel=new QLabel("");
    statusBar()->addPermanentWidget(statusLabel);

    softGameArea = new SoftGameArea(this,sessionDialog,statusLabel);

    QGridLayout *layout = new QGridLayout;
    layout->addWidget(softGameArea,0,0);
    ui->centralWidget->setLayout(layout);

    aboutDialog = new AboutDialog;

    QAction *newSession=new QAction(QIcon(":main/newSession.png"),tr("New Match"), ui->mainToolBar);
    QAction *restart=new QAction(QIcon(":main/newGame.png"),tr("Restart Set"), ui->mainToolBar);
    QAction *quick=new QAction(QIcon(":main/quickSession.png"),tr("Quick rules"), ui->mainToolBar);
    ui->mainToolBar->addAction(newSession);

    ui->mainToolBar->addAction(quick);
    ui->mainToolBar->addAction(restart);

    connect(restart, SIGNAL(triggered()), this, SLOT(restart()));
    connect(quick, SIGNAL(triggered()), this, SLOT(quick()));
    connect(newSession, SIGNAL(triggered()), this, SLOT(newSession()));
}

TTTFHGui::~TTTFHGui(){
    delete ui;
}

void TTTFHGui::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void TTTFHGui::restart(){
    if(softGameArea->mode)softGameArea->newGame(sessionDialog->getGridSize(),sessionDialog->getWinSize(),false);
}

void TTTFHGui::quick(){
    softGameArea->quickSettings();
}

void TTTFHGui::about(){
    aboutDialog->show();
}

void TTTFHGui::newSession(){    
    sessionDialog->show();

    if (sessionDialog->exec() == QDialog::Accepted) {        
        softGameArea->mode=1;
        softGameArea->newGame(sessionDialog->getGridSize(),sessionDialog->getWinSize(),true);
    }
}
