/*
 * Hqp_Conf.h -- declaration of the config-structure
 *
 * jb 030817
 *
 */

/*
    Copyright (C) 2003 Johan Borg

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; 
    version 2 of the License.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this library (file COPYING.LIB);
    if not, write to the Free Software Foundation, Inc.,
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef Hqp_Conf_H
#define Hqp_Conf_H


typedef void (update_t)(double *f,double *c,double *b,double * d,double *x,int full);

typedef struct bnd_t {
 double val;
 int ind;
 int type;
} bnd_t; 
 
 
typedef struct con_t {
// double val;
 double *der;
 int *ind;
} con_t;


//bool:  0 = default value, -1 = false, 1 = true    (here)
typedef struct Sqp_Config {
  double HL_eps;			//1e-8		(sqp_hela_eps)
  int HL_logging; 			//false		
  int HL_scale;  			//1		(sqp_hela_scale)
  int HL_init_multipliers;		//false		
  double HL_BFGS_gamma;			//0.1		
  int HL_BFGS_eigen_control;		//1		(sqp_hela_eigen_control)
  double IpsFranke_alpha;		//1.0		
  double IpsFranke_mu0; 		//_mu0 = 0.0
  double IpsFranke_beta;		//0.995		
  int IpsFranke_max_warm_iters; 	//15
  int IpsFranke_matrix;			//2	        (qp_mat_solver)		1: SpBKP  2: IpRedSpBKP  3: SpSC  4: LQDOCP
  int Solver_max_iters;			//200		(qp_max_iters)
  double Solver_eps;			//1e-10		(qp_eps)
  int SqpPowell_watchdog_start; 	//10		(sqp_watchdog_start)
  int SqpPowell_watchdog_credit;	//0		(sqp_watchdog_credit)
  int SqpPowell_watchdog_logging;	//true		(sqp_watchdog_logging)
  int SqpPowell_damped_multipliers;	//false
  int SqpSolver_solver;			//1		(sqp_qp_solver)		1: Franke  2: Mehrotra
  int SqpSolver_hela;			//1		(sqp_hela)		1: BFGS	 2: DScale  3: Gerschgorin
  int SqpSolver_max_iters;		//500		(sqp_max_iters)
  int SqpSolver_max_inf_iters;		//10		(sqp_max_inf_iters)
  double SqpSolver_min_alpha;		//1e-10		(sqp_min_alpha)
  double SqpSolver_eps;			//1e-6		(sqp_eps)
  double SqpSolver_solver_eps;		//1e-10;	
  double IpRedSpBKP_tol;		//1.0
  double IpMatrix_eps;			//1e-10
  int Solver;				//1		(sqp_solver)		1: Powell  2:Schittkowski
  int n;				//number of variables
  int m;				//number of inequality constrants 
  int me;				//number of equality constraints
  int mb;				//number of bounds
  update_t *prog;			//the callback function
  struct bnd_t *bnd;			//variable bounds
  struct con_t *icon,*econ;		//inequality and equality constraints
  double *x;				//initial and final x
} Sqp_Config;  


#endif
