/*
 * Hqp_IpMatrix.h -- abstract base class
 *   - manage the Jacobian matrix of Interior Point algorithms
 * rf, 6/1/94
 *
 * rf, 9/14/96
 *   - extended solve-interface
 *
 * rf, 3/3/97
 *   - introduce iterative refinement of solutions
 * 
 * jb, 9/18/03
 * stripped out parts related to iflist or tcl, possibly other parts too
 * added new means for configuration
 * changed license to gpl v2
 * 
 */

/*
    Copyright (C) 1994--2000  Ruediger Franke
    Copyright (C) 2003 Johan Borg

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; 
    version 2 of the License.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this library (file COPYING.LIB);
    if not, write to the Free Software Foundation, Inc.,
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef Hqp_IpMatrix_H
#define Hqp_IpMatrix_H


#include "Hqp_impl.h"

class Hqp_Program;


class Hqp_IpMatrix {

 protected:

  VEC	*_r1;
  VEC	*_r2;
  VEC	*_r3;
  VEC	*_r4;

  VEC	*_dx;
  VEC	*_dy;
  VEC	*_dz;
  VEC	*_dw;

  Real 	_eps;

 public:
  Hqp_IpMatrix(Sqp_Config * conf);
  virtual ~Hqp_IpMatrix();
  
  virtual void	init(const Hqp_Program *) = 0;
  virtual void	update(const Hqp_Program *) = 0;

  virtual void	factor(const Hqp_Program *,
		       const VEC *z, const VEC *w) = 0;

  // default solve() implements iterative refinement
  virtual Real	solve(const Hqp_Program *,
		      const VEC *z, const VEC *w,
		      const VEC *r1, const VEC *r2, const VEC *r3,
		      const VEC *r4,
		      VEC *dx, VEC *dy, VEC *dz, VEC *dw);

  virtual Real	residuum(const Hqp_Program *,
			 const VEC *z, const VEC *w,
			 const VEC *r1, const VEC *r2, const VEC *r3,
			 const VEC *r4,
			 VEC *dx, VEC *dy, VEC *dz, VEC *dw);

  virtual void	step(const Hqp_Program *,
		     const VEC *z, const VEC *w,
		     const VEC *r1, const VEC *r2, const VEC *r3,
		     const VEC *r4,
		     VEC *dx, VEC *dy, VEC *dz, VEC *dw);

  virtual char	*name()=0;
};

#endif
