/*
 * Hqp_Solver.C -- 
 *   - class definition
 *
 * rf, 7/19/94
 *
 * rf, 8/13/98
 *   - make Hqp_Solver a visible interface class
 * 
 * jb, 9/18/03
 * stripped out parts related to iflist or tcl, possibly other parts too
 * added new means for configuration
 * changed license to gpl v2
 * 
 */

/*
    Copyright (C) 1994--2001  Ruediger Franke
    Copyright (C) 2003 Johan Borg

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; 
    version 2 of the License.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this library (file COPYING.LIB);
    if not, write to the Free Software Foundation, Inc.,
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "Hqp_Solver.h"
#include "Hqp_Program.h"



//--------------------------------------------------------------------------
Hqp_Solver::Hqp_Solver(Sqp_Config * conf)
{
  _qp = NULL;
  _result = Hqp_Infeasible;
  _iter = 0;
  if (conf->Solver_max_iters) _max_iters=conf->Solver_max_iters; else _max_iters = 200;
  if (conf->Solver_eps) _eps=conf->Solver_eps; else _eps = 1e-10;
  _y = VNULL;
  _z = VNULL;

/*  GInt_qp_iter=&_iter;
  GInt_qp_max_iters=&_max_iters;
  GReal_qp_eps=&_eps;*/
//  HqpGCmd_qp_result=&_Solver::result_str, this;		//FIX (why/how?)
}

//--------------------------------------------------------------------------
Hqp_Solver::~Hqp_Solver()
{
  v_free(_y);
  v_free(_z);
}

//--------------------------------------------------------------------------
int Hqp_Solver::result_str()
{
//  *result = (char *)hqp_result_strings[_result];
  return IF_OK;
}

//--------------------------------------------------------------------------
void Hqp_Solver::qp(Hqp_Program *qp)
{
  _qp = qp;
}
