/*
 * Prg_Simple.h -- 
 *   - simple sqp interface, once
 *   - C interface now
 */

/*
    Copyright (C) 1999  Ruediger Franke
    Copyright (C) 2003 Johan Borg

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; 
    version 2 of the License.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this library (file COPYING.LIB);
    if not, write to the Free Software Foundation, Inc.,
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef Prg_Simple_H
#define Prg_Simple_H

#include "Hqp_SqpProgram.h"

/*
 * class declaration
 */
 
/* 
 
typedef struct bnd_t {
 double val;
 int ind;
 int type;
} bnd_t; 
 
 
typedef struct con_t {
 double val;
 double *der;
 int *ind;
} con_t;
*/





 

class Prg_Simple: public Hqp_SqpProgram {

 protected:



  int _m;		//number of inequality constraints
  int _me;		//equality constraints
  int _mb;		//variable bounds
  int _n; 		//variables
  struct bnd_t *_bnd;
  struct con_t	*_icon,*_econ; 
  double * _my_x;

  void update_bounds();
  update_t	*_update;

 public:
  Prg_Simple(Sqp_Config *conf);
  ~Prg_Simple();

  void	setup();
  void	init_x();

  void	update_fbd();
  void	update(const VECP y, const VECP z);

  char *name() {return "Simple";}
};  


#endif


