/* Sparse matrix utility macros */
/* (C) Copyright David Stewart Fri 25th Sep 1992, 04:34:41 PM */
/* This file contains macros for making life with sparse matrices easier */

/* loop over the columns in a row */
#define	loop_cols(r,e,code) \
    do { int _r_idx; row_elt *e; sp_row *_t_row;			\
	  _t_row = (r); e = &(_t_row->elt);				\
	  for ( _r_idx = 0; _r_idx < _t_row->len; _r_idx++, e++ )	\
	  {  code;  }  }  while ( 0 )

/* loop over the rows in a column */
#define	loop_cols(A,col,e,code) \
    do { int _r_num, _r_idx, _c; sp_row *_r; row_elt *e;		\
	  if ( ! (A)->flag_col )	sp_col_access((A));		\
	  col_num = (col);						\
	  if ( col_num < 0 || col_num >= A->n )				\
	      error(E_BOUNDS,"loop_cols");				\
          _r_num = (A)->start_row[_c]; _r_idx = (A)->start_idx[_c];	\
	  while ( _r_num >= 0 )  {					\
	      _r = &((A)->row[_r_num]);					\
              _r_idx = sp_get_idx2(_r,_c,_r_idx);			\
              if ( _r_idx < 0 )  continue;				\
	      e = &(_r->elt[_r_idx]);	code;				\
	      _r_num = e->nxt_row;	_r_idx = e->nxt_idx;		\
	      } } while ( 0 )

