//example of how to use the modified version of hqp with plain C
//I hope it still works...
/*
    Copyright (C) 2003 Johan Borg

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
            
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
                            
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/    



#include <stdio.h>
#include "Hqp_Conf.h"
#include <math.h>
#include <sys/time.h>


double x0[]={
20.000000,356.000000,20.000000,356.000000,20.000000,20.000000,290.000000,290.000000,
382.000000,752.000000,382.000000,752.000000,20.000000,20.000000,254.000000,254.000000,
20.000000,362.000000,20.000000,362.000000,310.000000,310.000000,597.000000,597.000000,
382.000000,749.000000,382.000000,749.000000,310.000000,310.000000,584.000000,584.000000};

double p1[]={
336,270,
370,234,
342,287,
367,274};

/*
#define p2m 0.1
double p2[]= {
1000*p2m,1000*p2m,1000*p2m,1000*p2m,1000*p2m,1000*p2m,
10,100,1000,1000,10,100};*/

double p2[]= {
1000,100000,1000,100000,10000,10000,
10,100,1000,1000,10,100};



double p3[]={2,0,0,0,0,0,0,0};

double p4[]={
0,297.000000,20.500000,1,27.000000,20.500000,
0,88.000000,258.000000,2,88.000000,65.000000,
2,313.000000,9.000000,0,313.000000,202.000000,
1,68.500000,219.000000,3,65.500000,13.000000,
0,314.500000,224.500000,1,44.500000,224.500000,
1,253.000000,219.000000,3,250.000000,13.000000,
2,317.000000,274.000000,3,44.000000,261.000000};

//2,334.000000,26.500000,3,61.000000,13.500000};



con_t *econ;

extern void Hqp_Init(Sqp_Config *conf);

double eps,seps;
#define deps 1e-8

int N,M;

double obj(double *x) {
 double a,b,c,d,e,g;
 double A,B,C,D,E,G;
 int j,n;
 double *p,f;
 
 //question is: do we calculate this once and risk loss of accuracy, 2 times, or once and store the results?
 
 A=B=C=D=E=G=0;

  
 for(n=0;n<N;n++) {
  p=x+n*8;
  A+=(p[2]-p[0])/p1[2*n+0];
  B+=(p[0]+p[6]-p[2]-p[4])/p1[2*n+1]/p1[2*n+0];
  C+=(p[5]-p[1])/p1[2*n+1];
  D+=(p[1]+p[7]-p[3]-p[5])/p1[2*n+1]/p1[2*n+0];
  E+=(p[4]-p[0])/p1[2*n+1];
  G+=(p[3]-p[1])/p1[2*n+0];
 } 
 
 
 A/=N; B/=N; C/=N;
 D/=N; E/=N; G/=N;

 
 a=b=c=d=e=g=0;
 
 for(n=0;n<N;n++) {
  p=x+n*8;
  a+=pow((p[2]-p[0])/p1[2*n+0]-A,2.0);
  b+=pow((p[0]+p[6]-p[2]-p[4])/p1[2*n+1]/p1[2*n+0]-B,2.0);
  c+=pow((p[5]-p[1])/p1[2*n+1]-C,2.0);
  d+=pow((p[1]+p[7]-p[3]-p[5])/p1[2*n+1]/p1[2*n+0]-D,2.0);
  e+=pow((p[4]-p[0])/p1[2*n+1]-E,2.0);
  g+=pow((p[3]-p[1])/p1[2*n+0]-G,2.0);
 } 

 f=(p2[0]*a+p2[1]*b+p2[2]*c+p2[3]*d+p2[4]*e+p2[5]*g)/N;
 f+=pow(A+C-2,2.0)*p2[6]+pow(A-C,2.0)*p2[7];
 f+=pow(B,2.0)*p2[8]+pow(D,2.0)*p2[9];
 f+=pow(E+G,2.0)*p2[10]+pow(E-G,2.0)*p2[11];
 
 return f;
}


//really, not using analytical derivatives is rather silly
double cmap(double *X,double *Y,double x,double y,double *p,int n) {
 double a,b,c,d,e,f,g,h;
 a=(p[2]-p[0])/p1[2*n+0];
 b=(p[0]+p[6]-p[2]-p[4])/p1[2*n+1]/p1[2*n+0];
 c=(p[5]-p[1])/p1[2*n+1];
 d=(p[1]+p[7]-p[3]-p[5])/p1[2*n+1]/p1[2*n+0];
 e=(p[4]-p[0])/p1[2*n+1];
 f=p[0];
 g=(p[3]-p[1])/p1[2*n+0];
 h=p[1];
  
 *Y=y*(c+d*x)+g*x+h;
 *X=x*(a+b*y)+e*y+f;
}




void prog(double *f,double *C,double *B,double * D,double *p,int full){
 int i,j,k1,k2;
 double a,b,c,x,y,x1,y1,x2,y2;
 double X,Y;

 if (full&1) { 
  a=obj(p); 
  for(i=0;i<N*8;i++) {
   b=p[i];
   p[i]+=seps;//*(b+deps);
   c=obj(p);
   p[i]=b;
   c-=a;
   c/=seps;//*(b+deps);
   C[i]=c;
  } 
//  printf("a: %f\n",a);
  
  *f=a;
 } else {
  *f=obj(p); 
 }


 if (full&2) {
  for(i=0;i<M;i++) {
   k1=p4[i*6];
   k2=p4[i*6+3];
   cmap(&x1,&y1,p4[i*6+1],p4[i*6+2],p+(k1*8),k1);
   cmap(&x2,&y2,p4[i*6+4],p4[i*6+5],p+(k2*8),k2);
   B[i*2]=x1-x2;
   B[i*2+1]=y1-y2;   
   
   for(j=0;j<8;j++) {
    
    a=p[k1*8+j];
    p[k1*8+j]+=seps;//*(a+deps);
   
    cmap(&x,&y,p4[i*6+1],p4[i*6+2],p+(k1*8),k1);

    p[k1*8+j]=a;
    
    x-=x1;
    y-=y1;
    econ[i*2  ].ind[j]=k1*8+j;
    econ[i*2+1].ind[j]=k1*8+j;
    
    econ[i*2  ].der[j]=x/seps;//(a+deps);
    econ[i*2+1].der[j]=y/seps;//(a+deps);
   } 
   

   for(j=0;j<8;j++) {
    a=p[k2*8+j];
    p[k2*8+j]+=seps;//*(a+deps);

    cmap(&x,&y,p4[i*6+4],p4[i*6+5],p+(k2*8),k2);

    p[k2*8+j]=a;

    x-=x2;
    y-=y2;
    econ[i*2  ].ind[j+8]=k2*8+j;
    econ[i*2+1].ind[j+8]=k2*8+j;
    
    econ[i*2  ].der[j+8]=-x/seps;//(a+deps);
    econ[i*2+1].der[j+8]=-y/seps;//(a+deps);
   } 
   econ[i*2  ].ind[16]=-1;
   econ[i*2+1].ind[16]=-1;
  } 
 } else {
  for(i=0;i<M;i++) {
   k1=p4[i*6];
   k2=p4[i*6+3];
   cmap(&x1,&y1,p4[i*6+1],p4[i*6+2],p+(k1*8),k1);
   cmap(&x2,&y2,p4[i*6+4],p4[i*6+5],p+(k2*8),k2);
   B[i*2]=x1-x2;
   B[i*2+1]=y1-y2;   
  }
 }
}


void check(double *x) {
 int n;
 double *p,a,b,c,d,e,g;
 for(n=0;n<N;n++) {
  p=x+n*8;
  a=(p[2]-p[0])/p1[2*n+0];
  b=(p[0]+p[6]-p[2]-p[4])/p1[2*n+1]/p1[2*n+0];
  c=(p[5]-p[1])/p1[2*n+1];
  d=(p[1]+p[7]-p[3]-p[5])/p1[2*n+1]/p1[2*n+0];
  e=(p[4]-p[0])/p1[2*n+1];
  g=(p[3]-p[1])/p1[2*n+0];
  printf("%2.8f %2.8f %2.8f %2.8f %2.8f %2.8f\n",a,b,c,d,e,g);
 } 
}


int main () {
 int i,j;
 double t;
 struct timeval tm;
 Sqp_Config conf={0};
 eps=pow(2,-52);
 seps=pow(eps,0.5);
 
 
 N=4;
 M=7;
 conf.prog=&prog;
 conf.x=x0;
 conf.n=N*8;
 conf.me=M*2;
 
 conf.SqpSolver_max_iters=10000;
 
 econ=conf.econ=(con_t *)malloc(sizeof(con_t)*14);
 for(i=0;i<14;i++) econ[i].ind=(int *)malloc(sizeof(int)*17);
 for(i=0;i<14;i++) econ[i].der=(double *)malloc(sizeof(double)*16);
 

 gettimeofday(&tm,NULL);
 t=-tm.tv_sec-(float)tm.tv_usec/1000000;
 Hqp_Init(&conf);
 gettimeofday(&tm,NULL);
 t+=tm.tv_sec+(float)tm.tv_usec/1000000;
 printf("t: %f\n",t);
 
 
 for(i=0;i<N;i++) {
  for (j=0;j<8;j++) printf("%3.5f ",x0[i*8+j]);
  printf("\n");
 } 
 check(x0);
 printf("\n");
} 