/*
 * lirccd v0.8 - Middle layer daemon between lircd and its clients
 * Copyright (C) 2003  Fredrik Tolf (fredrik@dolda2000.cjb.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _COMMAND_H
#define _COMMAND_H

#define STACK_DEPTH 128

#define VAL_NULL 0
#define VAL_INT 1
#define VAL_FLOAT 2
#define VAL_STRING 3
#define VAL_ARRAY 4
#define VAL_ARRAYSTART 5

struct value
{
    int ref;
    int type;
    union
    {
	int num;
	double flnum;
	struct
	{
	    unsigned char *buf;
	    int len;
	    int buflen;
	} string;
	struct
	{
	    struct value **values;
	    int len;
	} array;
    } val;
};

struct function
{
    struct function *next;
    unsigned char *name;
    struct instruction *code;
};

struct stackent
{
    struct stackent *next;
    struct value *val;
};

struct callstackent
{
    struct instruction *ins;
    int scope;
};

struct symbol
{
    struct symbol *next;
    unsigned char *name;
    struct value *val;
    int scope;
};

struct instruction
{
    struct instruction *next;
    void (*func)(void);
    struct value *pushval;
};

struct command
{
    struct command *next;
    unsigned char *name;
    void (*func)(void);
};

extern struct stackent *stack;
extern struct command *commands;
extern struct symbol *symbols;
struct function *functions;
struct instruction **labels;
extern struct callstackent callstack[STACK_DEPTH];
extern int curcall;
extern int curscope;

struct value *pop(void);
struct value* push(struct value *val);
struct value *newval(void);
void relval(struct value *val);
struct instruction *insmake(unsigned char *cmd);
void (*findcommand(unsigned char *name))(void);
void addcommand(unsigned char *name, void (*func)(void));
struct value *storeval(struct value *dest, struct value *src);
struct value *dupval(struct value *val);
struct instruction *inspush(struct value *val);
struct value *valmakestr(struct value *val, unsigned char *str);
struct instruction *insconcat(struct instruction *ins, ...);
int label(struct instruction *ins);
void printcmd(struct instruction *ins);
void initcommand(void);
void freefunc(struct function *func);
struct instruction *getfunc(unsigned char *name);
struct function *newfunc(unsigned char *name, struct instruction *code);
void freesym(struct symbol *sym);
struct value *getsym(unsigned char *name);
struct symbol *newsym(unsigned char *name, struct value *val);
void beginscope(void);
void endscope(void);
void run(struct instruction *code);
void makenull(struct value *val);
struct value *valprintf(struct value *val, unsigned char *format, ...);
void freecode(struct instruction *code);
void checkstack(void);
struct value *valcatarray(struct value *arr, struct value *val);
struct value *valmakenullarray(struct value *val);
struct value *valmakestr2(struct value *val, unsigned char *str, int len);
struct value *valcatstr(struct value *val, unsigned char *str, int len);
int valbool(struct value *val);
struct value *valmakeint(struct value *val, int num);
struct value *valmakefloat(struct value *val, double num);
struct value *runfunc(unsigned char *name, int release, ...);

#endif
