%{
#include <string.h>
#include <stdlib.h>
#include <malloc.h>

#include "confparse.h"

int yycurline = 1;
unsigned char *yycurfile = NULL;

static void processlm(unsigned char *str)
{
    unsigned char *p1, *p2;
    str += 2;
    yycurline = atoi(str);
    if(yycurfile != NULL)
	free(yycurfile);
    p1 = strchr(str, '\"') + 1;
    p2 = strchr(p1, '\"');
    yycurfile = memcpy(malloc((p2 - p1) + 1), p1, p2 - p1);
    yycurfile[p2 - p1] = 0;
}

static void transesc(unsigned char *str)
{
    int len;
    unsigned char c;
    
    for(; *str; str++)
    {
	if(*str == '\\')
	{
	    switch(str[1])
	    {
	    case 0:
		len = 0;
		c = '\\';
		break;
	    case 'n':
		len = 1;
		c = '\n';
		break;
	    case 't':
		len = 1;
		c = '\t';
		break;
	    case 'c':
		len = 1;
		c = '\"';
		break;
	    default:
		len = 1;
		c = str[1];
	    }
	    memmove(str + 1, str + len + 1, strlen(str) - len);
	    *str = c;
	}
    }
}
%}
%%

"if"				{return(IF);}
"else"				{return(ELSE);}
"for"				{return(FOR);}
"while"				{return(WHILE);}
"NULL"				{return(NULLTOK);}
"function"			{return(FUNCTION);}
"bind"				{return(BIND);}
"subtree"			{return(SUBTREE);}
"recursively"			{return(RECURSIVE);}
"final"				{return(FINAL);}
"global"			{return(GLOBAL);}
"return"			{return(RETURN);}
"var"				{return(VAR);}
"int"				{return(T_INT);}
"float"				{return(T_FLOAT);}
"string"			{return(T_STRING);}
"array"				{return(T_ARRAY);}
"+="				{return(AUTOADD);}
"-="				{return(AUTOSUB);}
"++"				{return(AUTOINC);}
"--"				{return(AUTODEC);}
"&&"				{return(LOGAND);}
"||"				{return(LOGOR);}
^#[^\n]*\n			{processlm(yytext);}
-?[0-9]+\.[0-9]+		{yylval.str = strdup(yytext); return(FLOAT);}
-?[0-9]+			{yylval.str = strdup(yytext); return(INT);}
\"[^"]*\"			{yylval.str = strdup(yytext + 1); yylval.str[yyleng - 2] = 0; transesc(yylval.str); return(STRING);}
[[:alpha:]_][[:alnum:]_]* 	{yylval.str = strdup(yytext); return(ID);}
[][+*/(),;={}!-]		{return(*yytext);}
"=="				{return(EQ);}
"!="				{return(NE);}
">"				{return(GT);}
"<"				{return(LT);}
">="				{return(GE);}
"<="				{return(LE);}
\n				{yycurline++;}
[ \t]+				{}
.				{printf("%i in %s: unmatched character '%c'\n", yycurline, yycurfile, *yytext);}

%%

int yywrap(void)
{
    return(1);
}
