#include <glib-object.h>

#include <gmyth/gmyth_uri.h>
#include <gmyth/gmyth_backendinfo.h>
#include <gmyth/gmyth_scheduler.h>
#include <gmyth/gmyth_epg.h>
#include <gmyth/gmyth_common.h>

#include "common.h"

static          gboolean
test_recording_list(GMythBackendInfo * backend_info)
{
    GList          *list = NULL;
    gint            length = 0;
    GMythScheduler *scheduler = gmyth_scheduler_new();

    if (gmyth_scheduler_connect_with_timeout(scheduler,
                                             backend_info, 10) == TRUE) {
        g_debug("===== Scheduler connection success =====");
    } else {
        g_debug("===== Scheduler connection failed =====");
        return FALSE;
    }

    length = gmyth_scheduler_get_recorded_list(scheduler, &list);

    g_debug("===== %d Recordings found =====\n", length);
    length--;
    while (length >= 0) {
        RecordedInfo   *record =
            (RecordedInfo *) g_list_nth_data(list, length);
        if (record == 0) {
            g_debug("===== Recorded list returned NULL pointer =====\n");
            length--;
            continue;
        }
        g_debug("===== Record id = %d =====\n", record->record_id);
        g_debug("===== Record name = %s =====\n",
                (record ? record->basename->str : "NULL"));
        length--;
    }

    gmyth_scheduler_disconnect(scheduler);

    if (scheduler != NULL)
        g_object_unref(scheduler);

    if (list != NULL)
        g_list_free(list);

}

int
main(int args, const char **argv)
{
    GMythBackendInfo *backend_info;
    g_type_init();

    backend_info = gmyth_backend_info_new_with_uri(argv[1]);

    test_recording_list(backend_info);

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    if (backend_info != NULL)
        g_object_unref(backend_info);

    return (0);
}
