#!/usr/bin/env python
# -*- coding: utf-8 -*-
# PyTube is a small script for downloading videos from several video hosts and converting them into multiple selected formats
import webbrowser,time, sys, re
sys.path.append('./stream2hdd')
sys.path.append('./gdata')
sys.path.append('./atom')
from stream2hdd import Stream2HDD

try:
	import pygtk
	pygtk.require("2.0")
except:
	pass
try:
	import gtk
	import gtk.glade
	import shutil
except:
	sys.exit(1)
try:
	import os
	from threading import Thread
	import gobject
	import copy
	import urllib
	import urllib2
	if sys.version >= 2.5:
		from xml.etree import cElementTree
	else:
		import cElementTree as ElementTree
except:
	sys.exit(1)
try:
        import gdata
        import gdata.service
	import gdata.youtube
	import gdata.youtube.service
except:
	print "You need to install the package 'python-gdata 1.1.1'"
picture = os.path.expanduser("~") + "/.pytube_framepic.png"
try:
	os.remove(picture)
except OSError:
	pass

def Close(widget):
	checkfilesdlg.destroy()

class Search(Thread):
	def __init__(self, tree, thumbnail, wTree):
                Thread.__init__(self)
                self.thumbnail = thumbnail
                self.tree = tree
                self.wTree = wTree
        def run(self):
                amount = 0
                if not(os.path.isdir(os.path.expanduser("~")+"/.pytube")):
                        os.mkdir(os.path.expanduser("~")+"/.pytube")
                else:
                        pass
		self.wTree.get_widget("scrolledwindow1").show()
                self.wTree.get_widget("label66").show()
		self.wTree.get_widget("label66").set_markup("<b>Obtaining results, please wait...</b>")
                results =  gdata.service.GDataService(server="gdata.youtube.com").Get(
                        "http://gdata.youtube.com/feeds/videos?vq=%s" %
                                urllib.quote_plus(self.wTree.get_widget("entry1").get_text())).entry
                for movie in results:
                        amount+=1
                        title = movie.title.text
                        id = movie.id.text.split("/")[-1]
			video = gdata.youtube.service.YouTubeService().GetYouTubeVideoEntry(video_id=id)
                        movie_url = "http://www.youtube.com/v/%s" % id
                        dlthumb = urllib.urlretrieve("http://img.youtube.com/vi/" + id + "/default.jpg", os.path.expanduser("~")+"/.pytube/thumbnail.jpg")
			thumb = os.path.expanduser("~")+"/.pytube/thumbnail.jpg"
			self.thumbnail.set_from_file(thumb)
			pixbuf = self.thumbnail.get_pixbuf()
                        iter = self.tree.append(None)
                        self.tree.set_value( iter, 0, pixbuf)#.scale_simple(32,32,3))
                        self.tree.set_value( iter, 1, "<b>Title:</b> "+title+"\n<b>URL:</b> "+ movie_url+ "\n<b>Duration:</b> " + video.media.duration.seconds + " seconds\n<b>Description:</b> " + video.media.description.text + "\n<b>View Count:</b> " + video.statistics.view_count)
                self.wTree.get_widget("label66").set_markup("<b><i>Top " + str(amount) + " results</i></b>")
		if amount > 0:
			self.wTree.get_widget("button19").show()
			self.wTree.get_widget("button54").show()
			self.wTree.get_widget("label66").set_markup("<b><i>Top " + str(amount) + " results</i></b>")
 	                self.wTree.get_widget("scrolledwindow1").show()
		else:
                	self.wTree.get_widget("scrolledwindow1").hide()
			self.wTree.get_widget("button19").hide()
			self.wTree.get_widget("button54").hide()		
			self.wTree.get_widget("label66").set_markup("<b>No results, please check for typing errors</b>")
class Information(Thread):
        def __init__(self, results, wTree, fulllink, linkid, title, list_of_files):
                Thread.__init__(self)
                self.results = results
                self.fulllink = fulllink
                self.linkid = linkid
                self.title = title
                self.wTree = wTree
		self.list_of_files = list_of_files
        def run(self):
                picture = os.path.expanduser("~") + "/.pytube/thumbmain1.jpg"
		picture1 = os.path.expanduser("~") + "/.pytube/thumbmain2.jpg"
		picture2 = os.path.expanduser("~") + "/.pytube/thumbmain3.jpg"
                self.fulllink = str(self.list_of_files[self.wTree.get_widget("combobox3").get_active()])
                self.linkid = self.fulllink.split("v=")[1]
		print "Downloading Thumbnails from: " + self.fulllink + " - " + self.linkid
                urllib.urlretrieve("http://img.youtube.com/vi/" + self.linkid + "/default.jpg", picture)
		urllib.urlretrieve("http://img.youtube.com/vi/" + self.linkid + "/1.jpg", picture1)
		urllib.urlretrieve("http://img.youtube.com/vi/" + self.linkid + "/3.jpg", picture2)
                self.wTree.get_widget("thumb1").set_from_file(picture)
		self.wTree.get_widget("thumb2").set_from_file(picture1)
		self.wTree.get_widget("thumb3").set_from_file(picture2)
                results = gdata.service.GDataService(server="gdata.youtube.com").Get("http://gdata.youtube.com/feeds/videos/" + self.linkid)
                self.title = results.title.text
      		os.remove(picture)
		os.remove(picture1)
		os.remove(picture2)
class QuickDownload(Thread):
	def __init__(self, videosave, task, wTree, list_of_quickfiles, configops):
                Thread.__init__(self)
                self.videosave = videosave
                self.task = task
                self.wTree = wTree
                self.list_of_quickfiles = list_of_quickfiles
                self.ErrorsString=''
		self.configops = configops
        def DownloadWithProgress(self,cmd,progressbar):
                progressbar.show()
                progressbar.set_fraction(0)
                RE=re.compile("\d{1,3}\.\d{1}%")
                hdl=os.popen(cmd)
                l=hdl.readline()
                while l:
                	hit=RE.search(l)
			if hit:
                        	a=float((hit.group().split('.')[0]))
                                if progressbar.get_fraction()<(a/100):
                                	progressbar.set_text(hit.group())
                                        progressbar.set_fraction(a/100)
                        l=hdl.read(30)
                hdl.close()
                progressbar.hide()
        def run(self):
                picture = os.path.expanduser("~") + "/.pytube/thumb0.jpg"
		picture2 = os.path.expanduser("~") + "/.pytube/thumb1.jpg"
		picture3 = os.path.expanduser("~") + "/.pytube/thumb2.jpg"
		self.task.get_widget("image15").show()
		self.task.get_widget("image18").show()
                self.ListToConvert=list()
		for i in self.list_of_quickfiles:
			self.task.get_widget("closebtn").hide()
			self.task.get_widget("label10").set_markup("<b>Downloading...</b>")
			self.task.get_widget("download_progress").set_text("Initializing...")
			self.task.get_widget("download_progress").set_fraction(0)	
			self.task.get_widget("download_progress").show()
			try:
				self.task.get_widget("download_progress").show()
				self.task.get_widget("destinid").set_text(self.configops[2])
                                self.task.get_widget("label10").show()
                                
                                username = str(self.configops[4])
                                password = str(self.configops[5])
				if self.configops[3] == "1":
					#print "Using an account" + username + password
					Dloader=Stream2HDD(i, self.videosave, username, password)
				elif self.configops[3] == "0":
					#print "Not using an account"
					Dloader=Stream2HDD(i,self.videosave)           
                                
				#Dloader=Stream2HDD(i,self.videosave)
				self.task.get_widget("vidid").set_text(Dloader.dest_file)
				self.task.get_widget("image1").set_from_file(picture)
				self.task.get_widget("image15").set_from_file(picture2)
				self.task.get_widget("image18").set_from_file(picture3)
				Dloader.Download(self.task.get_widget("download_progress"))
				self.ListToConvert.append(Dloader.dest_file)
				self.task.get_widget("label10").set_markup("<b>Done</b>")
			except Exception,e:
				print e
				self.task.get_widget("download_progress").hide()
				self.task.get_widget("label10").show()
				self.task.get_widget("label10").set_markup("<b>Incompatible Link</b>")
				self.ErrorsString=self.ErrorsString+"URL: "+i+"   -   "+"ERROR:"+str(e)+"\n"
				pass				
			self.task.get_widget("download_progress").hide()
		self.task.get_widget("button38").hide()
                self.task.get_widget("closebtn").show()
                print self.ErrorsString
		del self.list_of_quickfiles[0]
		self.wTree.get_widget("entry9").set_text(str(""))
class DownloadandEncode(Thread):
	def __init__(self, videosave, format, task, wTree, list_of_files, configops, userprefsfolder, selectedmethod):
		Thread.__init__(self)
		self.videosave = videosave
		self.format = format
		self.task = task
		self.wTree = wTree
		self.list_of_files = list_of_files
		self.configops = configops
		self.ErrorsString=''
		self.userprefsfolder = userprefsfolder
		self.selectedmethod = selectedmethod
	def DownloadWithProgress(self,cmd,progressbar):
		progressbar.show()
		progressbar.set_fraction(0)
		RE=re.compile("\d{1,3}\.\d{1}%")
		hdl=os.popen(cmd)
		l=hdl.readline()
		while l:
			hit=RE.search(l)
			if hit:
				a=float((hit.group().split('.')[0]))
				if progressbar.get_fraction()<(a/100):
					progressbar.set_text(hit.group())
					progressbar.set_fraction(a/100)
			l=hdl.read(30)
		hdl.close()
		progressbar.hide()
	def run(self):	
		picture = os.path.expanduser("~") + "/.pytube/thumb0.jpg"
		picture2 = os.path.expanduser("~") + "/.pytube/thumb1.jpg"
                picture3 = os.path.expanduser("~") + "/.pytube/thumb2.jpg"
		width = str(self.wTree.get_widget("spinbutton3").get_value()).split(".")[0]
		height =  str(self.wTree.get_widget("spinbutton4").get_value()).split(".")[0]
		self.task.get_widget("image15").show()
                self.task.get_widget("image18").show()
		if self.selectedmethod == "device":
			self.task.get_widget("label96").set_text(self.wTree.get_widget("combobox8").get_active_text())
		else:
			self.task.get_widget("label96").set_text(self.wTree.get_widget("combobox1").get_active_text())
		secondstep=""
		thirdstep=""
		fourthstep=""
		amount = str(len(self.list_of_files))
		currentdl = 0
		self.ListToConvert=list()
		#iter=0
		for i in self.list_of_files:
			#self.finalvideo = i.split("v=")[1]
			#changed to get rid of youtube specific call (line above)
			#self.finalvideo=str(iter)
			#we will have to change it to something like
			#self.finalvideo=Dloader.getFinalFilename()
			currentdl+=1
			#iter=iter+1
			#self.output = str(self.videosave+self.finalvideo) + ".flv"
			#firststep = "youtube-dl " + i + " -o " + str(self.output)
			#urllib.urlretrieve("http://img.youtube.com/vi/" + self.finalvideo + "/default.jpg", picture)
		        #       self.task.get_widget("image1").set_from_file(picture)
			#removed lines above- youtube specific
			
			self.task.get_widget("destinid").set_text(self.videosave)
	                       
			self.task.get_widget("closebtn").hide()
			self.task.get_widget("label10").set_markup("<b>Downloading </b> " + str(currentdl) + " of " + amount)
			self.task.get_widget("download_progress").set_text("Initializing...")
			self.task.get_widget("download_progress").set_fraction(0)
			#no progress bar
			#the line below was replaced with ExecWithProgress function call
		        #os.system(firststep)
			#progress bar implementation, added by swierq
			#self.DownloadWithProgress(firststep,self.task.get_widget("download_progress"))	
			self.task.get_widget("download_progress").show()
							
			try:
				self.task.get_widget("download_progress").show()
                                self.task.get_widget("label10").show() 
                                username = str(self.configops[4])
                                password = str(self.configops[5])
				if self.configops[3] == "1":
					#print "Using an account" + username + password
					Dloader=Stream2HDD(i, self.videosave, username, password)
				elif self.configops[3] == "0":
					#print "Not using an account"
					Dloader=Stream2HDD(i,self.videosave)
				self.task.get_widget("vidid").set_text(Dloader.dest_file)
				self.task.get_widget("image1").set_from_file(picture)
				self.task.get_widget("image15").set_from_file(picture2)
				self.task.get_widget("label96").show()
                                self.task.get_widget("image18").set_from_file(picture3)
				Dloader.Download(self.task.get_widget("download_progress"))
				#if exception occures, file wil not make it to convert list.
				self.ListToConvert.append(Dloader.dest_file)
			except Exception,e:
				print e
                                self.task.get_widget("label10").show()
                                self.task.get_widget("label10").set_markup("<b>Incompatible Link</b>")
				self.task.get_widget("download_progress").hide()
				self.task.get_widget("label10").set_markup("<b>ERROR:</b>"+str(e))
				#below string with all errors
				self.ErrorsString=self.ErrorsString+"URL: "+i+"   -   "+"ERROR:"+str(e)+"\n"
				#self.task.get_widget("closebtn").show()
				#if url is wrong or we can not get we just pass to another one
				#would be nice to open window at this point with textarea or something simillar 
				#and notify users about problems
				pass
				
			self.task.get_widget("download_progress").hide()
		for i in self.ListToConvert:
		#	urllib.urlretrieve("http://img.youtube.com/vi/" + i.split("v=")[1] + "/default.jpg", picture)
		#	self.task.get_widget("image1").set_from_file(picture)
         	        
			self.task.get_widget("destinid").set_text(self.videosave)
			self.task.get_widget("vidid").set_text(i)
			self.task.get_widget("label10").set_markup("<b>Converting...</b>")
			if self.selectedmethod == "advanced":
				if (self.format == 0) or (self.format == 1): # Theora Video
					if self.wTree.get_widget("radiobutton3").get_active():
						secondstep = self.configops[6] + '/ffmpeg2theora -x ' + width + ' -y ' + height + ' -v 10 --optimize --sync "' + str(self.videosave) + i + '".flv -o "' + str(self.videosave) + i + '.ogm"' 
					else:
						secondstep = self.configops[6] + '/ffmpeg2theora -v 10 --optimize --sync "' + str(self.videosave) + i + '".flv -o "' + str(self.videosave) + i + '.ogm"'
				if self.format==1: #  MPG Video
					if self.wTree.get_widget("radiobutton3").get_active():
						secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -s ' + width + 'x' + height + ' "' + str(self.videosave) + i  + '.mpeg"'
					else:
						secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv "' + str(self.videosave) + i + '.mpeg"'
				if self.format==2: # AVI Video
					if self.wTree.get_widget("radiobutton3").get_active():
        	                                secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -s ' + width + 'x' + height + ' "' + str(self.videosave) + i  + '.avi"'
	                                else:		
						secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv "' + str(self.videosave) + i + '.avi"'
				if self.format==4: # Animated GIF Video
					if self.wTree.get_widget("radiobutton3").get_active():
	                                        secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -s ' + width + 'x' + height + ' -pix_fmt rgb24 "' + str(self.videosave) + i  + '.gif"'
	                                else:
							secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv -pix_fmt rgb24 "' + str(self.videosave) + i + '.gif"'
				if self.format==5: # MP4 VIDEO
					if self.wTree.get_widget("radiobutton3").get_active():
        	                                secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -s ' + width + 'x' + height + ' "' + str(self.videosave) + i  + '.mp4"'
	                                else:
						secondstep = self.configops[6] + '/ffmpeg -i "' + str(self.videosave)+ i + '".flv -y -f mp4 -vcodec mpeg4 -maxrate 1000k -b 700k -qmin 3 -qmax 5 -bufsize 4096 -g 300 -acodec aac -ab 192 -s 320x240 -aspect 4:3 "' + str(self.videosave)+ i + '.mp4"'
					if self.configops[1]==int("1"):
						thirdstep = (self.configops[6] + '/ffmpeg -y -i "' +  str(self.videosave) + i + '".mp4 -f image2 -ss 5 -vframes 1 -s 160x120 -an "' + str(self.videosave) + i + '.THM"')
					else:
						pass
				if self.format==6: # Cellphone Video
					if self.wTree.get_widget("radiobutton3").get_active():
                	                        secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -s ' + width + 'x' + height + ' -ac 1 -acodec aac -vcodec h263 -r 12 -b 60 "' + str(self.videosave) + i  + '.3gp"'
	                                else:
		                       		secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv -ac 1 -acodec aac -vcodec h263 -s 176x144 -r 12 -b 60 "' + str(self.videosave) + i + '.3gp"'
				if self.format==7: # AMV Video (amv)
					if self.wTree.get_widget("radiobutton3").get_active():
						secondstep = self.userprefsfolder + '/ffmpeg-amv-i386 -y -i "' + str(self.videosave)+ i + '".flv -s ' +  width + 'x' + height + ' -ac 1 -ar 22050 -qmin 3 -qmax 3 "' +str(self.videosave) + i + '.amv"'
					else:
		                                secondstep = self.userprefsfolder + '/ffmpeg-amv-i386 -y -i "' + str(self.videosave)+ i + '".flv -ac 1 -ar 22050 -qmin 3 -qmax 3 "' + str(self.videosave) + i + '.amv"'
				if self.format==8: # Audio Only (mp3)
					secondstep = self.configops[6] + '/mencoder "' + str(self.videosave)+ i + '".flv  -ovc frameno -oac mp3lame -of rawaudio -lameopts cbr:br=128 -o "' + str(self.videosave) + i + '.mp3"'
				if self.format==9: # Audio Only (ogg)
					secondstep = self.configops[6] + '/ffmpeg2theora "' + str(self.videosave)+ i + '.flv"'
				if self.format==10: # Audio Only (wav)
					secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv "' + str(self.videosave) + i + '.wav"'
				self.task.get_widget("download_progress").hide()
				os.system(secondstep)
				if thirdstep!="":
	                                os.system(thirdstep)
	                        if fourthstep!="":
	                                os.remove(fourthstep)
				if int(self.configops[0]) == 0 and not(int(self.format) == 3):
					for i in self.ListToConvert:
						os.remove(str(self.videosave) + i + ".flv")
			elif self.selectedmethod == "device":
				if self.wTree.get_widget("combobox8").get_active_text()==str("Apple iPod Nano 3G"):
						secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -s 320x240 "' + str(self.videosave) + i  + '.mp4"'
				elif self.wTree.get_widget("combobox8").get_active_text()==str("Apple iPod Classic"):
                                                secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -s 320x240 "' + str(self.videosave) + i  + '.mp4"'
				elif self.wTree.get_widget("combobox8").get_active_text()==str("Apple iPod Video"):
                                                secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -s 320x240 "' + str(self.videosave) + i  + '.mp4"'
				if self.wTree.get_widget("combobox8").get_active_text()==str("Apple iPod Touch"):
                                                secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -s 480x320 -aspect 16:9 "' + str(self.videosave) + i  + '.mp4"'
				if self.wTree.get_widget("combobox8").get_active_text()==str("Sony PSP"):
                                                secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -f psp -r 29.97 -b 768k -ar 24000 -ab 64k -s 320x240 "' + str(self.videosave) + i  + '.mp4"'
				if self.wTree.get_widget("combobox8").get_active_text()==str("Sony PSP (Widescreen)"):
                                                secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -f psp -r 29.97 -b 768k -ar 24000 -ab 64k -s 368x208 "' + str(self.videosave) + i  + '.mp4"'
				if self.wTree.get_widget("combobox8").get_active_text()==str("Flip Mino"):
						secondstep = self.configops[6] + '/ffmpeg -y -i "' + str(self.videosave) + i + '".flv ' + ' -s 640x480 "' + str(self.videosave) + i  + '.mp4"'
				os.system(secondstep)
				for i in self.ListToConvert:
                                                os.remove(str(self.videosave) + i + ".flv")
		self.task.get_widget("label10").set_markup("<b>Done</b>")
		self.task.get_widget("button38").hide()
		self.task.get_widget("closebtn").show()
		#printing errors, we have display this variable on self.task window
		print self.ErrorsString
		
class EncodeLocal(Thread):
	def __init__(self, localvideo, finalvideo, format, task, wTree, configops, userprefsfolder):
                Thread.__init__(self)
                self.localvideo = localvideo
		self.finalvideo = finalvideo
                self.format = format
		self.task = task
                self.wTree = wTree
		self.configops = configops
		self.userprefsfolder = userprefsfolder
        def run(self):	
		firststep = ""
		secondstep = ""
		thirdstep = ""
		self.task.get_widget("label96").set_text(self.wTree.get_widget("combobox1").get_active_text())
		if (self.format==0) or (self.format==-1): # Theora Video
			firststep = self.configops[6] + '/ffmpeg2theora -v 10 --optimize --sync "' + str(self.localvideo) + '" -o "' + str(self.finalvideo) + '.ogm"'			
		if self.format==1: #  MPG Video
          		firststep = self.configops[6] + '/ffmpeg -y -i "' + str(self.localvideo) + '" "' + str(self.finalvideo) + '.mpg"'
		if self.format==2: # AVI Video
                 	firststep = self.configops[6] + '/ffmpeg -y -i "' + str(self.localvideo) + '" "' + str(self.finalvideo) + '.avi"'
		if self.format==3: # Animated GIF
			firststep = self.configops[6] + '/ffmpeg -y -pix_fmt rgb24 -i "' + str(self.localvideo) + '" "' + str(self.finalvideo) + '.gif"'
		if self.format==4: # MP4 Video
                       	firststep = self.configops[6] + '/ffmpeg -y -i "' + str(self.localvideo)+ '" -f mp4 -vcodec mpeg4 -maxrate 1000k -b 700k -qmin 3 -qmax 5 -bufsize 4096 -g 300 -acodec aac -ab 192 -s 320x240 -aspect 4:3 "' + str(self.finalvideo)+ '.mp4"'
			if self.configops[1]==int("1"):
                               	secondstep = self.configops[6] + '/ffmpeg -y -i "' +  str(self.finalvideo) + '".mp4 -f image2 -ss 5 -vframes 1 -s 160x120 -an "' + str(self.finalvideo) + '.THM"'
			else:
                              	pass
		if self.format==5: # Cellphone Video
			firststep = self.configops[6] + '/ffmpeg -i "' + str(self.localvideo) + '" -y -ac 1 -acodec aac -vcodec h263 -s 176x144 -r 12 -b 60 "' + str(self.finalvideo) + '.3gp"'
		if self.format==6: # AMV Video (amv)
                        secondstep = self.userprefsfolder + '/ffmpeg-amv-i386 -y -i "' + str(self.localvideo) + '" -ac 1 -ar 22050 -qmin 3 -qmax 3 "' + str(self.finalvideo) + '.amv"'                                
		if self.format==7: # Flash Video (flv)
			firststep = self.configops[6] + '/ffmpeg -y -i "' + str(self.localvideo) + '" -ar 22050 -b 200000 "' + str(self.finalvideo) + '.flv"'
		if self.format==8: # Audio Only (mp3)
			firststep = self.configops[6] + '/mencoder "' + str(self.localvideo) + '"  -ovc frameno -oac mp3lame -of rawaudio -lameopts cbr:br=128 -o "' + str(self.finalvideo) + '.mp3"'
		if self.format==9: # Audio Only (ogg)
			firststep = self.configops[6] + '/ffmpeg2theora "' + str(self.localvideo) + '"'
		if self.format==10: # Audio Only (wav)
			firststep = self.configops[6] + '/ffmpeg -y -i "' + str(self.localvideo) + '"' + str(self.finalvideo) + '.wav"'
		self.task.get_widget("closebtn").hide()
		self.task.get_widget("label10").set_markup("<b>Converting...</b>")
		try:
			os.system(firststep)
		except:
			self.task.get_widget("label10").set_markup("<b>Error executing converter</b>")
		if secondstep != "":
			os.system(secondstep)
                        if thirdstep != "":
                        	os.remove(thirdstep)
		if self.wTree.get_widget("deleteoriglocal").get_active():
			os.remove(str(self.localvideo))
		else:
			pass
		self.task.get_widget("button38").hide()
		self.task.get_widget("closebtn").show()
		if self.task.get_widget("label10").get_text()=="Error executing converter, make sure it exists":
			pass
		else:
			self.task.get_widget("label10").set_markup("<b>Done</b>")
class Rescale(Thread):
	def __init__(self, vidlocation, saveto, filename, scaleheight, scalewidth, task, configops):
		Thread.__init__(self)
		self.vidlocation = vidlocation
		self.saveto = saveto
		self.filename = filename
		self.scaleheight = scaleheight
		self.scalewidth = scalewidth
		self.task = task
		self.configops = configops
	def run(self):
        	self.task.get_widget("label10").set_markup("<b>Rescaling...</b>")
		firststep = self.configops[6] + '/mencoder "' + str(self.vidlocation) + '" -oac pcm -ovc lavc -lavcopts vcodec=mpeg4 -vf scale="' + str(self.scalewidth) + ':' + str(self.scaleheight) + '" -o "' + str(self.saveto+self.filename) + '".avi'
		self.task.get_widget("closebtn").hide()
		os.system(firststep)
		self.task.get_widget("button38").hide()
		self.task.get_widget("closebtn").show()
		self.task.get_widget("label10").set_markup("<b>Done</b>")
class RingTone(Thread):
	def __init__(self, audiolocation, saveto, filename, lengthchoice, task, configops):
		Thread.__init__(self)
		self.audiolocation = audiolocation
		self.saveto = saveto
		self.filename = filename
		self.lengthchoice = lengthchoice
		self.task = task
		self.configops = configops
	def run(self):
                if self.lengthchoice==0:
                        length=str("10")
                elif self.lengthchoice==1:
                        length=str("20")
                elif self.lengthchoice==2:
                        length=str("30")
                firststep = self.configops[6] + '/sox "' + str(self.audiolocation) + '" "' + str(self.saveto+self.filename) + '.wav" fade t 4 ' + length + " " + length
                secondstep = self.configops[6] + '/ffmpeg  -y -i "' + str(self.saveto+self.filename)+ '".wav -ab 192 -ar 44100 "' + str(self.saveto+self.filename) + '.mp3"'
		self.task.get_widget("closebtn").hide()
		self.task.get_widget("label10").set_markup("<b>Generating Ringtone...</b>")
                os.system(firststep)
		self.task.get_widget("label10").set_markup("<b>Converting to MP3...</b>")
		os.system(secondstep)
		self.task.get_widget("button38").hide()
                self.task.get_widget("closebtn").show()
                self.task.get_widget("label10").set_markup("<b>Done</b>")
		os.remove(str(self.saveto+self.filename) + ".wav")
class Rotate(Thread):
	def __init__(self, vidlocation, saveto, filename, degreeselected, task, configops):
		Thread.__init__(self)
		self.vidlocation = vidlocation
		self.saveto = saveto
		self.filename = filename
		self.degreeselected = degreeselected
		self.task = task
		self.configops = configops
	def run(self): 
		if self.degreeselected==0:
                        firststep = self.configops[6] + '/mencoder -vf rotate=1 -oac pcm -ovc lavc "' + str(self.vidlocation) + '" -o "' + str(self.saveto+self.filename) + '"'
                if self.degreeselected==1:
                        firststep = self.configops[6] + '/mencoder -vf rotate=2 -oac pcm -ovc lavc "' + str(self.vidlocation) + '" -o "' + str(self.saveto+self.filename) + '"'
                if self.degreeselected==2:
                        firststep = self.configops[6] + '/mencoder -vf flip=1 -oac pcm -ovc lavc "' + str(self.vidlocation) + '" -o "' + str(self.saveto+self.filename) + '"'
                if self.degreeselected==3:
                        firststep = self.configops[6] + '/mencoder -vf flip=0 -oac pcm -ovc lavc "' + str(self.vidlocation) + '" -o "' + str(self.saveto+self.filename) + '"'
                self.task.get_widget("label10").set_markup("<b>Rotating...</b>")
                os.system(firststep)
                self.task.get_widget("label10").set_markup("<b>Done</b>")
		self.task.get_widget("button38").hide()
		self.task.get_widget("closebtn").show()
		try:
			os.remove(picture)
		except:
			pass
class MergeVideos(Thread):
	def __init__(self, list_of_files, task, saveto, configops):
		Thread.__init__(self)
		self.file_list = list_of_files
		self.task = task
		self.saveto = saveto
		self.configops = configops
	def run(self):
		firststep = "mencoder"
                for file in self.file_list:
			firststep = firststep+" "+ '"' + file + '"' # Adding files to cmd, separated by spaces
		filename = self.file_list[0].split("/")
		filename = filename[-1]
		filename = filename.split(".")[0]
                firststep = firststep + ' -oac copy -ovc copy -o "' + str(self.saveto+filename) + '.avi"'
		self.task.get_widget("label10").set_markup("<b>Merging Videos</b>")
		os.system(self.configops[6] + "/" + firststep)
		self.task.get_widget("button38").hide()
		self.task.get_widget("closebtn").show()
                self.task.get_widget("label10").set_markup("<b>Done</b>")

class FetchAMV(Thread):
	def __init__(self, preferences):
		Thread.__init__(self)
		self.preferences = preferences
	def run(self):
                try:    
			self.preferences.get_widget("button29").hide()
			urllib.urlretrieve('http://amv-codec-tools.googlecode.com/files/amv-ffmpeg-linux-i386-20071030',os.path.expanduser("~")+"/.pytube/ffmpeg-amv-i386")
                        os.chmod(os.path.expanduser("~")+"/.pytube/ffmpeg-amv-i386", 7777)
                except:
                        self.preferences.get_widget("label68").set_markup("There was an error obtaining the binary")
			self.preferences.get_widget("button29").show()
                if os.path.isfile(os.path.expanduser("~")+"/.pytube/ffmpeg-amv-i386"):
                        self.preferences.get_widget("label68").set_markup("i386 Binary Found")
                        self.preferences.get_widget("button29").hide()
			self.preferences.get_widget("label70").hide()
                else:
                        self.preferences.get_widget("label68").set_markup("Binary not found")	
class FetchMemberInfo(Thread):
	def __init__(self, wTree, tree, userprefsfolder, accountname, accountinformation, thumbnail):
		Thread.__init__(self)
		self.wTree = wTree
		self.userprefsfolder = userprefsfolder
		self.accountname = accountname
		self.thumbnail = thumbnail
		self.tree = tree
		self.accountinformation = accountinformation
	def run(self):
		try:
			self.wTree.get_widget("label134").set_text(str(self.accountinformation.first_name.text))
		except:
			self.wTree.get_widget("label134").set_text("Not Specified")
		try:
			self.wTree.get_widget("label133").set_text(str(self.accountinformation.last_name.text))
		except:
			self.wTree.get_widget("label133").set_text("Not Specified")
		try:
			self.wTree.get_widget("label132").set_text(str(self.accountinformation.relationship.text))		
		except:
			self.wTree.get_widget("label132").set_text("Not Specified")
		try:
	                self.wTree.get_widget("label131").set_text(str(self.accountinformation.description.text))
	        except:
	                self.wTree.get_widget("label131").set_text("Not Specified")
		try:
	                self.wTree.get_widget("label130").set_text(str(self.accountinformation.hometown.text))
	        except:
	                self.wTree.get_widget("label130").set_text("Not Specified")
		try:
	                self.wTree.get_widget("label129").set_text(str(self.accountinformation.hobbies.text))
	        except:
	                self.wTree.get_widget("label129").set_text("Not Specified")
		try:
	                self.wTree.get_widget("label128").set_text(str(self.accountinformation.music.text))
	        except:
	                self.wTree.get_widget("label128").set_text("Not Specified")
		try:
	                self.wTree.get_widget("label127").set_text(str(self.accountinformation.books.text))
       		except:
                       	self.wTree.get_widget("label127").set_text("Not Specified")
		try:
                	self.wTree.get_widget("label139").set_text(str(self.accountinformation.movies.text))
                except:
                        self.wTree.get_widget("label139").set_text("Not Specified")
		try:
                        self.wTree.get_widget("label144").set_text(str(self.accountinformation.age.text))
                except:
                        self.wTree.get_widget("label144").set_text("Not Specified")
		try:
                        self.wTree.get_widget("label145").set_text(str(self.accountinformation.school.text))
                except:
                        self.wTree.get_widget("label145").set_text("Not Specified")
		try:
                        self.wTree.get_widget("label146").set_text(str(self.accountinformation.occupation.text))
                except:
                        self.wTree.get_widget("label146").set_text("Not Specified")
		try:
                        self.wTree.get_widget("label147").set_text(str(self.accountinformation.statistics.last_web_access))
                except:
                       	self.wTree.get_widget("label147").set_text("Not Specified")
		try:
                        self.wTree.get_widget("label149").set_text(str(self.accountinformation.statistics.video_watch_count))
                except:
                	self.wTree.get_widget("label149").set_text("Not Specified")
		if self.wTree.get_widget("checkbutton2").get_active():
			contacts = gdata.youtube.service.YouTubeService().GetYouTubeContactFeed(username=self.wTree.get_widget("entryaccount").get_text())
			for entry in contacts.entry:
				try:
					contactimage = gdata.youtube.service.YouTubeService().GetYouTubeUserEntry(username=str(entry.title.text))
		                	try:
		                	       	urllib.urlretrieve(str(contactimage.thumbnail.url).replace("'","") , self.userprefsfolder + "/contactthumbnail.jpg")
			                        thumb = os.path.expanduser("~")+"/.pytube/contactthumbnail.jpg"
			                except:
			                        thumb = "no_thumb.png"
			                self.thumbnail.set_from_file(thumb)
			                pixbuf = self.thumbnail.get_pixbuf()
			                iter = self.tree.append(None)
			                self.tree.set_value( iter, 0, pixbuf)
			                self.tree.set_value( iter, 1, entry.title.text)
				except:
					self.wTree.get_widget("label175").show()
					self.wTree.get_widget("label175").set_markup("<b>Error retrieving information from user:</b> " + entry.title.text)
class GUI:
	def __init__(self):
		self.pytubeversion = "0.0.11.5"
		self.gladefile = "pytubegui.glade"		
		self.wTree = gtk.glade.XML(self.gladefile, "mainwindow")
		self.window = self.wTree.get_widget("mainwindow")
		dic = { "on_imagemenuitem3_activate" : gtk.main_quit,
			"on_toolbutton1_clicked" : gtk.main_quit,
			"on_mainwindow_destroy" : gtk.main_quit,
			"on_button9_clicked" : self.YouTubeTab,
			"on_button12_clicked" : self.LocalTab,
			"on_button14_clicked" : self.TaskTab,
			"on_button24_clicked" : self.YouTubeTab,
			"on_button26_clicked" : self.SearchTab,
			"on_button10_clicked" : self.SearchTab,
			"on_button15_clicked" : self.TaskTab,
			"on_button18_clicked" : self.Download,
			"on_button50_clicked" : self.TaskTab,
			"on_button17_clicked" : self.TaskTab,
			"on_button28_clicked" : self.TaskTab,
			"on_button11_clicked" : self.MultiTab,
			"on_imagemenuitem10_activate" : self.ShowAbout,
			"on_button2_clicked" : self.Download,
			"on_toolbutton3_clicked" : self.ShowAbout,
			"on_youtubelink_clicked" : self.YouTubeTab,
			"on_localfilebtn_clicked" : self.LocalTab,
			"on_button21_clicked" : self.Merge,
			"on_button23_clicked" : self.AudioInVideo,
			"on_button25_clicked" : self.RotateVideo,
			"on_button20_clicked" : self.ScaleVideo,
			"on_button22_clicked" : self.RingTone,
			"on_checkfilesmenu_activate" : self.CheckFiles,
			"on_button6_clicked" : self.AddLinkWindow,
			"on_button8_clicked" : self.RemoveLink,
			"on_button13_clicked" : self.Search,
			"on_button19_clicked" : self.AddSearch,
			"on_button16_clicked" : self.QuickDownload,
			"on_combobox3_changed" : self.RefreshViewPort,
			"on_menuitem1_activate" : gtk.main_quit,
			"on_menuitem2_activate" : self.Preferences,
			"on_button30_clicked" : self.ImportList,
			"on_button33_clicked" : self.ExportList,
			"on_button37_clicked" : self.ExpListCombo,
			"on_radiobutton3_toggled" : self.ShowVideoOps,
			"on_combobox1_changed" : self.ShowVideoOps,
			"on_button39_clicked" : self.LiveFetchCopy,
			"on_menuitem5_toggled" : self.ChangeView,
			"on_button46_clicked" : self.ListViewChosen,
			"on_radiobutton4_toggled" : self.SelectMethod,
			"on_radiobutton5_toggled" : self.SelectMethod,
			"on_button48_clicked" : self.ProfileTab,
			"on_button49_clicked" : self.FetchMemberInfo,
			"on_button51_clicked" : self.FetchVidInfo,
			"on_button54_clicked" : self.FetchVidSearchInfo}
		self.wTree.signal_autoconnect(dic)
		self.selectedmethod = "device"
		self.wTree.get_widget("combobox1").set_active(3)
		self.wTree.get_widget("combobox2").set_active(0)
		self.wTree.get_widget("notebook1").set_current_page(2)
		self.wTree.get_widget("combobox3").remove_text(0)
		self.list_of_files=list()
		self.list_of_quickfiles=list()
		self.list_of_titles=list()
		self.videolist=list()
		self.tree = gtk.TreeStore(gtk.gdk.Pixbuf,str, str)
		self.listtree = gtk.TreeStore(str, str)
                self.thumbnail = gtk.Image()
                self.movies = self.wTree.get_widget("treeview1")
		self.movies.set_model(self.tree)
                rendertext = gtk.CellRendererText()
                renderpix = gtk.CellRendererPixbuf()
                column0 = gtk.TreeViewColumn("Image", renderpix, pixbuf=0)
                column1 = gtk.TreeViewColumn("Information", rendertext, markup=1)
                self.movies.append_column(column0)
                self.movies.append_column(column1)
		self.contacts = self.wTree.get_widget("treeview3")
		self.contacts.set_model(self.tree)
		column2 = gtk.TreeViewColumn("Image", renderpix, pixbuf = 0)
		column3 = gtk.TreeViewColumn("Contact's Name", rendertext, markup=1)
		self.contacts.append_column(column2)
		self.contacts.append_column(column3)
		self.wTree.get_widget("vbox24").hide()
                self.wTree.get_widget("vbox37").hide()
                self.wTree.get_widget("frame10").hide()
                self.wTree.get_widget("frame9").hide()
                self.wTree.get_widget("notebook1").set_current_page(2)
		self.wTree.get_widget("combobox7").set_active(0)
		self.wTree.get_widget("combobox8").set_active(0)
		gobject.timeout_add(2000, self.RefreshLiveFetch)
	### Preferences
		self.userprefsfolder = os.path.expanduser("~") + "/.pytube"
		self.userprefsfile = self.userprefsfolder + "/config"
		if not(os.path.isdir(self.userprefsfolder)):
			os.mkdir(self.userprefsfolder)
			print "User Preferences folder created"
		else:
			pass
		if not(os.path.isfile(self.userprefsfile)):
			print "Configuration file not found, creating one now."
			self.LoadDefaults()
		else:
			print "Configuration file found"
			self.LoadPrefFile()
	### Check for a newer release, if there is, inform the user	
		try:
			latestversion = str(urllib.urlopen("http://marcosrodriguez.me/pytube/latestrelease").read()).replace("\n","")
			print "Latest version: " + latestversion
			print "Current version: " + self.pytubeversion
			if latestversion > self.pytubeversion:
				self.wTree.get_widget("versionlabel").show()
			else:
				self.wTree.get_widget("versionlabel").hide()
		except:
			pass
	def ChangeView(self, widget):
		if self.wTree.get_widget("menuitem5").get_active():
			self.wTree.get_widget("alignment6").hide()
			self.wTree.get_widget("hbox60").show()
		else:
			self.wTree.get_widget("alignment6").show()
                        self.wTree.get_widget("hbox60").hide()
	def RefreshLiveFetch(self):
		flash = 0
		flashfound = []
		if os.path.isdir("/tmp"):
			for i in os.listdir("/tmp/"):
				flashfound.append(i)
		else:
			print "You are not running Linux, therefore this feature will not work, turning scanner off."
			return False
		if True:
			for x in flashfound:
		                if x.startswith("Flash"):
					self.wTree.get_widget("livefetch").show()
					flash = "1"
				if not(flash == "1"):
					self.wTree.get_widget("livefetch").hide()
			return True
	def CloseFetchVidInfo(self, widget):
		self.fetchvidinfodialog.destroy()
	def FetchVidSearchInfo(self, widget):
		(model,iter) = self.movies.get_selection().get_selected()
                url = model.get_value(iter,1)
                url = url.split("/")
                url = "http://www.youtube.com/watch?v=" + url[6].replace("\n<b>Duration:<","")	
		print url
		id = url.split("v=")[-1]
	        video = gdata.youtube.service.YouTubeService().GetYouTubeVideoEntry(video_id=str(id))
		print id
                picture = os.path.expanduser("~") + "/.pytube/thumbmain1.jpg"
                picture1 = os.path.expanduser("~") + "/.pytube/thumbmain2.jpg"
                picture2 = os.path.expanduser("~") + "/.pytube/thumbmain3.jpg"
                urllib.urlretrieve("http://img.youtube.com/vi/" + id + "/default.jpg", picture)
                urllib.urlretrieve("http://img.youtube.com/vi/" + id + "/1.jpg", picture1)
                urllib.urlretrieve("http://img.youtube.com/vi/" + id + "/3.jpg", picture2)
                self.fetchvidinfo = gtk.glade.XML(self.gladefile, "vidinformation")
                self.fetchvidinfodialog = self.fetchvidinfo.get_widget("vidinformation")
                self.fetchvidinfo.signal_autoconnect({"on_button53_clicked":  self.CloseFetchVidInfo})
		self.fetchvidinfo.get_widget("button52").hide()		
                self.fetchvidinfo.get_widget("image26").set_from_file(picture)
                self.fetchvidinfo.get_widget("image27").set_from_file(picture1)
                self.fetchvidinfo.get_widget("image28").set_from_file(picture2)
                self.fetchvidinfo.get_widget("label156").set_text(video.media.title.text)
                self.fetchvidinfo.get_widget("label164").set_text(video.published.text)
                self.fetchvidinfo.get_widget("label170").set_text(video.media.description.text)
                self.fetchvidinfo.get_widget("label166").set_text(video.media.category[0].text)
                self.fetchvidinfo.get_widget("label167").set_text(video.media.keywords.text)
                self.fetchvidinfo.get_widget("label168").set_text(video.media.player.url)
                try:self.fetchvidinfo.get_widget("label169").set_text(video.GetSwfUrl())
                except: self.fetchvidinfo.get_widget("label169").set_text("Not Specified")
                self.fetchvidinfo.get_widget("label165").set_text(video.media.duration.seconds + " seconds")
                try: self.fetchvidinfo.get_widget("label171").set_text(video.geo.location())
                except: self.fetchvidinfo.get_widget("label171").set_text("Not Specified")
                self.fetchvidinfo.get_widget("label172").set_text(video.statistics.view_count)
		self.fetchvidinfo.get_widget("label173").set_text(video.rating.average)
                try:
                	for alternate_format in video.media.content:
                        	if 'isDefault' not in alternate_format.extension_attributes:
                                	self.fetchvidinfo.get_widget("label174").set_markup("<b>" + alternate_format.type + "</b> <i>"  + alternate_format.url + "</i>")
                except:
                	self.fetchvidinfo.get_widget("label174").set_text("Not Specified")
	def FetchVidInfo(self, widget):
		if len(self.list_of_files)>=1:
			if "youtube.com/watch?v=" in str(self.list_of_files[self.wTree.get_widget("combobox3").get_active()]):
				video = gdata.youtube.service.YouTubeService().GetYouTubeVideoEntry(video_id=str(self.list_of_files[self.wTree.get_widget("combobox3").get_active()]).split("v=")[-1])
				id = str(self.list_of_files[self.wTree.get_widget("combobox3").get_active()]).split("v=")[-1] 
				picture = os.path.expanduser("~") + "/.pytube/thumbmain1.jpg"
	                	picture1 = os.path.expanduser("~") + "/.pytube/thumbmain2.jpg"
	                	picture2 = os.path.expanduser("~") + "/.pytube/thumbmain3.jpg"
	                	urllib.urlretrieve("http://img.youtube.com/vi/" + id + "/default.jpg", picture)
	                	urllib.urlretrieve("http://img.youtube.com/vi/" + id + "/1.jpg", picture1)
	                	urllib.urlretrieve("http://img.youtube.com/vi/" + id + "/3.jpg", picture2)
				self.fetchvidinfo = gtk.glade.XML(self.gladefile, "vidinformation")
				self.fetchvidinfodialog = self.fetchvidinfo.get_widget("vidinformation")
				self.fetchvidinfo.signal_autoconnect({"on_button53_clicked":  self.CloseFetchVidInfo,
								      "on_button52_clicked" : self.RemoveLink2})
				self.fetchvidinfo.get_widget("image26").set_from_file(picture)
				self.fetchvidinfo.get_widget("image27").set_from_file(picture1)
				self.fetchvidinfo.get_widget("image28").set_from_file(picture2)
				self.fetchvidinfo.get_widget("label156").set_text(video.media.title.text)
				self.fetchvidinfo.get_widget("label164").set_text(video.published.text)
				self.fetchvidinfo.get_widget("label170").set_text(video.media.description.text)	
				self.fetchvidinfo.get_widget("label166").set_text(video.media.category[0].text)	
				self.fetchvidinfo.get_widget("label167").set_text(video.media.keywords.text)
				self.fetchvidinfo.get_widget("label168").set_text(video.media.player.url)
				try:self.fetchvidinfo.get_widget("label169").set_text(video.GetSwfUrl())
				except: self.fetchvidinfo.get_widget("label169").set_text("Not Specified")
				self.fetchvidinfo.get_widget("label165").set_text(video.media.duration.seconds + " seconds")
				try: self.fetchvidinfo.get_widget("label171").set_text(video.geo.location())	
				except: self.fetchvidinfo.get_widget("label171").set_text("Not Specified")
				self.fetchvidinfo.get_widget("label172").set_text(video.statistics.view_count)
				self.fetchvidinfo.get_widget("label173").set_text(video.rating.average)
				try:
					for alternate_format in video.media.content:
	    					if 'isDefault' not in alternate_format.extension_attributes:
	      						self.fetchvidinfo.get_widget("label174").set_markup("<b>" + alternate_format.type + "</b> <i>"  + alternate_format.url + "</i>")
				except:
					self.fetchvidinfo.get_widget("label174").set_text("Not Specified")
			else:
				self.error = gtk.glade.XML(self.gladefile, "errorwindow")
	                        self.errordlg = self.error.get_widget("errorwindow")
	                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
	                        self.error.get_widget("errorlabel").set_text("Information can only be retrieved from a YouTube video.")
		else:
			 self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                         self.errordlg = self.error.get_widget("errorwindow")
                         self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                         self.error.get_widget("errorlabel").set_text("No video was selected.")
	def LoadPrefFile(self):
		self.configfile = open(self.userprefsfile, 'r')
		self.configops = {}
		x=-1
		for i in self.configfile.readlines():
			if x==-1:
				if(i.strip()=="#valid configuration file for pytube 0.0.10.6"):
					#print "jest ok"
					x+=1
					pass
				else:
					break
			else:	
				#print "wpiasuje w configa" + str(x) + "--" + i
				self.configops[x] = i.replace("\n","")
				x+=1
		if x==-1:
			self.configfile.close()
			self.LoadDefaults()		
		else:
			self.configfile.close()
		print "Configuration: " + str(self.configops)
	def LoadDefaults(self):
		self.configfile = open(self.userprefsfile, 'w')
		self.configops = {}
		self.configops[0] = "0"
		self.configops[1] = "0"
		self.configops[2] = str(os.path.expanduser("~"))
		self.configops[3] = "0"
		self.configops[4] = ""
		self.configops[5] = ""
		self.configops[6] = str("/usr/bin")
		self.configfile.write(str("#valid configuration file for pytube 0.0.10.6\n"))
		self.configfile.write(str(self.configops[0]) + "\n")
		self.configfile.write(str(self.configops[1]) + "\n")
		self.configfile.write(str(self.configops[2]) + "\n")
		self.configfile.write(str(self.configops[3]) + "\n")
		self.configfile.write(str(self.configops[4]) + "\n")
		self.configfile.write(str(self.configops[5]) + "\n")
		self.configfile.write(str(self.configops[6]) + "\n")
		self.configfile.write("\n")
		self.configfile.write("\n")
		self.configfile.close()
		os.chmod(self.userprefsfile,0600)
		self.LoadPrefFile()
		print "Loaded PyTube with defaults values"
		
	def SavePrefFile(self):
		if self.configurationtype == "preferences":
			self.configops[0] = int(self.preferences.get_widget("checkdelete1").get_active())
       	        	self.configops[1] = int(self.preferences.get_widget("createthmb1").get_active())
                	self.configops[2] = str(self.preferences.get_widget("filechooserbutton1").get_filename())
			self.configops[3] = int(self.preferences.get_widget("checkbutton1").get_active())
			self.configops[4] = str(self.preferences.get_widget("entry5").get_text())
			self.configops[5] = str(self.preferences.get_widget("entry7").get_text())
			self.configops[6] = str(self.preferences.get_widget("filechooserbutton7").get_filename())
			self.configfile = open(self.userprefsfile, 'w')
			self.configfile.write(str("#valid configuration file for pytube 0.0.10.6\n"))
			self.configfile.write(str(self.configops[0]) + "\n")
			self.configfile.write(str(self.configops[1]) + "\n")
			self.configfile.write(str(self.configops[2]) + "\n")
			self.configfile.write(str(self.configops[3]) + "\n")
			self.configfile.write(str(self.configops[4]) + "\n")
			self.configfile.write(str(self.configops[5]) + "\n")
			self.configfile.write(str(self.configops[6]) + "\n")
			self.configfile.close()
			os.chmod(self.userprefsfile,0600)
		elif self.configurationtype == "dependencies":
			self.configops[6] = str(self.checkfiles.get_widget("filechooserbutton14").get_filename())
                        self.configfile = open(self.userprefsfile, 'w')
                        self.configfile.write(str("#valid configuration file for pytube 0.0.10.6\n"))
                        self.configfile.write(str(self.configops[0]) + "\n")
                        self.configfile.write(str(self.configops[1]) + "\n")
                        self.configfile.write(str(self.configops[2]) + "\n")
                        self.configfile.write(str(self.configops[3]) + "\n")
                        self.configfile.write(str(self.configops[4]) + "\n")
                        self.configfile.write(str(self.configops[5]) + "\n")
                        self.configfile.write(str(self.configops[6]) + "\n")
                        self.configfile.close()
                        os.chmod(self.userprefsfile,0600)

	def ClosePreferences(self, widget):
		self.configurationtype = "preferences"
		if self.preferences.get_widget("checkbutton1").get_active()==True:
			if self.preferences.get_widget("entry5").get_text()=="" or self.preferences.get_widget("entry7").get_text()=="":
				self.error = gtk.glade.XML(self.gladefile, "errorwindow")
	                        self.errordlg = self.error.get_widget("errorwindow")
	                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})		
 				self.error.get_widget("errorlabel").set_text("No account was specified.")
			else:
				self.SavePrefFile()
				self.LoadPrefFile()
				
				self.preferencesdlg.destroy()
		else:
			self.SavePrefFile()
			self.LoadPrefFile()
                        self.preferencesdlg.destroy()
	def ClosePlayVideo(self, widget):
		self.playvideodialog.destroy()	
	def SelectMethod(self, widget):
		if self.wTree.get_widget("radiobutton4").get_active():
			self.wTree.get_widget("combobox8").show()
			self.wTree.get_widget("combobox1").hide()
			self.selectedmethod = "device"
		else:
			self.wTree.get_widget("combobox8").hide()
			self.wTree.get_widget("combobox1").show()
			self.selectedmethod = "advanced"
	def CloseExpListCombo(self, widget):
		self.expcombodlg.destroy()
	def ListViewChosen(self, widget):
		if self.wTree.get_widget("combobox7").get_active() == 0:
  			self.YouTubeTab(self)				
	        elif self.wTree.get_widget("combobox7").get_active() == 1:
                	self.LocalTab(self)
		elif self.wTree.get_widget("combobox7").get_active() == 2:
                	self.MultiTab(self)
		elif self.wTree.get_widget("combobox7").get_active() == 3:
			self.ProfileTab(self)
		elif self.wTree.get_widget("combobox7").get_active() == 4:
			self.SearchTab(self)
	def LiveFetchThumbnails(self, widget):
		if len(self.livefetchlist)>1:
			self.livefetch.get_widget("button42").show()
		else:
			self.livefetch.get_widget("button42").hide()
		try:
			os.system("ffmpeg -an -y -t 0:0:10 -i " + str("/tmp/" + self.livefetch.get_widget("combobox6").get_active_text()) + " -s 130x98 -f image2 " + os.path.expanduser("~") + "/.pytube/livefetch" + self.livefetch.get_widget("combobox6").get_active_text() + ".jpg")
			self.livefetch.get_widget("image23").set_from_file(str(os.path.expanduser("~") + "/.pytube/livefetch" + self.livefetch.get_widget("combobox6").get_active_text() + ".jpg"))
		except:
			pass
		self.livefetch.get_widget("label107").set_text(self.livefetch.get_widget("combobox6").get_active_text())
		self.livefetch.get_widget("label105").set_text(str(os.stat(str("/tmp/" + self.livefetch.get_widget("combobox6").get_active_text())).st_size))
	def CloseLiveFetch(self, widget):
		self.livefetchdlg.destroy()
	def FetchMemberInfo(self, widget):
		self.wTree.get_widget("label175").set_text("")
		self.wTree.get_widget("treeview3").get_model().clear()
		self.accountname = str(self.wTree.get_widget("entryaccount").get_text())
                self.accountinformation = gdata.youtube.service.YouTubeService().GetYouTubeUserEntry(username=self.accountname)
                urllib.urlretrieve(str(self.accountinformation.thumbnail.url), str(self.userprefsfolder + "/acctnthumb.jpg"))
                accountpic = self.userprefsfolder + "/acctnthumb.jpg"
		self.wTree.get_widget("image25").set_from_file(accountpic)
		startfetchmeminfo = FetchMemberInfo(self.wTree, self.tree, self.userprefsfolder, self.accountname, self.accountinformation, self.thumbnail)
		startfetchmeminfo.start()			
	def PlayLiveFetch(self, widget):
		if os.path.exists("/tmp/" + self.livefetch.get_widget("combobox6").get_active_text()):
			os.system('ffplay "/tmp/' + self.livefetch.get_widget("combobox6").get_active_text() + '"')
		else:
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                        self.error.get_widget("errorlabel").set_text("The specified file seems to have been deleted.")		
	def LiveFetchCopy(self, widget):
		self.livefetch = gtk.glade.XML(self.gladefile, "livefetchwindow")
		self.livefetchdlg = self.livefetch.get_widget("livefetchwindow")
		self.livefetch.signal_autoconnect({"on_button43_clicked" : self.SaveLiveFetch,
						   "on_button42_clicked" : self.SaveAllLiveFetch,
						   "on_button45_clicked" : self.PlayLiveFetch,
						   "on_button44_clicked" : self.CloseLiveFetch,
						   "on_combobox6_changed" : self.LiveFetchThumbnails})
		self.livefetch.get_widget("combobox6").remove_text(0)
		self.livefetchlist = {}
		self.livefetchcount = 0
		for i in os.listdir("/tmp/"):
                	if "Flash" in i:
                        	self.livefetch.get_widget("combobox6").append_text(i)
				self.livefetchlist[self.livefetchcount] = i
		print self.livefetchlist
		self.livefetch.get_widget("combobox6").set_active(0)	
	def SaveAllLiveFetch(self, widget):
		print self.livefetchlist
		for i in self.livefetchlist:
			shutil.copyfile("/tmp/" + str(self.livefetchlist[i]), self.configops[2] + "/" + str(self.livefetchlist[i]))
		self.livefetchdlg.destroy()
	def SaveLiveFetch(self, widget):
		shutil.copyfile("/tmp/" + self.livefetch.get_widget("combobox6").get_active_text(), self.configops[2] + "/" + \
self.livefetch.get_widget("combobox6").get_active_text())
		self.livefetchdlg.destroy()
	def ToggleAccountVisibility(self, widget):
		if self.preferences.get_widget("checkbutton1").get_active():
			self.preferences.get_widget("hbox51").show()
			self.preferences.get_widget("hbox52").show()
		else:
			self.preferences.get_widget("hbox51").hide()
                        self.preferences.get_widget("hbox52").hide()
			self.preferences.get_widget("entry5").set_text("")
			self.preferences.get_widget("entry7").set_text("")
	def Preferences(self, widget):
		print self.configops
		self.LoadPrefFile()
		print self.configops
		self.preferences = gtk.glade.XML(self.gladefile, "preferences")
		self.preferencesdlg = self.preferences.get_widget("preferences")
		self.preferences.signal_autoconnect({"on_button27_clicked" : self.ClosePreferences,
						     "on_button29_clicked" : self.DownloadAMV,
							"on_checkbutton1_toggled" : self.ToggleAccountVisibility})
		try: self.preferences.get_widget("checkdelete1").set_active(int(self.configops[0]))
		except: pass
		try: self.preferences.get_widget("createthmb1").set_active(int(self.configops[1]))
		except: pass
		try: self.preferences.get_widget("filechooserbutton1").set_current_folder(str(self.configops[2]))
		except: pass
		try: self.preferences.get_widget("checkbutton1").set_active(int(self.configops[3]))
		except: pass
		try: self.preferences.get_widget("entry5").set_text(str(self.configops[4]))
                except: pass
		try: self.preferences.get_widget("entry7").set_text(str(self.configops[5]))
                except: pass
		print self.configops[6]
		try: self.preferences.get_widget("filechooserbutton7").set_current_folder(str(self.configops[6]))
		except: pass
		if os.path.isfile(os.path.expanduser("~")+"/.pytube/ffmpeg-amv-i386"):
                        self.preferences.get_widget("label68").set_markup("i386 Binary Found")
                        self.preferences.get_widget("button29").hide()
                else:
                        self.preferences.get_widget("label68").set_markup("Binary not found")
			self.preferences.get_widget("label68").show()
			self.preferences.get_widget("button29").show()
	def ShowVideoOps(self, widget):		
		if (self.wTree.get_widget("combobox1").get_active()==3) or (self.wTree.get_widget("combobox1").get_active()==10) \
or (self.wTree.get_widget("combobox1").get_active()==11) or (self.wTree.get_widget("combobox1").get_active()==12) or \
(self.wTree.get_widget("combobox1").get_active()==6) or (self.wTree.get_widget("combobox1").get_active()==8) or \
(self.wTree.get_widget("combobox1").get_active()==9) or (self.wTree.get_widget("combobox1").get_active()==10) :
			self.wTree.get_widget("frame21").hide()
			self.wTree.get_widget("radiobutton2").set_active(True)
			self.wTree.get_widget("radiobutton3").set_active(False)
		else:
			self.wTree.get_widget("frame21").show()
		if self.wTree.get_widget("radiobutton3").get_active()==True:
			self.wTree.get_widget("label92").show()
			self.wTree.get_widget("label93").show()
			self.wTree.get_widget("spinbutton3").show()
			self.wTree.get_widget("spinbutton4").show()
		else:
			self.wTree.get_widget("label92").hide()
                        self.wTree.get_widget("label93").hide()
                        self.wTree.get_widget("spinbutton3").hide()
                        self.wTree.get_widget("spinbutton4").hide()	
	def DownloadAMV(self, widget):
		self.preferences.get_widget("label68").set_markup("<b>Downloading...</b>")
		startamvfetch = FetchAMV(self.preferences)
                startamvfetch.start()	
	def ImportList(self, widget):
		self.importlist = gtk.glade.XML(self.gladefile, "importlinks")
		self.importlistdlg = self.importlist.get_widget("importlinks")
		self.importlist.signal_autoconnect({"on_button36_clicked" : self.CloseImportLst,
						    "on_button35_clicked" : self.ImpList})
	def ImpList(self, widget):
		if self.importlist.get_widget("filechooserbutton3").get_filename()==None:
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                        self.error.get_widget("errorlabel").set_text("No file was provided to import.")
		elif not(self.importlist.get_widget("filechooserbutton3").get_filename().endswith(".pytube")):
                        self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                        self.error.get_widget("errorlabel").set_markup("The file you have provided is <b>not</b> compatible.")
                        self.importlist.get_widget("filechooserbutton3").set_filename("")
		else:
			list = open(self.importlist.get_widget("filechooserbutton3").get_filename(), 'r')
			for i in list.readlines():
				self.list_of_files.append(i.replace("\n",""))
                        	self.wTree.get_widget("combobox3").append_text(i.replace("\n",""))
                        	self.importlistdlg.destroy()
                        	self.wTree.get_widget("combobox3").set_active(0)
	def CloseImportLst(self, widget):
		self.importlistdlg.destroy()
	def RefreshViewPort(self, widget):
        	if self.wTree.get_widget("combobox3").get_active_text()==None:
                        self.wTree.get_widget("hbox150").hide()
			self.wTree.get_widget("button37").hide()
		try:
			if len(self.list_of_files)<1:
                        	self.wTree.get_widget("frame21").hide()
                        	self.wTree.get_widget("hbox150").hide()
				self.wTree.get_widget("button37").hide()
				self.wTree.get_widget("hbox53").hide()
				self.wTree.get_widget("frame13").hide()
                	else:
                	        self.wTree.get_widget("hbox150").show()
				self.wTree.get_widget("button37").show()
				self.wTree.get_widget("frame13").show()
		except:
			pass
		try:
			if "youtube.com/watch?v=" in str(self.list_of_files[self.wTree.get_widget("combobox3").get_active()]):
                	        self.wTree.get_widget("hbox150").show()
                	        self.fulllink = str(self.list_of_files[self.wTree.get_widget("combobox3").get_active()])
                	        self.linkid = self.fulllink.split("v=")[1]
                	        results = gdata.service.GDataService(server="gdata.youtube.com").Get("http://gdata.youtube.com/feeds/videos/" + self.linkid)
                	        title = results.title.text
               		       	startinformation = Information(self.fulllink, self.wTree, self.linkid, results, title, self.list_of_files)
               		        startinformation.start()
			else:
				self.wTree.get_widget("hbox150").hide()
		except:
			pass
	def AddSearch(self, widget):
                (model,iter) = self.movies.get_selection().get_selected()
                url = model.get_value(iter,1)
                url = url.split("/")
		print url
                url = "http://www.youtube.com/watch?v=" + url[6].replace("\n<b>Duration:<","")
                self.list_of_files.append(url)
		self.list_of_titles.append(model.get_value(iter,1).split("/")[0])
                self.wTree.get_widget("combobox3").append_text(str(model.get_value(iter,1)).split("/")[1].replace("b> ","").replace("\n<b>URL:<",""))
                self.wTree.get_widget("combobox3").set_active(0)
		self.wTree.get_widget("button24").show()
	def Search(self, widget):
		if self.wTree.get_widget("entry1").get_text()=="":
                        self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                        self.error.get_widget("errorlabel").set_text("Please input a search term.")
                else:
                        self.wTree.get_widget("label66").show()
                        self.wTree.get_widget("treeview1").get_model().clear()
                        startsearch = Search(self.tree, self.thumbnail, self.wTree)
                        startsearch.start()
	def CloseMerge(self, widget):
		self.mergedlg.destroy()
	def CloseError(self, widget):
		self.errordlg.destroy()
	def CloseTask(self, widget):
                self.taskdlg.destroy()
		self.window.show()
	def CloseScaleVideo(self, widget):
		self.scaledlg.destroy()
	def CloseAudioVid(self, widget):
		self.audioviddlg.destroy()
	def CloseCheckFiles(self, widget):
		self.checkfilesdlg.destroy()
	def CloseRotate(self, widget):
		self.rotatedlg.destroy()
	def CloseRingTone(self, widget):
		self.ringtonedlg.destroy()
	def CloseAddLinkWindow(self, widget):
		self.addlinkdlg.destroy()
	def AddLinkWindow(self, widget):
		self.addlink = gtk.glade.XML(self.gladefile, "addlink")
		self.addlinkdlg = self.addlink.get_widget("addlink")
		self.addlink.signal_autoconnect({"on_closelinkbtn_clicked" : self.CloseAddLinkWindow,
						 "on_addlinkbtn_clicked" : self.TransferAddLink})
	def TransferAddLink(self, destroy):
		if True:
			linkid = str(self.addlink.get_widget("entry6").get_text())
			self.list_of_files.append(linkid)
			if "youtube.com/" in str(linkid):
				try:
					results = gdata.service.GDataService(server="gdata.youtube.com").Get("http://gdata.youtube.com/feeds/videos/" + linkid.split("watch?v=")[-1])
        		        	self.title = str(results.title.text)
					self.list_of_titles.append(self.title)
        		        	self.wTree.get_widget("combobox3").append_text(self.title)
					self.addlinkdlg.destroy()
					self.wTree.get_widget("combobox3").set_active(len(self.list_of_titles)-1)
					print "Added: " + self.title + " - " + linkid
				except:
					self.title = str("Unknown")
                                        self.list_of_titles.append(self.title)
                                        self.wTree.get_widget("combobox3").append_text(self.title)
                                        self.addlinkdlg.destroy()
                                        self.wTree.get_widget("combobox3").set_active(len(self.list_of_titles)-1)
                                        print "Added: " + self.title + " - " + linkid
			else:
				try:
					self.title = str(linkid)
                                	self.list_of_titles.append(urllib.urlopen(self.title).read().split("<title>")[1].split("</title>")[0])
                                	self.wTree.get_widget("combobox3").append_text(urllib.urlopen(self.title).read().split("<title>")[1].split("</title>")[0])
				except:
					self.title = str("Unknown")
                                        self.list_of_titles.append(self.title)
                                        self.wTree.get_widget("combobox3").append_text("Unknown")
                        	self.addlinkdlg.destroy()
                        	self.wTree.get_widget("combobox3").set_active(len(self.list_of_titles)-1)
                        	print "Added: " + self.title + " - " + linkid
		else:
			 self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                         self.errordlg = self.error.get_widget("errorwindow")
                         self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                         self.error.get_widget("errorlabel").set_text("The link you have provided is invalid")
	def RemoveLink(self, destroy):
		current = int(self.wTree.get_widget("combobox3").get_active())
		del self.list_of_files[self.wTree.get_widget("combobox3").get_active()]
		del self.list_of_titles[self.wTree.get_widget("combobox3").get_active()]
                self.wTree.get_widget("combobox3").remove_text(self.wTree.get_widget("combobox3").get_active())
		if len(self.list_of_files)>=1:
			self.wTree.get_widget("combobox3").set_active((int(current)-1))
		else:
			self.wTree.get_widget("combobox3").set_active(1)
		
	def RemoveLink2(self, widget):
		current = int(self.wTree.get_widget("combobox3").get_active())
                del self.list_of_files[self.wTree.get_widget("combobox3").get_active()]
                del self.list_of_titles[self.wTree.get_widget("combobox3").get_active()]
                self.wTree.get_widget("combobox3").remove_text(self.wTree.get_widget("combobox3").get_active())
                if len(self.list_of_files)>=1:
                        self.wTree.get_widget("combobox3").set_active((int(current)-1))
                else:
                        self.wTree.get_widget("combobox3").set_active(1)
		self.fetchvidinfodialog.destroy()
	def RingTone(self, widget):
		self.ringtone = gtk.glade.XML(self.gladefile, "ringtone")
		self.ringtonedlg = self.ringtone.get_widget("ringtone")
		self.ringtone.signal_autoconnect({"on_closering_clicked" : self.CloseRingTone,
						  "on_generatebtn_clicked" : self.StartRingTone,
						  "on_previewtone_clicked" : self.PreviewRingTone})
		self.ringtone.get_widget("combobox5").set_active(0)
	def ScaleVideo(self, widget):
		self.scale = gtk.glade.XML(self.gladefile, "scalevid")
		self.scaledlg = self.scale.get_widget("scalevid")
		self.scale.signal_autoconnect({"on_button7_clicked" : self.CloseScaleVideo,
					       "on_scaleapply_clicked" : self.StartScaleVideo})
	def RotateVideo(self, widget):
		self.rotatea = gtk.glade.XML(self.gladefile, "rotatevid")
		self.rotatedlg = self.rotatea.get_widget("rotatevid")
		self.rotatea.get_widget("degreeselected").set_active(0)	
		self.rotatea.signal_autoconnect({"on_button5_clicked" : self.CloseRotate,
                                                "on_degreeapply_clicked" : self.StartRotate})
	def RescanDeps(self, widget):
		self.checkfiles.get_widget("filechooserbutton14").set_current_folder(str(self.configops[6]))
		self.configops[6] = str(self.checkfiles.get_widget("filechooserbutton14").get_filename())
		for i in [self.configops[6] + "/ffmpeg2theora", self.configops[6] + "/ffmpeg", self.configops[6] + "/sox", self.configops[6] + "/mencoder", self.configops[6] + "/ffplay"]:
			print i + " - %s"%os.path.isfile(i)
                        
			if os.path.isfile(i):
                                self.checkfiles.get_widget(i.split("/")[-1]).set_text("Found")
                        else:
                                self.checkfiles.get_widget(i.split("/")[-1]).set_text("Not Found")
                                self.checkfiles.get_widget("label44").show()
                                self.checkfiles.get_widget("label44").set_label("Please install the missing dependency.")
			
		if not(self.checkfiles.get_widget("label44").get_label()==str("Please install the missing dependency.")):
			self.checkfiles.get_widget("label44").hide()
		self.checkfiles.get_widget("filechooserbutton14").set_current_folder(str(self.configops[6]))
		self.configurationtype = "dependencies"
		self.SavePrefFile()
                self.LoadPrefFile()
	def CheckFiles(self, widget):
		print self.configops[6]
		self.checkfiles = gtk.glade.XML(self.gladefile, "binarycheck")
		self.checkfilesdlg = self.checkfiles.get_widget("binarycheck")
		try: self.checkfiles.get_widget("filechooserbutton14").set_current_folder(str(self.configops[6]))
		except: pass
		self.checkfiles.signal_autoconnect({"on_button4_clicked" : self.CloseCheckFiles	})
		self.checkfiles.signal_autoconnect({"on_button47_clicked": self.RescanDeps})
		for i in [self.configops[6] + "/ffmpeg2theora", self.configops[6] + "/ffmpeg", self.configops[6] + "/sox", self.configops[6] + "/mencoder", self.configops[6] + "/ffplay"]:
                        if os.path.isfile(i):
                                self.checkfiles.get_widget(i.split("/")[-1]).set_text("Found")
                        else:
                                self.checkfiles.get_widget(i.split("/")[-1]).set_text("Not Found")
                                self.checkfiles.get_widget("label44").show()
                                self.checkfiles.get_widget("label44").set_label("Please install the missing dependency.")
                self.checkfiles.signal_autoconnect({"on_button4_clicked" : self.CloseCheckFiles })		
	def StartRingTone(self, widget):
		if (self.ringtone.get_widget("filechooserbutton9").get_filename()==None) or (self.ringtone.get_widget("filechooserbutton9").get_filename()==None):
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.get_widget("errorlabel").set_text("Please, fill the required information correctly.")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})		
		else:	
			self.window.hide()
	                self.audiolocation = self.ringtone.get_widget("filechooserbutton9").get_filename()	
		        self.saveto = self.ringtone.get_widget("filechooserbutton10").get_filename() + "/"
	                self.filename =  self.audiolocation.split("/")[-1] 
			self.filename = self.filename.split(".")[0]
			print self.filename	
        	        self.lengthchoice = self.ringtone.get_widget("combobox5").get_active()
	                self.task = gtk.glade.XML(self.gladefile, "task")
        	        self.taskdlg = self.task.get_widget("task")
        	        self.task.signal_autoconnect({"on_closebtn_clicked" : self.CloseTask,
						"on_button38_clicked" : self.KillAll})		
			self.task.get_widget("vidid").set_text(self.audiolocation)
        	        self.task.get_widget("destinid").set_text(self.saveto+self.filename)
        	        self.task.get_widget("image1").hide()
			self.ringtonedlg.destroy()
            		startringtone = RingTone(self.audiolocation, self.saveto, self.filename, self.lengthchoice, self.task, self.configops)
			startringtone.start()
	def PreviewRingTone(self, widget):
        	if self.ringtone.get_widget("filechooserbutton9").get_filename()==None:
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.get_widget("errorlabel").set_text("Please, indicate the file you wish to preview.")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})    
		else:
			audiolocation = self.ringtone.get_widget("filechooserbutton9").get_filename()
			previewfile = os.path.expanduser("~") + "/.pytube/preview_ringtone.wav"
	                lengthchoice = self.ringtone.get_widget("combobox5").get_active()
	                if lengthchoice==0:
       		                length=str("10")
        	        elif lengthchoice==1:
        	                length=str("20")
       		        elif lengthchoice==2:
        	                length=str("30")
        	        os.system(self.configops[6] + '/sox "' + str(audiolocation) + '" "' + str(previewfile) + '" fade t 4 ' + length + '" "' + length)
			os.system(self.configops[6] + '/ffplay "' + str(previewfile) + '"')
			try:
				os.remove(previewfile)
			except OSError:
				pass
	def StartScaleVideo(self, widget):
		if (self.scale.get_widget("filechooserbutton11").get_filename()==None):
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.get_widget("errorlabel").set_text("Please, fill the required information correctly.")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
		else:
			self.window.hide()
			self.vidlocation = self.scale.get_widget("filechooserbutton11").get_filename()
			self.saveto = self.scale.get_widget("filechooserbutton12").get_filename() + "/"
			self.filename = self.vidlocation.split("/")
			self.filename = self.filename[-1].split(".")[0]
			self.scaleheight = self.scale.get_widget("spinbutton2").get_value()
			self.scaleheight = str(self.scaleheight).split(".")[0]
			self.scalewidth = self.scale.get_widget("spinbutton1").get_value()
			self.scalewidth = str(self.scalewidth).split(".")[0]	
			self.scaledlg.destroy()
	       		picture = os.path.expanduser("~") + "/.pytube_framepic.png"
			self.task = gtk.glade.XML(self.gladefile, "task")
	               	self.taskdlg = self.task.get_widget("task")
	                self.task.signal_autoconnect({"on_closebtn_clicked" : self.CloseTask,
							 "on_button38_clicked" : self.KillAll})
			self.task.get_widget("label10").set_markup("<b>Obtaining Preview</b>")
	                os.system("ffmpeg -an -y -t 0:0:0.100 -i " + str(self.vidlocation) + " -s 130x98 -f image2 " + picture)
	                self.task.get_widget("vidid").set_text(self.vidlocation)
	               	self.task.get_widget("destinid").set_text(self.saveto+self.filename)
       		        self.task.get_widget("image1").set_from_file(picture)
        		startscale = Rescale(self.vidlocation, self.saveto, self.filename, self.scaleheight, self.scalewidth, self.task, self.configops)
			startscale.start()
			os.remove(picture)	
	def StartRotate(self, widget):
		if (self.rotatea.get_widget("filechooserbutton5").get_filename()==None):
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.get_widget("errorlabel").set_text("Please, fill the required information correctly.")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
		else:
			self.window.hide()
			self.vidlocation = self.rotatea.get_widget("filechooserbutton5").get_filename()
	                self.saveto = self.rotatea.get_widget("filechooserbutton6").get_filename() + "/"
	                self.filename = self.vidlocation.split("/")[-1]
			self.filename = self.filename.split(".")[0] + ".avi"
			self.degreeselected = self.rotatea.get_widget("degreeselected").get_active()	
	       	        self.task = gtk.glade.XML(self.gladefile, "task")
       		        self.taskdlg = self.task.get_widget("task")
       		        self.task.signal_autoconnect({"on_closebtn_clicked" : self.CloseTask,
							"on_button38_clicked" : self.KillAll})
       	        	picture = os.path.expanduser("~") + "/.pytube_framepic.png"
       	        	self.task.get_widget("vidid").set_text(self.vidlocation)
      	         	self.task.get_widget("destinid").set_text(self.saveto+self.filename)
			self.rotatedlg.destroy()
	               	self.task.get_widget("label10").set_markup("<b>Obtaining Preview...</b>")
	        	os.system(self.configops[6] + "/ffmpeg -an -y -t 0:0:0.100 -i " + str(self.vidlocation) + " -s 130x98 -f image2 " + picture)
			try:
		               	self.task.get_widget("image1").set_from_file(picture)
			except:
				pass
			startrotation = Rotate(self.vidlocation, self.saveto, self.filename, self.degreeselected, self.task, self.configops)	
			startrotation.start()
	def AudioInVideo(self, widget):
		self.audiovid = gtk.glade.XML(self.gladefile, "audiovid")
		self.audioviddlg = self.audiovid.get_widget("audiovid")
		self.audiovid.signal_autoconnect({"on_button3_clicked" : self.StartAudioVidApply,
						  "on_closebtn_clicked" : self.CloseAudioVid})
			
	def StartAudioVidApply(self, widget):
		if (self.audiovid.get_widget("audioforvid").get_filename()==None) or (self.audiovid.get_widget("vidlocation").get_filename()==None):
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.get_widget("errorlabel").set_text("Please, fill the required information correctly.")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
		else:
			self.window.hide()
                	self.task = gtk.glade.XML(self.gladefile, "task")
                	self.taskdlg = self.task.get_widget("task")
                	self.task.signal_autoconnect({"on_closebtn_clicked" : self.CloseTask,
						 "on_button38_clicked" : self.KillAll})
			audioforvideo = self.audiovid.get_widget("audioforvid").get_filename()
			videotouse = self.audiovid.get_widget("vidlocation").get_filename()
			saveto = self.audiovid.get_widget("savefinal").get_filename() + "/"
			filename = videotouse.split("/")[-1]
			filename = filename.split(".")[0]
			picture = os.path.expanduser("~") + "/.pytube_framepic.png"
			self.task.get_widget("vidid").set_text(videotouse)
       		        self.task.get_widget("destinid").set_text(saveto+filename)
			self.task.get_widget("label10").set_markup("<b>Obtaining Preview...</b>")
			self.audioviddlg.destroy()
        	        os.system("ffmpeg -an -y -t 0:0:0.100 -i " + str(videotouse) + " -s 130x98 -f image2 " + picture)
			self.task.get_widget("image1").set_from_file(picture)
			self.task.get_widget("label10").set_markup("<b>Applying Audio...</b>")
			os.system('mencoder "' + str(videotouse) + '" -o "' + str(saveto+filename) + '".avi -ovc copy -oac pcm -audiofile "' + str(audioforvideo) + '"')
			self.task.get_widget("label10").set_markup("<b>Done</b>")
			os.remove(picture)
			self.task.get_widget("button38").hide()
			self.task.get_widget("closebtn").show()
	def StartMerge(self, widget):
		if (self.merge.get_widget("combobox4").get_active_text()==None):
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.get_widget("errorlabel").set_text("Please, fill the required information correctly.")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
		else:
			self.window.hide()
			self.saveto = self.merge.get_widget("filechooserbutton4").get_filename() + "/"	
			self.task = gtk.glade.XML(self.gladefile, "task")
	                self.taskdlg = self.task.get_widget("task")
	                self.task.signal_autoconnect({"on_closebtn_clicked" : self.CloseTask,
							"on_button38_clicked" : self.KillAll})
	                self.task.get_widget("vidid").set_text("Multiple")
	                self.task.get_widget("destinid").set_text(self.saveto)
			self.mergedlg.destroy()
			startmerging = MergeVideos(self.list_of_files, self.task, self.saveto, self.configops)
	                startmerging.start()		
	def Merge(self, widget):
		self.merge = gtk.glade.XML(self.gladefile, "merge")
		self.mergedlg = self.merge.get_widget("merge")
		self.merge.signal_autoconnect({"on_closemerge_clicked" : self.CloseMerge,
					       "on_mergebtn_clicked" : self.StartMerge,
					       "on_addmergevid_clicked" : self.AddFileMerge,
					       "on_removemergevid_clicked" : self.RemoveFileMerge})
		self.list_of_files = list()
		self.merge.get_widget("combobox4").remove_text(0)
	def AddFileMerge(self, widget):
		self.list_of_files.append(self.merge.get_widget("filechooserbutton2").get_filename())
                self.merge.get_widget("combobox4").append_text(self.merge.get_widget("filechooserbutton2").get_filename())
		self.merge.get_widget("combobox4").set_active(0)
	def RemoveFileMerge(self, widget):
		del self.list_of_files[self.merge.get_widget("combobox4").get_active()]
                self.merge.get_widget("combobox4").remove_text(self.merge.get_widget("combobox4").get_active())
	def SearchTab(self, widget):
		self.wTree.get_widget("vbox24").hide()
                self.wTree.get_widget("vbox37").hide()
                self.wTree.get_widget("frame10").hide()
		self.wTree.get_widget("vbox63").hide()
		self.wTree.get_widget("frame9").show()
		self.wTree.get_widget("vbox32").hide()
		self.wTree.get_widget("notebook1").set_current_page(4)
	def TaskTab(self, widget):
		self.wTree.get_widget("vbox63").hide()
		self.wTree.get_widget("vbox24").hide()
                self.wTree.get_widget("vbox37").hide()
                self.wTree.get_widget("frame10").hide()
                self.wTree.get_widget("frame9").hide()
		self.wTree.get_widget("vbox32").show()
		self.wTree.get_widget("notebook1").set_current_page(2)
		if not(self.wTree.get_widget("notebook1").get_current_page()==4):
                	self.wTree.get_widget("scrolledwindow1").hide()
			self.wTree.get_widget("button19").hide()
			self.wTree.get_widget("label66").hide()
	def YouTubeTab(self, widget):
		self.wTree.get_widget("vbox32").hide()
		self.wTree.get_widget("vbox24").show()
		self.wTree.get_widget("vbox37").hide()
		self.wTree.get_widget("frame10").hide()
		self.wTree.get_widget("frame9").hide()
		self.wTree.get_widget("vbox63").hide()
		self.wTree.get_widget("notebook1").set_current_page(0)
	def ProfileTab(self, widget):
		self.wTree.get_widget("vbox32").hide()	
		self.wTree.get_widget("vbox63").show()
                self.wTree.get_widget("vbox24").show()
                self.wTree.get_widget("vbox37").hide()
                self.wTree.get_widget("frame10").hide()
                self.wTree.get_widget("frame9").hide()
                self.wTree.get_widget("notebook1").set_current_page(5)
	def LocalTab(self, widget):
		self.wTree.get_widget("vbox24").hide()
                self.wTree.get_widget("vbox37").show()
		self.wTree.get_widget("vbox32").hide()
		self.wTree.get_widget("vbox63").hide()
                self.wTree.get_widget("frame10").hide()
		self.wTree.get_widget("frame9").hide()
		self.wTree.get_widget("notebook1").set_current_page(1)
	def MultiTab(self, widget):
		self.wTree.get_widget("vbox63").hide()
		self.wTree.get_widget("vbox24").hide()
                self.wTree.get_widget("vbox37").hide()
                self.wTree.get_widget("frame10").show()
		self.wTree.get_widget("frame9").hide()
		self.wTree.get_widget("vbox32").hide()
		self.wTree.get_widget("notebook1").set_current_page(3)
	def ShowAbout(self, widget):
		gtk.about_dialog_set_url_hook(self.LaunchBrowser)
		self.about = gtk.glade.XML(self.gladefile, "aboutdialog", "About PyTube")
		self.aboutdlg = self.about.get_widget("aboutdialog")
		self.aboutdlg.connect("response", lambda d, r: d.destroy())
	def LaunchBrowser(self, widget, link):
	 	webbrowser.open(link)
	def CreateThumb(self, widget):
		os.system("ffmpeg -y -i " +  str(videosave+finalvideo) + ".mp4 -f image2 -ss 5 -vframes 1 -s 160x120 -an " + str(videosave+finalvideo) + ".THM")
	def QuickDownload(self, widget):
		if self.wTree.get_widget("entry9").get_text()=="":
                	self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                	self.errordlg = self.error.get_widget("errorwindow")
                        self.error.get_widget("errorlabel").set_text("Please, insert a video link to download.")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                else:
			self.videosave = str(self.configops[2])
			self.list_of_quickfiles.append(self.wTree.get_widget("entry9").get_text())
                        self.window.hide()
                        self.task = gtk.glade.XML(self.gladefile, "task")
                        self.taskdlg = self.task.get_widget("task")
                        self.task.signal_autoconnect({"on_closebtn_clicked" : self.CloseTask,
							 "on_button38_clicked" : self.KillAll})
			self.task.get_widget("destinid").set_text(os.path.expanduser("~"))
                        self.startprogress = QuickDownload(self.videosave, self.task, self.wTree, self.list_of_quickfiles, self.configops)
                        self.startprogress.start()
	def CloseExpList(self, widget):
		self.exportdlg.destroy()
	def ExportList(self, widget):
		self.export = gtk.glade.XML(self.gladefile, "explist")
		self.exportdlg = self.export.get_widget("explist")
		self.export.signal_autoconnect({"on_closering2_clicked" : self.CloseExpList,
						"on_button32_clicked" : self.AddExpList,
						"on_button31_clicked" : self.ExpList,
						"on_button34_clicked" : self.CleanExpList})		
                self.movieslist = self.export.get_widget("treeview2")
                self.movieslist.set_model(self.listtree)
                rendertext = gtk.CellRendererText()
                renderpix = gtk.CellRendererPixbuf()
                column0 = gtk.TreeViewColumn("Links to export", rendertext, text=1)
                self.movieslist.append_column(column0)
		self.videolist = []
	def CleanExpList(self, widget):
		self.export.get_widget("treeview2").get_model().clear()
		self.videolist = []
	def ExpList(self, widget):
		if self.export.get_widget("entry3").get_text()=="":
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                        self.error.get_widget("errorlabel").set_text("Please provide a name for the playlist.")
		elif len(self.videolist)<1:
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                        self.error.get_widget("errorlabel").set_text("There are no videos to generate a playlist of.")
		else:
			destination = self.export.get_widget("filechooserbutton13").get_filename() + "/" + self.export.get_widget("entry3").get_text() + ".pytube"
			if self.export.get_widget("radiobutton1").get_active()==True:
				list = open(destination,'w')
				for i in self.videolist:
					list.write(i + "\n")
				list.close()
				self.export.get_widget("treeview2").get_model().clear()
				self.exportdlg.destroy()
	def ExpListCombo(self, widget):
		self.expcombo  = gtk.glade.XML(self.gladefile, "exportlinks")
		self.expcombodlg = self.expcombo.get_widget("exportlinks")
		self.expcombo.signal_autoconnect({"on_button41_clicked" : self.CloseExpListCombo,
						  "on_button40_clicked" : self.SaveComboList})
	def SaveComboList(self, widget):	
		if self.expcombo.get_widget("entry4").get_text()=="":
                        self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                        self.error.get_widget("errorlabel").set_text("Please provide a name for the playlist.")
                elif len(self.list_of_files)<1:
                        self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                        self.error.get_widget("errorlabel").set_text("There are no videos to generate a playlist of.")
                else:
                        destination = self.expcombo.get_widget("filechooserbutton8").get_filename() + "/" + self.expcombo.get_widget("entry4").get_text() + ".pytube"
                        list = open(destination,'w')
                        for i in self.list_of_files:
                        	list.write(i + "\n")
                        list.close()
                        self.expcombodlg.destroy()
	def AddExpList(self, widget):
		providedurl = str(self.export.get_widget("entry2").get_text())
		if not("youtube.com/watch?v=") in providedurl or self.export.get_widget("entry2").get_text()=="":
			self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                        self.errordlg = self.error.get_widget("errorwindow")
                        self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
                        self.error.get_widget("errorlabel").set_text("This feature currently works only with YouTube videos.")
		else:
			iter = self.listtree.append(None)
        	        self.listtree.set_value( iter, 1, providedurl)	
			self.videolist.append(providedurl)
			self.export.get_widget("entry2").set_text("")
			self.export.get_widget("entry2").is_focus()
	def KillAll(self, widget):
                print "killall called"
                os.popen("kill -9 "+str(os.getpid()))
	def Download(self, widget):  
		if (self.wTree.get_widget("notebook1").get_current_page()==0) and not(self.wTree.get_widget("notebook1").get_current_page()==1):
			self.videosave = self.configops[2] + "/"
			self.format = self.wTree.get_widget("combobox1").get_active()
			if self.wTree.get_widget("combobox3").get_active_text()==None:
				self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                                self.errordlg = self.error.get_widget("errorwindow")
                                self.error.get_widget("errorlabel").set_text("Please, insert video links to download.")
                                self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
			else:
				self.window.hide()
                        	self.task = gtk.glade.XML(self.gladefile, "task")
                        	self.taskdlg = self.task.get_widget("task")
                        	self.task.signal_autoconnect({"on_closebtn_clicked" : self.CloseTask,
								"on_button38_clicked" : self.KillAll})
				startprogress = DownloadandEncode(self.videosave, self.format, self.task, self.wTree, self.list_of_files, self.configops, self.userprefsfolder, self.selectedmethod)
				startprogress.start()
		if (self.wTree.get_widget("notebook1").get_current_page()==1) and not(self.wTree.get_widget("notebook1").get_current_page()==0):
			if self.wTree.get_widget("filechooserlocal").get_filename()==None:
				self.error = gtk.glade.XML(self.gladefile, "errorwindow")
                                self.errordlg = self.error.get_widget("errorwindow")
                                self.error.get_widget("errorlabel").set_text("Please, browse for the video you want to convert.")
                                self.error.signal_autoconnect({"on_button1_clicked" : self.CloseError})
  			else:
				chosenfile = self.wTree.get_widget("filechooserlocal").get_filename().split("/")[-1]
				chosenfile = chosenfile.split(".")[0]
				self.window.hide()
				self.task = gtk.glade.XML(self.gladefile, "task")
                        	self.taskdlg = self.task.get_widget("task")
                        	self.task.signal_autoconnect({"on_closebtn_clicked" : self.CloseTask,
								 "on_button38_clicked" : self.KillAll})
				self.task.get_widget("image15").hide()
				self.task.get_widget("image18").hide()
				self.localvideo = self.wTree.get_widget("filechooserlocal").get_filename()
				self.finalvideo = self.configops[2] + "/" + chosenfile
				print self.wTree.get_widget("filechooserlocal").get_filename().split("/")[-1]
				picture = os.path.expanduser("~") + "/.pytube_framepic.png"
				os.system("ffmpeg -an -y -t 0:0:0.010 -i " + str(self.localvideo) + " -s 130x98 -f image2 " + picture)
				self.task.get_widget("image1").set_from_file(str(picture))
				self.task.get_widget("vidid").set_text(self.localvideo)
                        	self.task.get_widget("destinid").set_text(self.finalvideo)
				self.format = self.wTree.get_widget("combobox2").get_active()
				startlocal = EncodeLocal(self.localvideo, self.finalvideo, self.format, self.task, self.wTree, self.configops, self.userprefsfolder )
				startlocal.start()			
				print self.localvideo
				print self.finalvideo		
if __name__ == "__main__":
	program = GUI()
	gobject.threads_init()
	gtk.main()
	
