#!/usr/bin/env python
from url2media import *


class Youtube2media(Url2media):
    ReUrl=re.compile(".*youtube.*?v=.{2,15}.*");
    def __init__(self,url,username=None,password=None):
        Url2media.__init__(self,url,username,password)
        self.service_name="YouTube"
        self.fetched=False
        self.const_login_url_str = 'http://www.youtube.com/login?next=/watch%%3Fv%%3D%s'
        self.const_login_post_str = 'current_form=loginForm&next=%%2Fwatch%%3Fv%%3D%s&username=%s&password=%s&action_login=Log+In'
        self.const_age_url_str = 'http://www.youtube.com/verify_age?next_url=/watch%%3Fv%%3D%s'
        self.const_age_post_str = 'next_url=%%2Fwatch%%3Fv%%3D%s&action_confirm=Confirm'


    def checkUrl(self):
        #print "checking if url is walid"
        if self.ReUrl.match(self.url):
            return True
        else:
            return False

    def getDestFilename(self):
       # if self.dest_filename is None:
       #self.dest_filename=self.url.split("v=")[1]
       #self.dest_filename=self.dest_filename.split("&")[0]
       #self.dest_filename=self.service_name+"_"+self.dest_filename
       if not self.fetched:
           self.fetch_data()
       return self.dest_filename

    def fetchThumbnail(self):
        #print "to nie ja"
        try:
            urllib.urlretrieve("http://img.youtube.com/vi/" + self.url.split("v=")[1].split('&')[0] + "/default.jpg", self.picture)
            urllib.urlretrieve("http://img.youtube.com/vi/" + self.url.split("v=")[1].split('&')[0] + "/1.jpg", self.picture1)
            urllib.urlretrieve("http://img.youtube.com/vi/" + self.url.split("v=")[1].split('&')[0] + "/3.jpg", self.picture2)
        except Exception,e :
            print e

    def url2media(self):
       if not self.fetched:
           self.fetch_data()
       return self.media_url
       # print "getting and returning mediaurl for youtube"

    def fetch_data(self):
        const_video_url_str = 'http://www.youtube.com/watch?v=%s'
        const_video_url_re = re.compile(r'^((?:http://)?(?:\w+\.)?youtube\.com/(?:v/|(?:watch(?:\.php)?)?\?(?:.+&)?v=))?([0-9A-Za-z_-]+)(?(1)[&/].*)?$')
        const_url_t_param_re = re.compile('&t=\w*')
        #const_url_t_param_re = re.compile(r'[,{]t:\'([^\']*)\'')
        const_video_url_real_str = 'http://www.youtube.com/get_video?video_id=%s&t=%s='
        const_video_title_re = re.compile(r'<title>YouTube - ([^<]*)</title>', re.M | re.I)

        title_re=re.compile("<title>.*</title>")

        video_url_mo = const_video_url_re.match(self.url)
        if video_url_mo is None:
            raise Exception('Error: URL does not seem to be a youtube video URL. If it is, report a bug.')


        video_url_id = video_url_mo.group(2)
        video_url = const_video_url_str % video_url_id



        urllib2.install_opener(urllib2.build_opener(urllib2.ProxyHandler()))
        urllib2.install_opener(urllib2.build_opener(urllib2.HTTPCookieProcessor()))


        if self.account_username is not None:

            url = self.const_login_url_str % video_url_id
            post = self.const_login_post_str % (video_url_id, self.account_username, self.account_password)
            self.performRequest(url, post)

            url = self.const_age_url_str % video_url_id
            post = self.const_age_post_str % video_url_id
            self.performRequest(url, post)




        #video_webpage = download_step(True, 'Retrieving video webpage', 'unable to retrieve video webpage', video_url)
        video_webpage=self.performRequest(video_url).read()

       # video_url_t_param = extract_step('Extracting URL "t" parameter', 'unable to extract URL "t" parameter', const_url_t_param_re, video_webpage)
        #video_url_real = const_video_url_real_str % (video_url_id, video_url_t_param)

        match = const_url_t_param_re.search(video_webpage)
        if match is None:
            raise Exception('Error: There is a problem with URL or this clip requires login.')

        t_param = match.group(0).split('=')[1]
        #print "t param: "+t_param
        self.media_url = const_video_url_real_str % (video_url_id, t_param)

        #getting title
        match = title_re.search(video_webpage)
        title = match.group(0)
        title=title.strip("</title>?:!.")
        title=title.replace(" ","_")
        title=title.replace("?","_")
        title=title.replace("/","_")
        title=title.replace("&","_")
        title=title.replace("@","_")
        title=title.replace("\\","_")
        title=title.replace("'","_")
        title=title.replace("\"","_")
        title=title.replace(",","_")
        title=title.replace(":","_")
        title=title.replace(";","_")
        title=title.replace("|","_")
        title=title.replace("$","_")
        title=title.replace("%","_")
        title=title.replace("*","_")
        title=title.replace("#","_")
        title=title.replace("^","_")
        title=title.replace("{","_")
        title=title.replace("}","_")
        title=title.replace("[","_")
        title=title.replace("]","_")
        title=title.replace("=","_")
        title=title.replace("`","_")

        self.dest_filename=title
        self.fetched=True


