#!/bin/bash

blanktype=$1
cdwriter=$2

if [ ! -b "$cdwriter" ]; then
	echo "usage: $0 all|fast cdwriter"
	echo "example: $0 fast /dev/sr0"
	exit
fi


source simpleburn-burning-suite quiet


mediatype=`simpleburn-media-detection $cdwriter | grep  "mediatype=" | cut -f2 -d=`


case `echo $mediatype | cut -c1-2` in
"cd")
	$CDRECORD gracetime=3 blank=$blanktype dev=$cdwriter
	;;
"dvd")
	#~ if echo $CDRECORD | grep -q "cdrskin"
	#~ then cdrskin blank=format_overwrite_full dev=$cdwriter
	#~ else $CDRECORD gracetime=3 -force -format dev=$cdwriter
	#~ fi
	$CDRECORD gracetime=3 -force -format dev=$cdwriter
	#~ dvd+rw-format -force $cdwriter
	
	if [ "$blanktype" == "all" ]
	then mediacapacity=`simpleburn-media-detection $cdwriter | grep mediacapacity | cut -f2 -d=`
		let mediacapacity=mediacapacity/2 #2048 kiB sectors
		$CDRECORD dev=$cdwriter tsize=$mediacapacity\s /dev/zero
		#~ growisofs -Z $cdwriter=/dev/zero
	fi
	;;
esac
