#!/bin/bash

cdwriter=$1
filename=`echo $2 | sed 's/"//g'`

if [ ! -f "$filename" ] || [ ! -b "$cdwriter" ]; then
	echo "usage: $0 cdwriter somefile.iso"
	echo "example: $0 /dev/sr0 /home/me/linux.iso"
	exit
fi


source simpleburn-burning-suite quiet

tracksize=`isosize -d 1048576 "$filename"`
$CDRECORD -v gracetime=3 dev=$cdwriter -pad "$filename" | simpleburn-gauges cdrecord $tracksize
