#!/bin/bash

cdreader=$1
cdwriter=$2

if [ ! -b "$cdwriter" ] || [ ! -b "$cdreader" ] || [ $cdwriter == $cdreader ]; then
	echo "usage: $0 cdreader cdwriter"
	echo "example: $0 /dev/sr0 /dev/sr1"
	exit
fi


source simpleburn-burning-suite quiet

tracksize=`isosize -d 1048576 $cdreader`
$CDRECORD -v gracetime=3 dev=$cdwriter -isosize $cdreader | simpleburn-gauges cdrecord $tracksize
