#!/bin/bash

function ddgauge() {
	cdsize=$1
	shift; filename=$*
	ppid=$$
	
	sleep 1
	lastpercent=0
	while pgrep -P $ppid dd >/dev/null; do
		filesize=`ls -l "$filename" | cut -f5 -d' '`
		let filesize=filesize/1048576
		let percent=(filesize*100)/cdsize
		let percent=percent%100
		if (( $percent != $lastpercent ))
		then echo $percent
			lastpercent=$percent
		fi
		sleep 1
	done
	echo 100
}


cdreader=$1
filename=`echo $2 | sed 's/"//g'`
directory=`dirname "$filename"`
mkdir -p "$directory"

if [ ! -b "$cdreader" ]; then
	echo "usage: $0 cdreader somefile.iso"
	echo "example: $0 /dev/sr0 /home/me/linux.iso"
	exit
fi


cdsizeinbytes=`isosize $cdreader`
let cdsizeinmegabytes=cdsizeinbytes/1048576
let blockscount=cdsizeinbytes/2048

rm -f "$filename"
dd if=$cdreader bs=2048 count=$blockscount of="$filename" | ddgauge $cdsizeinmegabytes $filename
