void extractimagehandler( GtkWidget *widget, gpointer user_data ) {
	GtkWidget *cdreaderwidget, *directorywidget, *filenamewidget, *burnimagefilewidget;
	gchar **command;
	gchar *cdreader, *directory, *imagefile, *tmpfilename, *tmpcommand;
	gchar *action;
	T_cdinfos readercdinfos;
	
	cdreaderwidget = (GtkWidget *) gtk_builder_get_object( xml, "extractimagecdreader" );
	cdreader = gtk_combo_box_get_active_text( (GtkComboBox*) cdreaderwidget );
	directorywidget = (GtkWidget *) gtk_builder_get_object( xml, "extractimagefiledirectory" );
	directory = gtk_file_chooser_get_filename( (GtkFileChooser*) directorywidget );
	filenamewidget = (GtkWidget *) gtk_builder_get_object( xml, "extractimagefilename" );
	burnimagefilewidget = (GtkWidget *) gtk_builder_get_object( xml, "burnimagefile" );
	
	setcdinfos( cdreader, &readercdinfos );
	
	if ( hasiso9660media( readercdinfos ) && hasfilename( "extractimagefilename" ) ) {
		if ( ! g_regex_match_simple(".iso$", gtk_entry_get_text( (GtkEntry*) filenamewidget ), 0, 0) ) {
			tmpfilename = g_strdup_printf( "%s.iso", gtk_entry_get_text( (GtkEntry*) filenamewidget ) );
			gtk_entry_set_text( (GtkEntry*) filenamewidget, tmpfilename );
			g_free( tmpfilename );
		}

		imagefile = g_strdup_printf( "%s/%s", directory, gtk_entry_get_text( (GtkEntry*) filenamewidget ) );
		
		tmpcommand = g_strdup_printf( "touch \"%s\"", imagefile );
		g_spawn_command_line_sync( tmpcommand, NULL, NULL, NULL, NULL );
		g_free( tmpcommand );
		
		gtk_file_chooser_set_filename( (GtkFileChooser*) burnimagefilewidget, imagefile );		
	
		command = g_new ( gchar *, 4 );
		command[0] = g_strdup_printf( "simpleburn-extract-iso" );
		command[1] = g_strdup_printf( "%s", cdreader );
		command[2] = g_strdup_printf( "\"%s\"", imagefile );
		command[3] = NULL;
		
		action = g_strdup_printf( gettext("Extracting ISO image of '%s' to '%s' ..."), cdreader, imagefile );
		displayinfo( action );
		startprogress( command, TRUE, TRUE, NULL );
		
		g_strfreev( command );
		g_free( action );
		g_free( imagefile );
	}
	
	g_free( cdreader );
	g_free( directory );
}


void extractaudiohandler( GtkWidget *widget, gpointer user_data ) {
	GtkWidget *cdreaderwidget;
	GtkWidget *directorywidget, *burndirectorywidget;
	gchar **command;
	gchar *action;
	gchar *cdreader, *directory;
	T_cdinfos readercdinfos;
	
	cdreaderwidget = (GtkWidget *) gtk_builder_get_object( xml, "extractaudiocdreader" );
	cdreader = gtk_combo_box_get_active_text( (GtkComboBox*) cdreaderwidget );
	directorywidget = (GtkWidget *) gtk_builder_get_object( xml, "extractaudiodirectory" );
	directory = gtk_file_chooser_get_filename( (GtkFileChooser*) directorywidget);
	burndirectorywidget = (GtkWidget *) gtk_builder_get_object( xml, "burndirectorydirectory" );
	
	setcdinfos( cdreader, &readercdinfos );
	
	if ( hasaudiocdmedia( readercdinfos ) ) {
		gtk_file_chooser_set_filename( (GtkFileChooser*) burndirectorywidget, directory );
		
		command = g_new ( gchar *, 4 );
		command[0] = g_strdup_printf( "simpleburn-extract-audio" );
		command[1] = g_strdup_printf( "%s", cdreader );
		command[2] = g_strdup_printf( "\"%s\"", directory );
		command[3] = NULL;
		
		action = g_strdup_printf( gettext("Extracting audio of '%s' to '%s' ..."), cdreader, directory );
		displayinfo( action );
		startprogress( command, TRUE, TRUE, NULL );
		
		g_strfreev( command );
		g_free( action );
	}
	
	g_free( cdreader );
	g_free( directory );
}
