#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define FALSE 0
#define TRUE 1
#define bool unsigned short


void xorrisogauge () {
	char line [90];
	char nullbuf [50];
	char echocommand[9];
	int percent, lastdisplayedpercent;
	
	lastdisplayedpercent = 0;
	while (fgets (line, 90, stdin) != NULL) {
		if (strncmp (line, "I:1: xorriso : UPDATE : Writing:", 32) == 0) {
			line[50]='\0';
			percent = atoi (line+47);
			if ( percent !=  lastdisplayedpercent ) {
				sprintf (echocommand, "echo %d", percent);
				system (echocommand);
				//~ printf ("%d\n", percent); fflush (stdout);
				lastdisplayedpercent = percent;
			}
		}
	}
	system ("echo 100");
	//~ printf ("100\n"); fflush (stdout);
}


void cdrecordgauge ( int trackscount, int trackssizes[] ) {
	int totalsize;
	int *writtensizes;
	int percent, lastdisplayedpercent;
	int inputchar;
	char inputline[80];
	int inputnextcharpos;
	int inputtrack, inputwritten, inputtracksize;
	int i;
	char echocommand[9];
	
	totalsize = 0;
	for (i=0; i<trackscount; i++)
		totalsize += trackssizes[i];
	
	writtensizes = (int *) malloc ((trackscount) * sizeof (int));
	writtensizes[0] = 0;
	for (i=1; i<trackscount; i++)
		writtensizes[i] = writtensizes[i - 1] + trackssizes[i - 1];
	
	while (inputchar = fgetc(stdin)) { if (inputchar == 13) break; } //waiting loop
	
	inputnextcharpos=0;
	inputline[inputnextcharpos] = '\0';
	inputchar = fgetc(stdin);
	lastdisplayedpercent = -1;
	while (inputchar != EOF) {
		if (inputchar == 13 || inputchar == 10) { //return to line begin
			if (sscanf (inputline, "Track %2d: %4d of %4d MB written", &inputtrack, &inputwritten, &inputtracksize)) {
				percent = ((inputwritten * 100) / totalsize) + (writtensizes[inputtrack - 1] * 100) / totalsize;
				if (percent != lastdisplayedpercent) {
					sprintf (echocommand, "echo %d", percent);
					system (echocommand);
					//~ printf ("%d\n", percent); fflush (stdout);
					lastdisplayedpercent = percent;
				}
			}
			inputnextcharpos=0;
		} else {
			inputline[inputnextcharpos] = (char) inputchar;
			inputnextcharpos++;
		}
	inputline[inputnextcharpos] = '\0';
	inputchar = fgetc(stdin);
	}
	
	free (writtensizes);
	system ("echo 100");
	//~ printf ("100\n"); fflush (stdout);
}


void cdrdaogauge () {
	int totalsize;
	int writtensize;
	int percent, lastdisplayedpercent;
	int inputchar;
	char inputline[80];
	int inputnextcharpos;
	char echocommand[9];
	
	inputnextcharpos=0;
	inputline[inputnextcharpos] = '\0';
	inputchar = fgetc(stdin);
	lastdisplayedpercent = -1;
	while (inputchar != EOF) {
		if (inputchar == 13 || inputchar == 10) { //return to line begin
			if (strlen (inputline) != 0 && sscanf (inputline, "Wrote %d of %d MB", &writtensize, &totalsize)) {
				percent = (writtensize * 100) / totalsize;
				if (percent != lastdisplayedpercent) {
					sprintf (echocommand, "echo %d", percent);
					system (echocommand);
					//~ printf ("%d\n", percent); fflush (stdout);
					lastdisplayedpercent = percent;
				}
			}
			inputnextcharpos=0;
		} else {
			inputline[inputnextcharpos] = (char) inputchar;
			inputnextcharpos++;
		}
	inputline[inputnextcharpos] = '\0';
	inputchar = fgetc(stdin);
	}
	
	system ("echo 100");
	//~ printf ("100\n"); fflush (stdout);
}


void cdda2wavgauge ( int trackscount, int trackslengths[] ) {
	int i, totalsize, totalwrittensize, percent, percentpertrack, lastdisplayedpercent, previousprogress;
	bool starting, endoftrack;
	char line[80];
	int length;
	char trackpercent[4];
	int c;
	char echocommand[9];
	
	totalsize = 0;
	for (i=0; i<trackscount; i++) {
		totalsize += trackslengths[i];
	}
	
	starting = FALSE;
	while (! starting) {
		fgets (line, 80, stdin);
		line[13] = '\0';
		if (strncmp (line, "percent_done:", 13) == 0)
			starting = TRUE;
	}
	
	totalwrittensize = 0;
	lastdisplayedpercent = -1;
	for (i=0; i<trackscount; i++) {
		percentpertrack = (trackslengths[i] * 100) / totalsize;
		previousprogress = (totalwrittensize * 100) / totalsize;
		endoftrack = FALSE;
		trackpercent[0] = '\0';
		c = fgetc(stdin);
		while ((c != EOF) && (! endoftrack)) {
			switch (c) {
			case 37: //'%'
				percent = (atoi (trackpercent) * percentpertrack) / 100 + previousprogress;
				if ( percent !=  lastdisplayedpercent && percent <= 100) {
					sprintf (echocommand, "echo %d", percent);
					system (echocommand);
					//~ printf ("%d\n", percent); fflush (stdout);
					lastdisplayedpercent = percent;
				}
				trackpercent[0] = '\0';
				break;
			case 32:
				break;
			case 13:
				break;
			default:
				if (( c >= 48) && (c <= 57)) { //[0-9]
					length = strlen (trackpercent);
					trackpercent[length] = c;
					trackpercent[length+1] = '\0';
				} else
					endoftrack = TRUE;
			}
			c = fgetc(stdin);
		}
		totalwrittensize += trackslengths[i];
		fgets (line, 80, stdin);
	}
	
	system ("echo 100");
	//~ printf ("100\n"); fflush (stdout);
	while (getc (stdin) != EOF);
}


void cdparanoiagauge ( int sectorscount ) {
	int percent, lastdisplayedpercent;
	char inputline[80];
	long int sectorswritten;
	char echocommand[9];
	
	lastdisplayedpercent = -1;
	while (fgets (inputline, 80, stdin)) {
		if (sscanf (inputline, "##: 0 [] @ %ld", &sectorswritten)) {
			sectorswritten = sectorswritten / 1176; //2352/2
			percent = (sectorswritten * 100) / sectorscount;
			if (percent != lastdisplayedpercent) {
				sprintf (echocommand, "echo %d", percent);
				system (echocommand);
				//~ printf ("%d\n", percent); fflush (stdout);
				lastdisplayedpercent = percent;
			}
		}
	}
	
	system ("echo 100");
	//~ printf ("100\n"); fflush (stdout);
}


int main (int argc, char *argv[]) {
	int i;
	int *args;
	
	if (argc < 2) { //basic check to prevent a user running this program
		printf ("Usage: intended for SimpleBurn scripts.\n");
		return -1;
	}
	
	args = (int *) malloc (argc * sizeof (int));
	
	if (strncmp (argv[1], "cdda2wav", 8) == 0) {
		for (i=2; i<argc; i++)
			args[i-2] = atoi (argv[i]);
		cdda2wavgauge (argc - 2, args);
	} else {
		if (strncmp (argv[1], "cdrecord", 8) == 0) {
			for (i=2; i<argc; i++)
				args[i-2] = atoi (argv[i]);
			cdrecordgauge (argc - 2, args);
		} else {
			if (strncmp (argv[1], "xorriso", 8) == 0)
				xorrisogauge ();
			else {
				if (strncmp (argv[1], "cdparanoia", 11) == 0)
					cdparanoiagauge (atoi (argv[2]));
				else {
					if (strncmp (argv[1], "cdrdao", 6) == 0)
						cdrdaogauge ();
				}
			}
		}
	}
	
	free (args);
}

