void init_ui(void)
{
	//------------------------window--------------------------//
			mainwin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
			gtk_window_set_title(GTK_WINDOW(mainwin),C_WINDOW_TITLE);
			gtk_window_set_default_size(GTK_WINDOW(mainwin),C_WINDOW_WIDTH,C_WINDOW_HEIGHT);
			gtk_container_set_border_width(GTK_CONTAINER(mainwin),1);
			gtk_window_set_position(GTK_WINDOW(mainwin),GTK_WIN_POS_CENTER);
			gtk_window_set_icon_from_file(GTK_WINDOW(mainwin),C_TRAY_ICON,NULL);
			gtk_signal_connect(GTK_OBJECT(mainwin),"delete-event",G_CALLBACK(on_exit_program),NULL);
	//------------------------window--------------------------//
	
	
	
	//------------------------system tray--------------------------//
			trayicon = gtk_status_icon_new_from_file(C_TRAY_ICON);
			gtk_status_icon_set_tooltip(trayicon, "Transcoder");
			g_signal_connect(trayicon, "activate", G_CALLBACK(on_tray_icon_activate), NULL);
	//------------------------system tray--------------------------//
	
	
	
	//------------------------menubar--------------------------//
			GtkAccelGroup* accel_group = gtk_accel_group_new();
			gtk_window_add_accel_group(GTK_WINDOW(mainwin),accel_group);
			
			GtkWidget* menu_bar=gtk_menu_bar_new();
			
			//----------------file menu(start)----------------//
			GtkWidget* file_menu=gtk_menu_new();
			
			GtkWidget* menu_file=gtk_menu_item_new_with_label("File");
				gtk_menu_shell_append(GTK_MENU_SHELL(menu_bar),menu_file);
				gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_file),file_menu);
			
			GtkWidget* menu_open=gtk_menu_item_new_with_label("Open");
				gtk_menu_shell_append(GTK_MENU_SHELL(file_menu),menu_open);
				g_signal_connect(G_OBJECT(menu_open),"activate",G_CALLBACK(add_files),NULL);
			
			GtkWidget* menu_exit=gtk_menu_item_new_with_label("Exit");
				gtk_menu_shell_append(GTK_MENU_SHELL(file_menu),menu_exit);
				g_signal_connect(G_OBJECT(menu_exit),"activate",G_CALLBACK(on_exit_program),NULL);
				gtk_widget_add_accelerator(menu_exit,"activate",accel_group,GDK_q,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
			//----------------file menu(end)----------------//
			
			//----------------edit menu(start)----------------//
			GtkWidget* edit_menu=gtk_menu_new();
			
			GtkWidget* menu_edit=gtk_menu_item_new_with_label("Edit");
				gtk_menu_shell_append(GTK_MENU_SHELL(menu_bar),menu_edit);
				gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_edit),edit_menu);
				
			GtkWidget* menu_remove=gtk_menu_item_new_with_label("Remove selected");
				gtk_menu_shell_append(GTK_MENU_SHELL(edit_menu),menu_remove);
				g_signal_connect(G_OBJECT(menu_remove),"activate",G_CALLBACK(on_item_del),NULL);
				gtk_widget_add_accelerator(menu_remove,"activate",accel_group,GDK_Delete,GDK_LOCK_MASK,GTK_ACCEL_VISIBLE);
			GtkWidget* menu_clear_all=gtk_menu_item_new_with_label("Clear all");
				gtk_menu_shell_append(GTK_MENU_SHELL(edit_menu),menu_clear_all);
				g_signal_connect(G_OBJECT(menu_clear_all),"activate",G_CALLBACK(on_list_clear),NULL);
				gtk_widget_add_accelerator(menu_clear_all,"activate",accel_group,GDK_Delete,GDK_SHIFT_MASK,GTK_ACCEL_VISIBLE);
			//----------------edit menu(end)----------------//
			
			//----------------help menu(start)----------------//
			GtkWidget* help_menu=gtk_menu_new();
			
			GtkWidget* menu_help=gtk_menu_item_new_with_label("Help");
				gtk_menu_shell_append(GTK_MENU_SHELL(menu_bar),menu_help);
				gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_help),help_menu);
				
			GtkWidget* menu_about=gtk_menu_item_new_with_label("About");
				gtk_menu_shell_append(GTK_MENU_SHELL(help_menu),menu_about);
				g_signal_connect(G_OBJECT(menu_about),"activate",G_CALLBACK(on_about),NULL);
			//----------------help menu(end)----------------//
	//------------------------menubar--------------------------//
	
	
	
	//------------------------toolbar--------------------------//
			GtkWidget* add=gtk_button_new_from_stock(GTK_STOCK_ADD);
			g_signal_connect(G_OBJECT(add),"clicked",G_CALLBACK(add_files),NULL);
			
			convert=gtk_button_new_from_stock(GTK_STOCK_CONVERT);
			g_signal_connect(G_OBJECT(convert),"clicked",G_CALLBACK(on_convert_btn_clicked),NULL);
			
			stop=gtk_button_new_from_stock(GTK_STOCK_STOP);
			g_signal_connect(G_OBJECT(stop),"clicked",G_CALLBACK(on_stop_btn_clicked),NULL);
			gtk_widget_set_sensitive(stop,FALSE);
			
			GtkWidget* separator=gtk_vseparator_new();
			
			pause_continue=gtk_button_new_with_label("Slower");
			g_signal_connect(G_OBJECT(pause_continue),"clicked",G_CALLBACK(on_pause_continue_btn_clicked),NULL);
			gtk_widget_set_sensitive(pause_continue,FALSE);
			
			GtkWidget *empty_space=gtk_hbox_new(TRUE, 0);
			
			GtkWidget *output_path_lable=gtk_label_new("Output folder");
			
			output_path=gtk_entry_new();
			gtk_editable_set_editable(GTK_EDITABLE(output_path),FALSE);
			
			GtkWidget* browse = gtk_button_new_with_label("Browse");
			g_signal_connect(G_OBJECT(browse),"clicked",G_CALLBACK(browse_path),NULL);
			
			GtkWidget* toolbar = gtk_hbox_new(FALSE, 1);
			gtk_box_pack_start(GTK_BOX(toolbar), GTK_WIDGET(add), FALSE, FALSE, 1);
			gtk_box_pack_start(GTK_BOX(toolbar), GTK_WIDGET(convert), FALSE, FALSE, 1);
			gtk_box_pack_start(GTK_BOX(toolbar), GTK_WIDGET(stop), FALSE, FALSE, 1);
			gtk_box_pack_start(GTK_BOX(toolbar), GTK_WIDGET(separator), FALSE, FALSE, 3);
			gtk_box_pack_start(GTK_BOX(toolbar), GTK_WIDGET(pause_continue), FALSE, FALSE, 1);
			gtk_box_pack_start(GTK_BOX(toolbar), GTK_WIDGET(empty_space), TRUE, TRUE, 1);
			gtk_box_pack_start(GTK_BOX(toolbar), GTK_WIDGET(output_path_lable), FALSE, FALSE, 1);
			gtk_box_pack_start(GTK_BOX(toolbar), GTK_WIDGET(output_path), FALSE, FALSE, 1);
			gtk_box_pack_start(GTK_BOX(toolbar), GTK_WIDGET(browse), FALSE, FALSE, 1);
	//------------------------toolbar--------------------------//
	
	
	
	//------------------------list--------------------------//
			GtkWidget* sw = gtk_scrolled_window_new(NULL, NULL);
			gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(sw),GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
			
			list = gtk_tree_view_new();//list in scrolled window
			gtk_container_add(GTK_CONTAINER(sw),list);
			gtk_drag_dest_set(GTK_WIDGET(list),GTK_DEST_DEFAULT_ALL,NULL,100,GDK_DRAG_ENTER);
			gtk_drag_dest_add_uri_targets(GTK_WIDGET(list));
			g_signal_connect(list, "drag_data_received", G_CALLBACK(on_list_drag_data_received), NULL);
			
			GtkCellRenderer *renderer;
			renderer = gtk_cell_renderer_text_new();
			
			GtkTreeViewColumn *column_name = gtk_tree_view_column_new_with_attributes("Name",renderer, "text", COLUMN_NAME, NULL);
			gtk_tree_view_column_set_min_width(column_name,150);
			gtk_tree_view_column_set_resizable(column_name,TRUE);
			gtk_tree_view_append_column(GTK_TREE_VIEW(list),column_name);
			
			GtkTreeViewColumn *column_status = gtk_tree_view_column_new_with_attributes("Status",renderer, "text", COLUMN_STATUS, NULL);
			gtk_tree_view_column_set_min_width(column_status,50);
			gtk_tree_view_column_set_resizable(column_status,TRUE);
			gtk_tree_view_append_column(GTK_TREE_VIEW(list),column_status);
			
			GtkTreeViewColumn *column_path = gtk_tree_view_column_new_with_attributes("Path",renderer, "text", COLUMN_PATH, NULL);
			gtk_tree_view_append_column(GTK_TREE_VIEW(list),column_path);
			
			store = gtk_list_store_new(N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
			gtk_tree_view_set_model(GTK_TREE_VIEW(list),GTK_TREE_MODEL(store));
			g_object_unref(store);
	//------------------------list--------------------------//
	
	
	progress_bar=gtk_progress_bar_new();
	
	
	//------------------------notebook--------------------------//
			gshort for_iter;
			//-------------------------video tab content(start)-----------------------//
			GtkWidget *v_format_lable=gtk_label_new("Format");
			gtk_misc_set_alignment(GTK_MISC(v_format_lable),0,0.5);
			gtk_widget_set_size_request(v_format_lable,C_LABLE_WIDTH,C_LABLE_HEIGHT);
			
			v_format_combo=gtk_combo_box_new_text();
			for(for_iter=0;for_iter<=C_NUM_FORMATS-1;for_iter++)
			{
				gtk_combo_box_append_text(GTK_COMBO_BOX(v_format_combo),vformats[for_iter].combo_name);
			}
			gtk_combo_box_set_active(GTK_COMBO_BOX(v_format_combo),0);
				
				GtkWidget *v_format_box=gtk_hbox_new(FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_format_box),v_format_lable,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_format_box),v_format_combo,FALSE,FALSE,1);
			
			GtkWidget *v_codec_lable=gtk_label_new("Codec");
			gtk_misc_set_alignment(GTK_MISC(v_codec_lable),0,0.5);
			gtk_widget_set_size_request(v_codec_lable,C_LABLE_WIDTH,C_LABLE_HEIGHT);
			
			v_codec_combo=gtk_combo_box_new_text();
			for(for_iter=0;for_iter<=C_NUM_V_CODECS-1;for_iter++)
			{
				gtk_combo_box_append_text(GTK_COMBO_BOX(v_codec_combo),vcodecs[for_iter].combo_name);
			}
			gtk_combo_box_set_active(GTK_COMBO_BOX(v_codec_combo),0);
				
				GtkWidget *v_codec_box=gtk_hbox_new(FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_codec_box),v_codec_lable,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_codec_box),v_codec_combo,FALSE,FALSE,1);
			
			GtkWidget *v_bitrate_lable=gtk_label_new("Bitrate");
			gtk_misc_set_alignment(GTK_MISC(v_bitrate_lable),0,0.5);
			gtk_widget_set_size_request(v_bitrate_lable,C_LABLE_WIDTH,C_LABLE_HEIGHT);
			
			v_bitrate_spin=gtk_spin_button_new_with_range(C_MIN_VIDEO_BITRATE,C_MAX_VIDEO_BITRATE,16);
			gtk_editable_set_editable(GTK_EDITABLE(v_bitrate_spin),FALSE);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(v_bitrate_spin),C_DEFAULT_VIDEO_BITRATE);
			
				GtkWidget *v_bitrate_box=gtk_hbox_new(FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_bitrate_box),v_bitrate_lable,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_bitrate_box),v_bitrate_spin,FALSE,FALSE,1);
			
			GtkWidget *v_resolution_lable=gtk_label_new("Resolution");
			gtk_misc_set_alignment(GTK_MISC(v_resolution_lable),0,0.5);
			gtk_widget_set_size_request(v_resolution_lable,C_LABLE_WIDTH,C_LABLE_HEIGHT);
			
			v_width_spin=gtk_spin_button_new_with_range(C_MIN_VIDEO_WIDTH,C_MAX_VIDEO_WIDTH,16);
			gtk_editable_set_editable(GTK_EDITABLE(v_width_spin),FALSE);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(v_width_spin),C_DEFAULT_VIDEO_WIDTH);
			
			GtkWidget *v_resolution_x=gtk_label_new(" x ");
			
			v_height_spin=gtk_spin_button_new_with_range(C_MIN_VIDEO_HEIGHT,C_MAX_VIDEO_HEIGHT,16);
			gtk_editable_set_editable(GTK_EDITABLE(v_height_spin),FALSE);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(v_height_spin),C_DEFAULT_VIDEO_HEIGHT);
			
			v_width_height_check = gtk_check_button_new_with_label("Same as source");
			g_signal_connect (v_width_height_check,"toggled",G_CALLBACK(on_width_x_height_box), NULL);

			
				GtkWidget *v_resolution_box=gtk_hbox_new(FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_resolution_box),v_resolution_lable,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_resolution_box),v_width_spin,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_resolution_box),v_resolution_x,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_resolution_box),v_height_spin,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_resolution_box),v_width_height_check,FALSE,FALSE,1);
				
			GtkWidget *v_aspect_lable=gtk_label_new("Aspect");
			gtk_misc_set_alignment(GTK_MISC(v_aspect_lable),0,0.5);
			gtk_widget_set_size_request(v_aspect_lable,C_LABLE_WIDTH,C_LABLE_HEIGHT);
			
			v_aspect_combo=gtk_combo_box_new_text();
			gtk_combo_box_append_text(GTK_COMBO_BOX(v_aspect_combo),"16:9");
			gtk_combo_box_append_text(GTK_COMBO_BOX(v_aspect_combo),"4:3");
			gtk_combo_box_set_active(GTK_COMBO_BOX(v_aspect_combo),1);
			
				GtkWidget *v_aspect_box=gtk_hbox_new(FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_aspect_box),v_aspect_lable,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_aspect_box),v_aspect_combo,FALSE,FALSE,1);
				
			GtkWidget *v_fps_lable=gtk_label_new("Frame rate");
			gtk_misc_set_alignment(GTK_MISC(v_fps_lable),0,0.5);
			gtk_widget_set_size_request(v_fps_lable,C_LABLE_WIDTH,C_LABLE_HEIGHT);
			
			v_fps_combo=gtk_combo_box_new_text();
			gtk_combo_box_append_text(GTK_COMBO_BOX(v_fps_combo),"Auto");
			gtk_combo_box_append_text(GTK_COMBO_BOX(v_fps_combo),"15.000");
			gtk_combo_box_append_text(GTK_COMBO_BOX(v_fps_combo),"23.976");
			gtk_combo_box_append_text(GTK_COMBO_BOX(v_fps_combo),"25.000");
			gtk_combo_box_append_text(GTK_COMBO_BOX(v_fps_combo),"29.970");
			gtk_combo_box_set_active(GTK_COMBO_BOX(v_fps_combo),0);
			
				GtkWidget *v_fps_box=gtk_hbox_new(FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_fps_box),v_fps_lable,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(v_fps_box),v_fps_combo,FALSE,FALSE,1);
			//-------------------------video tab content(end)-----------------------//
			
			//-------------------------audio tab content(start)-----------------------//
			GtkWidget *a_codec_lable=gtk_label_new("Codec");
			gtk_widget_set_size_request(a_codec_lable,C_LABLE_WIDTH,C_LABLE_HEIGHT);
			gtk_misc_set_alignment(GTK_MISC(a_codec_lable),0,0.5);
			
			a_codec_combo=gtk_combo_box_new_text();
			for(for_iter=0;for_iter<=C_NUM_A_CODECS-1;for_iter++)
			{
				gtk_combo_box_append_text(GTK_COMBO_BOX(a_codec_combo),acodecs[for_iter].combo_name);
			}
			gtk_combo_box_set_active(GTK_COMBO_BOX(a_codec_combo),0);
				
				GtkWidget *a_codec_box=gtk_hbox_new(FALSE,1);
				gtk_box_pack_start(GTK_BOX(a_codec_box),a_codec_lable,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(a_codec_box),a_codec_combo,FALSE,FALSE,1);
			
			GtkWidget *a_bitrate_lable=gtk_label_new("Bitrate");
			gtk_widget_set_size_request(a_bitrate_lable,C_LABLE_WIDTH,C_LABLE_HEIGHT);
			gtk_misc_set_alignment(GTK_MISC(a_bitrate_lable),0,0.5);
			
			a_bitrate_spin=gtk_spin_button_new_with_range(C_MIN_AUDIO_BITRATE,C_MAX_AUDIO_BITRATE,16);
			gtk_editable_set_editable(GTK_EDITABLE(a_bitrate_spin),FALSE);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(a_bitrate_spin),C_DEFAULT_AUDIO_BITRATE);
			
				GtkWidget *a_bitrate_box=gtk_hbox_new(FALSE,1);
				gtk_box_pack_start(GTK_BOX(a_bitrate_box),a_bitrate_lable,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(a_bitrate_box),a_bitrate_spin,FALSE,FALSE,1);
			
			GtkWidget* a_sr_lable=gtk_label_new("Sampling rate");
			gtk_widget_set_size_request(a_sr_lable,C_LABLE_WIDTH,C_LABLE_HEIGHT);
			gtk_misc_set_alignment(GTK_MISC(a_sr_lable),0,0.5);
			
			a_sr_combo=gtk_combo_box_new_text();
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_sr_combo),"Auto");
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_sr_combo),"8000");
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_sr_combo),"11025");
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_sr_combo),"16000");
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_sr_combo),"22050");
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_sr_combo),"44100");
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_sr_combo),"48000");
			gtk_combo_box_set_active(GTK_COMBO_BOX(a_sr_combo),6);
			
				GtkWidget *a_sr_box=gtk_hbox_new(FALSE,1);
				gtk_box_pack_start(GTK_BOX(a_sr_box),a_sr_lable,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(a_sr_box),a_sr_combo,FALSE,FALSE,1);
			
			GtkWidget* a_channel_lable=gtk_label_new("Channels");
			gtk_widget_set_size_request(a_channel_lable,C_LABLE_WIDTH,C_LABLE_HEIGHT);
			gtk_misc_set_alignment(GTK_MISC(a_channel_lable),0,0.5);
			
			a_channel_combo=gtk_combo_box_new_text();
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_channel_combo),"Auto");
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_channel_combo),"1");
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_channel_combo),"2");
			gtk_combo_box_append_text(GTK_COMBO_BOX(a_channel_combo),"6");
			gtk_combo_box_set_active(GTK_COMBO_BOX(a_channel_combo),2);
			
				GtkWidget *a_channel_box=gtk_hbox_new(FALSE,1);
				gtk_box_pack_start(GTK_BOX(a_channel_box),a_channel_lable,FALSE,FALSE,1);
				gtk_box_pack_start(GTK_BOX(a_channel_box),a_channel_combo,FALSE,FALSE,1);
			//-------------------------audio tab content(end)-----------------------//
			
			//-----------tab lables(start)------------//
			GtkWidget *video_lable;
			video_lable=gtk_label_new(C_VIDEO_TAB_TITLE);
			
			GtkWidget *audio_lable;
			audio_lable=gtk_label_new(C_AUDIO_TAB_TITLE);
			//-----------tab lables(end)------------//
			
			//----------------------tab boxes(start)------------//
			GtkWidget *video_box=gtk_vbox_new(FALSE,3);
			gtk_container_set_border_width(GTK_CONTAINER(video_box),5);
			gtk_box_pack_start(GTK_BOX(video_box),v_format_box,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(video_box),v_codec_box,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(video_box),v_bitrate_box,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(video_box),v_resolution_box,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(video_box),v_aspect_box,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(video_box),v_fps_box,FALSE,FALSE,0);
			
			GtkWidget *audio_box=gtk_vbox_new(FALSE,3);
			gtk_container_set_border_width(GTK_CONTAINER(audio_box),5);
			gtk_box_pack_start(GTK_BOX(audio_box),a_codec_box,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(audio_box),a_bitrate_box,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(audio_box),a_sr_box,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(audio_box),a_channel_box,FALSE,FALSE,0);
			//----------------------tab boxes(end)------------//
			
			GtkWidget* notebook = gtk_notebook_new();
			gtk_notebook_append_page(GTK_NOTEBOOK(notebook),video_box,video_lable);
			gtk_notebook_append_page(GTK_NOTEBOOK(notebook),audio_box,audio_lable);
	//------------------------notebook--------------------------//
	
	GtkWidget *vbox = gtk_vbox_new(FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(menu_bar), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(toolbar), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(sw), TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(progress_bar), FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(notebook), FALSE, FALSE, 0);
	gtk_container_add(GTK_CONTAINER(mainwin), vbox);
}
