/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.rating.ui;

import com.aelitis.azureus.plugins.rating.RatingPlugin;
import com.aelitis.azureus.plugins.rating.ui.RatingImageUtil;
import com.aelitis.azureus.plugins.rating.ui.RatingWindow;
import com.aelitis.azureus.plugins.rating.updater.RatingData;
import com.aelitis.azureus.plugins.rating.updater.RatingResults;
import com.aelitis.azureus.plugins.rating.updater.RatingsUpdater;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class RatingColumn
implements TableCellRefreshListener,
TableCellDisposeListener,
TableCellMouseListener {
    private RatingPlugin plugin;
    private RatingsUpdater updater;
    private UISWTInstance swt_ui;
    private LocaleUtilities localeTxt;

    public RatingColumn(RatingPlugin plugin) {
        this.plugin = plugin;
        this.swt_ui = plugin.getUI();
        this.localeTxt = plugin.getPluginInterface().getUtilities().getLocaleUtilities();
    }

    public void refresh(TableCell cell) {
        Object dataSource = cell.getDataSource();
        if (dataSource == null || !(dataSource instanceof Download)) {
            return;
        }
        Download download = (Download)dataSource;
        if (this.updater == null) {
            this.updater = this.plugin.getUpdater();
        }
        String toolTip = null;
        float average = 0.0f;
        float personalScore = 0.0f;
        if (this.updater != null) {
            RatingData personalData;
            RatingResults rating = this.updater.getRatingsForDownload(download);
            if (rating != null) {
                average = rating.getRealAverageScore();
                average += (float)rating.getNbRatings() / 10000.0f;
                toolTip = rating.getNbRatings() > 0 ? this.localeTxt.getLocalisedMessageText("RatingPlugin.tooltip.avgRating", new String[]{"" + rating.getAverageScore(), "" + rating.getNbRatings()}) : this.localeTxt.getLocalisedMessageText("RatingPlugin.tooltip.noRating", new String[]{"" + rating.getAverageScore()});
                int nbComments = rating.getNbComments();
                if (nbComments > 0) {
                    toolTip = toolTip + "\n" + this.localeTxt.getLocalisedMessageText("RatingPlugin.tooltip.numComments", new String[]{"" + rating.getNbComments()});
                }
            }
            if ((personalData = this.updater.loadRatingsFromDownload(download)) != null && (personalScore = (float)personalData.getScore()) > 0.0f) {
                toolTip = toolTip + "\n" + this.localeTxt.getLocalisedMessageText("RatingPlugin.tooltip.yourRating", new String[]{"" + personalScore});
            }
            if (this.swt_ui == null) {
                cell.setText(rating.getAverageScore() + "/" + "5.0");
            }
        }
        if (!cell.setSortValue(average) && cell.isValid()) {
            return;
        }
        if (this.swt_ui != null) {
            Image image = RatingImageUtil.createStarLineImage(average, personalScore, this.swt_ui.getDisplay());
            int cellWidth = cell.getWidth();
            if (cellWidth > 0 && cellWidth < image.getBounds().width) {
                ImageData data = image.getImageData();
                image.dispose();
                data = data.scaledTo(cell.getWidth(), data.height);
                image = new Image((Device)this.swt_ui.getDisplay(), data);
            }
            UISWTGraphic graphic = this.swt_ui.createGraphic(image);
            this.dispose(cell);
            cell.setGraphic((Graphic)graphic);
        }
        cell.setToolTip(toolTip);
    }

    public void dispose(TableCell cell) {
        Image img;
        Graphic g = cell.getGraphic();
        if (g instanceof UISWTGraphic && (img = ((UISWTGraphic)g).getImage()) != null && !img.isDisposed()) {
            img.dispose();
        }
    }

    public void cellMouseTrigger(TableCellMouseEvent event) {
        Object dataSource = event.cell.getDataSource();
        if (!(dataSource instanceof Download)) {
            return;
        }
        Download download = (Download)dataSource;
        if (event.eventType == 0 && event.button == 2) {
            try {
                int score = event.x / RatingImageUtil.starWidth + 1;
                if (this.updater == null) {
                    this.updater = this.plugin.getUpdater();
                }
                RatingData oldData = this.updater.loadRatingsFromDownload(download);
                RatingData data = new RatingData(score, oldData.getNick(), oldData.getComment());
                this.updater.storeRatingsToDownload(download, data);
                event.cell.invalidate();
            }
            catch (Exception e) {
                this.plugin.logError("Set personal rating via cell click", e);
            }
        } else if (event.eventType == 2 && this.swt_ui != null) {
            try {
                new RatingWindow(this.plugin, download);
                event.skipCoreFunctionality = true;
            }
            catch (Exception e) {
                this.plugin.logError("Open RatingWidnow via cell click", e);
            }
        }
    }
}

