/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.rating.ui;

import com.aelitis.azureus.plugins.rating.RatingPlugin;
import com.aelitis.azureus.plugins.rating.ui.RatingImageUtil;
import com.aelitis.azureus.plugins.rating.updater.RatingData;
import com.aelitis.azureus.plugins.rating.updater.RatingResults;
import com.aelitis.azureus.plugins.rating.updater.RatingsUpdater;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.ui.swt.ImageRepository;

public class RatingWindow {
    private static String MSG_PREFIX = "RatingPlugin.RatingWindow.";
    private static String MSG_SHELL_TITLE = MSG_PREFIX + "title";
    private static String MSG_GLOBAL_RATING = MSG_PREFIX + "globalRating";
    private static String MSG_PERSONAL_RATING = MSG_PREFIX + "personalRating";
    private static String MSG_BUTTON_CLEAR = MSG_PREFIX + "Button.clear";
    private static String MSG_BUTTON_OK = MSG_PREFIX + "Button.ok";
    private static String MSG_COMMENTS = MSG_PREFIX + "comments";
    private static String MSG_YOUR_COMMENT = MSG_PREFIX + "yourComment";
    private static String MSG_WARNING = MSG_PREFIX + "rateBeforeComment";
    RatingPlugin plugin;
    RatingsUpdater updater;
    Download download;
    Text txtPersonalComment;
    RatingResults results;
    int score;
    String comment;
    Image lastRatingImage = null;
    private LocaleUtilities localeTxt;

    public RatingWindow(RatingPlugin plugin, Download download) {
        this.plugin = plugin;
        this.updater = plugin.getUpdater();
        this.download = download;
        this.localeTxt = plugin.getPluginInterface().getUtilities().getLocaleUtilities();
        this.results = this.updater.getRatingsForDownload(download);
        RatingData personalData = this.updater.loadRatingsFromDownload(download);
        this.score = personalData.getScore();
        this.comment = personalData.getComment();
        final Shell shell = new Shell();
        shell.setText(this.localeTxt.getLocalisedMessageText(MSG_SHELL_TITLE, new String[]{download.getTorrent().getName()}));
        if (!plugin.getPluginInterface().getUtilities().isOSX()) {
            shell.setImage(ImageRepository.getImage((String)"azureus"));
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        shell.setLayout((Layout)layout);
        Label lblGlobalRating = new Label((Composite)shell, 0);
        lblGlobalRating.setText(this.localeTxt.getLocalisedMessageText(MSG_GLOBAL_RATING));
        final Label lblGlobalRatingIcon = new Label((Composite)shell, 0);
        Label lblGlobalRatingInfo = new Label((Composite)shell, 0);
        lblGlobalRatingInfo.setText(this.results.getAverageScore());
        Label personalRating = new Label((Composite)shell, 0);
        personalRating.setText(this.localeTxt.getLocalisedMessageText(MSG_PERSONAL_RATING));
        final Label personalRatingIcon = new Label((Composite)shell, 0);
        personalRatingIcon.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                RatingWindow.this.score = Math.min(5, event.x / RatingImageUtil.starWidth + 1);
                RatingWindow.this.setRatingImage(personalRatingIcon, RatingWindow.this.score);
            }
        });
        Button btnClear = new Button((Composite)shell, 8);
        btnClear.setText(this.localeTxt.getLocalisedMessageText(MSG_BUTTON_CLEAR));
        btnClear.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RatingWindow.this.score = 0;
                RatingWindow.this.setRatingImage(personalRatingIcon, RatingWindow.this.score);
            }
        });
        personalRating.setToolTipText("Click the image to change your rating");
        personalRatingIcon.setToolTipText("Click the image to change your rating");
        Label lblComments = new Label((Composite)shell, 0);
        lblComments.setText(this.localeTxt.getLocalisedMessageText(MSG_COMMENTS));
        StyledText txtComments = new StyledText((Composite)shell, 2568);
        txtComments.setText(this.results.getComments());
        txtComments.setWordWrap(true);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        txtComments.setLayoutData((Object)data);
        Label personalComment = new Label((Composite)shell, 0);
        personalComment.setText(this.localeTxt.getLocalisedMessageText(MSG_YOUR_COMMENT));
        data = new GridData();
        data.horizontalSpan = 3;
        personalComment.setLayoutData((Object)data);
        this.txtPersonalComment = new Text((Composite)shell, 2048);
        this.txtPersonalComment.setText(this.comment);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.txtPersonalComment.setLayoutData((Object)data);
        this.txtPersonalComment.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (RatingWindow.this.txtPersonalComment.getText().length() > 150 && e.character != '\u007f' && e.keyCode != 8) {
                    e.doit = false;
                }
            }
        });
        Button btnOk = new Button((Composite)shell, 8);
        btnOk.setText(this.localeTxt.getLocalisedMessageText(MSG_BUTTON_OK));
        data = new GridData(896);
        data.horizontalSpan = 3;
        data.widthHint = 70;
        btnOk.setLayoutData((Object)data);
        btnOk.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RatingData data = new RatingData(RatingWindow.this.score, RatingWindow.this.plugin.getNick(), RatingWindow.this.txtPersonalComment.getText());
                RatingWindow.this.updater.storeRatingsToDownload(RatingWindow.this.download, data);
                shell.close();
            }
        });
        this.setRatingImage(lblGlobalRatingIcon, this.results.getRealAverageScore());
        this.setRatingImage(personalRatingIcon, this.score);
        lblGlobalRatingIcon.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image img = lblGlobalRatingIcon.getImage();
                if (img != null && !img.isDisposed()) {
                    img.dispose();
                }
                if ((img = personalRatingIcon.getImage()) != null && !img.isDisposed()) {
                    img.dispose();
                }
            }
        });
        personalRatingIcon.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image img = personalRatingIcon.getImage();
                if (img != null && !img.isDisposed()) {
                    img.dispose();
                }
            }
        });
        shell.setSize(350, 400);
        shell.open();
    }

    private void setRatingImage(Label label, float rating) {
        Image img = label.getImage();
        if (img != null && !img.isDisposed()) {
            img.dispose();
        }
        img = RatingImageUtil.createRatingImage(rating, this.plugin.getUI().getDisplay());
        label.setImage(img);
        if (rating == 0.0f) {
            if (this.txtPersonalComment.isEnabled()) {
                this.comment = this.txtPersonalComment.getText();
                this.txtPersonalComment.setText(this.localeTxt.getLocalisedMessageText(MSG_WARNING));
                this.txtPersonalComment.setEnabled(false);
            }
        } else if (!this.txtPersonalComment.isEnabled()) {
            this.txtPersonalComment.setText(this.comment);
            this.txtPersonalComment.setEnabled(true);
        }
    }
}

