/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.activities;

import com.aelitis.azureus.activities.VuzeActivitiesEntryBuddy;
import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.util.MapUtils;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;

public class VuzeActivitiesEntryBuddyRequest
extends VuzeActivitiesEntryBuddy {
    private String urlAccept;

    public String getUrlAccept() {
        return this.urlAccept;
    }

    public void init(VuzeBuddy buddy, String acceptURL, long attempNumber) {
        this.buddy = buddy;
        this.urlAccept = this.getContentNetwork().appendURLSuffix(acceptURL, false, true);
        String textID = "v3.activity.buddy-request";
        if (attempNumber > 1L) {
            textID = textID + ".multi";
        }
        String text = MessageText.getString(textID, new String[]{buddy.getProfileAHREF("buddy-request"), this.urlAccept, "" + attempNumber});
        this.setText(text);
        this.setTypeID("buddy-request", true);
        this.setID(VuzeActivitiesEntryBuddyRequest.buildID(buddy.getCode()));
    }

    public void loadCommonFromMap(Map map) {
        super.loadCommonFromMap(map);
        this.urlAccept = MapUtils.getMapString(map, "url-accept", this.urlAccept);
        if (this.urlAccept != null) {
            this.urlAccept = this.getContentNetwork().appendURLSuffix(this.urlAccept, false, true);
        }
    }

    public Map toMap() {
        Map map = super.toMap();
        map.put("url-accept", this.urlAccept);
        return map;
    }

    public static String buildID(String code) {
        return "buddy-request-" + code;
    }
}

