/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.activities;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesEntryBuddyLinkup;
import com.aelitis.azureus.activities.VuzeActivitiesEntryBuddyRequest;
import com.aelitis.azureus.activities.VuzeActivitiesEntryContentShare;
import com.aelitis.azureus.activities.VuzeActivitiesListener;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkListener;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManager;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.cnetwork.ContentNetworkPropertyChangeListener;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformVuzeActivitiesMessenger;
import com.aelitis.azureus.core.messenger.config.RatingUpdateListener2;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.torrent.RatingInfoList;
import com.aelitis.azureus.core.torrent.SingleUserRatingInfo;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class VuzeActivitiesManager {
    public static final long MAX_LIFE_MS = 2592000000L;
    private static final long DEFAULT_PLATFORM_REFRESH = 86400000L;
    private static final long RATING_REMINDER_DELAY = 259200000L;
    private static final long WEEK_MS = 604800000L;
    private static final String SAVE_FILENAME = "VuzeActivities.config";
    private static ArrayList listeners = new ArrayList();
    private static ArrayList allEntries = new ArrayList();
    private static AEMonitor allEntries_mon = new AEMonitor("VuzeActivityMan");
    private static List removedEntries = new ArrayList();
    private static PlatformVuzeActivitiesMessenger.GetEntriesReplyListener replyListener;
    private static AEDiagnosticsLogger diag_logger;
    private static Map<String, Long> lastNewsAt;
    private static boolean skipAutoSave;
    private static AEMonitor config_mon;
    private static boolean saveEventsOnClose;

    public static void initialize(final AzureusCore core) {
        new AEThread2("lazy init", true){

            public void run() {
                VuzeActivitiesManager._initialize(core);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _initialize(AzureusCore core) {
        if (diag_logger != null) {
            diag_logger.log("Initialize Called");
        }
        core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void stopping(AzureusCore core) {
                if (saveEventsOnClose) {
                    VuzeActivitiesManager.saveEventsNow();
                }
            }
        });
        VuzeActivitiesManager.loadEvents();
        ContentNetworkManager cnm = ContentNetworkManagerFactory.getSingleton();
        if (cnm != null) {
            ContentNetwork[] contentNetworks = cnm.getContentNetworks();
            cnm.addListener(new ContentNetworkListener(){

                public void networkRemoved(ContentNetwork network) {
                }

                public void networkChanged(ContentNetwork network) {
                }

                public void networkAdded(ContentNetwork cn) {
                    VuzeActivitiesManager.setupContentNetwork(cn);
                }

                public void networkAddFailed(long network_id, Throwable error) {
                }
            });
            for (ContentNetwork cn : contentNetworks) {
                VuzeActivitiesManager.setupContentNetwork(cn);
            }
        }
        replyListener = new PlatformVuzeActivitiesMessenger.GetEntriesReplyListener(){

            public void gotVuzeNewsEntries(VuzeActivitiesEntry[] entries, long refreshInMS) {
                if (diag_logger != null) {
                    diag_logger.log("Received Reply from platform with " + entries.length + " entries.  Refresh in " + refreshInMS);
                }
                VuzeActivitiesManager.addEntries(entries);
                if (refreshInMS <= 0L) {
                    refreshInMS = 86400000L;
                }
                SimpleTimer.addEvent("GetVuzeNews", SystemTime.getOffsetTime(refreshInMS), new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        VuzeActivitiesManager.pullActivitiesNow(5000L);
                    }
                });
            }
        };
        VuzeActivitiesManager.pullActivitiesNow(5000L);
        PlatformRatingMessenger.addListener(new RatingUpdateListener2(){

            public void ratingUpdated(RatingInfoList rating) {
                if (!(rating instanceof SingleUserRatingInfo)) {
                    return;
                }
                Object[] allEntriesArray = allEntries.toArray();
                for (int i = 0; i < allEntriesArray.length; ++i) {
                    VuzeActivitiesEntry entry = (VuzeActivitiesEntry)allEntriesArray[i];
                    if (entry == null) continue;
                    String typeID = entry.getTypeID();
                    DownloadManager dm = entry.getDownloadManger();
                    if (!"Rating-Reminder".equals(typeID) || dm == null) continue;
                    try {
                        String hash = dm.getTorrent().getHashWrapper().toBase32String();
                        if (!rating.hasHash(hash) || rating.getRatingValue(hash, "content") == -1L) continue;
                        VuzeActivitiesManager.removeEntries(new VuzeActivitiesEntry[]{entry});
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        });
        GlobalManagerListener gmListener = new GlobalManagerListener(){

            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }

            public void downloadManagerRemoved(DownloadManager dm) {
            }

            public void downloadManagerAdded(DownloadManager dm) {
                List entries = VuzeActivitiesManager.registerDM(dm);
                if (entries != null && entries.size() > 0) {
                    VuzeActivitiesManager.addEntries(entries.toArray(new VuzeActivitiesEntry[0]));
                }
            }

            public void destroyed() {
            }

            public void destroyInitiated() {
            }
        };
        ArrayList newEntries = new ArrayList();
        GlobalManager gm = core.getGlobalManager();
        gm.addListener(gmListener, false);
        List downloadManagers = gm.getDownloadManagers();
        for (DownloadManager dm : downloadManagers) {
            List entries = VuzeActivitiesManager.registerDM(dm);
            if (entries == null || entries.size() <= 0) continue;
            newEntries.addAll(entries);
        }
        if (newEntries.size() > 0) {
            VuzeActivitiesManager.trimReminders(newEntries, false);
            VuzeActivitiesManager.addEntries(newEntries.toArray(new VuzeActivitiesEntry[0]));
        }
        try {
            allEntries_mon.enter();
            VuzeActivitiesManager.trimReminders(allEntries, true);
        }
        finally {
            allEntries_mon.exit();
        }
    }

    private static void setupContentNetwork(final ContentNetwork cn) {
        cn.addPersistentPropertyChangeListener(new ContentNetworkPropertyChangeListener(){

            public void propertyChanged(String name) {
                boolean isActive;
                if (!"active".equals(name)) {
                    return;
                }
                Object oIsActive = cn.getPersistentProperty("active");
                boolean bl = isActive = oIsActive instanceof Boolean ? (Boolean)oIsActive : false;
                if (isActive) {
                    VuzeActivitiesManager.pullActivitiesNow(2000L);
                }
            }
        });
    }

    private static void trimReminders(List entries, boolean liveRemove) {
        ArrayList<VuzeActivitiesEntry> listReminders = new ArrayList<VuzeActivitiesEntry>();
        for (VuzeActivitiesEntry entry : entries) {
            if (!"Rating-Reminder".equals(entry.getTypeID())) continue;
            listReminders.add(entry);
        }
        if (listReminders.size() > 3) {
            Collections.sort(listReminders);
            long weekBreak = SystemTime.getCurrentTime() - 2419200000L;
            int numInWeek = 0;
            for (VuzeActivitiesEntry entry : listReminders) {
                if (entry.getTimestamp() < weekBreak) {
                    if (++numInWeek <= 3) continue;
                    if (liveRemove) {
                        VuzeActivitiesManager.removeEntries(new VuzeActivitiesEntry[]{entry});
                        continue;
                    }
                    entries.remove(entry);
                    continue;
                }
                numInWeek = 1;
                while (entry.getTimestamp() >= weekBreak) {
                    weekBreak += 604800000L;
                }
            }
        }
    }

    private static List registerDM(DownloadManager dm) {
        TOTorrent torrent = dm.getTorrent();
        if (PlatformTorrentUtils.getAdId(torrent) != null) {
            return null;
        }
        boolean isContent = PlatformTorrentUtils.isContent(torrent, true);
        ArrayList<VuzeActivitiesEntry> entries = new ArrayList<VuzeActivitiesEntry>();
        try {
            if (isContent) {
                int userRating;
                long networkID = PlatformTorrentUtils.getContentNetworkID(torrent);
                long completedOn = dm.getDownloadState().getLongParameter("stats.download.completed.time");
                if (completedOn > 0L && networkID == ConstantsVuze.getDefaultContentNetwork().getID() && SystemTime.getCurrentTime() - completedOn > 259200000L && (userRating = PlatformTorrentUtils.getUserRating(torrent)) < 0) {
                    String title;
                    VuzeActivitiesEntry entry = new VuzeActivitiesEntry();
                    entries.add(entry);
                    String hash = torrent.getHashWrapper().toBase32String();
                    ContentNetwork cn = DataSourceUtils.getContentNetwork(dm);
                    if (cn == null) {
                        title = PlatformTorrentUtils.getContentTitle2(dm);
                    } else {
                        String url = cn.getContentDetailsService(hash, "activity-Rating-Reminder");
                        title = "<A HREF=\"" + url + "\">" + PlatformTorrentUtils.getContentTitle2(dm) + "</A>";
                    }
                    entry.setAssetHash(hash);
                    entry.setDownloadManager(dm);
                    entry.setShowThumb(true);
                    entry.setID(hash + ";r" + completedOn);
                    entry.setText("To improve your recommendations, please rate " + title);
                    entry.setTimestamp(SystemTime.getCurrentTime());
                    entry.setTypeID("Rating-Reminder", true);
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return entries;
    }

    public static void pullActivitiesNow(long delay) {
        ContentNetwork[] contentNetworks;
        ContentNetworkManager cnm = ContentNetworkManagerFactory.getSingleton();
        if (cnm == null) {
            return;
        }
        for (ContentNetwork cn : contentNetworks = cnm.getContentNetworks()) {
            boolean isActive;
            if (cn == null) continue;
            Object oIsActive = cn.getPersistentProperty("active");
            boolean bl = isActive = oIsActive instanceof Boolean ? (Boolean)oIsActive : false;
            if (!isActive) continue;
            String id = "" + cn.getID();
            Long oLastPullTime = lastNewsAt.get(id);
            long lastPullTime = oLastPullTime != null ? oLastPullTime : 0L;
            long now = SystemTime.getCurrentTime();
            long diff = now - lastPullTime;
            if (diff > 2592000000L) {
                diff = 2592000000L;
            }
            PlatformVuzeActivitiesMessenger.getEntries(cn.getID(), diff, delay, replyListener);
            lastNewsAt.put(id, new Long(now));
        }
    }

    public static void clearLastPullTimes() {
        lastNewsAt = new HashMap<String, Long>();
    }

    public static void resetRemovedEntries() {
        removedEntries.clear();
        VuzeActivitiesManager.saveEvents();
    }

    private static void saveEvents() {
        saveEventsOnClose = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEvents() {
        skipAutoSave = true;
        try {
            Object value2;
            List newRemovedEntries;
            long lastVuzeNewsAt;
            Map map = FileUtil.readResilientConfigFile(SAVE_FILENAME);
            long cutoffTime = VuzeActivitiesManager.getCutoffTime();
            try {
                lastNewsAt = MapUtils.getMapMap(map, "LastChecks", new HashMap());
            }
            catch (Exception e) {
                Debug.out(e);
            }
            if (lastNewsAt.size() == 0 && (lastVuzeNewsAt = MapUtils.getMapLong(map, "LastCheck", 0L)) > 0L) {
                if (lastVuzeNewsAt < cutoffTime) {
                    lastVuzeNewsAt = cutoffTime;
                }
                lastNewsAt.put("1", new Long(lastVuzeNewsAt));
            }
            if ((newRemovedEntries = (List)MapUtils.getMapObject(map, "removed-entries", null, List.class)) != null) {
                for (Object value2 : newRemovedEntries) {
                    VuzeActivitiesEntry entry;
                    if (!(value2 instanceof Map) || (entry = VuzeActivitiesManager.createEntryFromMap((Map)value2, true)) == null || entry.getTimestamp() <= cutoffTime) continue;
                    removedEntries.add(entry);
                }
            }
            if (!((value2 = map.get("entries")) instanceof List)) {
                return;
            }
            List entries = (List)value2;
            ArrayList<VuzeActivitiesEntry> entriesToAdd = new ArrayList<VuzeActivitiesEntry>(entries.size());
            for (Object value2 : entries) {
                VuzeActivitiesEntry entry;
                if (!(value2 instanceof Map) || (entry = VuzeActivitiesManager.createEntryFromMap((Map)value2, true)) == null) continue;
                if ("Rating-Reminder".equals(entry.getTypeID())) {
                    entry.setShowThumb(true);
                }
                if (entry.getTimestamp() <= cutoffTime) continue;
                entriesToAdd.add(entry);
            }
            int num = entriesToAdd.size();
            if (num > 0) {
                VuzeActivitiesManager.addEntries(entriesToAdd.toArray(new VuzeActivitiesEntry[num]));
            }
        }
        finally {
            skipAutoSave = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveEventsNow() {
        if (skipAutoSave) {
            return;
        }
        try {
            config_mon.enter();
            HashMap<String, Object> mapSave = new HashMap<String, Object>();
            mapSave.put("LastChecks", lastNewsAt);
            ArrayList<Map> entriesList = new ArrayList<Map>();
            VuzeActivitiesEntry[] allEntriesArray = VuzeActivitiesManager.getAllEntries();
            for (int i = 0; i < allEntriesArray.length; ++i) {
                boolean isHeader;
                VuzeActivitiesEntry entry = allEntriesArray[i];
                if (entry == null || (isHeader = "Header".equals(entry.getTypeID()))) continue;
                entriesList.add(entry.toMap());
            }
            mapSave.put("entries", entriesList);
            ArrayList<Map> removedEntriesList = new ArrayList<Map>();
            for (VuzeActivitiesEntry entry : removedEntries) {
                removedEntriesList.add(entry.toDeletedMap());
            }
            mapSave.put("removed-entries", removedEntriesList);
            FileUtil.writeResilientConfigFile(SAVE_FILENAME, mapSave);
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        finally {
            config_mon.exit();
        }
    }

    public static long getCutoffTime() {
        return SystemTime.getOffsetTime(-2592000000L);
    }

    public static void addListener(VuzeActivitiesListener l) {
        listeners.add(l);
    }

    public static void removeListener(VuzeActivitiesListener l) {
        listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VuzeActivitiesEntry[] addEntries(VuzeActivitiesEntry[] entries) {
        long cutoffTime = VuzeActivitiesManager.getCutoffTime();
        ArrayList<VuzeActivitiesEntry> newEntries = new ArrayList<VuzeActivitiesEntry>(entries.length);
        ArrayList<VuzeActivitiesEntry> existingEntries = new ArrayList<VuzeActivitiesEntry>(0);
        try {
            allEntries_mon.enter();
            for (int i = 0; i < entries.length; ++i) {
                VuzeActivitiesEntry entry = entries[i];
                boolean isHeader = "Header".equals(entry.getTypeID());
                if (entry.getTimestamp() < cutoffTime && !isHeader || removedEntries.contains(entry)) continue;
                if (allEntries.contains(entry)) {
                    existingEntries.add(entry);
                    continue;
                }
                newEntries.add(entry);
                allEntries.add(entry);
            }
        }
        finally {
            allEntries_mon.exit();
        }
        VuzeActivitiesEntry[] newEntriesArray = newEntries.toArray(new VuzeActivitiesEntry[newEntries.size()]);
        if (newEntriesArray.length > 0) {
            VuzeActivitiesManager.saveEventsNow();
            Object[] listenersArray = listeners.toArray();
            for (int i = 0; i < listenersArray.length; ++i) {
                VuzeActivitiesListener l = (VuzeActivitiesListener)listenersArray[i];
                l.vuzeNewsEntriesAdded(newEntriesArray);
            }
        }
        if (existingEntries.size() > 0) {
            if (newEntriesArray.length == 0) {
                VuzeActivitiesManager.saveEvents();
            }
            for (VuzeActivitiesEntry entry : existingEntries) {
                VuzeActivitiesManager.triggerEntryChanged(entry);
            }
        }
        return newEntriesArray;
    }

    public static void removeEntries(VuzeActivitiesEntry[] entries) {
        VuzeActivitiesManager.removeEntries(entries, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEntries(VuzeActivitiesEntry[] entries, boolean allowReAdd) {
        long cutoffTime = VuzeActivitiesManager.getCutoffTime();
        try {
            allEntries_mon.enter();
            for (int i = 0; i < entries.length; ++i) {
                VuzeActivitiesEntry entry = entries[i];
                if (entry == null) continue;
                allEntries.remove(entry);
                boolean isHeader = "Header".equals(entry.getTypeID());
                if (allowReAdd || entry.getTimestamp() <= cutoffTime || isHeader) continue;
                removedEntries.add(entry);
            }
        }
        finally {
            allEntries_mon.exit();
        }
        Object[] listenersArray = listeners.toArray();
        for (int i = 0; i < listenersArray.length; ++i) {
            VuzeActivitiesListener l = (VuzeActivitiesListener)listenersArray[i];
            l.vuzeNewsEntriesRemoved(entries);
        }
        VuzeActivitiesManager.saveEventsNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VuzeActivitiesEntry getEntryByID(String id) {
        try {
            allEntries_mon.enter();
            for (VuzeActivitiesEntry entry : allEntries) {
                if (entry == null) continue;
                String entryID = entry.getID();
                if (entryID == null || !entryID.equals(id)) continue;
                VuzeActivitiesEntry vuzeActivitiesEntry = entry;
                return vuzeActivitiesEntry;
            }
        }
        finally {
            allEntries_mon.exit();
        }
        return null;
    }

    public static VuzeActivitiesEntry[] getAllEntries() {
        return allEntries.toArray(new VuzeActivitiesEntry[allEntries.size()]);
    }

    public static int getNumEntries() {
        return allEntries.size();
    }

    public static void log(String s) {
        if (diag_logger != null) {
            diag_logger.log(s);
        }
    }

    public static void triggerEntryChanged(VuzeActivitiesEntry entry) {
        Object[] listenersArray = listeners.toArray();
        for (int i = 0; i < listenersArray.length; ++i) {
            VuzeActivitiesListener l = (VuzeActivitiesListener)listenersArray[i];
            l.vuzeNewsEntryChanged(entry);
        }
        VuzeActivitiesManager.saveEvents();
    }

    public static VuzeActivitiesEntry createEntryFromMap(Map map, boolean internalMap) {
        return VuzeActivitiesManager.createEntryFromMap(1L, map, internalMap);
    }

    public static VuzeActivitiesEntry createEntryFromMap(long defaultContentNetworkID, Map map, boolean internalMap) {
        String typeID = MapUtils.getMapString(map, "typeID", MapUtils.getMapString(map, "type-id", null));
        VuzeActivitiesEntry entry = "buddy-request".equals(typeID) ? new VuzeActivitiesEntryBuddyRequest() : ("buddy-share".equals(typeID) ? new VuzeActivitiesEntryContentShare() : ("buddy-new".equals(typeID) ? new VuzeActivitiesEntryBuddyLinkup() : new VuzeActivitiesEntry()));
        entry.setContentNetworkID(defaultContentNetworkID);
        if (internalMap) {
            entry.loadFromInternalMap(map);
        } else {
            entry.loadFromExternalMap(map);
        }
        return entry;
    }

    static {
        lastNewsAt = new HashMap<String, Long>();
        skipAutoSave = true;
        config_mon = new AEMonitor("ConfigMon");
        saveEventsOnClose = false;
        if (System.getProperty("debug.vuzenews", "0").equals("1")) {
            diag_logger = AEDiagnostics.getLogger("v3.vuzenews");
            diag_logger.log("\n\nVuze News Logging Starts");
        } else {
            diag_logger = null;
        }
    }
}

