/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.buddy.chat;

import com.aelitis.azureus.buddy.chat.ChatMessageListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class ChatMessage {
    private BuddyPluginBuddyMessage persistent_msg;
    final long originalTimeStamp;
    final long timestamp;
    final String senderPK;
    final String sender;
    final String message;
    private boolean rendered;
    private List listeners = new ArrayList();

    public static ChatMessage deserialise(BuddyPluginBuddyMessage pm) {
        try {
            Map m = pm.getRequest();
            long original_ts = (Long)m.get("ot");
            long ts = (Long)m.get("t");
            String sender = new String((byte[])m.get("se"), "UTF-8");
            byte[] sender_pk_b = (byte[])m.get("sk");
            String sender_pk = sender_pk_b == null ? null : new String(sender_pk_b, "UTF-8");
            String message = new String((byte[])m.get("msg"), "UTF-8");
            ChatMessage res = new ChatMessage(sender_pk, original_ts, ts, sender, message);
            res.setPersistentMessage(pm);
            return res;
        }
        catch (Throwable e) {
            Debug.out("Failed to decode chat message '" + pm + "'", e);
            return null;
        }
    }

    public ChatMessage(String senderPK, long originalTimeStamp, long timestamp, String sender, String message) {
        this.senderPK = senderPK;
        this.originalTimeStamp = originalTimeStamp;
        this.timestamp = timestamp;
        this.sender = sender;
        this.message = message;
    }

    public void setPersistentMessage(BuddyPluginBuddyMessage _pm) {
        this.persistent_msg = _pm;
    }

    public BuddyPluginBuddyMessage getPersistentMessage() {
        return this.persistent_msg;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getOriginatorTimestamp() {
        return this.originalTimeStamp;
    }

    public String getSender() {
        return this.sender;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isMe() {
        return this.senderPK == null || this.senderPK.length() == 0;
    }

    public String getSenderPK() {
        return this.senderPK;
    }

    public void setRendered() {
        this.rendered = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ChatMessageListener)this.listeners.get(i)).rendered(this);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean getRendered() {
        return this.rendered;
    }

    public void addListener(ChatMessageListener l) {
        this.listeners.add(l);
    }

    public Map toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("ot", new Long(this.originalTimeStamp));
        m.put("t", new Long(this.timestamp));
        try {
            m.put("se", this.sender.getBytes("UTF-8"));
            if (this.senderPK != null) {
                m.put("sk", this.senderPK.getBytes("UTF-8"));
            }
            m.put("msg", this.message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Debug.out(e);
        }
        return m;
    }

    public boolean equals(Object o) {
        if (o instanceof ChatMessage) {
            ChatMessage other = (ChatMessage)o;
            return other.originalTimeStamp == this.originalTimeStamp;
        }
        return false;
    }
}

