/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.buddy.impl;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesEntryContentShare;
import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.VuzeBuddyListener;
import com.aelitis.azureus.buddy.VuzeShareable;
import com.aelitis.azureus.buddy.chat.ChatMessage;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessage;
import com.aelitis.azureus.ui.utils.ImageBytesDownloader;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.LoginInfoManager;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.StringCompareUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VuzeBuddyImpl
implements VuzeBuddy {
    protected String displayName;
    private String loginID;
    private String code;
    private long lastUpdated;
    private long createdOn;
    private String avatarURL;
    private CopyOnWriteList<BuddyPluginBuddy> pluginBuddies = new CopyOnWriteList();
    private AEMonitor mon_pluginBuddies = new AEMonitor("pluginBuddies");
    private ArrayList<VuzeBuddyListener> listeners = new ArrayList(0);

    protected VuzeBuddyImpl(String publicKey) {
        this.addPublicKey(publicKey);
    }

    protected VuzeBuddyImpl() {
    }

    @Override
    public void loadFromMap(Map mapNewBuddy) {
        String pk;
        if (mapNewBuddy == null) {
            return;
        }
        this.setDisplayName(MapUtils.getMapString(mapNewBuddy, "display-name", "" + ((Object)mapNewBuddy).hashCode()));
        this.setLoginID(MapUtils.getMapString(mapNewBuddy, "login-id", "" + ((Object)mapNewBuddy).hashCode()));
        ArrayList<String> pksAdded = new ArrayList<String>();
        List pkList = MapUtils.getMapList(mapNewBuddy, "pks", Collections.EMPTY_LIST);
        for (Object o : pkList) {
            pk = null;
            if (o instanceof byte[]) {
                try {
                    pk = new String((byte[])o, "utf-8");
                }
                catch (UnsupportedEncodingException e) {}
            } else if (o instanceof String) {
                pk = (String)o;
            }
            if (pk == null) continue;
            this.addPublicKey(pk);
            pksAdded.add(pk);
        }
        for (BuddyPluginBuddy pluginBuddy : this.pluginBuddies.getList()) {
            pk = pluginBuddy.getPublicKey();
            if (pk == null || pksAdded.contains(pk)) continue;
            this.removePublicKey(pk);
        }
        byte[] newAvatar = MapUtils.getMapByteArray(mapNewBuddy, "avatar", null);
        if (newAvatar != null) {
            this.setAvatar(newAvatar);
        }
        String newAvatarURL = MapUtils.getMapString(mapNewBuddy, "avatar.url", null);
        if (this.avatarURL == null && this.hasAvatar()) {
            this.avatarURL = newAvatarURL;
        } else if (!StringCompareUtils.equals(newAvatarURL, this.avatarURL) || !this.hasAvatar()) {
            this.avatarURL = newAvatarURL;
            if (this.avatarURL != null) {
                ImageBytesDownloader.loadImage(this.avatarURL, new ImageBytesDownloader.ImageDownloaderListener(){

                    public void imageDownloaded(byte[] image) {
                        VuzeBuddyManager.log("Got new avatar! " + VuzeBuddyImpl.this.toDebugString());
                        VuzeBuddyImpl.this.setAvatar(image);
                    }
                });
            }
        }
        this.setCode(MapUtils.getMapString(mapNewBuddy, "code", null));
        this.setCreatedOn(MapUtils.getMapLong(mapNewBuddy, "created-on", 0L));
    }

    @Override
    public Map toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("display-name", this.displayName);
        map.put("login-id", this.loginID);
        map.put("code", this.code);
        map.put("created-on", new Long(this.createdOn));
        List<String> pks = Arrays.asList(this.getPublicKeys());
        map.put("pks", pks);
        map.put("avatar.url", this.avatarURL);
        return map;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        if (displayName == null) {
            displayName = "";
        }
        if (displayName.equals(this.displayName)) {
            return;
        }
        this.displayName = displayName;
        VuzeBuddyManager.triggerOrderChangedListener();
    }

    @Override
    public String getLoginID() {
        return this.loginID;
    }

    @Override
    public void setLoginID(String loginID) {
        this.loginID = loginID;
    }

    @Override
    public long getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public void setLastUpdated(long lastUpdated) {
        boolean trigger = this.lastUpdated > 0L;
        this.lastUpdated = lastUpdated;
        if (trigger) {
            VuzeBuddyManager.triggerChangeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getAvatar() {
        block5: {
            byte[] byArray;
            File file = this.getAvatarFile();
            if (!file.exists()) break block5;
            FileInputStream fis = new FileInputStream(file);
            try {
                byArray = FileUtil.readInputStreamAsByteArray(fis);
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            fis.close();
            return byArray;
        }
        return null;
    }

    private File getAvatarFile() {
        return new File(SystemProperties.getUserPath(), "friends" + File.separator + this.getLoginID().hashCode() + ".ico");
    }

    private boolean hasAvatar() {
        return this.getAvatarFile().exists();
    }

    @Override
    public void setAvatar(byte[] avatar) {
        File file = this.getAvatarFile();
        FileUtil.writeBytesAsFile(file.getAbsolutePath(), avatar);
        VuzeBuddyManager.triggerChangeListener(this);
    }

    @Override
    public boolean isOnline(boolean is_connected) {
        for (BuddyPluginBuddy pluginBuddy : this.pluginBuddies) {
            if (!pluginBuddy.isOnline(is_connected) || pluginBuddy.getOnlineStatus() == 4) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getVersion() {
        int version = 1;
        for (BuddyPluginBuddy pluginBuddy : this.pluginBuddies) {
            version = Math.max(pluginBuddy.getVersion(), version);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPublicKey(String pk) {
        BuddyPluginBuddy pluginBuddy = VuzeBuddyManager.getBuddyPluginBuddyForVuze(pk);
        this.mon_pluginBuddies.enter();
        try {
            if (pluginBuddy != null && !this.pluginBuddies.contains(pluginBuddy)) {
                if (this.pluginBuddies.size() > 0) {
                    BuddyPluginBuddy template_buddy = this.pluginBuddies.getList().get(0);
                    Set<String> template_loc_cat = template_buddy.getLocalAuthorisedRSSCategories();
                    pluginBuddy.setLocalAuthorisedRSSCategories(template_loc_cat);
                }
                this.pluginBuddies.add(pluginBuddy);
            }
        }
        finally {
            this.mon_pluginBuddies.exit();
        }
        VuzeBuddyManager.linkPKtoBuddy(pk, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePublicKey(String pk) {
        this.mon_pluginBuddies.enter();
        try {
            Iterator<BuddyPluginBuddy> iter = this.pluginBuddies.iterator();
            while (iter.hasNext()) {
                BuddyPluginBuddy pluginBuddy = iter.next();
                if (!pluginBuddy.getPublicKey().equals(pk)) continue;
                iter.remove();
                if (pluginBuddy.getSubsystem() == 2) {
                    VuzeBuddyManager.log("Remove pk " + pk);
                    pluginBuddy.remove();
                    continue;
                }
                VuzeBuddyManager.log("Can't remove pk as it's not az3: " + pk);
            }
        }
        finally {
            this.mon_pluginBuddies.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPublicKeys() {
        this.mon_pluginBuddies.enter();
        try {
            String[] ret = new String[this.pluginBuddies.size()];
            int x = 0;
            for (BuddyPluginBuddy pluginBuddy : this.pluginBuddies) {
                ret[x++] = pluginBuddy.getPublicKey();
            }
            String[] stringArray = ret;
            return stringArray;
        }
        finally {
            this.mon_pluginBuddies.exit();
        }
    }

    @Override
    public void sendActivity(VuzeActivitiesEntry entry) throws NotLoggedInException {
        BuddyPluginBuddy[] buddies = this.pluginBuddies.toArray((BuddyPluginBuddy[])new BuddyPluginBuddy[0]);
        VuzeBuddyManager.sendActivity(entry, buddies);
    }

    @Override
    public void sendPayloadMap(Map map) throws NotLoggedInException {
        BuddyPluginBuddy[] buddies = this.pluginBuddies.toArray((BuddyPluginBuddy[])new BuddyPluginBuddy[0]);
        VuzeBuddyManager.sendPayloadMap(map, buddies);
    }

    @Override
    public void sendBuddyMessage(String namespace, Map map) throws NotLoggedInException {
        HashMap<String, Object> containerMap = new HashMap<String, Object>(3);
        containerMap.put("namespace", namespace);
        containerMap.put("VuzeMessageType", "BuddyMessage");
        containerMap.put("map", map);
        BuddyPluginBuddy[] buddies = this.pluginBuddies.toArray((BuddyPluginBuddy[])new BuddyPluginBuddy[0]);
        VuzeBuddyManager.sendPayloadMap(containerMap, buddies);
    }

    @Override
    public void shareDownload(VuzeShareable content, String message) throws NotLoggedInException {
        if (content == null) {
            return;
        }
        VuzeActivitiesEntryContentShare entry = new VuzeActivitiesEntryContentShare(content, message);
        entry.setBuddyID(LoginInfoManager.getInstance().getUserInfo().userName);
        this.sendActivity(entry);
    }

    @Override
    public void tellBuddyToSyncUp() throws NotLoggedInException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("VuzeMessageType", "BuddySync");
        this.sendPayloadMap(map);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getProfileAHREF(String referer) {
        return this.getProfileAHREF(referer, false);
    }

    @Override
    public String getProfileAHREF(String referer, boolean useImage) {
        StringBuffer buf = new StringBuffer();
        buf.append("<A HREF=\"");
        buf.append(this.getProfileUrl(referer));
        buf.append("\" TITLE=\"");
        buf.append(this.displayName);
        if (!this.loginID.equals(this.displayName)) {
            buf.append(" (");
            buf.append(this.loginID);
            buf.append(")");
        }
        buf.append("\">");
        if (useImage) {
            buf.append("%0 ");
        }
        buf.append(this.displayName);
        buf.append("</A>");
        return buf.toString();
    }

    @Override
    public String getProfileUrl(String referer) {
        return ConstantsVuze.getDefaultContentNetwork().getProfileService(this.getLoginID(), referer);
    }

    public int compare(Object arg0, Object arg1) {
        if (!(arg0 instanceof VuzeBuddy) || !(arg1 instanceof VuzeBuddy)) {
            return 0;
        }
        String c0 = ((VuzeBuddy)arg0).getDisplayName();
        String c1 = ((VuzeBuddy)arg1).getDisplayName();
        if (c0 == null) {
            c0 = "";
        }
        if (c1 == null) {
            c1 = "";
        }
        return c0.compareToIgnoreCase(c1);
    }

    public int compareTo(Object arg0) {
        return this.compare(this, arg0);
    }

    @Override
    public void setCreatedOn(long createdOn) {
        this.createdOn = createdOn;
    }

    @Override
    public long getCreatedOn() {
        return this.createdOn;
    }

    @Override
    public String toDebugString() {
        return "Buddy {" + this.loginID + "}";
    }

    @Override
    public void addListener(VuzeBuddyListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeListener(VuzeBuddyListener l) {
        this.listeners.remove(l);
    }

    @Override
    public VuzeBuddyListener[] getListeners() {
        return this.listeners.toArray(new VuzeBuddyListener[0]);
    }

    @Override
    public int getStoredChatMessageCount() {
        Iterator<BuddyPluginBuddy> it = this.pluginBuddies.iterator();
        int res = 0;
        while (it.hasNext()) {
            BuddyPluginBuddy pluginBuddy = it.next();
            List<BuddyPluginBuddyMessage> msgs = pluginBuddy.retrieveMessages(1);
            res += msgs.size();
        }
        return res;
    }

    @Override
    public List<ChatMessage> getStoredChatMessages() {
        Iterator<BuddyPluginBuddy> it = this.pluginBuddies.iterator();
        ArrayList<ChatMessage> result = new ArrayList<ChatMessage>();
        while (it.hasNext()) {
            BuddyPluginBuddy pluginBuddy = it.next();
            List<BuddyPluginBuddyMessage> msgs = pluginBuddy.retrieveMessages(1);
            for (int i = 0; i < msgs.size(); ++i) {
                try {
                    BuddyPluginBuddyMessage msg = msgs.get(i);
                    ChatMessage cm = ChatMessage.deserialise(msg);
                    if (cm == null) continue;
                    result.add(cm);
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public void storeChatMessage(ChatMessage msg) {
        String sender_pk = msg.getSenderPK();
        if (sender_pk != null) {
            BuddyPluginBuddy pluginBuddy = VuzeBuddyManager.getBuddyPluginBuddyForVuze(sender_pk);
            if (pluginBuddy == null) {
                VuzeBuddyManager.log("Can't persist message for " + sender_pk + ", buddy not found");
            } else {
                BuddyPluginBuddyMessage pm = pluginBuddy.storeMessage(1, msg.toMap());
                if (pm != null) {
                    msg.setPersistentMessage(pm);
                }
            }
        }
    }

    @Override
    public void deleteChatMessage(ChatMessage msg) {
        BuddyPluginBuddyMessage pm = msg.getPersistentMessage();
        if (pm != null) {
            pm.delete();
        }
    }

    @Override
    public Set<String> getSubscribableCategories() {
        Iterator<BuddyPluginBuddy> it = this.pluginBuddies.iterator();
        HashSet<String> result = new HashSet<String>();
        while (it.hasNext()) {
            BuddyPluginBuddy pluginBuddy = it.next();
            Set<String> x = pluginBuddy.getRemoteAuthorisedRSSCategories();
            if (x == null) continue;
            result.addAll(x);
        }
        return result;
    }

    @Override
    public boolean canSubscribeToCategory() {
        for (BuddyPluginBuddy pluginBuddy : this.pluginBuddies) {
            Set<String> x = pluginBuddy.getRemoteAuthorisedRSSCategories();
            if (x == null || x.size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubscribedToCategory(String category) {
        for (BuddyPluginBuddy pluginBuddy : this.pluginBuddies) {
            Subscription subs;
            if (!pluginBuddy.isRemoteRSSCategoryAuthorised(category) || (subs = this.lookupSubscription(pluginBuddy, category)) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSubscribedToCategory(String category, boolean subscribed) {
        for (BuddyPluginBuddy pluginBuddy : this.pluginBuddies) {
            Subscription subs = this.lookupSubscription(pluginBuddy, category);
            if (!subscribed) {
                if (subs == null) continue;
                subs.remove();
                continue;
            }
            if (subs != null || !pluginBuddy.isRemoteRSSCategoryAuthorised(category)) continue;
            try {
                pluginBuddy.subscribeToCategory(category);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected Subscription lookupSubscription(BuddyPluginBuddy buddy, String cat) {
        Subscription[] subs;
        for (Subscription s : subs = SubscriptionManagerFactory.getSingleton().getSubscriptions()) {
            if (!buddy.isSubscribedToCategory(cat, s.getCreatorRef())) continue;
            return s;
        }
        return null;
    }

    @Override
    public Set<String> getPublishedCategories() {
        Iterator<BuddyPluginBuddy> it = this.pluginBuddies.iterator();
        HashSet<String> result = new HashSet<String>();
        while (it.hasNext()) {
            BuddyPluginBuddy pluginBuddy = it.next();
            Set<String> x = pluginBuddy.getLocalAuthorisedRSSCategories();
            if (x == null) continue;
            result.addAll(x);
        }
        return result;
    }

    @Override
    public boolean isPublishedCategory(String category) {
        for (BuddyPluginBuddy pluginBuddy : this.pluginBuddies) {
            if (pluginBuddy.isLocalRSSCategoryAuthorised(category)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setPublishedCategory(String category, boolean published) {
        for (BuddyPluginBuddy pluginBuddy : this.pluginBuddies) {
            if (published) {
                pluginBuddy.addLocalAuthorisedRSSCategory(category);
                continue;
            }
            pluginBuddy.removeLocalAuthorisedRSSCategory(category);
        }
    }

    @Override
    public boolean canSetPublishedCategory(String category) {
        return VuzeBuddyManager.canSetPublishedCategory(category);
    }
}

