/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.buddy.impl;

import com.aelitis.azureus.activities.VuzeActivitiesBuddyInvited;
import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesEntryBuddyLinkup;
import com.aelitis.azureus.activities.VuzeActivitiesEntryBuddyRequest;
import com.aelitis.azureus.activities.VuzeActivitiesEntryContentShare;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.buddy.QueuedVuzeShare;
import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.VuzeBuddyCreator;
import com.aelitis.azureus.buddy.VuzeBuddyListener;
import com.aelitis.azureus.buddy.VuzeShareable;
import com.aelitis.azureus.buddy.impl.VuzeBuddyFakeImpl;
import com.aelitis.azureus.buddy.impl.VuzeBuddyImpl;
import com.aelitis.azureus.buddy.impl.VuzeBuddyMessageListener;
import com.aelitis.azureus.buddy.impl.VuzeQueuedShares;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.crypto.VuzeCryptoException;
import com.aelitis.azureus.core.crypto.VuzeCryptoListener;
import com.aelitis.azureus.core.crypto.VuzeCryptoManager;
import com.aelitis.azureus.core.messenger.PlatformAuthorizedSender;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformBuddyMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformKeyExchangeMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformRelayMessenger;
import com.aelitis.azureus.core.messenger.config.VuzeBuddySyncListener;
import com.aelitis.azureus.core.messenger.config.VuzeRelayListener;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessage;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessageListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyRequestListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.ILoginInfoListener;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.azureus.util.LoginInfoManager;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.StaticUtilities;

public class VuzeBuddyManager {
    private static final int SEND_P2P_TIMEOUT = 180000;
    protected static final boolean ALLOW_ONLY_AZ3 = true;
    private static final String SAVE_FILENAME = "v3.Friends.dat";
    public static final String VUZE_MESSAGE_TYPE = "VuzeMessageType";
    public static final String VMT_CHECKINVITES = "CheckInvites";
    public static final String VMT_BUDDYACCEPT = "BuddyAccept";
    public static final String VMT_ACTIVITYENTRY = "ActivityEntry";
    public static final String VMT_BUDDY_MESSAGE = "BuddyMessage";
    public static final String VMT_BUDDYSYNC = "BuddySync";
    private static final String UNKNOWN_MSG_TYPE = "Unknown Message Type";
    private static BuddyPlugin buddyPlugin = null;
    private static List buddyList = new ArrayList();
    private static AEMonitor buddy_mon = new AEMonitor("buddy list/map");
    private static Map mapPKtoVuzeBuddy = new HashMap();
    private static VuzeBuddyCreator vuzeBuddyCreator;
    private static List listeners;
    private static boolean saveDelayed;
    private static File configDir;
    private static ArrayList messageListeners;
    private static BuddyPluginBuddyMessageListener buddy_message_handler_listener;
    private static VuzeCryptoListener vuzeCryptoListener;
    private static ILoginInfoListener loginInfoListener;
    private static VuzeRelayListener vuzeRelayListener;
    private static BuddyPluginListener buddyPluginListener;
    private static BuddyPluginBuddyRequestListener buddyPluginBuddyRequestListener;
    private static boolean pluginEnabled;
    private static boolean skipOrderChangedListener;

    public static void init(VuzeBuddyCreator vuzeBuddyCreator) {
        VuzeBuddyManager.vuzeBuddyCreator = vuzeBuddyCreator;
        PlatformMessenger.setAuthorizedDelayed(true);
        configDir = new File(SystemProperties.getUserPath());
        VuzeBuddyManager.setupBuddyPlugin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupBuddyPlugin() {
        VuzeBuddyManager.setSaveDelayed(true);
        try {
            VuzeBuddyManager.log("setupBuddyPlugin");
            boolean newPluginEnabled = false;
            try {
                Plugin plugin;
                PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azbuddy");
                if (pi != null && (plugin = pi.getPlugin()) instanceof BuddyPlugin) {
                    ((BuddyPlugin)plugin).addListener(buddyPluginListener);
                    if (!pi.getPluginState().isDisabled()) {
                        buddyPlugin = (BuddyPlugin)plugin;
                        newPluginEnabled = buddyPlugin.isEnabled();
                    }
                }
            }
            catch (Throwable t) {
                Debug.out(t);
            }
            if (buddyPlugin == null) {
                return;
            }
            if (newPluginEnabled == pluginEnabled) {
                return;
            }
            pluginEnabled = newPluginEnabled;
            if (!pluginEnabled) {
                buddyPlugin.removeRequestListener(buddyPluginBuddyRequestListener);
                buddyPlugin = null;
                VuzeCryptoManager.getSingleton().removeListener(vuzeCryptoListener);
                PlatformRelayMessenger.removeRelayServerListener(vuzeRelayListener);
                try {
                    buddy_mon.enter();
                    Object[] buddyArray = buddyList.toArray();
                    for (int i = 0; i < buddyArray.length; ++i) {
                        VuzeBuddy buddy = (VuzeBuddy)buddyArray[i];
                        try {
                            VuzeBuddyManager.removeBuddy(buddy, false);
                            continue;
                        }
                        catch (NotLoggedInException e) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    buddy_mon.exit();
                }
                return;
            }
            buddyPlugin.addRequestListener(buddyPluginBuddyRequestListener);
            List<BuddyPluginBuddy> buddies = buddyPlugin.getBuddies();
            for (int i = 0; i < buddies.size(); ++i) {
                BuddyPluginBuddy buddy = buddies.get(i);
                if (!VuzeBuddyManager.canHandleBuddy(buddy)) continue;
                buddyPluginListener.buddyAdded(buddy);
            }
            VuzeQueuedShares.init(configDir);
            try {
                VuzeBuddyManager.loadVuzeBuddies();
                VuzeCryptoManager.getSingleton().addListener(vuzeCryptoListener);
                PlatformRelayMessenger.addRelayServerListener(vuzeRelayListener);
                PlatformRelayMessenger.relayCheck();
            }
            catch (Throwable t) {
                Debug.out(t);
            }
            LoginInfoManager.getInstance().addListener(loginInfoListener);
        }
        finally {
            VuzeBuddyManager.setSaveDelayed(false);
        }
    }

    protected static void loginUpdateTriggered(final LoginInfoManager.LoginInfo info, boolean isNewLoginID) {
        boolean inited;
        if (!isNewLoginID) {
            return;
        }
        if (!pluginEnabled && (inited = COConfigurationManager.getBooleanParameter("vuze.crypto.manager.initial.login.done", false))) {
            return;
        }
        if (info.userName == null || info.userName.length() == 0) {
            VuzeBuddyManager.log("Logging out.. clearing password");
            VuzeCryptoManager.getSingleton().clearPassword();
            PlatformMessenger.setAuthorizedDelayed(true);
        } else {
            VuzeBuddyManager.log("Logging in.. getting pw from webapp");
            try {
                PlatformKeyExchangeMessenger.getPassword(new PlatformKeyExchangeMessenger.platformPasswordListener(){

                    public void passwordRetrieved() {
                        String myPK = null;
                        try {
                            myPK = VuzeCryptoManager.getSingleton().getPublicKey(null);
                        }
                        catch (VuzeCryptoException e) {
                            // empty catch block
                        }
                        if (myPK != null && !myPK.equals(info.pk)) {
                            VuzeBuddyManager.log("webapp's PK (" + info.pk + ") doesn't match.  Sending out PK");
                            try {
                                PlatformKeyExchangeMessenger.setPublicKey();
                            }
                            catch (NotLoggedInException e) {
                                VuzeBuddyManager.log("SPK failed. User must have logged out between getPassword and setPK");
                            }
                        }
                        PlatformMessenger.setAuthorizedDelayed(false);
                        try {
                            PlatformBuddyMessenger.sync(new VuzeBuddySyncListener(){

                                public void syncComplete() {
                                    PlatformRelayMessenger.relayCheck();
                                }
                            });
                            PlatformBuddyMessenger.getInvites();
                        }
                        catch (NotLoggedInException e) {
                            PlatformRelayMessenger.relayCheck();
                            VuzeBuddyManager.log("OOPS, sync or getInvite failed because you were no longer logged in");
                        }
                        if (buddyPlugin != null) {
                            String nickname = buddyPlugin.getNickname();
                            if (myPK != null && (nickname == null || nickname.length() == 0)) {
                                buddyPlugin.setNickname(info.userName + " (" + myPK.substring(0, 3) + ")");
                            }
                        }
                    }

                    public void passwordRetrievalFailed() {
                        try {
                            String url = ContentNetworkUtils.getUrl(ConstantsVuze.getDefaultContentNetwork(), 23);
                            PlatformAuthorizedSender sender = PlatformMessenger.getAuthorizedTransferListener();
                            AESemaphore sem = new AESemaphore("logoutWait");
                            sender.startDownload(new URL(url), null, sem, false);
                            sem.reserve();
                            LoginInfoManager.getInstance().logout();
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (NotLoggedInException e) {
                VuzeBuddyManager.log("calling getPassword RPC afer login failed because we aren't logged in?");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String processPayloadMap(final String pkSender, final Map mapPayload, final boolean authorizedBuddy, final long addedOn, boolean retryAuthFail) {
        block25: {
            String mt;
            block24: {
                block23: {
                    mt = MapUtils.getMapString(mapPayload, VUZE_MESSAGE_TYPE, "");
                    VuzeBuddyManager.log("processing payload " + mt + ";auth=" + authorizedBuddy);
                    if (!mt.equals(VMT_ACTIVITYENTRY)) break block23;
                    Map mapEntry2 = (Map)MapUtils.getMapObject(mapPayload, VMT_ACTIVITYENTRY, new HashMap(), Map.class);
                    VuzeActivitiesEntry entry = VuzeActivitiesManager.createEntryFromMap(mapEntry2, true);
                    if (entry != null) {
                        entry.setTimestamp(addedOn);
                        if (authorizedBuddy) {
                            VuzeActivitiesManager.addEntries(new VuzeActivitiesEntry[]{entry});
                            return "Ok";
                        }
                        if ("buddy-request".equals(entry.getTypeID())) {
                            VuzeActivitiesManager.addEntries(new VuzeActivitiesEntry[]{entry});
                            return "Ok";
                        }
                        if (!retryAuthFail) {
                            VuzeBuddyManager.log("Not authorized to add activity " + entry.getID() + ";" + entry.getTypeID());
                            return "Not Authorized";
                        }
                        try {
                            PlatformBuddyMessenger.sync(new String[]{pkSender}, new VuzeBuddySyncListener(){

                                public void syncComplete() {
                                    VuzeBuddyManager.processPayloadMap(pkSender, mapPayload, authorizedBuddy, addedOn, false);
                                }
                            });
                        }
                        catch (NotLoggedInException e) {
                            VuzeBuddyManager.log(e);
                        }
                    }
                    break block24;
                }
                if (authorizedBuddy && mt.equals(VMT_BUDDYSYNC)) {
                    try {
                        PlatformBuddyMessenger.sync(null);
                        return "Ok";
                    }
                    catch (NotLoggedInException e) {
                        // empty catch block
                    }
                    return "Ok";
                }
                if (mt.equals(VMT_CHECKINVITES)) {
                    try {
                        PlatformBuddyMessenger.getInvites();
                        return "Ok";
                    }
                    catch (NotLoggedInException e) {
                        // empty catch block
                    }
                    return "Ok";
                }
                if (mt.equals(VMT_BUDDYACCEPT)) {
                    String code = MapUtils.getMapString(mapPayload, "BuddyAcceptCode", null);
                    VuzeQueuedShares.updateSharePK(code, pkSender);
                    VuzeBuddy buddyByPK = VuzeBuddyManager.getBuddyByPK(pkSender);
                    if (buddyByPK != null) {
                        VuzeBuddyManager.sendQueudShares(buddyByPK);
                        return "Ok";
                    }
                    try {
                        PlatformBuddyMessenger.sync(null);
                        return "Ok";
                    }
                    catch (NotLoggedInException e) {
                        VuzeBuddyManager.log("Not Logged in, yet we were able to decrypt the BuddyAccept message.  Amazing!");
                        VuzeBuddyManager.log(e);
                    }
                    return "Ok";
                }
                if (mt.equals(VMT_BUDDY_MESSAGE)) break block25;
            }
            VuzeBuddyManager.log("processPayLoadMap from " + pkSender + ": Unknown Message Type " + mt);
            return UNKNOWN_MSG_TYPE;
        }
        VuzeBuddy buddyByPK = VuzeBuddyManager.getBuddyByPK(pkSender);
        String namespace = MapUtils.getMapString(mapPayload, "namespace", null);
        Map map = MapUtils.getMapMap(mapPayload, "map", null);
        Object[] listeners = messageListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            VuzeBuddyMessageListener l = (VuzeBuddyMessageListener)listeners[i];
            try {
                l.messageRecieved(buddyByPK, pkSender, namespace, addedOn, map);
            }
            catch (Exception e) {
                VuzeBuddyManager.log(e);
            }
            ++i;
        }
        return "Ok";
    }

    private static boolean canHandleBuddy(BuddyPluginBuddy buddy) {
        if (!VuzeBuddyManager.isEnabled() || buddy == null) {
            return false;
        }
        int subsystem = buddy.getSubsystem();
        return subsystem == 2;
    }

    public static BuddyPlugin getBuddyPlugin() {
        return buddyPlugin;
    }

    public static boolean canSetPublishedCategory(String category) {
        if (buddyPlugin == null) {
            return false;
        }
        return !buddyPlugin.isPublicCategory(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllVuzeBuddies() {
        try {
            buddy_mon.enter();
            ArrayList arrayList = new ArrayList(buddyList);
            return arrayList;
        }
        finally {
            buddy_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VuzeBuddy getBuddyByPK(String pk) {
        try {
            buddy_mon.enter();
            VuzeBuddy vuzeBuddy = (VuzeBuddy)mapPKtoVuzeBuddy.get(pk);
            return vuzeBuddy;
        }
        finally {
            buddy_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VuzeBuddy getBuddyByLoginID(String loginID) {
        if (loginID == null) {
            return null;
        }
        loginID = loginID.toLowerCase();
        try {
            buddy_mon.enter();
            for (VuzeBuddy buddy : buddyList) {
                String loginID2 = buddy.getLoginID();
                if (loginID2 == null || !loginID.equals(loginID2.toLowerCase())) continue;
                VuzeBuddy vuzeBuddy = buddy;
                return vuzeBuddy;
            }
        }
        finally {
            buddy_mon.exit();
        }
        return null;
    }

    public static void log(String s) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.Friends");
        diag_logger.log(s);
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + s);
        }
    }

    public static void log(Exception e) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.Friends");
        diag_logger.log(e);
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.err.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] ");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBuddy(VuzeBuddy buddy, boolean createActivityEntry) {
        try {
            buddy_mon.enter();
            int index = Collections.binarySearch(buddyList, buddy);
            if (index < 0) {
                VuzeBuddyManager.log("Add new buddy '" + buddy.getDisplayName() + "' to Manager; #pk:" + buddy.getPublicKeys().length);
                index = -1 * index - 1;
                buddyList.add(index, buddy);
                if (createActivityEntry) {
                    VuzeActivitiesEntryBuddyLinkup entry = new VuzeActivitiesEntryBuddyLinkup(buddy);
                    VuzeActivitiesManager.addEntries(new VuzeActivitiesEntry[]{entry});
                }
                VuzeBuddyManager.triggerAddListener(buddy, index);
                VuzeBuddyManager.saveVuzeBuddies();
            }
        }
        finally {
            buddy_mon.exit();
        }
        VuzeBuddyManager.sendQueudShares(buddy);
        if (createActivityEntry) {
            VuzeBuddyManager.removeInviteActivities(buddy.getLoginID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getBuddyPosition(VuzeBuddy buddy) {
        try {
            buddy_mon.enter();
            long l = Collections.binarySearch(buddyList, buddy);
            return l;
        }
        finally {
            buddy_mon.exit();
        }
    }

    private static void sendQueudShares(VuzeBuddy buddy) {
        String[] publicKeys = buddy.getPublicKeys();
        for (int i = 0; i < publicKeys.length; ++i) {
            String pk = publicKeys[i];
            List shares = VuzeQueuedShares.getSharesByPK(pk);
            for (QueuedVuzeShare share : shares) {
                VuzeActivitiesEntry entry = share.getActivityEntry();
                try {
                    buddy.sendActivity(entry);
                    VuzeQueuedShares.remove(share);
                }
                catch (NotLoggedInException e) {
                    VuzeBuddyManager.log("Not logged in: Sending Queued Share");
                }
            }
        }
    }

    public static VuzeBuddy createNewBuddy(BuddyPluginBuddy buddy, boolean createActivityEntry) {
        String pk = buddy.getPublicKey();
        VuzeBuddy newBuddy = vuzeBuddyCreator == null ? new VuzeBuddyImpl(pk) : vuzeBuddyCreator.createBuddy(pk);
        if (newBuddy == null) {
            return null;
        }
        if (newBuddy != null) {
            newBuddy.setDisplayName(buddy.getName());
        }
        VuzeBuddyManager.getBuddyPluginBuddyForVuze(pk);
        VuzeBuddyManager.addBuddy(newBuddy, createActivityEntry);
        return newBuddy;
    }

    public static VuzeBuddy createNewBuddy(Map mapNewBuddy, boolean createActivityEntry) {
        VuzeBuddy newBuddy = VuzeBuddyManager.createNewBuddyNoAdd(mapNewBuddy);
        if (newBuddy != null) {
            VuzeBuddyManager.addBuddy(newBuddy, createActivityEntry);
        }
        return newBuddy;
    }

    public static VuzeBuddy createNewBuddyNoAdd(Map mapNewBuddy) {
        if (buddyPlugin == null) {
            return null;
        }
        VuzeBuddy existingBuddy = VuzeBuddyManager.getBuddyByLoginID(MapUtils.getMapString(mapNewBuddy, "login-id", null));
        if (existingBuddy != null) {
            return existingBuddy;
        }
        VuzeBuddy newBuddy = vuzeBuddyCreator == null ? new VuzeBuddyImpl() : vuzeBuddyCreator.createBuddy();
        if (newBuddy == null) {
            return null;
        }
        newBuddy.loadFromMap(mapNewBuddy);
        return newBuddy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBuddy(VuzeBuddy buddy, boolean login) throws NotLoggedInException {
        if (buddy == null) {
            return;
        }
        try {
            buddy_mon.enter();
            if (!buddyList.contains(buddy)) {
                VuzeBuddyManager.log("Buddy " + buddy.getDisplayName() + ";" + buddy.getLoginID() + " already removed via " + Debug.getCompressedStackTrace());
                return;
            }
            VuzeBuddyManager.log("Removing Buddy " + buddy.getDisplayName() + ";" + buddy.getLoginID());
            buddyList.remove(buddy);
            String[] publicKeys = buddy.getPublicKeys();
            for (int i = 0; i < publicKeys.length; ++i) {
                String pk = publicKeys[i];
                buddy.removePublicKey(pk);
                mapPKtoVuzeBuddy.remove(pk);
            }
            VuzeBuddyManager.triggerRemoveListener(buddy);
        }
        finally {
            buddy_mon.exit();
        }
        if (buddy.getLoginID() != null && buddyPlugin != null) {
            PlatformBuddyMessenger.remove(buddy, login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBuddiesOlderThan(long updateTime, boolean tellPlatform) {
        try {
            buddy_mon.enter();
            Object[] buddyArray = buddyList.toArray();
            for (int i = 0; i < buddyArray.length; ++i) {
                VuzeBuddy buddy = (VuzeBuddy)buddyArray[i];
                if (buddy.getLastUpdated() >= updateTime) continue;
                VuzeBuddyManager.log("Removing Buddy " + buddy.getDisplayName() + ";" + buddy.getLoginID() + ";updateTime=" + updateTime + ";buddyTime" + buddy.getLastUpdated());
                buddyList.remove(buddy);
                String[] publicKeys = buddy.getPublicKeys();
                for (int j = 0; j < publicKeys.length; ++j) {
                    String pk = publicKeys[j];
                    mapPKtoVuzeBuddy.remove(pk);
                    buddy.removePublicKey(pk);
                }
                VuzeBuddyManager.triggerRemoveListener(buddy);
                if (!tellPlatform || buddy.getLoginID() == null) continue;
                try {
                    PlatformBuddyMessenger.remove(buddy, false);
                    continue;
                }
                catch (NotLoggedInException e) {
                    // empty catch block
                }
            }
            VuzeBuddyManager.saveVuzeBuddies();
        }
        finally {
            buddy_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void linkPKtoBuddy(String pk, VuzeBuddy buddy) {
        try {
            buddy_mon.enter();
            VuzeBuddy existingBuddy = (VuzeBuddy)mapPKtoVuzeBuddy.get(pk);
            if (existingBuddy != null) {
                if (!existingBuddy.getLoginID().equalsIgnoreCase(buddy.getLoginID())) {
                    VuzeBuddyManager.log("DANGER: Changing PK's user from " + existingBuddy.getLoginID() + " to " + buddy.getLoginID());
                    mapPKtoVuzeBuddy.put(pk, buddy);
                }
            } else {
                VuzeBuddyManager.log("add PK " + pk + " to " + buddy.getLoginID());
                mapPKtoVuzeBuddy.put(pk, buddy);
            }
        }
        finally {
            buddy_mon.exit();
        }
    }

    protected static BuddyPluginBuddy getBuddyPluginBuddyForVuze(String pk) {
        if (buddyPlugin == null) {
            return null;
        }
        return buddyPlugin.addBuddy(pk, 2);
    }

    private static void invitePKs(String[] pks, String code) {
        if (buddyPlugin == null) {
            return;
        }
        if (pks != null && pks.length > 0) {
            final BuddyPluginBuddy[] pluginBuddies = new BuddyPluginBuddy[pks.length];
            for (int i = 0; i < pks.length; ++i) {
                String pk = pks[i];
                pluginBuddies[i] = buddyPlugin.addBuddy(pk, 2);
            }
            SimpleTimer.addEvent("send invites", SystemTime.getOffsetTime(10000L), new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(VuzeBuddyManager.VUZE_MESSAGE_TYPE, VuzeBuddyManager.VMT_CHECKINVITES);
                    try {
                        VuzeBuddyManager.sendPayloadMap(map, pluginBuddies);
                    }
                    catch (NotLoggedInException e) {
                        VuzeBuddyManager.log(e);
                    }
                }
            });
        }
    }

    public static void inviteWithShare(final Map invites, final VuzeShareable contentToShare, final String shareMessage, final VuzeBuddy[] buddies) throws NotLoggedInException {
        if (!LoginInfoManager.getInstance().isLoggedIn()) {
            throw new NotLoggedInException();
        }
        new AEThread2("inviteWithShare", true){

            public void run() {
                try {
                    VuzeBuddyManager._inviteWithShare(invites, contentToShare, shareMessage, buddies);
                }
                catch (NotLoggedInException e) {
                    Debug.out(e);
                }
            }
        }.start();
    }

    private static void _inviteWithShare(Map invites, VuzeShareable contentToShare, String shareMessage, VuzeBuddy[] buddies) throws NotLoggedInException {
        Map inviteMessage;
        if (!LoginInfoManager.getInstance().isLoggedIn()) {
            throw new NotLoggedInException();
        }
        String name = "na";
        if (contentToShare != null) {
            DownloadManager dm = contentToShare.getDownloadManager();
            String string = name = dm == null ? contentToShare.getDisplayName() : dm.toString();
        }
        if (buddies != null && contentToShare != null) {
            VuzeBuddyManager.log("share " + name + " with " + buddies.length + " existing buddies");
            for (int i = 0; i < buddies.length; ++i) {
                VuzeBuddy v3Buddy = buddies[i];
                if (v3Buddy == null) continue;
                v3Buddy.shareDownload(contentToShare, shareMessage);
            }
        }
        if ((inviteMessage = MapUtils.getMapMap(invites, "message", null)) == null) {
            inviteMessage = invites;
        }
        List sentInvitations = MapUtils.getMapList(inviteMessage, "sentInvitations", Collections.EMPTY_LIST);
        VuzeBuddyManager.log("invite " + sentInvitations.size() + " ppl, sharing " + name);
        ArrayList<String[]> displayNames = new ArrayList<String[]>();
        for (Map mapInvitation : sentInvitations) {
            boolean success = MapUtils.getMapBoolean(mapInvitation, "success", false);
            if (!success) continue;
            String code = MapUtils.getMapString(mapInvitation, "code", null);
            if (contentToShare != null) {
                VuzeBuddyManager.queueShare(contentToShare, shareMessage, code);
            }
            List pkList = MapUtils.getMapList(mapInvitation, "pks", Collections.EMPTY_LIST);
            String[] newPKs = pkList.toArray(new String[0]);
            VuzeBuddyManager.invitePKs(newPKs, code);
            String[] nameArray = new String[]{MapUtils.getMapString(mapInvitation, "value", "???"), MapUtils.getMapString(mapInvitation, "display-name", null)};
            displayNames.add(nameArray);
        }
        if (displayNames.size() > 0) {
            VuzeActivitiesBuddyInvited entry = new VuzeActivitiesBuddyInvited(displayNames);
            VuzeActivitiesManager.addEntries(new VuzeActivitiesEntry[]{entry});
        }
    }

    private static void queueShare(VuzeShareable content, String message, String code) {
        if (content == null) {
            return;
        }
        try {
            VuzeActivitiesEntryContentShare entry = new VuzeActivitiesEntryContentShare(content, message);
            QueuedVuzeShare vuzeShare = VuzeQueuedShares.add(code);
            vuzeShare.setDownloadHash(entry.getAssetHash());
            vuzeShare.setActivityEntry(entry);
            VuzeQueuedShares.save();
        }
        catch (NotLoggedInException e) {
            Debug.out(e);
        }
    }

    public static void removeInviteActivities(String fromLoginID) {
        if (fromLoginID == null) {
            return;
        }
        ArrayList<VuzeActivitiesEntry> requestEntries = new ArrayList<VuzeActivitiesEntry>();
        VuzeActivitiesEntry[] allEntries = VuzeActivitiesManager.getAllEntries();
        for (int i = 0; i < allEntries.length; ++i) {
            VuzeActivitiesEntryBuddyRequest inviteEntry;
            VuzeActivitiesEntry entry = allEntries[i];
            if (!(entry instanceof VuzeActivitiesEntryBuddyRequest) || !fromLoginID.equals((inviteEntry = (VuzeActivitiesEntryBuddyRequest)entry).getBuddy().getLoginID())) continue;
            requestEntries.add(entry);
        }
        if (requestEntries.size() > 0) {
            VuzeActivitiesEntry[] toRemove = requestEntries.toArray(new VuzeActivitiesEntry[requestEntries.size()]);
            VuzeActivitiesManager.removeEntries(toRemove);
        }
    }

    public static void acceptInvite(final String code, final String[] pks) throws NotLoggedInException {
        if (!VuzeBuddyManager.isEnabled()) {
            VuzeBuddyManager.showDisabledDialog();
            return;
        }
        PlatformBuddyMessenger.sync(new VuzeBuddySyncListener(){

            public void syncComplete() {
                VuzeBuddyManager.log("Sending Invite Accept; code=" + code);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(VuzeBuddyManager.VUZE_MESSAGE_TYPE, VuzeBuddyManager.VMT_BUDDYACCEPT);
                map.put("BuddyAcceptCode", code);
                for (int i = 0; i < pks.length; ++i) {
                    String pk = pks[i];
                    VuzeBuddy buddy = VuzeBuddyManager.getBuddyByPK(pk);
                    if (buddy == null) continue;
                    try {
                        buddy.sendPayloadMap(map);
                    }
                    catch (NotLoggedInException e) {
                        VuzeBuddyManager.log("Not Logged In: Accept Invite");
                    }
                    break;
                }
            }
        });
    }

    protected static void sendActivity(VuzeActivitiesEntry entry, BuddyPluginBuddy[] buddies) throws NotLoggedInException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(VUZE_MESSAGE_TYPE, VMT_ACTIVITYENTRY);
        map.put(VMT_ACTIVITYENTRY, entry.toMap());
        VuzeBuddyManager.sendPayloadMap(map, buddies);
    }

    public static void sendPayloadMap(Map map, BuddyPluginBuddy[] buddies) throws NotLoggedInException {
        if (buddyPlugin == null) {
            return;
        }
        if (!LoginInfoManager.getInstance().isLoggedIn()) {
            throw new NotLoggedInException();
        }
        try {
            VuzeBuddyManager.log("sending map to " + buddies.length + " PKs");
            for (int i = 0; i < buddies.length; ++i) {
                BuddyPluginBuddy pluginBuddy = buddies[i];
                pluginBuddy.getMessageHandler().queueMessage(2, map, 180000);
            }
        }
        catch (BuddyPluginException e) {
            VuzeBuddyManager.log(e);
        }
    }

    public static void addListener(VuzeBuddyListener l, boolean trigger) {
        if (!listeners.contains(l)) {
            listeners.add(l);
        }
        if (trigger) {
            Object[] buddies = buddyList.toArray();
            for (int i = 0; i < buddies.length; ++i) {
                VuzeBuddy buddy = (VuzeBuddy)buddies[i];
                l.buddyAdded(buddy, i);
            }
        }
    }

    public static void removeListener(VuzeBuddyListener l) {
        listeners.remove(l);
    }

    private static void triggerRemoveListener(VuzeBuddy buddy) {
        Object[] listenersArray = listeners.toArray();
        for (int i = 0; i < listenersArray.length; ++i) {
            VuzeBuddyListener l = (VuzeBuddyListener)listenersArray[i];
            l.buddyRemoved(buddy);
        }
        VuzeBuddyListener[] buddyListeners = buddy.getListeners();
        for (int i = 0; i < buddyListeners.length; ++i) {
            VuzeBuddyListener l = buddyListeners[i];
            l.buddyRemoved(buddy);
        }
    }

    private static void triggerAddListener(VuzeBuddy buddy, int position) {
        Object[] listenersArray = listeners.toArray();
        for (int i = 0; i < listenersArray.length; ++i) {
            VuzeBuddyListener l = (VuzeBuddyListener)listenersArray[i];
            l.buddyAdded(buddy, position);
        }
        VuzeBuddyListener[] buddyListeners = buddy.getListeners();
        for (int i = 0; i < buddyListeners.length; ++i) {
            VuzeBuddyListener l = buddyListeners[i];
            l.buddyAdded(buddy, position);
        }
    }

    protected static void triggerChangeListener(VuzeBuddy buddy) {
        VuzeBuddyManager.triggerChangeListener(buddy, false);
    }

    protected static void triggerChangeListener(VuzeBuddy buddy, boolean save) {
        if (!buddyList.contains(buddy)) {
            return;
        }
        if (save) {
            VuzeBuddyManager.saveVuzeBuddies();
        }
        Object[] listenersArray = listeners.toArray();
        for (int i = 0; i < listenersArray.length; ++i) {
            VuzeBuddyListener l = (VuzeBuddyListener)listenersArray[i];
            l.buddyChanged(buddy);
        }
        VuzeBuddyListener[] buddyListeners = buddy.getListeners();
        for (int i = 0; i < buddyListeners.length; ++i) {
            VuzeBuddyListener l = buddyListeners[i];
            l.buddyChanged(buddy);
        }
    }

    protected static void triggerOrderChangedListener() {
        if (skipOrderChangedListener) {
            return;
        }
        Collections.sort(buddyList);
        Object[] listenersArray = listeners.toArray();
        for (int i = 0; i < listenersArray.length; ++i) {
            VuzeBuddyListener l = (VuzeBuddyListener)listenersArray[i];
            l.buddyOrderChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveVuzeBuddies() {
        if (VuzeBuddyManager.isSaveDelayed()) {
            return;
        }
        VuzeBuddyManager.log("save " + Debug.getCompressedStackTrace());
        HashMap mapSave = new HashMap();
        ArrayList<Map> storedBuddyList = new ArrayList<Map>();
        mapSave.put("buddies", storedBuddyList);
        try {
            buddy_mon.enter();
            for (VuzeBuddy buddy : buddyList) {
                if (buddy == null) continue;
                storedBuddyList.add(buddy.toMap());
            }
            FileUtil.writeResilientFile(configDir, SAVE_FILENAME, mapSave, true);
        }
        finally {
            buddy_mon.exit();
        }
    }

    private static void loadVuzeBuddies() {
        Map map = FileUtil.readResilientFile(configDir, SAVE_FILENAME, true);
        skipOrderChangedListener = true;
        List storedBuddyList = MapUtils.getMapList(map, "buddies", Collections.EMPTY_LIST);
        for (Map mapBuddy : storedBuddyList) {
            VuzeBuddyManager.createNewBuddy(mapBuddy, false);
        }
        skipOrderChangedListener = false;
        VuzeBuddyManager.triggerOrderChangedListener();
    }

    public static VuzeBuddy createPotentialBuddy(Map mapBuddy) {
        VuzeBuddy newBuddy = vuzeBuddyCreator == null ? new VuzeBuddyFakeImpl(mapBuddy) : vuzeBuddyCreator.createPotentialBuddy(mapBuddy);
        return newBuddy;
    }

    public static VuzeBuddy getOrCreatePotentialBuddy(Map mapBuddy) {
        VuzeBuddy vuzeBuddy;
        String loginID = MapUtils.getMapString(mapBuddy, "login-id", null);
        if (loginID != null && (vuzeBuddy = VuzeBuddyManager.getBuddyByLoginID(loginID)) != null) {
            return vuzeBuddy;
        }
        return VuzeBuddyManager.createPotentialBuddy(mapBuddy);
    }

    public static boolean isEnabled() {
        return pluginEnabled;
    }

    public static void showDisabledDialog() {
        UIFunctions uif = UIFunctionsManager.getUIFunctions();
        if (uif != null) {
            uif.promptUser(MessageText.getString("v3.buddies.disabled.title"), MessageText.getString("v3.buddies.disabled.text"), new String[]{MessageText.getString("Button.ok")}, 0, null, null, false, 0);
        }
    }

    public static void setSaveDelayed(boolean saveDelayed) {
        if (VuzeBuddyManager.saveDelayed != saveDelayed) {
            VuzeBuddyManager.saveDelayed = saveDelayed;
            if (!saveDelayed) {
                VuzeBuddyManager.saveVuzeBuddies();
            }
        }
    }

    public static boolean isSaveDelayed() {
        return saveDelayed;
    }

    public static String generateBuddyAHREF(String loginID, String displayName, String referer) {
        StringBuffer buf = new StringBuffer();
        buf.append("<A HREF=\"");
        buf.append(ConstantsVuze.getDefaultContentNetwork().getProfileService(loginID, referer));
        buf.append("\" TITLE=\"");
        buf.append(displayName);
        if (!loginID.equals(displayName)) {
            buf.append(" (");
            buf.append(loginID);
            buf.append(")");
        }
        buf.append("\">");
        buf.append(displayName);
        buf.append("</A>");
        return buf.toString();
    }

    public static void addMessageListener(VuzeBuddyMessageListener l) {
        if (!messageListeners.contains(l)) {
            messageListeners.add(l);
        }
    }

    public static void removeMessageListener(VuzeBuddyMessageListener l) {
        messageListeners.remove(l);
    }

    static {
        listeners = new ArrayList();
        saveDelayed = true;
        messageListeners = new ArrayList(1);
        buddy_message_handler_listener = new BuddyPluginBuddyMessageListener(){
            private Set pending_messages = new HashSet();
            private int consecutive_fails = 0;
            private long last_send_attempt;

            public void messageQueued(BuddyPluginBuddyMessage message) {
            }

            public void messageDeleted(BuddyPluginBuddyMessage message) {
            }

            public boolean deliverySucceeded(BuddyPluginBuddyMessage message, Map reply) {
                if (message.getSubsystem() != 2) {
                    return true;
                }
                VuzeBuddyManager.log("REPLY REC " + (message.getBuddy() == null ? "" : message.getBuddy().getName()) + JSONUtils.encodeToJSON(reply));
                String response = MapUtils.getMapString(reply, "response", "");
                if (response.equals(VuzeBuddyManager.UNKNOWN_MSG_TYPE)) {
                    try {
                        Map map = message.getRequest();
                        VuzeBuddyManager.log("  " + response + "; " + MapUtils.getMapString(map, VuzeBuddyManager.VUZE_MESSAGE_TYPE, "null"));
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    return true;
                }
                if (!response.toLowerCase().equals("ok")) {
                    this.sendViaRelayServer(message);
                    return false;
                }
                return true;
            }

            public void deliveryFailed(BuddyPluginBuddyMessage message, BuddyPluginException cause) {
                if (message.getSubsystem() != 2) {
                    return;
                }
                BuddyPluginBuddy buddy = message.getBuddy();
                VuzeBuddyManager.log("SEND FAILED " + buddy.getPublicKey() + "\n" + cause);
                if (!message.isDeleted()) {
                    this.sendViaRelayServer(message);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void sendViaRelayServer(BuddyPluginBuddyMessage message) {
                Set set = this.pending_messages;
                synchronized (set) {
                    if (this.pending_messages.contains(message)) {
                        return;
                    }
                    long now = SystemTime.getCurrentTime();
                    if (this.last_send_attempt > now) {
                        this.last_send_attempt = now;
                    }
                    if (this.consecutive_fails > 1) {
                        long delay_remaining;
                        long delay = 300000L;
                        int MAX_DELAY = 14400000;
                        for (int i = 2; i <= this.consecutive_fails; ++i) {
                            if ((delay <<= 1) <= 14400000L) continue;
                            delay = 14400000L;
                            break;
                        }
                        if ((delay_remaining = delay - (now - this.last_send_attempt)) > 0L) {
                            VuzeBuddyManager.log("RELAY: deferring put due to repeated failures (retry in " + delay_remaining + ")");
                            return;
                        }
                    }
                    this.pending_messages.add(message);
                    this.last_send_attempt = now;
                }
                PlatformRelayMessenger.put(message, 500L, new PlatformRelayMessenger.putListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void putOK(BuddyPluginBuddyMessage message) {
                        try {
                            try {
                                BuddyPluginBuddy buddy = message.getBuddy();
                                buddy.setMessagePending();
                                VuzeBuddyManager.log("Sending YGM to " + buddy.getName());
                            }
                            catch (Exception e) {
                                VuzeBuddyManager.log(e);
                            }
                            message.delete();
                        }
                        finally {
                            Set set = pending_messages;
                            synchronized (set) {
                                pending_messages.remove(message);
                                consecutive_fails = 0;
                                VuzeBuddyManager.log("RELAY: put ok - resetting consec fails");
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void putFailed(BuddyPluginBuddyMessage message, Throwable cause) {
                        Set set = pending_messages;
                        synchronized (set) {
                            pending_messages.remove(message);
                            consecutive_fails++;
                            VuzeBuddyManager.log("RELAY: put failed - " + Debug.getNestedExceptionMessage(cause) + ", consec fails=" + consecutive_fails);
                        }
                    }
                });
            }
        };
        vuzeCryptoListener = new VuzeCryptoListener(){
            private AESemaphore warning_sem = new AESemaphore("VBM:pwwarning", 1);
            private int consec_bad_passwords;
            private long first_bad_password = -1L;
            private long last_warning = -1L;

            public void sessionPasswordIncorrect() {
                VuzeBuddyManager.log("Incorrect Password!");
                if (Constants.isCVSVersion()) {
                    long time = SystemTime.getMonotonousTime();
                    if (this.first_bad_password == -1L) {
                        this.first_bad_password = time;
                    }
                    ++this.consec_bad_passwords;
                    VuzeBuddyManager.log("Consecutive bad passwords = " + this.consec_bad_passwords);
                    if (time - this.first_bad_password > 600000L && this.consec_bad_passwords >= 3 && (this.last_warning == -1L || time - this.last_warning > 3600000L) && this.warning_sem.getValue() > 0) {
                        this.last_warning = time;
                        new AEThread2("VBM:warning", true){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    warning_sem.reserve();
                                    StaticUtilities.promptUser("Password Error", "There is a problem with system password management. Please logout and login again.\nIf this problem persists refer to the user forums.", new String[]{"OK"}, 0);
                                }
                                finally {
                                    warning_sem.release();
                                }
                            }
                        }.start();
                    }
                }
            }

            public void sessionPasswordCorrect() {
                VuzeBuddyManager.log("Correct Password!");
                this.consec_bad_passwords = 0;
                this.first_bad_password = -1L;
            }

            public char[] getSessionPassword(String reason) throws VuzeCryptoException {
                VuzeBuddyManager.log("PW Request: " + reason + "; " + Debug.getCompressedStackTrace());
                throw new VuzeCryptoException("Not Logged In", null);
            }
        };
        loginInfoListener = new ILoginInfoListener(){

            public void loginUpdate(LoginInfoManager.LoginInfo info, boolean isNewLoginID) {
                VuzeBuddyManager.loginUpdateTriggered(info, isNewLoginID);
            }

            public void avatarURLUpdated(String newAvatarURL) {
            }
        };
        vuzeRelayListener = new VuzeRelayListener(){

            public void newRelayServerPayLoad(VuzeBuddy sender, String pkSender, Map decodedMap, long addedOn) {
                VuzeBuddyManager.processPayloadMap(pkSender, decodedMap, sender != null, addedOn, true);
            }

            public void hasPendingRelayMessage(int count) {
                if (count == 0) {
                    return;
                }
                try {
                    PlatformRelayMessenger.fetch(0L);
                    VuzeBuddyManager.log("have " + count + " pending relay messages. Attempting fetch");
                }
                catch (NotLoggedInException e) {
                    VuzeBuddyManager.log("have " + count + " pending relay messages. Not logged in");
                }
            }
        };
        buddyPluginListener = new BuddyPluginListener(){

            public void messageLogged(String str, boolean error) {
            }

            public void initialised(boolean available) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void buddyRemoved(BuddyPluginBuddy buddy) {
                if (!VuzeBuddyManager.canHandleBuddy(buddy)) {
                    return;
                }
                try {
                    buddy_mon.enter();
                    String pk = buddy.getPublicKey();
                    VuzeBuddy vuzeBuddy = (VuzeBuddy)mapPKtoVuzeBuddy.remove(pk);
                    if (vuzeBuddy != null) {
                        vuzeBuddy.removePublicKey(pk);
                        if (vuzeBuddy.getPublicKeys().length == 0) {
                            try {
                                VuzeBuddyManager.removeBuddy(vuzeBuddy, true);
                            }
                            catch (NotLoggedInException e) {
                                VuzeBuddyManager.log(e);
                            }
                        }
                    }
                }
                finally {
                    buddy_mon.exit();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void buddyChanged(BuddyPluginBuddy buddy) {
                if (!VuzeBuddyManager.canHandleBuddy(buddy)) {
                    return;
                }
                try {
                    buddy_mon.enter();
                    String pk = buddy.getPublicKey();
                    VuzeBuddy vuzeBuddy = (VuzeBuddy)mapPKtoVuzeBuddy.get(pk);
                    if (vuzeBuddy != null) {
                        VuzeBuddyManager.triggerChangeListener(vuzeBuddy, false);
                    } else {
                        this.buddyAdded(buddy);
                    }
                }
                finally {
                    buddy_mon.exit();
                }
            }

            public void buddyAdded(BuddyPluginBuddy buddy) {
                if (!VuzeBuddyManager.canHandleBuddy(buddy)) {
                    return;
                }
                buddy.getMessageHandler().addListener(buddy_message_handler_listener);
            }

            public void enabledStateChanged(boolean enabled) {
                VuzeBuddyManager.log("buddy plugin enabled state changed to " + enabled);
                VuzeBuddyManager.setupBuddyPlugin();
                if (LoginInfoManager.getInstance().isLoggedIn()) {
                    VuzeBuddyManager.loginUpdateTriggered(LoginInfoManager.getInstance().getUserInfo(), true);
                }
            }
        };
        buddyPluginBuddyRequestListener = new BuddyPluginBuddyRequestListener(){

            public Map requestReceived(BuddyPluginBuddy from_buddy, int subsystem, Map request2) throws BuddyPluginException {
                if (subsystem != 2) {
                    return null;
                }
                HashMap<String, String> mapResponse = new HashMap<String, String>();
                try {
                    String pk = from_buddy.getPublicKey();
                    String reply = VuzeBuddyManager.processPayloadMap(pk, request2, from_buddy.isAuthorised(), SystemTime.getCurrentTime(), true);
                    mapResponse.put("response", reply);
                }
                catch (Exception e) {
                    mapResponse.put("response", "Exception: " + e.toString());
                    Debug.out(e);
                }
                return mapResponse;
            }

            public void pendingMessages(BuddyPluginBuddy[] from_buddies) {
                for (int i = 0; i < from_buddies.length; ++i) {
                    BuddyPluginBuddy pluginBuddy = from_buddies[i];
                    String pk = pluginBuddy.getPublicKey();
                    VuzeBuddy vuzeBuddy = VuzeBuddyManager.getBuddyByPK(pk);
                    if (vuzeBuddy != null) {
                        VuzeBuddyManager.log("Relay: YGM from " + pk);
                        continue;
                    }
                    VuzeBuddyManager.log("Relay: YGM from non vuzer " + pk);
                }
                PlatformRelayMessenger.relayCheck();
            }
        };
        pluginEnabled = false;
    }
}

