/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.buddy.impl;

import com.aelitis.azureus.buddy.QueuedVuzeShare;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;

public class VuzeQueuedShares {
    private static final long EXPIREY_MS = 2592000000L;
    private static List shares = new ArrayList();
    private static AEMonitor shares_mon = new AEMonitor("Qd Shares");
    private static String SAVE_FILENAME = "v3.QdShares.dat";
    private static File configDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSharesByCode(String code) {
        ArrayList<QueuedVuzeShare> results = new ArrayList<QueuedVuzeShare>();
        shares_mon.enter();
        try {
            for (QueuedVuzeShare share : shares) {
                if (!share.getCode().equals(code)) continue;
                results.add(share);
            }
        }
        finally {
            shares_mon.exit();
        }
        return results;
    }

    public static void updateSharePK(String code, String pkSender) {
        List sharesByCode = VuzeQueuedShares.getSharesByCode(code);
        VuzeQueuedShares.log("Updating " + sharesByCode.size() + " shares with code " + code + " to pk " + pkSender);
        for (QueuedVuzeShare share : sharesByCode) {
            share.setPk(pkSender);
        }
        VuzeQueuedShares.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSharesByPK(String pk) {
        ArrayList<QueuedVuzeShare> results = new ArrayList<QueuedVuzeShare>();
        if (pk == null) {
            return results;
        }
        shares_mon.enter();
        try {
            for (QueuedVuzeShare share : shares) {
                if (!pk.equals(share.getPk())) continue;
                results.add(share);
            }
        }
        finally {
            shares_mon.exit();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(QueuedVuzeShare share) {
        shares_mon.enter();
        try {
            shares.remove(share);
        }
        finally {
            shares_mon.exit();
        }
        VuzeQueuedShares.log("Remove");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueuedVuzeShare add(String code) {
        QueuedVuzeShare share = new QueuedVuzeShare();
        share.setCode(code);
        shares_mon.enter();
        try {
            shares.add(share);
        }
        finally {
            shares_mon.exit();
        }
        VuzeQueuedShares.log("Share Added for code " + code);
        return share;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        VuzeQueuedShares.log("Qd Shares Save");
        HashMap mapSave = new HashMap();
        ArrayList<Map> storedShareList = new ArrayList<Map>();
        mapSave.put("shares", storedShareList);
        try {
            shares_mon.enter();
            for (QueuedVuzeShare share : shares) {
                if (share == null) continue;
                storedShareList.add(share.toMap());
            }
            FileUtil.writeResilientFile(configDir, SAVE_FILENAME, mapSave, true);
        }
        finally {
            shares_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        Map map = FileUtil.readResilientFile(configDir, SAVE_FILENAME, true);
        List storedBuddyList = MapUtils.getMapList(map, "shares", Collections.EMPTY_LIST);
        shares_mon.enter();
        try {
            shares.clear();
            long tooOld = SystemTime.getCurrentTime() - 2592000000L;
            for (Map mapBuddy : storedBuddyList) {
                QueuedVuzeShare share = new QueuedVuzeShare(mapBuddy);
                if (share.getSharedOn() <= tooOld) continue;
                shares.add(share);
            }
        }
        finally {
            shares_mon.exit();
        }
        VuzeQueuedShares.log("Qd Shares Load.  Size=" + shares.size());
    }

    public static void init(File configDir) {
        VuzeQueuedShares.configDir = configDir;
        try {
            VuzeQueuedShares.load();
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private static void log(String s) {
        VuzeBuddyManager.log("[Qd Shares] " + s);
    }
}

