/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.cnetwork.impl;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkPropertyChangeListener;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkManagerImpl;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkVuzeGeneric;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.MapUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentNetworkImpl
implements ContentNetwork {
    protected static final long TYPE_VUZE_GENERIC = 1L;
    private static final String PP_STARTUP_NETWORK = "startup_network";
    private ContentNetworkManagerImpl manager;
    private long type;
    private long version;
    private long id;
    private String name;
    private Map<String, Object> pprop_defaults;
    private Map<Object, Object> transient_properties = Collections.synchronizedMap(new HashMap());
    private CopyOnWriteList persistent_listeners = new CopyOnWriteList();

    protected static ContentNetworkImpl importFromBEncodedMapStatic(ContentNetworkManagerImpl manager, Map map) throws IOException {
        long type = ImportExportUtils.importLong(map, "type");
        if (type == 1L) {
            return new ContentNetworkVuzeGeneric(manager, map);
        }
        throw new IOException("Unsupported network type: " + type);
    }

    protected ContentNetworkImpl(ContentNetworkManagerImpl _manager, long _type, long _id, long _version, String _name, Map<String, Object> _pprop_defaults) {
        this.manager = _manager;
        this.type = _type;
        this.version = _version;
        this.id = _id;
        this.name = _name;
        this.pprop_defaults = _pprop_defaults;
    }

    protected ContentNetworkImpl(ContentNetworkManagerImpl _manager) {
        this.manager = _manager;
    }

    protected void importFromBEncodedMap(Map<String, Object> map) throws IOException {
        this.type = ImportExportUtils.importLong(map, "type");
        this.id = ImportExportUtils.importLong(map, "id");
        this.version = ImportExportUtils.importLong(map, "version");
        this.name = ImportExportUtils.importString(map, "name");
        this.pprop_defaults = (Map)map.get("pprop_defaults");
    }

    protected void exportToBEncodedMap(Map<String, Object> map) throws IOException {
        ImportExportUtils.exportLong(map, "type", this.type);
        ImportExportUtils.exportLong(map, "id", this.id);
        ImportExportUtils.exportLong(map, "version", this.version);
        ImportExportUtils.exportString(map, "name", this.name);
        if (this.pprop_defaults != null) {
            map.put("pprop_defaults", this.pprop_defaults);
        }
    }

    protected void updateFrom(ContentNetworkImpl other) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        other.exportToBEncodedMap(map);
        this.importFromBEncodedMap(map);
    }

    @Override
    public long getID() {
        return this.id;
    }

    protected long getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected boolean isSameAs(ContentNetworkImpl other) {
        try {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            this.exportToBEncodedMap(map1);
            other.exportToBEncodedMap(map2);
            return BEncoder.mapsAreIdentical(map1, map2);
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    @Override
    public String getSearchService(String query) {
        return this.getServiceURL(1, new Object[]{query});
    }

    @Override
    public String getXSearchService(String query, boolean to_subscribe) {
        return this.getServiceURL(2, new Object[]{query, to_subscribe});
    }

    @Override
    public String getContentDetailsService(String hash, String client_ref) {
        return this.getServiceURL(11, new Object[]{hash, client_ref});
    }

    @Override
    public String getCommentService(String hash) {
        return this.getServiceURL(12, new Object[]{hash});
    }

    @Override
    public String getProfileService(String login_id, String client_ref) {
        return this.getServiceURL(13, new Object[]{login_id, client_ref});
    }

    @Override
    public String getTorrentDownloadService(String hash, String client_ref) {
        return this.getServiceURL(14, new Object[]{hash, client_ref});
    }

    @Override
    public String getFAQTopicService(String topic) {
        return this.getServiceURL(18, new Object[]{topic});
    }

    @Override
    public String getLoginService(String message) {
        return this.getServiceURL(22, new Object[]{message});
    }

    @Override
    public String getSiteRelativeURL(String relative_url, boolean append_suffix) {
        return this.getServiceURL(27, new Object[]{relative_url, append_suffix});
    }

    @Override
    public String getAddFriendURL(String colour) {
        return this.getServiceURL(28, new Object[]{colour});
    }

    @Override
    public String getSubscriptionURL(String subs_id) {
        return this.getServiceURL(29, new Object[]{subs_id});
    }

    @Override
    public VuzeFile getVuzeFile() {
        VuzeFile vf = VuzeFileHandler.getSingleton().create();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            this.exportToBEncodedMap(map);
            vf.addComponent(128, map);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return vf;
    }

    @Override
    public boolean isStartupNetwork() {
        if (this.hasPersistentProperty(PP_STARTUP_NETWORK)) {
            return (Boolean)this.getPersistentProperty(PP_STARTUP_NETWORK);
        }
        return (Boolean)this.getPersistentProperty("is_cust");
    }

    @Override
    public void setStartupNetwork(boolean b) {
        this.setPersistentProperty(PP_STARTUP_NETWORK, new Boolean(b));
    }

    @Override
    public void setTransientProperty(Object key, Object value) {
        this.transient_properties.put(key, value);
    }

    @Override
    public Object getTransientProperty(Object key) {
        return this.transient_properties.get(key);
    }

    protected String getPropertiesKey() {
        return "cnetwork.net." + this.id + ".props";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPersistentProperty(String name, Object new_value) {
        ContentNetworkImpl contentNetworkImpl = this;
        synchronized (contentNetworkImpl) {
            HashMap<String, Object> props;
            Object old_value;
            String key = this.getPropertiesKey();
            if (new_value instanceof Boolean) {
                new_value = new Long((Boolean)new_value != false ? 1L : 0L);
            }
            if (BEncoder.objectsAreIdentical(old_value = (props = new HashMap<String, Object>(COConfigurationManager.getMapParameter(key, new HashMap()))).get(key), new_value)) {
                return;
            }
            props.put(name, new_value);
            COConfigurationManager.setParameter(key, props);
        }
        Iterator it = this.persistent_listeners.iterator();
        while (it.hasNext()) {
            try {
                ((ContentNetworkPropertyChangeListener)it.next()).propertyChanged(name);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPersistentProperty(String name) {
        ContentNetworkImpl contentNetworkImpl = this;
        synchronized (contentNetworkImpl) {
            String key = this.getPropertiesKey();
            Map props = COConfigurationManager.getMapParameter(key, new HashMap());
            if (name == "source_ref") {
                return MapUtils.getMapString(props, name, MapUtils.getMapString(this.pprop_defaults, name, null));
            }
            Object obj = props.get(name);
            if (name == "auth_shown" || name == "is_cust" || name == "active" || name == "in_menu" || name == PP_STARTUP_NETWORK) {
                if (obj == null && this.pprop_defaults != null) {
                    obj = this.pprop_defaults.get(name);
                }
                if (obj == null) {
                    return false;
                }
                return (Long)obj == 1L;
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPersistentProperty(String name) {
        ContentNetworkImpl contentNetworkImpl = this;
        synchronized (contentNetworkImpl) {
            String key = this.getPropertiesKey();
            Map props = COConfigurationManager.getMapParameter(key, new HashMap());
            return props.containsKey(name);
        }
    }

    protected Map<String, Object> getPersistentPropertyDefaults() {
        return this.pprop_defaults;
    }

    @Override
    public void addPersistentPropertyChangeListener(ContentNetworkPropertyChangeListener listener) {
        this.persistent_listeners.add(listener);
    }

    @Override
    public void removePersistentPropertyChangeListener(ContentNetworkPropertyChangeListener listener) {
        this.persistent_listeners.remove(listener);
    }

    protected void destroy() {
        String key = this.getPropertiesKey();
        COConfigurationManager.setParameter(key, new HashMap());
    }

    @Override
    public void remove() {
        this.manager.removeNetwork(this);
    }

    protected void debug(String str) {
        Debug.out(this.getString() + ": " + str);
    }

    protected String getString() {
        return this.getID() + " - " + this.getName() + ": version=" + this.getVersion() + ", site=" + this.getProperty(1);
    }
}

