/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.content.ContentException;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentLookupListener;
import com.aelitis.azureus.core.content.RelatedContentManagerListener;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.util.ImportExportUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedContentManager {
    private static final boolean TRACE = false;
    private static final int MAX_HISTORY = 16;
    private static final int MAX_TITLE_LENGTH = 80;
    private static final int MAX_CONCURRENT_PUBLISH = 2;
    private static final String CONFIG_FILE = "rcm.config";
    private static final String PERSIST_DEL_FILE = "rcmx.config";
    private static final String CONFIG_TOTAL_UNREAD = "rcm.numunread.cache";
    private static RelatedContentManager singleton;
    private static AzureusCore core;
    private PluginInterface plugin_interface;
    private TorrentAttribute ta_networks;
    private DHTPlugin dht_plugin;
    private long global_random_id = -1L;
    private LinkedList<DownloadInfo> download_infos1 = new LinkedList();
    private LinkedList<DownloadInfo> download_infos2 = new LinkedList();
    private ByteArrayHashMapEx<DownloadInfo> download_info_map = new ByteArrayHashMapEx();
    private Set<String> download_priv_set = new HashSet<String>();
    private boolean enabled;
    private boolean ui_enabled;
    private int max_search_level;
    private int max_results;
    private int publishing_count = 0;
    private CopyOnWriteList<RelatedContentManagerListener> listeners = new CopyOnWriteList();
    private AESemaphore initialisation_complete_sem = new AESemaphore("RCM:init");
    private static final int TIMER_PERIOD = 30000;
    private static final int PUBLISH_CHECK_PERIOD = 30000;
    private static final int PUBLISH_CHECK_TICKS = 1;
    private static final int SECONDARY_LOOKUP_PERIOD = 900000;
    private static final int SECONDARY_LOOKUP_TICKS = 30;
    private static final int REPUBLISH_PERIOD = 28800000;
    private static final int REPUBLISH_TICKS = 960;
    private static final int CONFIG_DISCARD_MILLIS = 60000;
    private ContentCache content_cache_ref;
    private WeakReference<ContentCache> content_cache;
    private boolean content_dirty;
    private long last_config_access;
    private int content_discard_ticks;
    private AtomicInteger total_unread = new AtomicInteger(COConfigurationManager.getIntParameter("rcm.numunread.cache", 0));
    private AsyncDispatcher content_change_dispatcher = new AsyncDispatcher();
    private static final int SECONDARY_LOOKUP_CACHE_MAX = 10;
    private LinkedList<SecondaryLookup> secondary_lookups = new LinkedList();
    private boolean secondary_lookup_in_progress;
    private long secondary_lookup_complete_time;
    private static final int PD_BLOOM_INITIAL_SIZE = 1000;
    private static final int PD_BLOOM_INCREMENT_SIZE = 1000;
    private BloomFilter persist_del_bloom;

    public static synchronized void preInitialise(AzureusCore _core) {
        core = _core;
    }

    public static synchronized RelatedContentManager getSingleton() throws ContentException {
        if (singleton == null) {
            singleton = new RelatedContentManager();
        }
        return singleton;
    }

    protected RelatedContentManager() throws ContentException {
        if (!FeatureAvailability.isRCMEnabled()) {
            this.enabled = false;
            this.ui_enabled = false;
            return;
        }
        this.enabled = true;
        try {
            if (core == null) {
                throw new ContentException("getSingleton called before pre-initialisation");
            }
            while (this.global_random_id == -1L) {
                this.global_random_id = COConfigurationManager.getLongParameter("rcm.random.id", -1L);
                if (this.global_random_id != -1L) continue;
                this.global_random_id = RandomUtils.nextLong();
                COConfigurationManager.setParameter("rcm.random.id", this.global_random_id);
            }
            this.plugin_interface = core.getPluginManager().getDefaultPluginInterface();
            this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
            COConfigurationManager.addAndFireParameterListeners(new String[]{"rcm.ui.enabled", "rcm.max_search_level", "rcm.max_results"}, new ParameterListener(){

                public void parameterChanged(String name) {
                    RelatedContentManager.this.ui_enabled = COConfigurationManager.getBooleanParameter("rcm.ui.enabled", true);
                    RelatedContentManager.this.max_search_level = COConfigurationManager.getIntParameter("rcm.max_search_level", 3);
                    RelatedContentManager.this.max_results = COConfigurationManager.getIntParameter("rcm.max_results", 500);
                }
            });
            SimpleTimer.addEvent("rcm.delay.init", SystemTime.getOffsetTime(15000L), new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    RelatedContentManager.this.plugin_interface.addListener(new PluginListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void initializationComplete() {
                            try {
                                PluginInterface dht_pi = RelatedContentManager.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                                if (dht_pi != null) {
                                    RelatedContentManager.this.dht_plugin = (DHTPlugin)dht_pi.getPlugin();
                                    DownloadManager dm = RelatedContentManager.this.plugin_interface.getDownloadManager();
                                    Download[] downloads = dm.getDownloads();
                                    RelatedContentManager.this.addDownloads(downloads, true);
                                    dm.addListener(new DownloadManagerListener(){

                                        public void downloadAdded(Download download) {
                                            RelatedContentManager.this.addDownloads(new Download[]{download}, false);
                                        }

                                        public void downloadRemoved(Download download) {
                                        }
                                    }, false);
                                    SimpleTimer.addPeriodicEvent("RCM:publisher", 30000L, new TimerEventPerformer(){
                                        private int tick_count;

                                        public void perform(TimerEvent event2) {
                                            if (RelatedContentManager.this.ui_enabled) {
                                                ++this.tick_count;
                                                if (this.tick_count % 1 == 0) {
                                                    RelatedContentManager.this.publish();
                                                    RelatedContentManager.this.saveRelatedContent();
                                                }
                                                if (this.tick_count % 30 == 0) {
                                                    RelatedContentManager.this.secondaryLookup();
                                                }
                                                if (this.tick_count % 960 == 0) {
                                                    RelatedContentManager.this.republish();
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                            finally {
                                RelatedContentManager.this.initialisation_complete_sem.releaseForever();
                            }
                        }

                        public void closedownInitiated() {
                            RelatedContentManager.this.saveRelatedContent();
                        }

                        public void closedownComplete() {
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            this.initialisation_complete_sem.releaseForever();
            if (e instanceof ContentException) {
                throw (ContentException)e;
            }
            throw new ContentException("Initialisation failed", e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isUIEnabled() {
        return this.ui_enabled;
    }

    public void setUIEnabled(boolean _ui_enabled) {
        COConfigurationManager.setParameter("rcm.ui.enabled", _ui_enabled);
    }

    public int getMaxSearchLevel() {
        return this.max_search_level;
    }

    public void setMaxSearchLevel(int _level) {
        COConfigurationManager.setParameter("rcm.max_search_level", _level);
    }

    public int getMaxResults() {
        return this.max_results;
    }

    public void setMaxResults(int _max) {
        COConfigurationManager.setParameter("rcm.max_results", _max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDownloads(Download[] downloads, boolean initialising) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ArrayList<DownloadInfo> new_info = new ArrayList<DownloadInfo>(downloads.length);
            for (Download download : downloads) {
                try {
                    DownloadManagerState state;
                    String[] networks;
                    byte[] hash;
                    Torrent torrent;
                    if (!download.isPersistent() || (torrent = download.getTorrent()) == null || this.download_info_map.containsKey(hash = torrent.getHash()) || (networks = download.getListAttribute(this.ta_networks)) == null) continue;
                    boolean public_net = false;
                    for (int i = 0; i < networks.length; ++i) {
                        if (!networks[i].equalsIgnoreCase("Public")) continue;
                        public_net = true;
                        break;
                    }
                    if (!public_net || TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(torrent)) || (state = PluginCoreUtils.unwrap(download).getDownloadState()).getFlag(16L)) continue;
                    long rand = this.global_random_id ^ state.getLongParameter("rand");
                    DownloadInfo info = new DownloadInfo(hash, hash, download.getName(), (int)rand, torrent.isPrivate() ? StringInterner.intern(torrent.getAnnounceURL().getHost()) : null, 0, torrent.getSize());
                    new_info.add(info);
                    if (initialising || this.download_infos1.size() == 0) {
                        this.download_infos1.add(info);
                    } else {
                        this.download_infos1.add(RandomUtils.nextInt(this.download_infos1.size()), info);
                    }
                    this.download_infos2.add(info);
                    this.download_info_map.put(hash, info);
                    if (info.getTracker() == null) continue;
                    this.download_priv_set.add(this.getPrivateInfoKey(info));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            List history = COConfigurationManager.getListParameter("rcm.dlinfo.history", new ArrayList());
            if (initialising) {
                int padd = 16 - this.download_info_map.size();
                for (int i = 0; i < history.size() && padd > 0; ++i) {
                    try {
                        DownloadInfo info = this.deserialiseDI((Map)history.get(i), null);
                        if (info == null || this.download_info_map.containsKey(info.getHash())) continue;
                        this.download_info_map.put(info.getHash(), info);
                        if (info.getTracker() != null) {
                            this.download_priv_set.add(this.getPrivateInfoKey(info));
                        }
                        this.download_infos1.add(info);
                        this.download_infos2.add(info);
                        --padd;
                        continue;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                Collections.shuffle(this.download_infos1);
            } else if (new_info.size() > 0) {
                for (DownloadInfo info : new_info) {
                    Map<String, Object> map = this.serialiseDI(info, null);
                    if (map == null) continue;
                    history.add(map);
                }
                while (history.size() > 16) {
                    history.remove(0);
                }
                COConfigurationManager.setParameter("rcm.dlinfo.history", history);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void republish() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            if (this.publishing_count > 0) {
                return;
            }
            if (this.download_infos1.isEmpty()) {
                List list = this.download_info_map.values();
                this.download_infos1.addAll(list);
                this.download_infos2.addAll(list);
                Collections.shuffle(this.download_infos1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish() {
        while (true) {
            DownloadInfo info1 = null;
            DownloadInfo info2 = null;
            RelatedContentManager relatedContentManager = this;
            synchronized (relatedContentManager) {
                if (this.publishing_count >= 2) {
                    return;
                }
                if (this.download_infos1.isEmpty() || this.download_info_map.size() == 1) {
                    return;
                }
                info1 = this.download_infos1.removeFirst();
                Iterator it = this.download_infos2.iterator();
                while (it.hasNext()) {
                    info2 = (DownloadInfo)it.next();
                    if (info1 == info2 && this.download_infos2.size() != 1) continue;
                    it.remove();
                    break;
                }
                if (info1 == info2 && ((info2 = this.download_info_map.getRandomValueExcluding(info1)) == null || info1 == info2)) {
                    Debug.out("Inconsistent!");
                    return;
                }
                ++this.publishing_count;
            }
            try {
                this.publish(info1, info2);
                continue;
            }
            catch (Throwable e) {
                RelatedContentManager relatedContentManager2 = this;
                synchronized (relatedContentManager2) {
                    --this.publishing_count;
                }
                Debug.out(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishNext() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            --this.publishing_count;
            if (this.publishing_count < 0) {
                this.publishing_count = 0;
            }
        }
        this.publish();
    }

    protected void publish(final DownloadInfo from_info, DownloadInfo to_info) throws Exception {
        final String from_hash = ByteFormatter.encodeString(from_info.getHash());
        final String to_hash = ByteFormatter.encodeString(to_info.getHash());
        final byte[] key_bytes = ("az:rcm:assoc:" + from_hash).getBytes("UTF-8");
        String title = to_info.getTitle();
        if (title.length() > 80) {
            title = title.substring(0, 80);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("d", title);
        map.put("r", new Long(Math.abs(to_info.getRand() % 1000)));
        String tracker = to_info.getTracker();
        if (tracker == null) {
            map.put("h", to_info.getHash());
        } else {
            map.put("t", tracker);
        }
        long size = to_info.getSize();
        if (size != 0L) {
            map.put("s", new Long(size));
        }
        final byte[] map_bytes = BEncoder.encode(map);
        int max_hits = 30;
        this.dht_plugin.get(key_bytes, "Content relationship read: " + from_hash, (byte)0, 30, 30000L, false, false, new DHTPluginOperationListener(){
            private boolean diversified;
            private int hits;
            private Set<String> entries = new HashSet<String>();

            public void starts(byte[] key) {
            }

            public void diversified() {
                this.diversified = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                try {
                    Map map = BDecoder.decode(value.getValue());
                    String title = new String((byte[])map.get("d"), "UTF-8");
                    String tracker = null;
                    byte[] hash = (byte[])map.get("h");
                    if (hash == null) {
                        tracker = new String((byte[])map.get("t"), "UTF-8");
                    }
                    int rand = ((Long)map.get("r")).intValue();
                    String key = title + " % " + rand;
                    Set<String> set = this.entries;
                    synchronized (set) {
                        if (this.entries.contains(key)) {
                            return;
                        }
                        this.entries.add(key);
                    }
                    Long l_size = (Long)map.get("s");
                    long size = l_size == null ? 0L : l_size;
                    RelatedContentManager.this.analyseResponse(new DownloadInfo(from_info.getHash(), hash, title, rand, tracker, 1, size), null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++this.hits;
            }

            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            public void complete(byte[] key, boolean timeout_occurred) {
                boolean do_it;
                if (this.diversified || this.hits >= 20) {
                    do_it = false;
                } else if (this.hits <= 10) {
                    do_it = true;
                } else {
                    boolean bl = do_it = RandomUtils.nextInt(this.hits - 10 + 1) == 0;
                }
                if (do_it) {
                    try {
                        RelatedContentManager.this.dht_plugin.put(key_bytes, "Content relationship: " + from_hash + " -> " + to_hash, map_bytes, (byte)16, new DHTPluginOperationListener(){

                            public void diversified() {
                            }

                            public void starts(byte[] key) {
                            }

                            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                            }

                            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                            }

                            public void complete(byte[] key, boolean timeout_occurred) {
                                RelatedContentManager.this.publishNext();
                            }
                        });
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        RelatedContentManager.this.publishNext();
                    }
                } else {
                    RelatedContentManager.this.publishNext();
                }
            }
        });
    }

    public void lookupContent(Download download, final RelatedContentLookupListener listener) throws ContentException {
        Torrent t = download.getTorrent();
        if (t == null) {
            throw new ContentException("Torrent not available");
        }
        final byte[] hash = t.getHash();
        if (!this.initialisation_complete_sem.isReleasedForever() || this.dht_plugin != null && this.dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(hash, 0, listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupContentSupport(hash, 0, listener);
        }
    }

    private void lookupContentSupport(final byte[] from_hash, final int level, final RelatedContentLookupListener listener) throws ContentException {
        try {
            if (this.dht_plugin == null) {
                throw new ContentException("DHT plugin unavailable");
            }
            String from_hash_str = ByteFormatter.encodeString(from_hash);
            byte[] key_bytes = ("az:rcm:assoc:" + from_hash_str).getBytes("UTF-8");
            int max_hits = 30;
            this.dht_plugin.get(key_bytes, "Content relationship read: " + from_hash_str, (byte)0, 30, 60000L, false, true, new DHTPluginOperationListener(){
                private Set<String> entries = new HashSet<String>();
                private RelatedContentManagerListener manager_listener = new RelatedContentManagerListener(){
                    private Set<RelatedContent> content_list = new HashSet<RelatedContent>();

                    public void contentFound(RelatedContent[] content) {
                        this.handle(content);
                    }

                    public void contentChanged(RelatedContent[] content) {
                        this.handle(content);
                    }

                    public void contentRemoved(RelatedContent[] content) {
                    }

                    public void contentChanged() {
                    }

                    public void contentReset() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void handle(RelatedContent[] content) {
                        Set<RelatedContent> set = this.content_list;
                        synchronized (set) {
                            if (this.content_list.contains(content)) {
                                return;
                            }
                            for (RelatedContent c : content) {
                                this.content_list.add(c);
                            }
                        }
                        listener.contentFound(content);
                    }
                };

                public void starts(byte[] key) {
                    if (listener != null) {
                        try {
                            listener.lookupStart();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }

                public void diversified() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    try {
                        Map map = BDecoder.decode(value.getValue());
                        String title = new String((byte[])map.get("d"), "UTF-8");
                        String tracker = null;
                        byte[] hash = (byte[])map.get("h");
                        if (hash == null) {
                            tracker = new String((byte[])map.get("t"), "UTF-8");
                        }
                        int rand = ((Long)map.get("r")).intValue();
                        String key = title + " % " + rand;
                        Set<String> set = this.entries;
                        synchronized (set) {
                            if (this.entries.contains(key)) {
                                return;
                            }
                            this.entries.add(key);
                        }
                        Long l_size = (Long)map.get("s");
                        long size = l_size == null ? 0L : l_size;
                        RelatedContentManager.this.analyseResponse(new DownloadInfo(from_hash, hash, title, rand, tracker, level + 1, size), listener == null ? null : this.manager_listener);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                public void complete(byte[] key, boolean timeout_occurred) {
                    if (listener != null) {
                        try {
                            listener.lookupComplete();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            ContentException ce = e instanceof ContentException ? (ContentException)e : new ContentException("Lookup failed", e);
            if (listener != null) {
                try {
                    listener.lookupFailed(ce);
                }
                catch (Throwable f) {
                    Debug.out(f);
                }
            }
            throw ce;
        }
    }

    protected void popuplateSecondaryLookups(ContentCache content_cache) {
        Random rand = new Random();
        this.secondary_lookups.clear();
        List primaries = this.download_info_map.values();
        int primary_count = primaries.size();
        int primaries_to_add = primary_count < 2 ? 0 : (primary_count < 5 ? (rand.nextInt(4) == 0 ? 1 : 0) : (primary_count < 10 ? 1 : 2));
        if (primaries_to_add > 0) {
            HashSet<DownloadInfo> added = new HashSet<DownloadInfo>();
            for (int i = 0; i < primaries_to_add; ++i) {
                DownloadInfo info = (DownloadInfo)primaries.get(rand.nextInt(primaries.size()));
                if (added.contains(info)) continue;
                added.add(info);
                this.secondary_lookups.addLast(new SecondaryLookup(info.getHash(), info.getLevel()));
            }
        }
        Map related_content = content_cache.related_content;
        Iterator it = related_content.values().iterator();
        ArrayList<DownloadInfo> secondary_cache_temp = new ArrayList<DownloadInfo>(related_content.size());
        while (it.hasNext()) {
            DownloadInfo di = (DownloadInfo)it.next();
            if (di.getHash() == null || di.getLevel() >= this.max_search_level) continue;
            secondary_cache_temp.add(di);
        }
        int cache_size = Math.min(secondary_cache_temp.size(), 10 - this.secondary_lookups.size());
        if (cache_size > 0) {
            int i;
            for (i = 0; i < cache_size; ++i) {
                int index = rand.nextInt(secondary_cache_temp.size());
                DownloadInfo x = (DownloadInfo)secondary_cache_temp.get(index);
                secondary_cache_temp.set(index, (DownloadInfo)secondary_cache_temp.get(i));
                secondary_cache_temp.set(i, x);
            }
            for (i = 0; i < cache_size; ++i) {
                DownloadInfo x = (DownloadInfo)secondary_cache_temp.get(i);
                this.secondary_lookups.addLast(new SecondaryLookup(x.getHash(), x.getLevel()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void secondaryLookup() {
        SecondaryLookup sl;
        long now = SystemTime.getMonotonousTime();
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            if (this.secondary_lookup_in_progress) {
                return;
            }
            if (now - this.secondary_lookup_complete_time < 900000L) {
                return;
            }
            if (this.secondary_lookups.size() == 0) {
                ContentCache cc;
                ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
                if (cc == null) {
                    cc = this.loadRelatedContent();
                } else {
                    this.popuplateSecondaryLookups(cc);
                }
            }
            if (this.secondary_lookups.size() == 0) {
                return;
            }
            sl = this.secondary_lookups.removeFirst();
            this.secondary_lookup_in_progress = true;
        }
        try {
            this.lookupContentSupport(sl.getHash(), sl.getLevel(), new RelatedContentLookupListener(){

                public void lookupStart() {
                }

                public void contentFound(RelatedContent[] content) {
                }

                public void lookupComplete() {
                    this.next();
                }

                public void lookupFailed(ContentException error) {
                    this.next();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void next() {
                    SecondaryLookup next_sl;
                    RelatedContentManager relatedContentManager = RelatedContentManager.this;
                    synchronized (relatedContentManager) {
                        if (RelatedContentManager.this.secondary_lookups.size() == 0) {
                            RelatedContentManager.this.secondary_lookup_in_progress = false;
                            RelatedContentManager.this.secondary_lookup_complete_time = SystemTime.getMonotonousTime();
                            return;
                        }
                        next_sl = (SecondaryLookup)RelatedContentManager.this.secondary_lookups.removeFirst();
                    }
                    final 6 listener = this;
                    SimpleTimer.addEvent("RCM:SLDelay", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent event2) {
                            try {
                                RelatedContentManager.this.lookupContentSupport(next_sl.getHash(), next_sl.getLevel(), listener);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                RelatedContentManager relatedContentManager = RelatedContentManager.this;
                                synchronized (relatedContentManager) {
                                    RelatedContentManager.this.secondary_lookup_in_progress = false;
                                    RelatedContentManager.this.secondary_lookup_complete_time = SystemTime.getMonotonousTime();
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
            RelatedContentManager relatedContentManager2 = this;
            synchronized (relatedContentManager2) {
                this.secondary_lookup_in_progress = false;
                this.secondary_lookup_complete_time = now;
            }
        }
    }

    protected void contentChanged(final DownloadInfo info) {
        this.setConfigDirty();
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentChanged(new RelatedContent[]{info});
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected void contentChanged(boolean is_dirty) {
        if (is_dirty) {
            this.setConfigDirty();
        }
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentChanged();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RelatedContent[] content) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache content_cache = this.loadRelatedContent();
            this.delete(content, content_cache, true);
        }
    }

    protected void delete(final RelatedContent[] content, ContentCache content_cache, boolean persistent) {
        if (persistent) {
            this.addPersistentlyDeleted(content);
        }
        Map related_content = content_cache.related_content;
        Iterator it = related_content.values().iterator();
        while (it.hasNext()) {
            DownloadInfo di = (DownloadInfo)it.next();
            for (RelatedContent c : content) {
                if (c != di) continue;
                it.remove();
                if (!di.isUnread()) continue;
                this.decrementUnread();
            }
        }
        ByteArrayHashMapEx related_content_map = content_cache.related_content_map;
        ArrayList<byte[]> delete = new ArrayList<byte[]>();
        block2: for (byte[] key : related_content_map.keys()) {
            ArrayList infos = (ArrayList)related_content_map.get(key);
            for (RelatedContent c : content) {
                if (!infos.remove(c) || infos.size() != 0) continue;
                delete.add(key);
                continue block2;
            }
        }
        for (byte[] key : delete) {
            related_content_map.remove(key);
        }
        this.setConfigDirty();
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentRemoved(content);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected String getPrivateInfoKey(RelatedContent info) {
        return info.getTitle() + ":" + info.getTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyseResponse(DownloadInfo to_info, final RelatedContentManagerListener listener) {
        try {
            RelatedContentManager relatedContentManager = this;
            synchronized (relatedContentManager) {
                String key;
                byte[] target = to_info.getHash();
                if (target != null) {
                    if (this.download_info_map.containsKey(target)) {
                        return;
                    }
                    key = Base32.encode(target);
                } else {
                    key = this.getPrivateInfoKey(to_info);
                    if (this.download_priv_set.contains(key)) {
                        return;
                    }
                }
                if (this.isPersistentlyDeleted(to_info)) {
                    return;
                }
                ContentCache content_cache = this.loadRelatedContent();
                DownloadInfo target_info = null;
                boolean changed_content = false;
                boolean new_content = false;
                target_info = (DownloadInfo)content_cache.related_content.get(key);
                if (target_info == null) {
                    if (this.enoughSpaceFor(content_cache, to_info)) {
                        target_info = to_info;
                        content_cache.related_content.put(key, target_info);
                        byte[] from_hash = to_info.getRelatedToHash();
                        ArrayList<DownloadInfo> links = (ArrayList<DownloadInfo>)content_cache.related_content_map.get(from_hash);
                        if (links == null) {
                            links = new ArrayList<DownloadInfo>(1);
                            content_cache.related_content_map.put(from_hash, links);
                        }
                        links.add(target_info);
                        links.trimToSize();
                        target_info.setPublic(content_cache);
                        if (this.secondary_lookups.size() < 10) {
                            byte[] hash = target_info.getHash();
                            int level = target_info.getLevel();
                            if (hash != null && level < this.max_search_level) {
                                this.secondary_lookups.add(new SecondaryLookup(hash, level));
                            }
                        }
                        new_content = true;
                    }
                } else {
                    changed_content = target_info.addInfo(to_info);
                }
                if (target_info != null) {
                    boolean something_changed;
                    final RelatedContent[] f_target = new RelatedContent[]{target_info};
                    final boolean f_change = changed_content;
                    boolean bl = something_changed = changed_content || new_content;
                    if (something_changed) {
                        this.setConfigDirty();
                    }
                    this.content_change_dispatcher.dispatch(new AERunnable(){

                        public void runSupport() {
                            if (something_changed) {
                                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                                    try {
                                        if (f_change) {
                                            l.contentChanged(f_target);
                                            continue;
                                        }
                                        l.contentFound(f_target);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                            if (listener != null) {
                                try {
                                    if (f_change) {
                                        listener.contentChanged(f_target);
                                    } else {
                                        listener.contentFound(f_target);
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected boolean enoughSpaceFor(ContentCache content_cache, DownloadInfo fi) {
        Map related_content = content_cache.related_content;
        if (related_content.size() < this.max_results) {
            return true;
        }
        Iterator it = related_content.entrySet().iterator();
        int level = fi.getLevel();
        HashMap<Integer, DownloadInfo> oldest_per_rank = new HashMap<Integer, DownloadInfo>();
        int min_rank = Integer.MAX_VALUE;
        while (it.hasNext()) {
            DownloadInfo oldest;
            int rank;
            Map.Entry entry = it.next();
            DownloadInfo info = (DownloadInfo)entry.getValue();
            int info_level = info.getLevel();
            if (info_level < level) continue;
            if (info_level > level) {
                level = info_level;
                min_rank = Integer.MAX_VALUE;
                oldest_per_rank.clear();
            }
            if ((rank = info.getRank()) < min_rank) {
                min_rank = rank;
            }
            if ((oldest = (DownloadInfo)oldest_per_rank.get(rank)) == null) {
                oldest_per_rank.put(rank, info);
                continue;
            }
            if (info.getLastSeenSecs() >= oldest.getLastSeenSecs()) continue;
            oldest_per_rank.put(rank, info);
        }
        DownloadInfo to_remove = (DownloadInfo)oldest_per_rank.get(min_rank);
        if (to_remove != null) {
            this.delete(new RelatedContent[]{to_remove}, content_cache, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelatedContent[] getRelatedContent() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache content_cache = this.loadRelatedContent();
            return content_cache.related_content.values().toArray(new DownloadInfo[content_cache.related_content.size()]);
        }
    }

    public void reset() {
        this.reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(boolean reset_perm_dels) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache cc;
            ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
            if (cc == null) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                cc.related_content = new HashMap();
                cc.related_content_map = new ByteArrayHashMapEx();
            }
            this.download_infos1.clear();
            this.download_infos2.clear();
            List list = this.download_info_map.values();
            this.download_infos1.addAll(list);
            this.download_infos2.addAll(list);
            Collections.shuffle(this.download_infos1);
            this.total_unread.set(0);
            if (reset_perm_dels) {
                this.resetPersistentlyDeleted();
            }
            this.setConfigDirty();
        }
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    l.contentReset();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConfigDirty() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            this.content_dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentCache loadRelatedContent() {
        boolean fire_event = false;
        try {
            RelatedContentManager relatedContentManager = this;
            synchronized (relatedContentManager) {
                ContentCache cc;
                this.last_config_access = SystemTime.getMonotonousTime();
                ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
                if (cc == null) {
                    fire_event = true;
                    cc = new ContentCache();
                    this.content_cache = new WeakReference<ContentCache>(cc);
                    try {
                        int new_total_unread = 0;
                        if (FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
                            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
                            Map related_content = cc.related_content;
                            ByteArrayHashMapEx related_content_map = cc.related_content_map;
                            Map rcm_map = (Map)map.get("rcm");
                            Object rc_map_stuff = map.get("rc");
                            if (rc_map_stuff != null && rcm_map != null) {
                                String key;
                                HashMap<Integer, DownloadInfo> id_map = new HashMap<Integer, DownloadInfo>();
                                if (rc_map_stuff instanceof Map) {
                                    Map rc_map = (Map)rc_map_stuff;
                                    for (Map.Entry entry : rc_map.entrySet()) {
                                        try {
                                            key = (String)entry.getKey();
                                            Map info_map = (Map)entry.getValue();
                                            DownloadInfo info = this.deserialiseDI(info_map, cc);
                                            if (info.isUnread()) {
                                                ++new_total_unread;
                                            }
                                            related_content.put(key, info);
                                            int id = ((Long)info_map.get("_i")).intValue();
                                            id_map.put(id, info);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                } else {
                                    List rc_map_list = (List)rc_map_stuff;
                                    for (Map map2 : rc_map_list) {
                                        try {
                                            key = new String((byte[])map2.get("_k"), "UTF-8");
                                            DownloadInfo info = this.deserialiseDI(map2, cc);
                                            if (info.isUnread()) {
                                                ++new_total_unread;
                                            }
                                            related_content.put(key, info);
                                            int id = ((Long)map2.get("_i")).intValue();
                                            id_map.put(id, info);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                                if (rcm_map.size() != 0 && id_map.size() != 0) {
                                    for (String key2 : rcm_map.keySet()) {
                                        try {
                                            byte[] byArray = Base32.decode(key2);
                                            int[] ids = ImportExportUtils.importIntArray(rcm_map, key2);
                                            if (ids == null || ids.length == 0) {
                                                Debug.out("Inconsistent - no ids");
                                                continue;
                                            }
                                            ArrayList<DownloadInfo> di_list = new ArrayList<DownloadInfo>(ids.length);
                                            for (int id : ids) {
                                                DownloadInfo di = (DownloadInfo)id_map.get(id);
                                                if (di == null) {
                                                    Debug.out("Inconsistent: id " + id + " missing");
                                                    continue;
                                                }
                                                di.setRelatedToHash(byArray);
                                                di_list.add(di);
                                            }
                                            if (di_list.size() <= 0) continue;
                                            related_content_map.put(byArray, di_list);
                                        }
                                        catch (Throwable throwable) {
                                            Debug.out(throwable);
                                        }
                                    }
                                }
                                Iterator it = related_content.values().iterator();
                                while (it.hasNext()) {
                                    DownloadInfo di = (DownloadInfo)it.next();
                                    if (di.getRelatedToHash() != null) continue;
                                    Debug.out("Inconsistent: info not referenced");
                                    if (di.isUnread()) {
                                        --new_total_unread;
                                    }
                                    it.remove();
                                }
                                this.popuplateSecondaryLookups(cc);
                            }
                        }
                        if (this.total_unread.get() != new_total_unread) {
                            Debug.out("total_unread - inconsistent (" + this.total_unread + "/" + new_total_unread + ")");
                            this.total_unread.set(new_total_unread);
                            COConfigurationManager.setParameter(CONFIG_TOTAL_UNREAD, new_total_unread);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                this.content_cache_ref = cc;
                ContentCache contentCache2 = cc;
                return contentCache2;
            }
        }
        finally {
            if (fire_event) {
                this.contentChanged(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRelatedContent() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache cc;
            COConfigurationManager.setParameter(CONFIG_TOTAL_UNREAD, this.total_unread.get());
            long now = SystemTime.getMonotonousTime();
            ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
            if (!this.content_dirty) {
                if (cc != null && now - this.last_config_access > 60000L) {
                    if (this.content_cache_ref != null) {
                        this.content_discard_ticks = 0;
                    }
                    this.content_cache_ref = null;
                }
                return;
            }
            this.last_config_access = now;
            this.content_dirty = false;
            if (cc == null) {
                Debug.out("RCM: cache inconsistent");
            } else {
                Map related_content = cc.related_content;
                ByteArrayHashMapEx related_content_map = cc.related_content_map;
                if (related_content.size() == 0) {
                    FileUtil.deleteResilientConfigFile(CONFIG_FILE);
                } else {
                    HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
                    Set rcs = related_content.entrySet();
                    ArrayList<Map<String, Object>> rc_map_list = new ArrayList<Map<String, Object>>(rcs.size());
                    map.put("rc", rc_map_list);
                    int id = 0;
                    HashMap<DownloadInfo, Integer> info_map = new HashMap<DownloadInfo, Integer>();
                    for (Map.Entry entry : rcs) {
                        DownloadInfo info = (DownloadInfo)entry.getValue();
                        Map<String, Object> di_map = this.serialiseDI(info, cc);
                        if (di_map == null) continue;
                        info_map.put(info, id);
                        di_map.put("_i", new Long(id));
                        di_map.put("_k", entry.getKey());
                        if (rc_map_list.add(di_map)) {
                            // empty if block
                        }
                        ++id;
                    }
                    HashMap rcm_map = new HashMap();
                    map.put("rcm", rcm_map);
                    for (byte[] hash : related_content_map.keys()) {
                        List dis = (List)related_content_map.get(hash);
                        int[] ids = new int[dis.size()];
                        int pos = 0;
                        for (DownloadInfo di : dis) {
                            Integer index = (Integer)info_map.get(di);
                            if (index == null) {
                                Debug.out("inconsistent: info missing for " + di);
                                break;
                            }
                            ids[pos++] = index;
                        }
                        if (pos != ids.length) continue;
                        ImportExportUtils.exportIntArray(rcm_map, Base32.encode(hash), ids);
                    }
                    FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
                }
            }
        }
    }

    public int getNumUnread() {
        return this.total_unread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllRead() {
        boolean changed = false;
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            DownloadInfo[] content;
            for (DownloadInfo c : content = (DownloadInfo[])this.getRelatedContent()) {
                if (!c.isUnread()) continue;
                changed = true;
                c.setUnreadInternal(false);
            }
            this.total_unread.set(0);
        }
        if (changed) {
            this.contentChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache content_cache = this.loadRelatedContent();
            this.addPersistentlyDeleted(content_cache.related_content.values().toArray(new DownloadInfo[content_cache.related_content.size()]));
            this.reset(false);
        }
    }

    protected void incrementUnread() {
        this.total_unread.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementUnread() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            int val = this.total_unread.decrementAndGet();
            if (val < 0) {
                Debug.out("inconsistent");
                this.total_unread.set(0);
            }
        }
    }

    protected Download getDownload(byte[] hash) {
        try {
            return this.plugin_interface.getDownloadManager().getDownload(hash);
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected byte[] getPermDelKey(RelatedContent info) {
        byte[] bytes = info.getHash();
        if (bytes == null) {
            try {
                bytes = new SHA1Simple().calculateHash(this.getPrivateInfoKey(info).getBytes("ISO-8859-1"));
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }
        byte[] key = new byte[8];
        System.arraycopy(bytes, 0, key, 0, 8);
        return key;
    }

    protected List<byte[]> loadPersistentlyDeleted() {
        List entries = null;
        if (FileUtil.resilientConfigFileExists(PERSIST_DEL_FILE)) {
            Map map = FileUtil.readResilientConfigFile(PERSIST_DEL_FILE);
            entries = (List)map.get("entries");
        }
        if (entries == null) {
            entries = new ArrayList(0);
        }
        return entries;
    }

    protected void addPersistentlyDeleted(RelatedContent[] content) {
        block6: {
            if (content.length == 0) {
                return;
            }
            List<byte[]> entries = this.loadPersistentlyDeleted();
            ArrayList<byte[]> new_keys = new ArrayList<byte[]>(content.length);
            for (RelatedContent rc : content) {
                byte[] key = this.getPermDelKey(rc);
                new_keys.add(key);
                entries.add(key);
            }
            HashMap<String, List<byte[]>> map = new HashMap<String, List<byte[]>>();
            map.put("entries", entries);
            FileUtil.writeResilientConfigFile(PERSIST_DEL_FILE, map);
            if (this.persist_del_bloom == null) break block6;
            if (this.persist_del_bloom.getSize() / (this.persist_del_bloom.getEntryCount() + content.length) < 10) {
                this.persist_del_bloom = BloomFilterFactory.createAddOnly(Math.max(1000, this.persist_del_bloom.getSize() * 10 + 1000 + content.length));
                for (byte[] k : entries) {
                    this.persist_del_bloom.add(k);
                }
            } else {
                for (byte[] k : new_keys) {
                    this.persist_del_bloom.add(k);
                }
            }
        }
    }

    protected boolean isPersistentlyDeleted(RelatedContent content) {
        if (this.persist_del_bloom == null) {
            List<byte[]> entries = this.loadPersistentlyDeleted();
            this.persist_del_bloom = BloomFilterFactory.createAddOnly(Math.max(1000, entries.size() * 10 + 1000));
            for (byte[] k : entries) {
                this.persist_del_bloom.add(k);
            }
        }
        byte[] key = this.getPermDelKey(content);
        return this.persist_del_bloom.contains(key);
    }

    protected void resetPersistentlyDeleted() {
        FileUtil.deleteResilientConfigFile(PERSIST_DEL_FILE);
        this.persist_del_bloom = BloomFilterFactory.createAddOnly(1000);
    }

    public void addListener(RelatedContentManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RelatedContentManagerListener listener) {
        this.listeners.remove(listener);
    }

    private Map<String, Object> serialiseDI(DownloadInfo info, ContentCache cc) {
        try {
            HashMap<String, Object> info_map = new HashMap<String, Object>();
            info_map.put("h", info.getHash());
            ImportExportUtils.exportString(info_map, "d", info.getTitle());
            ImportExportUtils.exportInt(info_map, "r", info.getRand());
            ImportExportUtils.exportString(info_map, "t", info.getTracker());
            ImportExportUtils.exportLong(info_map, "z", info.getSize());
            if (cc != null) {
                ImportExportUtils.exportBoolean(info_map, "u", info.isUnread());
                ImportExportUtils.exportIntArray(info_map, "l", info.getRandList());
                ImportExportUtils.exportInt(info_map, "s", info.getLastSeenSecs());
                ImportExportUtils.exportInt(info_map, "e", info.getLevel());
            }
            return info_map;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    private DownloadInfo deserialiseDI(Map<String, Object> info_map, ContentCache cc) {
        try {
            byte[] hash = (byte[])info_map.get("h");
            String title = ImportExportUtils.importString(info_map, "d");
            int rand = ImportExportUtils.importInt(info_map, "r");
            String tracker = ImportExportUtils.importString(info_map, "t");
            long size = ImportExportUtils.importLong(info_map, "z");
            if (cc == null) {
                return new DownloadInfo(hash, hash, title, rand, tracker, 0, size);
            }
            boolean unread = ImportExportUtils.importBoolean(info_map, "u");
            int[] rand_list = ImportExportUtils.importIntArray(info_map, "l");
            int last_seen = ImportExportUtils.importInt(info_map, "s");
            int level = ImportExportUtils.importInt(info_map, "e");
            return new DownloadInfo(hash, title, rand, tracker, unread, rand_list, last_seen, level, size, cc);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ByteArrayHashMapEx<T>
    extends ByteArrayHashMap<T> {
        protected ByteArrayHashMapEx() {
        }

        public T getRandomValueExcluding(T excluded) {
            int num = RandomUtils.nextInt(this.size);
            T result = null;
            for (int j = 0; j < this.table.length; ++j) {
                ByteArrayHashMap.Entry e = this.table[j];
                while (e != null) {
                    Object value = e.value;
                    if (value != excluded) {
                        result = (T)value;
                    }
                    if (num <= 0 && result != null) {
                        return result;
                    }
                    --num;
                    e = e.next;
                }
            }
            return result;
        }
    }

    private static class ContentCache {
        private Map<String, DownloadInfo> related_content = new HashMap<String, DownloadInfo>();
        private ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = new ByteArrayHashMapEx();

        private ContentCache() {
        }
    }

    protected class DownloadInfo
    extends RelatedContent {
        private final int rand;
        private boolean unread;
        private int[] rand_list;
        private int last_seen;
        private int level;
        private ContentCache cc;

        protected DownloadInfo(byte[] _related_to, byte[] _hash, String _title, int _rand, String _tracker, int _level, long _size) {
            super(_related_to, _title, _hash, _tracker, _size);
            this.unread = true;
            this.rand = _rand;
            this.level = _level;
            this.updateLastSeen();
        }

        protected DownloadInfo(byte[] _hash, String _title, int _rand, String _tracker, boolean _unread, int[] _rand_list, int _last_seen, int _level, long _size, ContentCache _cc) {
            super(_title, _hash, _tracker, _size);
            this.unread = true;
            this.rand = _rand;
            this.unread = _unread;
            this.rand_list = _rand_list;
            this.last_seen = _last_seen;
            this.level = _level;
            this.cc = _cc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean addInfo(DownloadInfo info) {
            boolean result = false;
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                this.updateLastSeen();
                int r = info.getRand();
                if (this.rand_list == null) {
                    this.rand_list = new int[]{r};
                    result = true;
                } else {
                    boolean match = false;
                    for (int i = 0; i < this.rand_list.length; ++i) {
                        if (this.rand_list[i] != r) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        int len = this.rand_list.length;
                        int[] new_rand_list = new int[len + 1];
                        System.arraycopy(this.rand_list, 0, new_rand_list, 0, len);
                        new_rand_list[len] = r;
                        this.rand_list = new_rand_list;
                        result = true;
                    }
                }
                if (info.getLevel() < this.level) {
                    this.level = info.getLevel();
                    result = true;
                }
            }
            return result;
        }

        public int getLevel() {
            return this.level;
        }

        protected void updateLastSeen() {
            this.last_seen = (int)(SystemTime.getCurrentTime() / 1000L);
        }

        public int getRank() {
            return this.rand_list == null ? 0 : this.rand_list.length;
        }

        public boolean isUnread() {
            return this.unread;
        }

        protected void setPublic(ContentCache _cc) {
            this.cc = _cc;
            if (this.unread) {
                RelatedContentManager.this.incrementUnread();
            }
            this.rand_list = new int[]{this.rand};
        }

        public int getLastSeenSecs() {
            return this.last_seen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setUnreadInternal(boolean _unread) {
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                this.unread = _unread;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setUnread(boolean _unread) {
            boolean changed = false;
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                if (this.unread != _unread) {
                    this.unread = _unread;
                    changed = true;
                }
            }
            if (changed) {
                if (_unread) {
                    RelatedContentManager.this.incrementUnread();
                } else {
                    RelatedContentManager.this.decrementUnread();
                }
                RelatedContentManager.this.contentChanged(this);
            }
        }

        protected int getRand() {
            return this.rand;
        }

        protected int[] getRandList() {
            return this.rand_list;
        }

        public Download getRelatedToDownload() {
            try {
                return RelatedContentManager.this.getDownload(this.getRelatedToHash());
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }

        public void delete() {
            RelatedContentManager.this.delete(new RelatedContent[]{this});
        }

        public String getString() {
            return super.getString() + ", " + this.rand;
        }
    }

    private static class SecondaryLookup {
        private final byte[] hash;
        private final int level;

        protected SecondaryLookup(byte[] _hash, int _level) {
            this.hash = _hash;
            this.level = _level;
        }

        protected byte[] getHash() {
            return this.hash;
        }

        protected int getLevel() {
            return this.level;
        }
    }
}

