/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.custom.impl;

import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationException;
import com.aelitis.azureus.core.custom.CustomizationManager;
import com.aelitis.azureus.core.custom.impl.CustomizationImpl;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class CustomizationManagerImpl
implements CustomizationManager {
    private static CustomizationManagerImpl singleton = new CustomizationManagerImpl();
    private Map customization_file_map = new HashMap();
    private String current_customization_name;
    private CustomizationImpl current_customization;

    public static CustomizationManager getSingleton() {
        return singleton;
    }

    protected CustomizationManagerImpl() {
        String active;
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            public void process(VuzeFile[] files, int expected_types) {
                for (int i = 0; i < files.length; ++i) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    for (int j = 0; j < comps.length; ++j) {
                        VuzeFileComponent comp2 = comps[j];
                        if (comp2.getType() != 64) continue;
                        try {
                            Map map = comp2.getContent();
                            ((CustomizationManagerImpl)CustomizationManagerImpl.getSingleton()).importCustomization(map);
                            comp2.setProcessed();
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        });
        File user_dir = FileUtil.getUserFile("custom");
        File app_dir = FileUtil.getApplicationFile("custom");
        this.loadCustomizations(app_dir);
        if (!user_dir.equals(app_dir)) {
            this.loadCustomizations(user_dir);
        }
        if (this.customization_file_map.get(active = COConfigurationManager.getStringParameter("customization.active.name", "")) == null) {
            for (String name : this.customization_file_map.keySet()) {
                String version_key = "customization.name." + name + ".version";
                String existing_version = COConfigurationManager.getStringParameter(version_key, "0");
                if (!existing_version.equals("0")) continue;
                active = name;
                String version = ((String[])this.customization_file_map.get(name))[0];
                COConfigurationManager.setParameter("customization.active.name", active);
                COConfigurationManager.setParameter(version_key, version);
                break;
            }
        }
        this.current_customization_name = active;
    }

    protected void loadCustomizations(File dir) {
        File[] files;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String name = file.getName();
                if (!name.endsWith(".zip")) {
                    this.logInvalid(file);
                    continue;
                }
                String base = name.substring(0, name.length() - 4);
                int u_pos = base.lastIndexOf(95);
                if (u_pos == -1) {
                    this.logInvalid(file);
                    continue;
                }
                String lhs = base.substring(0, u_pos).trim();
                String rhs = base.substring(u_pos + 1).trim();
                if (lhs.length() == 0 || !Constants.isValidVersionFormat(rhs)) {
                    this.logInvalid(file);
                    continue;
                }
                String[] details = (String[])this.customization_file_map.get(lhs);
                if (details == null) {
                    this.customization_file_map.put(lhs, new String[]{rhs, file.getAbsolutePath()});
                    continue;
                }
                String old_version = details[0];
                if (Constants.compareVersions(old_version, rhs) >= 0) continue;
                this.customization_file_map.put(lhs, new String[]{rhs, file.getAbsolutePath()});
            }
        }
    }

    protected void logInvalid(File file) {
        Debug.out("Invalid customization file name '" + file.getAbsolutePath() + "' - format must be <name>_<version>.zip where version is numeric and dot separated");
    }

    protected void importCustomization(Map map) throws CustomizationException {
        try {
            File target;
            String name = new String((byte[])map.get("name"), "UTF-8");
            String version = new String((byte[])map.get("version"), "UTF-8");
            if (!Constants.isValidVersionFormat(version)) {
                throw new CustomizationException("Invalid version specification: " + version);
            }
            byte[] data = (byte[])map.get("data");
            File user_dir = FileUtil.getUserFile("custom");
            if (!user_dir.exists()) {
                user_dir.mkdirs();
            }
            if (!(target = new File(user_dir, name + "_" + version + ".zip")).exists() && !FileUtil.writeBytesAsFile2(target.getAbsolutePath(), data)) {
                throw new CustomizationException("Failed to save customization to " + target);
            }
        }
        catch (CustomizationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CustomizationException("Failed to import customization", e);
        }
    }

    protected void exportCustomization(CustomizationImpl cust, File to_file) throws CustomizationException {
        if (to_file.isDirectory()) {
            to_file = new File(to_file, cust.getName() + "_" + cust.getVersion() + ".vuze");
        }
        if (!to_file.getName().endsWith(".vuze")) {
            to_file = new File(to_file.getParentFile(), to_file.getName() + ".vuze");
        }
        try {
            HashMap<String, Object> contents = new HashMap<String, Object>();
            byte[] data = FileUtil.readFileAsByteArray(cust.getContents());
            contents.put("name", cust.getName());
            contents.put("version", cust.getVersion());
            contents.put("data", data);
            VuzeFile vf = VuzeFileHandler.getSingleton().create();
            vf.addComponent(64, contents);
            vf.write(to_file);
        }
        catch (Throwable e) {
            throw new CustomizationException("Failed to export customization", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customization getActiveCustomization() {
        CustomizationManagerImpl customizationManagerImpl = this;
        synchronized (customizationManagerImpl) {
            String[] entry;
            if (this.current_customization == null && this.current_customization_name != null && (entry = (String[])this.customization_file_map.get(this.current_customization_name)) != null) {
                try {
                    this.current_customization = new CustomizationImpl(this, this.current_customization_name, entry[0], new File(entry[1]));
                    SimpleTimer.addEvent("Custom:clear", SystemTime.getCurrentTime() + 120000L, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent event2) {
                            CustomizationManagerImpl customizationManagerImpl = CustomizationManagerImpl.this;
                            synchronized (customizationManagerImpl) {
                                CustomizationManagerImpl.this.current_customization = null;
                            }
                        }
                    });
                }
                catch (CustomizationException e) {
                    e.printStackTrace();
                }
            }
            return this.current_customization;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customization[] getCustomizations() {
        ArrayList<CustomizationImpl> result = new ArrayList<CustomizationImpl>();
        CustomizationManagerImpl customizationManagerImpl = this;
        synchronized (customizationManagerImpl) {
            for (Map.Entry entry : this.customization_file_map.entrySet()) {
                String name = (String)entry.getKey();
                String[] bits = (String[])entry.getValue();
                String version = bits[0];
                File file = new File(bits[1]);
                try {
                    CustomizationImpl cust = new CustomizationImpl(this, name, version, file);
                    result.add(cust);
                }
                catch (Throwable e) {}
            }
        }
        return result.toArray(new Customization[result.size()]);
    }

    public static void main(String[] args) {
        try {
            CustomizationManagerImpl manager = (CustomizationManagerImpl)CustomizationManagerImpl.getSingleton();
            CustomizationImpl cust = new CustomizationImpl(manager, "blah", "1.2", new File("C:\\temp\\cust\\details.zip"));
            cust.exportToVuzeFile(new File("C:\\temp\\cust"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

