/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererManual;
import com.aelitis.azureus.core.drivedetector.DriveDetectedInfo;
import com.aelitis.azureus.core.drivedetector.DriveDetectedListener;
import com.aelitis.azureus.core.drivedetector.DriveDetectorFactory;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;

public class DeviceDriveManager
implements DriveDetectedListener {
    private DeviceManagerImpl manager;
    private Map<String, DeviceMediaRendererManual> device_map = new HashMap<String, DeviceMediaRendererManual>();
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher();
    private boolean listener_added;

    protected DeviceDriveManager(DeviceManagerImpl _manager) {
        this.manager = _manager;
        if (this.manager.getAutoSearch()) {
            this.listener_added = true;
            DriveDetectorFactory.getDeviceDetector().addListener(this);
        }
    }

    protected void search() {
        this.async_dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                if (DeviceDriveManager.this.listener_added) {
                    return;
                }
                try {
                    DriveDetectorFactory.getDeviceDetector().addListener(DeviceDriveManager.this);
                }
                finally {
                    DriveDetectorFactory.getDeviceDetector().removeListener(DeviceDriveManager.this);
                }
            }
        });
    }

    public void driveDetected(final DriveDetectedInfo info) {
        this.async_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                File[] folders;
                File root = info.getLocation();
                if (root.exists() && (folders = root.listFiles()) != null) {
                    HashSet<String> names = new HashSet<String>();
                    for (File file : folders) {
                        names.add(file.getName().toLowerCase());
                    }
                    if (names.contains("psp") && names.contains("video")) {
                        DeviceImpl[] devices = DeviceDriveManager.this.manager.getDevices();
                        String target_name = "PSP";
                        String target_classification = "sony.PSP";
                        File target_directory = new File(root, "VIDEO");
                        for (DeviceImpl device : devices) {
                            DeviceMediaRendererManual renderer;
                            String classification;
                            if (!(device instanceof DeviceMediaRendererManual) || !(classification = (renderer = (DeviceMediaRendererManual)device).getClassification()).equalsIgnoreCase(target_classification)) continue;
                            DeviceDriveManager.this.mapDevice(renderer, root, target_directory);
                            return;
                        }
                        DeviceTemplate[] templates = DeviceDriveManager.this.manager.getDeviceTemplates(3);
                        DeviceMediaRendererManual renderer = null;
                        for (DeviceTemplate template : templates) {
                            if (!template.getClassification().equalsIgnoreCase(target_classification)) continue;
                            try {
                                renderer = (DeviceMediaRendererManual)template.createInstance(target_name);
                                break;
                            }
                            catch (Throwable e) {
                                DeviceDriveManager.this.log("Failed to add device", e);
                            }
                        }
                        if (renderer == null) {
                            try {
                                renderer = (DeviceMediaRendererManual)DeviceDriveManager.this.manager.createDevice(3, target_classification, target_name);
                            }
                            catch (Throwable e) {
                                DeviceDriveManager.this.log("Failed to add device", e);
                            }
                        }
                        if (renderer != null) {
                            try {
                                renderer.setAutoCopyToFolder(true);
                                DeviceDriveManager.this.mapDevice(renderer, root, target_directory);
                                return;
                            }
                            catch (Throwable e) {
                                DeviceDriveManager.this.log("Failed to add device", e);
                            }
                        }
                    }
                }
            }
        });
    }

    public void driveRemoved(final DriveDetectedInfo info) {
        this.async_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                DeviceDriveManager.this.unMapDevice(info.getLocation());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapDevice(DeviceMediaRendererManual renderer, File root, File copy_to) {
        DeviceMediaRendererManual existing;
        Map<String, DeviceMediaRendererManual> map = this.device_map;
        synchronized (map) {
            existing = this.device_map.put(root.getAbsolutePath(), renderer);
        }
        if (existing != null && existing != renderer) {
            this.log("Unmapped " + existing.getName() + " from " + root);
            existing.setCopyToFolder(null);
        }
        this.log("Mapped " + renderer.getName() + " to " + root);
        renderer.setCopyToFolder(copy_to);
        renderer.setLivenessDetectable(true);
        renderer.alive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unMapDevice(File root) {
        DeviceMediaRendererManual existing;
        Map<String, DeviceMediaRendererManual> map = this.device_map;
        synchronized (map) {
            existing = this.device_map.remove(root.getAbsolutePath());
        }
        if (existing != null) {
            this.log("Unmapped " + existing.getName() + " from " + root);
            existing.setCopyToFolder(null);
            existing.dead();
        }
    }

    protected void log(String str) {
        this.manager.log("DriveMan: " + str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log("DriveMan: " + str, e);
    }
}

