/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.DeviceInternetGateway;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceUPnPImpl;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceInternetGatewayImpl
extends DeviceUPnPImpl
implements DeviceInternetGateway {
    private static final int CHECK_MAPPINGS_PERIOD = 30000;
    private static final int CHECK_MAPPINGS_TICK_COUNT = 6;
    private static UPnPPlugin upnp_plugin;
    private static List<DeviceInternetGatewayImpl> igds;
    private boolean mapper_enabled;
    private UPnPPluginService[] current_services;
    private UPnPMapping[] current_mappings;

    protected DeviceInternetGatewayImpl(DeviceManagerImpl _manager, UPnPDevice _device, List<UPnPWANConnection> _connections) {
        super(_manager, _device, 1);
        this.updateStatus(0);
    }

    protected DeviceInternetGatewayImpl(DeviceManagerImpl _manager, Map _map) throws IOException {
        super(_manager, _map);
    }

    @Override
    protected boolean updateFrom(DeviceImpl _other, boolean _is_alive) {
        if (!super.updateFrom(_other, _is_alive)) {
            return false;
        }
        if (!(_other instanceof DeviceInternetGatewayImpl)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceInternetGatewayImpl other = (DeviceInternetGatewayImpl)_other;
        return true;
    }

    @Override
    protected void updateStatus(int tick_count) {
        super.updateStatus(tick_count);
        if (tick_count % 6 != 0) {
            return;
        }
        this.mapper_enabled = upnp_plugin != null && upnp_plugin.isEnabled();
        UPnPDevice device = this.getUPnPDevice();
        if (this.mapper_enabled && device != null) {
            this.current_services = upnp_plugin.getServices(device);
            this.current_mappings = upnp_plugin.getMappings();
        }
    }

    @Override
    protected URL getPresentationURL(UPnPDevice device) {
        URL url = super.getPresentationURL(device);
        if (url == null) {
            try {
                URL loc = device.getRootDevice().getLocation();
                URL test_loc = new URL(loc.getProtocol() + "://" + loc.getHost() + "/");
                test_loc.openConnection().connect();
                return test_loc;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return url;
    }

    protected Set<mapping> getRequiredMappings() {
        TreeSet<mapping> res = new TreeSet<mapping>();
        UPnPMapping[] required_mappings = this.current_mappings;
        if (required_mappings != null) {
            for (UPnPMapping mapping2 : required_mappings) {
                if (!mapping2.isEnabled()) continue;
                res.add(new mapping(mapping2));
            }
        }
        return res;
    }

    protected Set<mapping> getActualMappings(UPnPPluginService service) {
        UPnPPluginService.serviceMapping[] actual_mappings = service.getMappings();
        TreeSet<mapping> actual = new TreeSet<mapping>();
        for (UPnPPluginService.serviceMapping act_mapping : actual_mappings) {
            mapping m = new mapping(act_mapping);
            actual.add(m);
        }
        return actual;
    }

    @Override
    protected void getDisplayProperties(List<String[]> dp) {
        super.getDisplayProperties(dp);
        this.addDP(dp, "device.router.is_mapping", this.mapper_enabled);
        UPnPPluginService[] services = this.current_services;
        String req_map_str = "";
        Set<mapping> required = this.getRequiredMappings();
        for (mapping m : required) {
            req_map_str = req_map_str + (req_map_str.length() == 0 ? "" : ",") + m.getString();
        }
        this.addDP(dp, "device.router.req_map", req_map_str);
        if (services != null) {
            for (UPnPPluginService service : services) {
                Set<mapping> actual = this.getActualMappings(service);
                String act_map_str = "";
                for (mapping m : actual) {
                    if (!required.contains(m)) continue;
                    act_map_str = act_map_str + (act_map_str.length() == 0 ? "" : ",") + m.getString();
                }
                String service_name = MessageText.getString("device.router.con_type", new String[]{service.getService().getConnectionType()});
                this.addDP(dp, "!    " + service_name + "!", act_map_str);
            }
        }
    }

    static {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                try {
                    PluginInterface pi_upnp = core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                    if (pi_upnp != null) {
                        upnp_plugin = (UPnPPlugin)pi_upnp.getPlugin();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class mapping
    implements Comparable<mapping> {
        private boolean is_tcp;
        private int port;

        protected mapping(UPnPMapping m) {
            this.is_tcp = m.isTCP();
            this.port = m.getPort();
        }

        protected mapping(UPnPPluginService.serviceMapping m) {
            this.is_tcp = m.isTCP();
            this.port = m.getPort();
        }

        @Override
        public int compareTo(mapping o) {
            int res = this.port - o.port;
            if (res == 0) {
                res = (this.is_tcp ? 1 : 0) - (o.is_tcp ? 1 : 0);
            }
            return res;
        }

        public boolean equals(Object _other) {
            if (_other instanceof mapping) {
                mapping other = (mapping)_other;
                return this.is_tcp == other.is_tcp && this.port == other.port;
            }
            return false;
        }

        public int hashCode() {
            return (this.port << 16) + (this.is_tcp ? 1 : 0);
        }

        public String getString() {
            return (this.is_tcp ? "TCP" : "UDP") + " " + this.port;
        }
    }
}

